/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.enums.PsDataTypeEnum;
import kd.epm.epbs.business.paramsetting.util.ParamSettingUtils;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.serviceHelper.ReportServiceHelper;
import kd.fi.bcm.business.serviceHelper.ReportToVoucherServiceHelper;
import kd.fi.bcm.business.serviceHelper.ScenePeriodServiceHelper;
import kd.fi.bcm.business.serviceHelper.TreeStructureServiceHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.ReportStatusEnum;
import kd.fi.bcm.common.enums.config.ProcessSelectionEnum;
import kd.fi.bcm.common.json.JSONObjectUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.service.ReportToVoucherMsService;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.util.DataCollectUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class ReportToVoucherMsServiceImpl
implements ReportToVoucherMsService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, ReportToVoucherMsServiceImpl.class);

    public String execute(String json) {
        return ReportToVoucherServiceHelper.query((String)json);
    }

    public boolean isAuditted(String org, String book, String year, Object period) {
        logger.info("\u53cd\u7ed3\u8d26 -- \u5165\u53c2org:" + org + " book\uff1a" + book + " year\uff1a" + year + " period\uff1a" + period);
        try {
            if (period instanceof Date) {
                return this.isAuditted(org, book, year, (Date)period);
            }
            if (period instanceof String) {
                return this.isAuditted(org, book, year, String.valueOf(period));
            }
            return false;
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u4e0d\u6821\u9a8c %s\u3002", (String)"ReportToVoucherMsServiceImpl_6", (String)"fi-bcm-mservice", (Object[])new Object[0]);
            logger.info(String.format(msg, e));
            return false;
        }
    }

    public Map<String, Object> isAuditted(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("status", false);
        String org = null;
        String year = null;
        String period = null;
        Date date = null;
        try {
            org = (String)param.get("org");
            year = (String)param.get("year");
            period = (String)param.get("period");
            date = (Date)param.get("date");
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26 %s\u3002", (String)"ReportToVoucherMsServiceImpl_4", (String)"fi-bcm-mservice", (Object[])new Object[0]);
            result.put("status", true);
            result.put("msg", String.format(msg, e));
            return result;
        }
        Map<Long, List<DynamicObject>> excludeOrgsByModel = ReportToVoucherMsServiceImpl.getCM018Entitys();
        Map<Long, Pair<Boolean, String>> cm018s = ReportToVoucherMsServiceImpl.getCM018s();
        if (MapUtils.isEmpty(cm018s)) {
            return result;
        }
        Map entity2YearPeriods = ReportServiceHelper.collectEntity2YearPeriods(excludeOrgsByModel);
        for (Map.Entry<Long, Pair<Boolean, String>> entry : cm018s.entrySet()) {
            try {
                Long periodDimId;
                QFilter qFilter;
                DynamicObjectCollection memberDims;
                Long modelId = entry.getKey();
                Map dimMemMapByNum = DataCollectUtils.getGlMemMapByNum((Long)modelId, Collections.singletonList(org), (String)"Entity");
                String orgRef = (String)dimMemMapByNum.get(org);
                if (StringUtils.isEmpty((CharSequence)orgRef)) {
                    orgRef = org;
                }
                period = !(memberDims = QueryServiceHelper.query((String)"bcm_membermapentity", (String)"bcmmember", (QFilter[])(qFilter = new QFilter("model", "=", (Object)modelId).and("bcmdim", "=", (Object)(periodDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Period"))).and("asstmember", "=", (Object)period)).toArray())).isEmpty() ? ((DynamicObject)memberDims.get(0)).getString("bcmmember") : (period.length() == 1 ? "M_M0" + period : "M_M" + period);
                this.audittedByModelWithPeriod(modelId, orgRef, year, date, period, (String)entry.getValue().p2, excludeOrgsByModel.get(entry.getKey()), entity2YearPeriods);
            }
            catch (Exception e) {
                result.put("status", true);
                if (e instanceof KDBizException) {
                    result.put("msg", e.getMessage());
                } else {
                    String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26 %s\u3002", (String)"ReportToVoucherMsServiceImpl_5", (String)"fi-bcm-mservice", (Object[])new Object[0]);
                    result.put("msg", String.format(msg, e));
                }
                logger.error((Throwable)e);
                return result;
            }
        }
        return result;
    }

    public Map<String, Boolean> isAudittedBatch(List<String> org, String book, String year, Object period) {
        if (period instanceof Date) {
            return this.isAudittedBatch(org, book, year, (Date)period);
        }
        if (period instanceof String) {
            return this.isAudittedBatch(org, book, year, String.valueOf(period));
        }
        return null;
    }

    private boolean isAuditted(String org, String bookType, String year, String period) {
        Map<Long, List<DynamicObject>> cm018Entitys = ReportToVoucherMsServiceImpl.getCM018Entitys();
        logger.info("\u53cd\u7ed3\u8d26 -- CM018\u914d\u7f6e\u8fc7\u65e0\u9700\u4ea4\u9a8c\u7ec4\u7ec7\u7684\u4f53\u7cfb\u96c6\u5408:" + cm018Entitys);
        Map<Long, Pair<Boolean, String>> cm018s = ReportToVoucherMsServiceImpl.getCM018s();
        logger.info("\u53cd\u7ed3\u8d26 -- CMO18\u662f\u5426\u5f00\u542f\u6821\u9a8c\u7684\u4f53\u7cfb\u96c6\u5408:" + cm018s);
        if (cm018s == null || cm018s.size() <= 0) {
            return Boolean.FALSE;
        }
        Map entity2YearPeriods = ReportServiceHelper.collectEntity2YearPeriods(cm018Entitys);
        for (Map.Entry<Long, Pair<Boolean, String>> entry : cm018s.entrySet()) {
            JSONObject json;
            Long modelId = entry.getKey();
            logger.info("\u53cd\u7ed3\u8d26 -- \u4f53\u7cfb:" + modelId);
            Map dimMemMapByNum = DataCollectUtils.getGlMemMapByNum((Long)modelId, Collections.singletonList(org), (String)"Entity");
            String orgRef = (String)dimMemMapByNum.get(org);
            if (StringUtils.isEmpty((CharSequence)orgRef)) {
                orgRef = org;
            }
            String processSelection = (json = JSONObjectUtil.parseObjectOrder((String)((String)entry.getValue().p2))) == null ? "1" : (String)json.get((Object)"processselection");
            List<DynamicObject> dyc_CM018 = cm018Entitys.get(modelId);
            if (!StringUtils.isEmpty((CharSequence)period) && period.length() == 1) {
                period = "0" + period;
            }
            long yearId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "FY" + year, "bcm_fymembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u8d22\u5e74:" + yearId);
            long periodId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "M_M" + period, "bcm_periodmembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u671f\u95f4:" + periodId);
            if (dyc_CM018 != null && ReportToVoucherMsServiceImpl.containOrg(orgRef, entity2YearPeriods, modelId, dyc_CM018, yearId, periodId)) continue;
            long orgId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, orgRef, "bcm_entitymembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u7ec4\u7ec7:" + orgId);
            if (orgId == 0L || yearId == 0L || periodId == 0L) {
                return false;
            }
            long scenarioId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "MRpt", "bcm_scenemembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u60c5\u666fID:" + scenarioId);
            DynamicObjectCollection dynamicObjects = this.getReportWithCheckreportstatus(orgId, yearId, periodId, scenarioId, processSelection);
            logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u5df2\u4e0a\u62a5\u62a5\u8868:" + dynamicObjects);
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                ArrayList<DynamicObject> reportList = new ArrayList<DynamicObject>(10);
                boolean templateObj = ReportToVoucherMsServiceImpl.getTemplateWithCheckStatus(dynamicObjects, modelId, orgRef, reportList);
                return templateObj;
            }
            if (scenarioId == 0L) continue;
            long entityBaseMemberId = TreeStructureServiceHelper.getEntityBaseMemberId((long)orgId);
            McStatus mcStatus = McStatus.getMcStatus((Object)modelId, (Object)entityBaseMemberId, (Object)scenarioId, (Object)yearId, (Object)periodId);
            logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u6d41\u7a0b:" + mcStatus);
            if (!mcStatus.getFlow().isSubmit()) continue;
            logger.info("\u53cd\u7ed3\u8d26 -- \u6d41\u7a0b\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26:" + mcStatus);
            return true;
        }
        return false;
    }

    private static boolean containOrg(String org, Map<Long, Pair<List<Long>, List<Long>>> entity2YearPeriods, Long modelId, List<DynamicObject> dyc_CM018, long yearId, long periodId) {
        boolean containOrg = false;
        for (DynamicObject p : dyc_CM018) {
            HashSet allEntityIdSet = new HashSet(16);
            if (StringUtil.isEmptyString((String)p.getString("dentity.oid")) || StringUtil.isEmptyString((String)p.getString("dentity.num")) || StringUtil.isEmptyString((String)p.getString("dentity.rangevalue"))) {
                return false;
            }
            Set entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange((String)"bcm_entitymembertree", (Long)LongUtil.toLong((Object)p.getString("dentity.oid")), (String)p.getString("dentity.num"), (int)Integer.parseInt(p.getString("dentity.rangevalue")), (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.MEMBERPERM);
            allEntityIdSet.addAll(entitySet);
            if (!allEntityIdSet.contains(org)) continue;
            if (entity2YearPeriods.get(p.getLong("dentity.id")) != null) {
                Pair<List<Long>, List<Long>> yearPeriods = entity2YearPeriods.get(p.getLong("dentity.id"));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)yearPeriods.p1)) && !containOrg) {
                    containOrg = ((List)yearPeriods.p1).contains(yearId);
                }
                if (CollectionUtils.isNotEmpty((Collection)((Collection)yearPeriods.p2)) && (CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p1)) || containOrg)) {
                    containOrg = ((List)yearPeriods.p2).contains(periodId);
                }
                if (CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p1)) && CollectionUtils.isEmpty((Collection)((Collection)yearPeriods.p2))) {
                    containOrg = true;
                }
            } else {
                containOrg = true;
            }
            if (!containOrg) continue;
            logger.info("\u53cd\u7ed3\u8d26 -- \u4f20\u8fc7\u6765\u7684\u7ec4\u7ec7\u5728\u65e0\u9700\u6821\u9a8c\u7ec4\u7ec7\u96c6\u5408\u91cc:" + org);
            break;
        }
        return containOrg;
    }

    private boolean audittedByModelWithPeriod(Long modelId, String org, String year, Date periodDate, String period, String jsonStr, List<DynamicObject> excludOrgs, Map<Long, Pair<List<Long>, List<Long>>> entity2YearPeriods) {
        ArrayList<DynamicObject> reportList;
        boolean hasAudditedReport;
        JSONObject json = JSONObjectUtil.parseObjectOrder((String)jsonStr);
        String processSelection = json == null ? "1" : (String)json.get((Object)"processselection");
        logger.info("\u53cd\u7ed3\u8d26 -- \u4f53\u7cfb:" + modelId);
        long yearId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "FY" + year, "bcm_fymembertree");
        long periodId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, period, "bcm_periodmembertree");
        if (excludOrgs != null && ReportToVoucherMsServiceImpl.containOrg(org, entity2YearPeriods, modelId, excludOrgs, yearId, periodId)) {
            return false;
        }
        DynamicObjectCollection fyColl = ReportToVoucherMsServiceImpl.getFYIdCollection(modelId);
        DynamicObjectCollection periodColl = ReportToVoucherMsServiceImpl.getPeriodIdCollection(modelId);
        long orgId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, org, "bcm_entitymembertree");
        if (orgId == 0L || fyColl == null || CollectionUtils.isEmpty((Collection)fyColl) || periodColl == null || CollectionUtils.isEmpty((Collection)periodColl)) {
            logger.info("\u53cd\u7ed3\u8d26 -- \u7ec4\u7ec7/\u8d22\u5e74\u96c6\u5408/\u671f\u95f4\u96c6\u5408\u4e3a\u7a7a");
            return false;
        }
        long scenarioId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "MRpt", "bcm_scenemembertree");
        logger.info("\u53cd\u7ed3\u8d26 -- \u60c5\u666f:" + scenarioId);
        DynamicObjectCollection dynamicObjects = ReportToVoucherMsServiceImpl.getReportWithCheckreportstatus(orgId, fyColl, periodColl, year, periodDate, scenarioId, processSelection, period, modelId);
        logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u5df2\u4e0a\u62a5\u62a5\u8868:" + dynamicObjects);
        String msg = "";
        if (dynamicObjects != null && dynamicObjects.size() > 0 && (hasAudditedReport = ReportToVoucherMsServiceImpl.getTemplateWithCheckStatus(dynamicObjects, modelId, org, reportList = new ArrayList<DynamicObject>(10)).booleanValue())) {
            String modelNum = MemberReader.findModelNumberById((Object)modelId);
            StringBuilder sb = new StringBuilder();
            sb.append(modelNum).append("_");
            for (DynamicObject report : reportList) {
                String scene = report.getString("scene.number");
                String yearnum = report.getString("fyear.number");
                String periodNum = report.getString("period.number");
                String currency = report.getString("currency.number");
                String join = String.join((CharSequence)"_", scene, yearnum, periodNum, currency, org, report.getString("template.number"));
                sb.append(join).append(";");
            }
            msg = processSelection.equalsIgnoreCase(ProcessSelectionEnum.REPORTCOMMIT.getValue()) ? ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u4e0a\u62a5\u62a5\u8868\u201c%s\u201d\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"ReportToVoucherMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b58\u5728\u7f16\u5236\u5b8c\u6210\u62a5\u8868\u201c%s\u201d\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"ReportToVoucherMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]);
            msg = String.format(msg, sb);
            throw new KDBizException(msg);
        }
        if (scenarioId != 0L) {
            long entityBaseMemberId = TreeStructureServiceHelper.getEntityBaseMemberId((long)orgId);
            List<Pair<Long, List<Long>>> pair = ReportToVoucherMsServiceImpl.getFYAndPeriodFilter(fyColl, periodColl, year, periodDate, period, modelId);
            if (pair == null) {
                return Boolean.FALSE;
            }
            for (Pair<Long, List<Long>> longListPair : pair) {
                List<Object> fyIds = Collections.singletonList(longListPair.p1);
                Map mcStatusMap = McStatus.batchGetMcStatus4Periods((Long)modelId, (Collection)Sets.newHashSet((Object[])new Long[]{entityBaseMemberId}), (Collection)Sets.newHashSet((Object[])new Long[]{scenarioId}), fyIds, (Collection)((Collection)longListPair.p2));
                logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u6d41\u7a0b:" + mcStatusMap);
                for (Map.Entry mcStatus : mcStatusMap.entrySet()) {
                    if (!((McStatus)mcStatus.getValue()).getFlow().isSubmit()) continue;
                    String key = (String)mcStatus.getKey();
                    String[] split = key.split("_");
                    msg = ResManager.loadKDString((String)"%1s %2s %3s %4s %5s \u6d41\u7a0b\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u3002", (String)"ReportToVoucherMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]);
                    if (split.length == 4) {
                        String modelNum = MemberReader.findModelNumberById((Object)modelId);
                        String scenaNum = MemberReader.findScenaMemberById((Long)modelId, (Long)LongUtil.toLong((Object)split[0])).getNumber();
                        String yearNum = MemberReader.findFyMemberById((Long)modelId, (Long)LongUtil.toLong((Object)split[1])).getNumber();
                        String periodNum = MemberReader.findPeriodMemberById((Long)modelId, (Long)LongUtil.toLong((Object)split[2])).getNumber();
                        msg = String.format(msg, modelNum, scenaNum, yearNum, periodNum, org);
                    }
                    throw new KDBizException(msg);
                }
            }
        }
        logger.info("\u53cd\u7ed3\u8d26 -- \u4e0d\u5b58\u5728\u4e0a\u62a5\u62a5\u8868\u4e0e\u63d0\u4ea4\u6d41\u7a0b\u5141\u8bb8\u53cd\u7ed3\u8d26");
        return Boolean.FALSE;
    }

    private static Set<String> getExcludOrgNums(Long modelId, List<DynamicObject> excludOrgs) {
        HashSet<String> allEntityIdSet = new HashSet<String>(excludOrgs.size());
        excludOrgs.forEach(p -> {
            Set entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange((String)"bcm_entitymembertree", (Long)LongUtil.toLong((Object)p.getString("dentity.oid")), (String)p.getString("dentity.num"), (int)Integer.parseInt(p.getString("dentity.rangevalue")), (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.MEMBERPERM);
            allEntityIdSet.addAll(entitySet);
        });
        return allEntityIdSet;
    }

    private boolean isAuditted(String org, String bookType, String year, Date period) {
        Map<Long, List<DynamicObject>> cm018Entitys = ReportToVoucherMsServiceImpl.getCM018Entitys();
        logger.info("\u53cd\u7ed3\u8d26 -- CM018\u914d\u7f6e\u8fc7\u65e0\u9700\u4ea4\u9a8c\u7ec4\u7ec7\u7684\u4f53\u7cfb\u96c6\u5408:" + cm018Entitys);
        Map<Long, Pair<Boolean, String>> cm018s = ReportToVoucherMsServiceImpl.getCM018s();
        logger.info("\u53cd\u7ed3\u8d26 -- CMO18\u662f\u5426\u5f00\u542f\u6821\u9a8c\u7684\u4f53\u7cfb\u96c6\u5408:" + cm018s);
        if (MapUtils.isEmpty(cm018s)) {
            return Boolean.FALSE;
        }
        Map entity2YearPeriods = ReportServiceHelper.collectEntity2YearPeriods(cm018Entitys);
        Calendar instance = Calendar.getInstance();
        instance.setTime(period);
        int month = instance.get(2) + 1;
        String monthStr = String.valueOf(month);
        if (!StringUtils.isEmpty((CharSequence)monthStr) && monthStr.length() == 1) {
            monthStr = "0" + monthStr;
        }
        for (Map.Entry<Long, Pair<Boolean, String>> entry : cm018s.entrySet()) {
            ArrayList<DynamicObject> reportList;
            boolean templateObj;
            Long modelId = entry.getKey();
            JSONObject json = JSONObjectUtil.parseObjectOrder((String)((String)entry.getValue().p2));
            String processSelection = json == null ? "1" : (String)json.get((Object)"processselection");
            logger.info("\u53cd\u7ed3\u8d26 -- \u4f53\u7cfb:" + modelId);
            List<DynamicObject> dyc_CM018 = cm018Entitys.get(modelId);
            Map dimMemMapByNum = DataCollectUtils.getGlMemMapByNum((Long)modelId, Collections.singletonList(org), (String)"Entity");
            String orgRef = (String)dimMemMapByNum.get(org);
            if (StringUtils.isEmpty((CharSequence)orgRef)) {
                orgRef = org;
            }
            String cube = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode fy = MemberReader.findFyMemberByNum((String)cube, (String)("FY" + year));
            IDNumberTreeNode monthNode = MemberReader.findPeriodMemberByNum((String)cube, (String)("M_M" + monthStr));
            Long periodId = monthNode.getId();
            Long yearId = fy.getId();
            if (dyc_CM018 != null && ReportToVoucherMsServiceImpl.containOrg(orgRef, entity2YearPeriods, modelId, dyc_CM018, yearId, periodId)) continue;
            DynamicObjectCollection fyColl = ReportToVoucherMsServiceImpl.getFYIdCollection(modelId);
            logger.info("\u53cd\u7ed3\u8d26 -- \u8d22\u5e74\u96c6\u5408:" + fyColl);
            DynamicObjectCollection periodColl = ReportToVoucherMsServiceImpl.getPeriodIdCollection(modelId);
            logger.info("\u53cd\u7ed3\u8d26 -- \u671f\u95f4\u96c6\u5408:" + periodColl);
            long orgId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, orgRef, "bcm_entitymembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u7ec4\u7ec7:" + orgId);
            if (orgId == 0L || fyColl == null || CollectionUtils.isEmpty((Collection)fyColl) || periodColl == null || CollectionUtils.isEmpty((Collection)periodColl)) continue;
            long scenarioId = ReportToVoucherMsServiceImpl.getIdByNameAndModel(modelId, "MRpt", "bcm_scenemembertree");
            logger.info("\u53cd\u7ed3\u8d26 -- \u60c5\u666f:" + scenarioId);
            DynamicObjectCollection dynamicObjects = ReportToVoucherMsServiceImpl.getReportWithCheckreportstatus(orgId, fyColl, periodColl, year, period, scenarioId, processSelection);
            logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u5df2\u4e0a\u62a5\u62a5\u8868:" + dynamicObjects);
            if (dynamicObjects != null && dynamicObjects.size() > 0 && (templateObj = ReportToVoucherMsServiceImpl.getTemplateWithCheckStatus(dynamicObjects, modelId, orgRef, reportList = new ArrayList<DynamicObject>(10)).booleanValue())) {
                return Boolean.TRUE;
            }
            if (scenarioId == 0L) continue;
            long entityBaseMemberId = TreeStructureServiceHelper.getEntityBaseMemberId((long)orgId);
            List<Pair<Long, List<Long>>> pair = ReportToVoucherMsServiceImpl.getFYAndPeriodFilter(fyColl, periodColl, year, period);
            if (pair == null) {
                return Boolean.FALSE;
            }
            for (Pair<Long, List<Long>> longListPair : pair) {
                List<Object> fyIds = Collections.singletonList(longListPair.p1);
                Map mcStatusMap = McStatus.batchGetMcStatus4Periods((Long)modelId, (Collection)Sets.newHashSet((Object[])new Long[]{entityBaseMemberId}), (Collection)Sets.newHashSet((Object[])new Long[]{scenarioId}), fyIds, (Collection)((Collection)longListPair.p2));
                logger.info("\u53cd\u7ed3\u8d26 -- \u67e5\u8be2\u6d41\u7a0b:" + mcStatusMap);
                for (Map.Entry mcStatus : mcStatusMap.entrySet()) {
                    if (!((McStatus)mcStatus.getValue()).getFlow().isSubmit()) continue;
                    logger.info("\u53cd\u7ed3\u8d26 -- \u6d41\u7a0b\u5df2\u63d0\u4ea4\u4e0d\u5141\u8bb8\u53cd\u7ed3\u8d26:" + mcStatus);
                    return Boolean.TRUE;
                }
            }
        }
        logger.info("\u53cd\u7ed3\u8d26 -- \u4e0d\u5b58\u5728\u4e0a\u62a5\u62a5\u8868\u4e0e\u63d0\u4ea4\u6d41\u7a0b\u5141\u8bb8\u53cd\u7ed3\u8d26");
        return Boolean.FALSE;
    }

    private static DynamicObjectCollection getPeriodIdCollection(long modelId) {
        Map scenePeriodByModel = ScenePeriodServiceHelper.getScenePeriodByModel((Long)modelId, Collections.singletonList("MRpt"));
        List periodIds = scenePeriodByModel.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", periodIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id,number, expmonth, expday", (QFilter[])qf.toArray(), (String)"expmonth,expday");
        if (query != null && query.size() > 0) {
            return query;
        }
        return null;
    }

    private static DynamicObjectCollection getFYIdCollection(long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id, number", (QFilter[])qf.toArray());
        if (query != null && query.size() > 0) {
            return query;
        }
        return null;
    }

    private static List<Long> getPeriodIds(long modelId, Date period) {
        List<Object> effectPeriodIds = Lists.newArrayList();
        Calendar instance = Calendar.getInstance();
        instance.setTime(period);
        int month = instance.get(2) + 1;
        int day = instance.get(5);
        Map scenePeriodByModel = ScenePeriodServiceHelper.getScenePeriodByModel((Long)modelId, Collections.singletonList("MRpt"));
        List periodIds = scenePeriodByModel.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QFilter qf = new QFilter("id", "in", periodIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_periodmembertree", (String)"id, expmonth, expday", (QFilter[])qf.toArray(), (String)"expmonth,expday");
        if (query != null && query.size() > 0) {
            effectPeriodIds = query.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) >= month).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= day).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        }
        return effectPeriodIds;
    }

    private static List<Long> getFYIds(long modelId, String year) {
        List<Object> effectFYIds = Lists.newArrayList();
        int currentYear = LocalDate.now().getYear();
        Integer yearInt = Integer.valueOf(year);
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id, number", (QFilter[])qf.toArray());
        if (query != null && query.size() > 0) {
            effectFYIds = query.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)) >= yearInt && Integer.parseInt(dynamicObject.getString("number").substring(2)) <= currentYear).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        }
        return effectFYIds;
    }

    private static long getIdByNameAndModel(long modelId, String number, String entityName) {
        DynamicObject dynamicObject;
        QFilter qf = new QFilter("number", "=", (Object)number);
        qf.and("model", "=", (Object)modelId);
        if (entityName.equals("bcm_entitymembertree")) {
            qf.and("storagetype", "=", (Object)"2");
        }
        if ((dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])qf.toArray())) == null) {
            return 0L;
        }
        return dynamicObject.getLong("id");
    }

    private DynamicObjectCollection getReportWithCheckreportstatus(long org, long year, long period, long scenarioId, String processSelection) {
        QFilter filter = new QFilter("entity", "=", (Object)org);
        filter.and("fyear", "=", (Object)year);
        filter.and("period", "=", (Object)period);
        filter.and("reportstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
        filter.and("scene", "=", (Object)scenarioId);
        return QueryServiceHelper.query((String)"ReportToVoucherMsServiceImpl", (String)"bcm_reportentity", (String)"template,template.number, period.number, fyear.number,scene.number,currency.number", (QFilter[])new QFilter[]{filter}, null);
    }

    private static DynamicObjectCollection getReportWithCheckreportstatus(long org, DynamicObjectCollection yearIds, DynamicObjectCollection periodIds, String year, Date periodDate, long scenarioId, String processSelection, String period, Long modelId) {
        List<Pair<Long, List<Long>>> ids = ReportToVoucherMsServiceImpl.getFYAndPeriodFilter(yearIds, periodIds, year, periodDate, period, modelId);
        return ReportToVoucherMsServiceImpl.getEffiectYearIdAndPeriodIds(org, scenarioId, processSelection, ids);
    }

    private static DynamicObjectCollection getReportWithCheckreportstatus(long org, DynamicObjectCollection yearIds, DynamicObjectCollection periodIds, String year, Date period, long scenarioId, String processSelection) {
        List<Pair<Long, List<Long>>> ids = ReportToVoucherMsServiceImpl.getFYAndPeriodFilter(yearIds, periodIds, year, period);
        return ReportToVoucherMsServiceImpl.getEffiectYearIdAndPeriodIds(org, scenarioId, processSelection, ids);
    }

    private static DynamicObjectCollection getEffiectYearIdAndPeriodIds(long org, long scenarioId, String processSelection, List<Pair<Long, List<Long>>> ids) {
        QFBuilder filter = new QFBuilder("entity", "=", (Object)org);
        logger.info("\u53cd\u7ed3\u8d26 -- \u8d22\u5e74\u671f\u95f4\u5bf9\u5e94\u8fc7\u6ee4\u7ec4\u5408:" + ids);
        if (ids == null) {
            return null;
        }
        List fyIds = ids.stream().map(Pair2 -> (Long)Pair2.p1).collect(Collectors.toList());
        ArrayList prIds = new ArrayList(16);
        ids.forEach(id -> {
            List perIds = (List)id.p2;
            prIds.addAll(perIds);
        });
        filter.and("fyear", "in", fyIds);
        filter.and("period", "in", prIds);
        if (processSelection.equalsIgnoreCase(ProcessSelectionEnum.REPORTCOMMIT.getValue())) {
            filter.and("reportstatus", "=", (Object)ReportStatusEnum.COMMIT.status());
        } else {
            filter.and("reportstatus", "in", (Object)new String[]{ReportStatusEnum.COMPLETE.status(), ReportStatusEnum.COMMIT.status()});
        }
        filter.and("scene", "=", (Object)scenarioId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ReportToVoucherMsServiceImpl", (String)"bcm_reportentity", (String)"id,template,period,fyear,template.number, period.number, fyear.number,scene.number,currency.number", (QFilter[])filter.toArray(), null);
        DynamicObjectCollection dynamicCollection = new DynamicObjectCollection();
        dynamicCollection = ids.size() == 1 ? dynamicObjectCollection : ReportToVoucherMsServiceImpl.getDynamicObjects(ids, dynamicObjectCollection, false);
        return dynamicCollection;
    }

    private static DynamicObjectCollection getDynamicObjects(List<Pair<Long, List<Long>>> ids, DynamicObjectCollection dynamicObjectCollection, boolean isMerge) {
        DynamicObjectCollection dynamicCollection = new DynamicObjectCollection();
        String yearColumn = "fyear";
        String periodColumn = "period";
        if (isMerge) {
            yearColumn = "year.id";
            periodColumn = "period.id";
        }
        String finalYearColumn = yearColumn;
        String finalPeriodColumn = periodColumn;
        ids.forEach(id -> {
            List dynamicObjects = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getLong(finalYearColumn) == ((Long)id.p1).longValue() && ((List)id.p2).contains(dynamicObject.getLong(finalPeriodColumn))).collect(Collectors.toList());
            dynamicCollection.addAll(dynamicObjects);
        });
        return dynamicCollection;
    }

    private static List<Pair<Long, List<Long>>> getFYAndPeriodFilter(DynamicObjectCollection yearDys, DynamicObjectCollection periodDys, String year, Date period, String periodNum, Long modelId) {
        int currentYear = LocalDate.now().getYear();
        int currentMonth = LocalDate.now().getMonth().getValue();
        int currentDay = LocalDate.now().getDayOfMonth();
        String yearNum = "FY" + year;
        int audittedYearInt = Integer.parseInt(year);
        Calendar instance = Calendar.getInstance();
        instance.setTime(period);
        int month = instance.get(2) + 1;
        int day = instance.get(5);
        ArrayList<Pair<Long, List<Long>>> fyAndPeriodIds = new ArrayList<Pair<Long, List<Long>>>(16);
        Map<String, Integer> periodSort = ReportToVoucherMsServiceImpl.getPeriodSort(modelId, DimTypesEnum.PERIOD.getNumber());
        List periodList = periodDys.stream().sorted(Comparator.comparing(e -> (Integer)periodSort.get(e.getString("number")), Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
        int index = -1;
        for (int i = 0; i < periodList.size(); ++i) {
            if (!periodNum.equalsIgnoreCase(((DynamicObject)periodList.get(i)).getString("number"))) continue;
            index = i;
        }
        List<DynamicObject> subPerioddys = null;
        if (index != -1) {
            subPerioddys = periodList.subList(index, periodList.size());
        }
        if (currentYear == audittedYearInt) {
            Long audittedYearId = ReportToVoucherMsServiceImpl.getAudittedYear(yearDys, yearNum);
            List<Long> effectPeriodIds = subPerioddys != null ? ReportToVoucherMsServiceImpl.getEffectPeriodIdsBeforeNow(currentMonth, currentDay, subPerioddys) : periodList.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) >= month).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= day).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) <= currentMonth).filter(dynamicObject -> ReportToVoucherMsServiceImpl.checkPeriodByCurrent(currentMonth, currentDay, dynamicObject)).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (audittedYearId == 0L || effectPeriodIds.isEmpty()) {
                return null;
            }
            fyAndPeriodIds.add(Pair.onePair((Object)audittedYearId, effectPeriodIds));
        } else if (currentYear > audittedYearInt) {
            Long audittedEffectFYId = ReportToVoucherMsServiceImpl.getAudittedYear(yearDys, yearNum);
            List audittedEffectPeriodIds = subPerioddys != null ? subPerioddys.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()) : periodDys.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) >= month).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) != month || Integer.parseInt(dynamicObject.getString("expday")) >= day).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (audittedEffectFYId != 0L && !audittedEffectPeriodIds.isEmpty()) {
                fyAndPeriodIds.add((Pair<Long, List<Long>>)Pair.onePair((Object)audittedEffectFYId, audittedEffectPeriodIds));
            }
            Long effectCurrentFYId = ReportToVoucherMsServiceImpl.getAudittedYear(yearDys, "FY" + currentYear);
            List<Long> effectCurrentPeriodIds = ReportToVoucherMsServiceImpl.getEffectPeriodIdsBeforeNow(currentMonth, currentDay, (List<DynamicObject>)periodDys);
            if (effectCurrentFYId != 0L && !effectCurrentPeriodIds.isEmpty()) {
                fyAndPeriodIds.add((Pair<Long, List<Long>>)Pair.onePair((Object)effectCurrentFYId, effectCurrentPeriodIds));
            }
            if (currentYear - audittedYearInt > 1) {
                List<Long> effectFYIds = ReportToVoucherMsServiceImpl.getBetweenYear(yearDys, currentYear, audittedYearInt);
                List effectPeriodIds = periodDys.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                if (!effectFYIds.isEmpty() && !effectPeriodIds.isEmpty()) {
                    effectFYIds.forEach(id -> fyAndPeriodIds.add(Pair.onePair((Object)id, (Object)effectPeriodIds)));
                }
            }
        } else {
            return null;
        }
        return fyAndPeriodIds;
    }

    private static List<Long> getBetweenYear(DynamicObjectCollection yearDys, int currentYear, int audittedYearInt) {
        List<Long> effectFYIds = yearDys.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> {
            int fy = Integer.parseInt(dynamicObject.getString("number").substring(2));
            return fy > audittedYearInt && fy < currentYear;
        }).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return effectFYIds;
    }

    private static Long getAudittedYear(DynamicObjectCollection yearDys, String yearNum) {
        Optional<Long> year = yearDys.stream().filter(dynamicObject -> dynamicObject.getString("number").equalsIgnoreCase(yearNum)).map(e -> e.getLong("id")).findFirst();
        return year.orElseGet(() -> 0L);
    }

    private static List<Long> getEffectPeriodIdsBeforeNow(int currentMonth, int currentDay, List<DynamicObject> perioddys) {
        List<Long> effectPeriodIds = perioddys.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) <= currentMonth).filter(dynamicObject -> ReportToVoucherMsServiceImpl.checkPeriodByCurrent(currentMonth, currentDay, dynamicObject)).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return effectPeriodIds;
    }

    private static boolean checkPeriodByCurrent(int currentMonth, int currentDay, DynamicObject dynamicObject) {
        return Integer.parseInt(dynamicObject.getString("expmonth")) != currentMonth || Integer.parseInt(dynamicObject.getString("expday")) >= currentDay;
    }

    public static Map<String, Integer> getPeriodSort(long modelId, String dimnum) {
        Map<String, Integer> number2seq = new HashMap<String, Integer>(10);
        if (DimTypesEnum.PERIOD.getNumber().equals(dimnum)) {
            Long periodDimId = MemberReader.getDimensionIdByNum((long)modelId, (String)dimnum);
            DimMemberSortUtil.compareTimeOfChangeAndRefresh((Long)modelId, null, (Long)periodDimId);
            String entityNumber = DimEntityNumEnum.getEntieyNumByNumber((String)dimnum);
            QFilter qFilter = new QFilter("model", "=", (Object)modelId);
            qFilter.and("membertype", "=", (Object)entityNumber);
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_memberorder", (String)"number, dseq", (QFilter[])qFilter.toArray());
            number2seq = dys.stream().collect(Collectors.toMap(d -> d.getString("number"), d -> d.getInt("dseq")));
        }
        return number2seq;
    }

    private static List<Pair<Long, List<Long>>> getFYAndPeriodFilter(DynamicObjectCollection yearIds, DynamicObjectCollection periodIds, String year, Date period) {
        int currentYear = LocalDate.now().getYear();
        int currentMonth = LocalDate.now().getMonth().getValue();
        int currentDay = LocalDate.now().getDayOfMonth();
        int yearInt = Integer.parseInt(year);
        Calendar instance = Calendar.getInstance();
        instance.setTime(period);
        int month = instance.get(2) + 1;
        int day = instance.get(5);
        ArrayList<Pair<Long, List<Long>>> fYAndPeriodIds = new ArrayList<Pair<Long, List<Long>>>(16);
        if (currentYear == yearInt) {
            List effectFYIds = yearIds.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)) >= yearInt && Integer.parseInt(dynamicObject.getString("number").substring(2)) <= currentYear).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            List effectPeriodIds = periodIds.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) >= month).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= day).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) <= currentMonth).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= currentDay).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (effectFYIds.isEmpty() || effectPeriodIds.isEmpty()) {
                return null;
            }
            fYAndPeriodIds.add(Pair.onePair(effectFYIds.get(0), effectPeriodIds));
        } else if (currentYear > yearInt) {
            List effectFYIds = yearIds.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)) == yearInt).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            List effectPeriodIds = periodIds.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) >= month).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= day).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (!effectFYIds.isEmpty() && !effectPeriodIds.isEmpty()) {
                fYAndPeriodIds.add(Pair.onePair(effectFYIds.get(0), effectPeriodIds));
            }
            List effectFYIds1 = yearIds.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)) == currentYear).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            List effectPeriodIds1 = periodIds.stream().filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expmonth")) <= currentMonth).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("expday")) >= currentDay).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            if (!effectFYIds1.isEmpty() && !effectPeriodIds1.isEmpty()) {
                fYAndPeriodIds.add((Pair<Long, List<Long>>)Pair.onePair(effectFYIds1.get(0), effectPeriodIds1));
            }
            if (currentYear - yearInt > 1) {
                List<Long> effectFYIds2 = yearIds.stream().filter(dynamicObject -> dynamicObject.getString("number").startsWith("FY")).filter(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)) > yearInt && Integer.parseInt(dynamicObject.getString("number").substring(2)) < currentYear).sorted(Comparator.comparing(dynamicObject -> Integer.parseInt(dynamicObject.getString("number").substring(2)))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                List effectPeriodIds2 = periodIds.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                if (!effectFYIds2.isEmpty() && !effectPeriodIds2.isEmpty()) {
                    effectFYIds2.forEach(id -> fYAndPeriodIds.add(Pair.onePair((Object)id, (Object)effectPeriodIds2)));
                }
            }
        } else {
            return null;
        }
        return fYAndPeriodIds;
    }

    private static Boolean getTemplateWithCheckStatus(DynamicObjectCollection dynamicObjects, Long modelId, String org, List<DynamicObject> reportList) {
        Map<String, List<DynamicObject>> reportByTemPlateId = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getString("template.number")));
        ArrayList<Long> templateIdList = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            templateIdList.add(dynamicObject.getLong("template"));
        }
        logger.info("\u53cd\u7ed3\u8d26 -- \u5df2\u4e0a\u62a5\u62a5\u8868\u6a21\u677fID:" + templateIdList);
        HashSet allEntityIdSet = new HashSet(16);
        QFilter templateFilter = new QFilter("ischeckstatus", "=", (Object)"1");
        templateFilter.and("ID", "in", templateIdList);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)"bcm_templateentity", (String)"number, ischeckstatus, uncheckentity", (QFilter[])new QFilter[]{templateFilter});
        for (DynamicObject template : templates) {
            String unCheckEntityStr = template.getString("uncheckentity");
            if (!StringUtil.isEmptyString((String)unCheckEntityStr)) {
                List list = (List)JSON.parseObject((String)unCheckEntityStr, List.class);
                for (Map stringStringMap : list) {
                    Set entitySet = QueryMemberDetailsHelper.queryMemberNumbersByRange((String)"bcm_entitymembertree", (Long)Long.parseLong((String)stringStringMap.get("oid")), (String)((String)stringStringMap.get("number")), (int)Integer.parseInt((String)stringStringMap.get("rangevalue")), (String)modelId.toString(), (DetailTypeEnum)DetailTypeEnum.MEMBERPERM);
                    allEntityIdSet.addAll(entitySet);
                }
            }
            if (allEntityIdSet.contains(org)) continue;
            reportList.addAll((Collection<DynamicObject>)reportByTemPlateId.get(template.getString("number")));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Map<String, Boolean> isAudittedBatch(List<String> orgs, String bookType, String year, String period) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(orgs.size());
        for (String org : orgs) {
            resultMap.put(org, this.isAuditted(org, bookType, year, period));
        }
        return resultMap;
    }

    private Map<String, Boolean> isAudittedBatch(List<String> orgs, String bookType, String year, Date period) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(orgs.size());
        for (String org : orgs) {
            resultMap.put(org, this.isAuditted(org, bookType, year, period));
        }
        return resultMap;
    }

    private long getModelId() {
        QFilter qFilter = new QFilter("number", "=", (Object)"CM03");
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_modelconfigsetting", (String)"searchmodel", (QFilter[])qFilter.toArray());
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("searchmodel");
    }

    public static Map<Long, List<DynamicObject>> getCM018Entitys() {
        QFBuilder cm018Builder = new QFBuilder("number", "=", (Object)"CM018").add("dentity.isshow", "=", (Object)"1");
        DynamicObjectCollection dyc_CM018s = QueryServiceHelper.query((String)"bcm_checkledgersetting", (String)"id, model, number, dentity.num, dentity.rangevalue, dentity.oid, dentity.year, dentity.period, dentity.id", (QFilter[])cm018Builder.toArray());
        Map<Object, Object> cm018GroupByModel = Maps.newHashMap();
        if (dyc_CM018s != null && !dyc_CM018s.isEmpty()) {
            cm018GroupByModel = dyc_CM018s.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("model")));
        }
        return cm018GroupByModel;
    }

    public static Map<Long, Pair<Boolean, String>> getCM018s() {
        QFilter qf = new QFilter("number", "=", (Object)"CM018").and("entryentity.model", "!=", (Object)0L);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_preset_param", (String)"entryentity.params,entryentity.model", (QFilter[])qf.toArray());
        HashMap cm018GroupByModel = Maps.newHashMap();
        dys.forEach(dy -> {
            JSONObject json;
            String params = dy.getString("entryentity.params");
            if (StringUtils.isNotEmpty((CharSequence)params) && (json = (JSONObject)ParamSettingUtils.convertParams2Object((PsDataTypeEnum)PsDataTypeEnum.JSON, (String)params)).getBoolean("checkreport").booleanValue()) {
                cm018GroupByModel.put(dy.getLong("entryentity.model"), Pair.onePair((Object)json.getBoolean("checkreport"), (Object)params));
            }
        });
        return cm018GroupByModel;
    }
}

