/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.adjust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.convert.AdjustRateDiffCreateService;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDataNotNullValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckDimMemValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustCheckPermValidator;
import kd.fi.bcm.business.adjust.validator.DynamicValidator.AdjustSceneVersionValidator;
import kd.fi.bcm.business.adjust.validator.IValidator;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.enums.RptAdjustStatusEnum;
import kd.fi.bcm.common.enums.adjust.AdjustEntryRowTypeEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.opplugin.AbstractBcmBaseOpServicePlugin;

public class AdjustCreateDiffOp
extends AbstractBcmBaseOpServicePlugin {
    protected OperationResult operationResult = new OperationResult();

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        AdjustRateDiffCreateService rateDiff;
        List ids = Arrays.stream(e.getDataEntities()).map(p -> p.getLong("id")).collect(Collectors.toList());
        this.operationResult.getSuccessPkIds().addAll(ids);
        this.operationResult.setBillCount(ids.size());
        Long model = Long.parseLong(this.getOption().getVariableValue("model"));
        long scene = Long.parseLong(this.getOption().getVariableValue("scene"));
        Long tarYear = Long.parseLong(this.getOption().getVariableValue("year"));
        Long tarPeriod = Long.parseLong(this.getOption().getVariableValue("period"));
        OperationResult tempResult = AdjustmentServiceHelper.checkAdjustByValidator((long)model, ids.parallelStream().collect(Collectors.toList()), e1 -> {
            e1.setValidateResult(this.getOperationResult());
            e1.setOperationKey("btn_adddiffentry");
            e1.getCtx().setScenarioId(scene);
            e1.addValidator((IValidator)new AdjustSceneVersionValidator());
            e1.addValidator((IValidator)new AdjustCheckDataNotNullValidator());
            e1.addValidator((IValidator)new AdjustCheckPermValidator());
            e1.addValidator((IValidator)new AdjustCheckDimMemValidator());
        });
        tempResult.getAllErrorInfo().forEach(error -> this.addErrorMsg((Long)error.getPkValue(), "", error.getMessage()));
        this.getOperationResult().getSuccessPkIds().retainAll(tempResult.getSuccessPkIds());
        ArrayList resultDataList = new ArrayList(10);
        ArrayList resultList = new ArrayList(10);
        try {
            rateDiff = new AdjustRateDiffCreateService(model, Long.valueOf(scene), tarYear, tarPeriod);
        }
        catch (KDBizException ex) {
            QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)model);
            qfBuilder.add("id", "in", ids);
            DynamicObject[] numbers = BusinessDataServiceHelper.load((String)"bcm_rptadjust", (String)"id,number", (QFilter[])qfBuilder.toArray());
            if (numbers == null || numbers.length == 0) {
                return;
            }
            for (DynamicObject number : numbers) {
                this.addErrorMsg(number.getLong("id"), number.getString("number"), ex.getMessage());
            }
            return;
        }
        AdjustOperationThreadHelper.iterator((List)this.getOperationResult().getSuccessPkIds(), (boolean)true, (adjust, list) -> {
            if (this.checkSingleAdjust(adjust, list)) {
                try {
                    resultDataList.addAll(rateDiff.createRateDiffSingleElim(list, adjust.getBoolean("multiplecurrency")));
                    adjust.set("spreadjson", null);
                    adjust.set("data", null);
                    resultList.add(adjust);
                }
                catch (Throwable ex) {
                    this.addErrorMsg(adjust.getLong("id"), adjust.getString("number"), adjust.getString("number") + ":" + AdjustmentServiceHelper.toString_Adj((Throwable)ex));
                }
            }
        });
        if (this.operationResult.getSuccessPkIds().size() > 0) {
            try (TXHandle tx = TX.required();){
                try {
                    SaveServiceHelper.update((DynamicObject[])resultList.toArray(new DynamicObject[resultList.size()]));
                    DeleteServiceHelper.delete((String)"bcm_rptadjustdata", (QFilter[])new QFilter[]{new QFilter("adjust", "in", (Object)this.operationResult.getSuccessPkIds()), new QFilter("entryrowtype", "in", (Object)new String[]{AdjustEntryRowTypeEnum.CURR_DIFF.getValue() + "", AdjustEntryRowTypeEnum.RATE_DIFF.getValue() + ""})});
                    SaveServiceHelper.save((DynamicObject[])resultDataList.toArray(new DynamicObject[resultDataList.size()]));
                }
                catch (Throwable ex) {
                    tx.markRollback();
                    this.operationResult.getSuccessPkIds().clear();
                    this.addErrorMsg(0L, "", ThrowableHelper.toString((Throwable)ex));
                }
            }
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)ResManager.loadKDString((String)"\u6c47\u7387\u5dee\u8ba1\u7b97\u5df2\u5b8c\u6210\u3002", (String)"AdjustCreateDiffOp_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u6c47\u7387\u5dee\u8ba1\u7b97\u5df2\u5b8c\u6210\u3002", (String)"AdjustCreateDiffOp_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]), (Long)model, (String)"bcm_rptadjust");
        logService.addLog(logInfo);
    }

    private boolean checkSingleAdjust(DynamicObject adjust, List<DynamicObject> list) {
        String status = adjust.getString("status");
        if (list == null || list.isEmpty()) {
            this.addErrorMsg(adjust.getLong("id"), adjust.getString("number"), ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustCreateDiffOp_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!(RptAdjustStatusEnum.BACK.status().equals(status) || RptAdjustStatusEnum.TEMPSAVE.status().equals(status) || RptAdjustStatusEnum.SAVE.status().equals(status))) {
            this.addErrorMsg(adjust.getLong("id"), adjust.getString("number"), ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6682\u5b58\uff0c\u4fdd\u5b58\u53ca\u5df2\u6253\u56de\u7684\u5206\u5f55\u8ba1\u7b97\u6c47\u5dee\u3002", (String)"AdjustCreateDiffOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        e.getOperationResult().getSuccessPkIds().clear();
        e.getOperationResult().getAllErrorInfo().clear();
        e.getOperationResult().getAllErrorInfo().addAll(this.operationResult.getAllErrorInfo());
        e.getOperationResult().setSuccessPkIds(this.operationResult.getSuccessPkIds());
        ((OperationResult)e.getOperationResult()).setBillCount(this.operationResult.getBillCount());
        ((OperationResult)e.getOperationResult()).setSuccess(this.operationResult.isSuccess());
    }

    protected void addErrorMsg(Long pkid, String number, String msg) {
        this.operationResult.getSuccessPkIds().remove(pkid);
        this.operationResult.setSuccess(false);
        OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
        if (StringUtils.isEmpty((String)number)) {
            operateErrorInfo.setMessage(msg);
        } else {
            operateErrorInfo.setMessage(number + "\uff1a" + msg);
        }
        operateErrorInfo.setErrorLevel(ErrorLevel.Error.name());
        this.operationResult.addErrorInfo(operateErrorInfo);
    }
}

