/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.computing;

import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.common.enums.BizRuleRunStatusEnum;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.formplugin.computing.BizRuleConfigFormulaHelper;
import kd.fi.bcm.opplugin.computing.BizRuleSaveValidator;

public class BizRuleConfigSaveOp
extends AbstractOperationServicePlugIn {
    public static final Log logger = LogFactory.getLog(BizRuleConfigSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BizRuleSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bizRules = e.getDataEntities();
        long currentTime = System.currentTimeMillis();
        String userId = RequestContext.get().getUserId();
        for (DynamicObject bizRule : bizRules) {
            String msg;
            bizRule.set("modifytime", (Object)currentTime);
            bizRule.set("modifier", (Object)userId);
            QFilter filter = new QFilter("processcatalog", "=", bizRule.get("processcatalog.id"));
            filter.and("deletestatus", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id, catalog, processcatalog", (QFilter[])new QFilter[]{filter});
            if (bizRule.getLong("id") == 0L) {
                bizRule.set("executeseq", (Object)("" + (collection.size() + 1)));
            }
            bizRule.set("deletestatus", (Object)Boolean.FALSE);
            String script = BizRuleConfigFormulaHelper.buildScript((DynamicObject)bizRule);
            if (bizRule.getDynamicObjectCollection("entryentity").size() > 1) {
                StringBuilder builder = new StringBuilder("beginBatch();\r\n");
                script = builder.append(script).append("\r\nendBatch();").toString();
            }
            if (StringUtils.isNotEmpty((CharSequence)(msg = BizRuleUtil.checkScriptGrammar((String)script)))) {
                logger.info("---\u53ef\u89c6\u5316\u4e1a\u52a1\u89c4\u5219-----\u811a\u672c\u62fc\u63a5\u9519\u8bef\uff1a" + script);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"BizRuleConfigSaveOp_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]), msg));
            }
            if (BizRuleUtil.checkAllProcessBeforeSave((boolean)bizRule.getBoolean("iscommon"), (String)bizRule.getString("alloprocessid"), (String)bizRule.getString("alloprocessname"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u914d\u8fc7\u7a0b\u3002", (String)"BizRuleConfigSaveOp_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            }
            if (ThreadCache.get((Object)"isCommit") != null && bizRule.getInt("runstatus") == BizRuleRunStatusEnum.COMMITED.getIndex() && !script.equals(bizRule.get("debug"))) {
                bizRule.set("runstatus", (Object)BizRuleRunStatusEnum.MODIFIED.getIndex());
            }
            bizRule.set("debug", (Object)script);
            if (bizRule.getLong("internal") != 0L) continue;
            bizRule.set("internal", (Object)BizRuleUtil.getNewInternalId());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        CacheGenFactory.getCommonCache().invalidateByKey("getAllBizRule_" + MemberReader.findModelNumberById((Object)e.getDataEntities()[0].getLong("model.id")));
    }
}

