/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.computing;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.bizrule.BizRuleUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.factory.CacheGenFactory;
import kd.fi.bcm.opplugin.computing.BizRuleSaveValidator;

public class BizRuleSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BizRuleSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bizRules = e.getDataEntities();
        long currentTime = System.currentTimeMillis();
        String userId = RequestContext.get().getUserId();
        for (DynamicObject bizRule : bizRules) {
            bizRule.set("modifytime", (Object)currentTime);
            bizRule.set("name", (Object)bizRule.getString("name").trim());
            bizRule.set("modifier", (Object)userId);
            QFilter filter = new QFilter("processcatalog", "=", bizRule.get("processcatalog.id"));
            filter.and("deletestatus", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bcm_bizruleentity", (String)"id, catalog, processcatalog", (QFilter[])new QFilter[]{filter});
            if (bizRule.getLong("id") == 0L) {
                bizRule.set("executeseq", (Object)(collection.size() + 1));
            }
            bizRule.set("deletestatus", (Object)Boolean.FALSE);
            if (bizRule.getLong("internal") != 0L) continue;
            bizRule.set("internal", (Object)BizRuleUtil.getNewInternalId());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        CacheGenFactory.getCommonCache().invalidateByKey("getAllBizRule_" + MemberReader.findModelNumberById((Object)e.getDataEntities()[0].getLong("model.id")));
    }
}

