/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.Date;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.opplugin.dimension.AccountMemberSaveValidator;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveOp;

public class AccountMemberSaveOp
extends DimensionMemberSaveOp {
    private static final String BOYUserdefinedRate = "BOYUserdefinedRate";
    private static final String UserdefinedRate = "UserdefinedRate";
    private static final String ACCOUNTMEMBER = "accountnumber";
    private static final String SCALE = "scale";
    private static final String ACCOUNTSCALE = "accountscale";
    private static final String MODEL = "model";

    private static String getUserdefinedRateName() {
        return ResManager.loadKDString((String)"\u5e74\u521d\u81ea\u5b9a\u4e49\u6c47\u7387", (String)"AccountMemberSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AccountMemberSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dys;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dy : dys = e.getDataEntities()) {
            SaveDimMemberHelper.saveLog((DynamicObject)dy);
            DynamicObject part = dy.getDynamicObject("accountpart");
            part = part == null ? BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp") : BusinessDataServiceHelper.loadSingle((Object)part.getLong("id"), (DynamicObjectType)part.getDynamicObjectType());
            part.set("isaccountoffset", (Object)dy.getBoolean("isaccountoffset"));
            part = (DynamicObject)SaveServiceHelper.save((IDataEntityType)part.getDataEntityType(), (Object[])new DynamicObject[]{part})[0];
            dy.set("accountpart", part.get("id"));
            String number = dy.getString("number");
            String actionName = dy.getString("addtext");
            if (!number.contains(UserdefinedRate) || !"baritemaddlevel".equals(actionName) && !"baritemaddsub".equals(actionName)) continue;
            String replace = number.replace(UserdefinedRate, "");
            int seq = 2;
            if (StringUtils.isNotEmpty((CharSequence)replace)) {
                seq = Integer.parseInt(replace);
            }
            this.newFYAccount(seq, dy);
            dy.set("dseq", (Object)(dy.getInt("dseq") + 1));
        }
        this.saveModifyInfo(dys[0]);
    }

    private void newFYAccount(Integer seq, DynamicObject account) {
        String number = BOYUserdefinedRate + seq;
        DynamicObject model = account.getDynamicObject(MODEL);
        String _number = seq == 1 ? BOYUserdefinedRate : BOYUserdefinedRate + (seq - 1);
        QFilter filter = QFilter.of((String)"model = ? and number = ?", (Object[])new Object[]{model.getLong("id"), _number});
        DynamicObject acountId = BusinessDataServiceHelper.loadSingle((String)"bcm_accountmembertree", (String)"id", (QFilter[])filter.toArray());
        if (acountId != null) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)acountId.get("id"), (String)"bcm_accountmembertree");
            CloneUtils cloneUtils = new CloneUtils(true, true);
            DynamicObject newdy = (DynamicObject)cloneUtils.clone(loadSingle.getDataEntityType(), (Object)loadSingle);
            newdy.set("number", (Object)number);
            String name = AccountMemberSaveOp.getUserdefinedRateName() + seq;
            newdy.set("name", (Object)name);
            newdy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            newdy.set("creator", (Object)RequestContext.get().getUserId());
            newdy.set("createtime", (Object)new Date());
            newdy.set("modifier", (Object)RequestContext.get().getUserId());
            newdy.set("modifytime", (Object)new Date());
            newdy.set("issysmember", (Object)Boolean.FALSE);
            newdy.set("dseq", (Object)(loadSingle.getInt("dseq") + 1));
            newdy.set("longnumber", (Object)(loadSingle.getDynamicObject("parent").getString("longnumber") + "!" + number));
            newdy.set("fullname", (Object)(loadSingle.getDynamicObject("parent").getString("fullname") + "." + name));
            newdy.set("simplename", (Object)name);
            newdy.set("parent_id", loadSingle.getDynamicObject("parent").getPkValue());
            SysDimensionEnum dimension = SysDimensionEnum.Account;
            String memberTreemodel = dimension.getMemberMemberModel();
            DynamicObject memberDyn = BusinessDataServiceHelper.newDynamicObject((String)memberTreemodel);
            memberDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            memberDyn.set(MODEL, newdy.get(MODEL));
            memberDyn.set("dimension", newdy.get("dimension"));
            memberDyn.set("number", newdy.get("number"));
            memberDyn.set("name", newdy.get("name"));
            memberDyn.set("simplename", newdy.get("simplename"));
            newdy.set("member", (Object)memberDyn);
            QFilter qf1 = new QFilter("dseq", ">", (Object)loadSingle.getInt("dseq"));
            QFilter _filter = new QFilter("parent", "=", loadSingle.getDynamicObject("parent").getPkValue());
            QFilter[] filters = new QFilter[]{qf1, _filter};
            DynamicObject[] dcs = BusinessDataServiceHelper.load((String)"bcm_accountmembertree", (String)"id,dseq", (QFilter[])filters, (String)"dseq desc");
            if (dcs.length > 0) {
                Stream.of(dcs).forEach(v -> v.set("dseq", (Object)(v.getInt("dseq") + 1)));
            }
            try (TXHandle th = TX.requiresNew();){
                try {
                    if (dcs.length > 0) {
                        SaveServiceHelper.save((DynamicObject[])dcs);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newdy});
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{memberDyn});
                    OlapServiceHelper.createMember((String)model.getString("number"), (String)newdy.getDynamicObject("dimension").getString("number"), (String)number, (int)5, (String)loadSingle.getDynamicObject("parent").getString("number"));
                }
                catch (Exception ex) {
                    th.markRollback();
                }
            }
        }
    }

    private void saveModifyInfo(DynamicObject entityData) {
        DynamicObject model = entityData.getDynamicObject(MODEL);
        long modelid = model.getLong("id");
        DynamicObject modifier = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        modifier.set("id", (Object)RequestContext.get().getUserId());
        modifier.set("name", (Object)RequestContext.get().getUserName());
        Date nowDate = TimeServiceHelper.now();
        DynamicObjectCollection bizChangerds = entityData.getDynamicObjectCollection("bizchangerds");
        if (bizChangerds.size() < 1) {
            DynamicObject defaultBiz = bizChangerds.addNew();
            defaultBiz.set("bizeffdate", (Object)nowDate);
            defaultBiz.set("bizmodifier", (Object)modifier);
            defaultBiz.set("bizmodifytime", (Object)nowDate);
            defaultBiz.set("modelid", (Object)modelid);
        }
        for (int i = bizChangerds.size() - 1; i >= 0; --i) {
            DynamicObject bizData = (DynamicObject)bizChangerds.get(i);
            if (!StringUtils.isEmpty((CharSequence)bizData.getString("bizmodifier"))) continue;
            bizData.set("bizmodifier", (Object)modifier);
            bizData.set("bizmodifytime", (Object)nowDate);
            bizData.set("modelid", (Object)modelid);
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    @Override
    public String getModelType() {
        return "bcm_accountmember";
    }

    @Override
    public String getTreeModelType() {
        return "bcm_accountmembertree";
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String actionName = data.getString("addtext");
            if (!"baritemaddlevel".equals(actionName) && !"baritemaddsub".equals(actionName) && !"edit".equals(actionName)) continue;
            this.saveCurrencyScale(data);
        }
    }

    private void saveCurrencyScale(DynamicObject account) {
        String selectFields = "accountnumber,scale";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter(MODEL, "=", (Object)account.getLong("model.id")));
        qfBuilder.add(new QFilter(ACCOUNTMEMBER, "=", (Object)account.getString("number")));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_accountscale", (String)selectFields, (QFilter[])qfBuilder.toArray());
        if (dynamicObject == null && account.getString(ACCOUNTSCALE) != null) {
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_accountscale");
            newDynamicObject.set(MODEL, (Object)account.getLong("model.id"));
            newDynamicObject.set(ACCOUNTMEMBER, (Object)account.getString("number"));
            newDynamicObject.set(SCALE, (Object)account.getInt(ACCOUNTSCALE));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
        } else if (dynamicObject != null && account.getString(ACCOUNTSCALE) != null) {
            dynamicObject.set(SCALE, (Object)account.getInt(ACCOUNTSCALE));
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        } else if (dynamicObject != null && account.getString(ACCOUNTSCALE) == null) {
            QFBuilder deletefilter = new QFBuilder();
            deletefilter.add(new QFilter(MODEL, "=", (Object)account.getLong("model.id")));
            deletefilter.add(new QFilter(ACCOUNTMEMBER, "=", (Object)dynamicObject.getString(ACCOUNTMEMBER)));
            DeleteServiceHelper.delete((String)"bcm_accountscale", (QFilter[])deletefilter.toArray());
        }
    }
}

