/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.mq.consumer.MQMessagePublisherServiceHelper;
import kd.fi.bcm.business.olap.dynamic.DynamicOlapHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.common.CheckConstant;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.opplugin.AbstractBcmBaseOpServicePlugin;

public class CreateDimensionOp
extends AbstractBcmBaseOpServicePlugin {
    private boolean isEdit = false;
    private boolean isDynamicCacPropChanged = false;
    private static final String[] num = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DimensionSubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long dimId = e.getDataEntities()[0].getLong("id");
        String dimName = e.getDataEntities()[0].getString("name");
        DynamicObject existingBill = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"", (QFilter[])new QFilter("id", "=", (Object)dimId).toArray());
        this.isEdit = Objects.nonNull(existingBill);
        this.isDynamicCacPropChanged = !this.isEdit || existingBill.getBoolean("isexcdycompute") != e.getDataEntities()[0].getBoolean("isexcdycompute");
        long modelId = e.getDataEntities()[0].getDynamicObject("model").getLong("id");
        String modelNum = e.getDataEntities()[0].getDynamicObject("model").getString("number");
        String newnumber = e.getDataEntities()[0].getString("number");
        OrmLocaleValue newname = (OrmLocaleValue)e.getDataEntities()[0].get("name");
        String shortnumber = e.getDataEntities()[0].getString("shortnumber");
        String fieldmapped = e.getDataEntities()[0].getString("fieldmapped");
        String storetype = e.getDataEntities()[0].getString("storagetype");
        String membermodel = e.getDataEntities()[0].getString("membermodel");
        if (!this.isEdit) {
            long memberId = GlobalIdUtil.genGlobalLongId();
            DimensionServiceHelper.afterCreateDim((long)modelId, (long)dimId, (long)memberId, (boolean)true);
            this.addDefineDimForCheck(modelId, e.getDataEntities()[0], memberId, fieldmapped);
            this.addDefineDimForIntraCheck(modelId, memberId, fieldmapped);
            this.addDefineDimForInvelim(modelId, memberId, fieldmapped);
            this.addDefineDimForInvSheetElim(modelId, memberId, fieldmapped);
            this.addLinkageMapping(modelId, memberId, fieldmapped, dimName, newname.getLocaleValue());
            DimensionServiceHelper.addChkFormula((long)modelId, (String)shortnumber, (String)(shortnumber + "None"));
            DimensionServiceHelper.addInvFormula((long)modelId, (String)shortnumber, (String)(shortnumber + "None"));
            AdjustmentServiceHelper.updateAdjust2AddDim((long)modelId, (long)dimId, (String)fieldmapped, (long)memberId, (String)membermodel);
            this.preSetUserDefine(modelId, dimId, newname, newnumber, shortnumber, modelNum, storetype, memberId);
        } else {
            QFilter fmodelid = new QFilter("dimension", "=", (Object)Long.valueOf(QueryDimensionServiceHelper.getDimIdByNumber((String)newnumber, (String)String.valueOf(modelId))));
            QFilter fmodelid2 = new QFilter("level", "=", (Object)1);
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)membermodel, (String)"id", (QFilter[])filters, null);
            String id = "";
            if (dcs != null && dcs.size() > 0) {
                id = String.valueOf(((DynamicObject)dcs.get(0)).get("id"));
            }
            DynamicObject dddy = BusinessDataServiceHelper.newDynamicObject((String)membermodel);
            DynamicObject dj = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)dddy.getDynamicObjectType());
            dj.set("name", (Object)newname);
            dj.set("storagetype", (Object)storetype);
            dj.set("modifytime", (Object)TimeServiceHelper.now());
            dj.set("modifier", (Object)RequestContext.get().getUserId());
            DynamicObject[] djs = new DynamicObject[]{dj};
            SaveServiceHelper.save((DynamicObject[])djs);
            OlapServiceHelper.alterMemberStorageType((String)modelNum, (String)newnumber, (String)newnumber, (String)storetype);
            MQMessagePublisherServiceHelper.publishClearDimMemberCache((String)modelNum, (String)membermodel);
            GlobalCacheServiceHelper.getCommonCache().invalidateByKey("getDimensionDynById-" + dimId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dataEntity = e.getDataEntities()[0];
        long modelId = dataEntity.getDynamicObject("model").getLong("id");
        long dimId = dataEntity.getLong("id");
        if (this.isDynamicCacPropChanged) {
            String modelNumber = e.getDataEntities()[0].getDynamicObject("model").getString("number");
            if (e.getDataEntities()[0].getBoolean("isexcdycompute")) {
                DynamicOlapHelper.setDynamicDim((long)modelId, (String)modelNumber, (String)e.getDataEntities()[0].getString("number"));
            } else {
                DynamicOlapHelper.unSetDynamicDim((long)modelId, (String)modelNumber, (String)e.getDataEntities()[0].getString("number"));
            }
        }
        if (!this.isEdit) {
            DimMemberSortUtil.upadteDimChangeTime((Long)modelId, (Long)0L, (Long)dimId, (String)"changetime");
        }
    }

    private void addDefineDimForInvelim(long modelId, long memberId, String fieldmapped) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dycoll = QueryServiceHelper.query((String)"bcm_invelimtemplate", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> invelimtmplIds = new ArrayList<Long>();
        for (DynamicObject dy : dycoll) {
            invelimtmplIds.add(dy.getLong("id"));
        }
        int index = Integer.parseInt(fieldmapped.substring(3));
        if (invelimtmplIds.size() > 0) {
            DynamicObject[] result = BusinessDataServiceHelper.load((Object[])invelimtmplIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_invelimtemplate").getDynamicObjectType());
            String key = "userdefine" + index;
            for (DynamicObject obj : result) {
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("invelimtplentry");
                for (DynamicObject entry : entryColl) {
                    entry.set(key, (Object)memberId);
                }
            }
            SaveServiceHelper.save((DynamicObject[])result);
        }
    }

    private void addDefineDimForInvSheetElim(long modelId, long memberId, String fieldmapped) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dycoll = QueryServiceHelper.query((String)"bcm_invsheetttplentrys", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> invelimtmplIds = new ArrayList<Long>();
        for (DynamicObject dy : dycoll) {
            invelimtmplIds.add(dy.getLong("id"));
        }
        int index = Integer.parseInt(fieldmapped.substring(3));
        if (invelimtmplIds.size() > 0) {
            DynamicObject[] result = BusinessDataServiceHelper.load((Object[])invelimtmplIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_invsheetttplentrys").getDynamicObjectType());
            String key = "userdefine" + index;
            for (DynamicObject obj : result) {
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("invelimtplentry");
                for (DynamicObject entry : entryColl) {
                    entry.set(key, (Object)memberId);
                }
            }
            SaveServiceHelper.save((DynamicObject[])result);
        }
    }

    private void addDefineDimForCheck(long modelId, DynamicObject dim, long memberId, String fieldmapped) {
        DynamicObject[] recordObjs;
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dycoll = QueryServiceHelper.query((String)"bcm_checktmpl", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> checktmplIds = new ArrayList<Long>();
        for (DynamicObject dy : dycoll) {
            checktmplIds.add(dy.getLong("id"));
        }
        int index = Integer.parseInt(fieldmapped.substring(3));
        if (checktmplIds.size() > 0) {
            DynamicObject[] result = BusinessDataServiceHelper.load((Object[])checktmplIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_checktmpl").getDynamicObjectType());
            String key = (String)CheckConstant.PRESET_DIMFIELDS.get(index - 1);
            String elimKey = (String)CheckConstant.PRESET_ELIM_DIMFIELDS.get(index - 1);
            for (DynamicObject obj : result) {
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("entryentity");
                DynamicObjectType type = ((DynamicObject)entryColl.get(0)).getDynamicObjectCollection("detailscope").getDynamicObjectType();
                DynamicObjectType elimType = ((DynamicObject)entryColl.get(0)).getDynamicObjectCollection("elimdetailscope").getDynamicObjectType();
                for (DynamicObject entry : entryColl) {
                    this.setDetailScopeByKey(memberId, false, key, dim, entry, type);
                    this.setDetailScopeByKey(memberId, true, elimKey, dim, entry, elimType);
                }
            }
            SaveServiceHelper.save((DynamicObject[])result);
        }
        DynamicObjectCollection recordColl = QueryServiceHelper.query((String)"bcm_checkrecord", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> recordIds = new ArrayList<Long>();
        for (DynamicObject dd : recordColl) {
            recordIds.add(dd.getLong("id"));
        }
        QFilter recordFilters = new QFilter("id", "in", recordIds);
        for (DynamicObject obj : recordObjs = BusinessDataServiceHelper.load((String)"bcm_checkrecord", (String)"id,entryentity,entryentity.entrydim1,entryentity.entrydim2,entryentity.entrydim3,entryentity.entrydim4,entryentity.entrydim5,entryentity.entrydim6", (QFilter[])new QFilter[]{recordFilters})) {
            DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryColl) {
                entry.set("entrydim" + index, (Object)memberId);
            }
        }
        SaveServiceHelper.save((DynamicObject[])recordObjs);
    }

    private void addDefineDimForIntraCheck(long modelId, long memberId, String fieldmapped) {
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection dycoll = QueryServiceHelper.query((String)"bcm_adjsetting", (String)"id", (QFilter[])new QFilter[]{fmodelid});
        ArrayList<Long> adjSettingIds = new ArrayList<Long>();
        for (DynamicObject dy : dycoll) {
            adjSettingIds.add(dy.getLong("id"));
        }
        int index = Integer.parseInt(fieldmapped.substring(3));
        if (adjSettingIds.size() > 0) {
            DynamicObject[] result = BusinessDataServiceHelper.load((Object[])adjSettingIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_adjsetting").getDynamicObjectType());
            String key = (String)CheckConstant.PRESET_DIMFIELDS.get(index - 1);
            for (DynamicObject obj : result) {
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryColl) {
                    entry.set(key + "classtype", (Object)"bcm_userdefinedmembertree");
                    entry.set(key + "dyn", (Object)memberId);
                }
            }
            SaveServiceHelper.save((DynamicObject[])result);
        }
    }

    private void setDetailScopeByKey(long memberId, boolean isElim, String key, DynamicObject dimension, DynamicObject entry, DynamicObjectType type) {
        String preKey = isElim ? "elim" : "";
        String dyCtrl = isElim ? "elimdetailscope" : "detailscope";
        DynamicObjectCollection coll = entry.getDynamicObjectCollection(dyCtrl);
        if (coll == null || coll.size() == 0) {
            coll = new DynamicObjectCollection();
        }
        DynamicObject dy = new DynamicObject(type);
        dy.set(preKey + "dimension", (Object)dimension);
        dy.set(preKey + "sign", (Object)key);
        dy.set(preKey + "memberid", (Object)memberId);
        dy.set(preKey + "scope", (Object)RangeEnum.VALUE_10.getValue());
        coll.add((Object)dy);
        entry.set(dyCtrl, (Object)coll);
    }

    private void addLinkageMapping(long modelId, long memberId, String fieldmapped, String dimName, String newname) {
        int index = Integer.parseInt(fieldmapped.substring(3));
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] linkagemappings = BusinessDataServiceHelper.load((String)"bcm_linkagemapping", (String)("id, entryentity.userdefined" + index + ", entryentity.dimshow"), (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < linkagemappings.length; ++i) {
            DynamicObjectCollection dycol = linkagemappings[i].getDynamicObjectCollection("entryentity");
            dycol.forEach(dy -> {
                dy.set("userdefined" + index, (Object)memberId);
                String dimshow = dy.getString("dimshow");
                dy.set("dimshow", (Object)dimshow.concat("\u3010").concat(dimName).concat("\uff01").concat(ResManager.loadKDString((String)"\u4e0d\u533a\u5206", (String)"CreateDimensionOp_15", (String)"fi-bcm-opplugin", (Object[])new Object[0])).concat(newname).concat("\u3011 "));
            });
        }
        SaveServiceHelper.save((DynamicObject[])linkagemappings);
    }

    private void preSetUserDefine(long modelId, long dimId, OrmLocaleValue name, String number, String shortNumber, String modelNum, String storetype, long memberId) {
        DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)model);
        model.set("id", (Object)modelId);
        DynamicObject dimesion = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)dimesion);
        dimesion.set("model", (Object)model);
        dimesion.set("id", (Object)dimId);
        DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)entity);
        entity.set("number", (Object)number);
        entity.set("name", (Object)name);
        entity.set("model", (Object)model);
        entity.set("dimension", (Object)dimesion);
        Object[] entitys = new Object[]{entity};
        BusinessDataWriter.save((IDataEntityType)entity.getDynamicObjectType(), (Object[])entitys);
        DynamicObject entityTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)entityTree);
        entityTree.set("model", (Object)model);
        entityTree.set("dimension", (Object)dimesion);
        entityTree.set("level", (Object)1);
        entityTree.set("member", (Object)entity);
        entityTree.set("storagetype", (Object)storetype);
        entityTree.set("isleaf", (Object)Boolean.FALSE);
        entityTree.set("longnumber", (Object)number);
        entityTree.set("number", (Object)number);
        entityTree.set("name", (Object)name);
        entityTree.set("issysmember", (Object)1);
        entityTree.set("dseq", (Object)1);
        entityTree.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
        Object[] entityTrees = new Object[]{entityTree};
        BusinessDataWriter.save((IDataEntityType)entityTree.getDynamicObjectType(), (Object[])entityTrees);
        DynamicObject none = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmember");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)none);
        none.set("number", (Object)(shortNumber + "None"));
        LocaleString nameLs = ResManager.getLocaleString((String)"\u4e0d\u533a\u5206%s", (String)"CreateDimensionOp_9", (String)"fi-bcm-opplugin");
        for (String next : nameLs.keySet()) {
            if (!Lang.zh_CN.toString().equalsIgnoreCase(next) && !Lang.zh_TW.toString().equalsIgnoreCase(next) && !Lang.en_US.toString().equalsIgnoreCase(next)) continue;
            nameLs.put(next, (Object)String.format((String)nameLs.get((Object)next), name.get((Object)next)));
        }
        none.set("name", (Object)nameLs);
        none.set("model", (Object)model);
        none.set("dimension", (Object)dimesion);
        Object[] nones = new Object[]{none};
        BusinessDataWriter.save((IDataEntityType)none.getDynamicObjectType(), (Object[])nones);
        DynamicObject noneTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)noneTree);
        noneTree.set("model", (Object)model);
        noneTree.set("dimension", (Object)dimesion);
        noneTree.set("level", (Object)2);
        noneTree.set("member", (Object)none);
        noneTree.set("parent", (Object)entityTree);
        noneTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
        noneTree.set("datatype", (Object)"0");
        noneTree.set("aggoprt", (Object)"1");
        noneTree.set("isleaf", (Object)Boolean.TRUE);
        noneTree.set("longnumber", (Object)(number + '!' + shortNumber + "None"));
        noneTree.set("number", (Object)(shortNumber + "None"));
        noneTree.set("name", (Object)nameLs);
        noneTree.set("issysmember", (Object)1);
        noneTree.set("dseq", (Object)1);
        noneTree.set("id", (Object)memberId);
        Object[] noneTrees = new Object[]{noneTree};
        BusinessDataWriter.save((IDataEntityType)noneTree.getDynamicObjectType(), (Object[])noneTrees);
        OlapServiceHelper.createDimensionSchemes((String)modelNum, (String)number, (String)shortNumber);
        OlapServiceHelper.createMember((String)modelNum, (String)number, (String)number);
    }

    static class DimensionSubmitValidator
    extends AbstractValidator {
        DimensionSubmitValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObjectCollection numbers;
                boolean flag;
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String newnumber = String.valueOf(dynamicObject.get("number"));
                String newname = String.valueOf(dynamicObject.get("name"));
                String shortnumber = String.valueOf(dynamicObject.get("shortnumber"));
                long mid = dynamicObject.getLong("model.id");
                Long dimId = dynamicObject.getLong("id");
                String membermodel = String.valueOf(dynamicObject.get("membermodel"));
                if (StringUtils.isEmpty((CharSequence)newnumber.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateDimensionOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)newname.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateDimensionOp_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (StringUtils.isEmpty((CharSequence)shortnumber.trim())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b80\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateDimensionOp_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if ("xdm".equalsIgnoreCase(newnumber)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7f16\u7801\u4e0d\u5141\u8bb8\u521b\u5efa\u4e3a\u201c%s\u201d\u3002", (String)"CreateDimensionOp_12", (String)"fi-bcm-opplugin", (Object[])new Object[0]), newnumber));
                    return;
                }
                if ("xdm".equalsIgnoreCase(shortnumber)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7b80\u7801\u4e0d\u5141\u8bb8\u521b\u5efa\u4e3a\u201c%s\u201d\u3002", (String)"CreateDimensionOp_13", (String)"fi-bcm-opplugin", (Object[])new Object[0]), shortnumber));
                    return;
                }
                QFilter qf = new QFilter("model", "=", (Object)mid);
                if (QueryServiceHelper.exists((String)"bcm_dimension_ext", (QFilter[])qf.toArray()) && (flag = (numbers = QueryServiceHelper.query((String)"bcm_structofextend", (String)"number", (QFilter[])qf.toArray())).stream().anyMatch(x -> newnumber.equals(x.getString("number"))))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u7f16\u7801\u4e0e\u62d3\u5c55\u7ef4\u6210\u5458\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CreateDimensionOp_14", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                String regEx = "^(?!_)[a-zA-Z0-9]+$";
                Pattern pattern = Pattern.compile(regEx);
                Matcher matcher = pattern.matcher(newnumber);
                Matcher matcher2 = pattern.matcher(shortnumber);
                if (StringUtils.startsWithAny((CharSequence)newnumber, (CharSequence[])num) || StringUtils.startsWithAny((CharSequence)shortnumber, (CharSequence[])num) || !matcher.matches() || !matcher2.matches()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CreateDimensionOp_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (newnumber.contains(".") || shortnumber.contains(".")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u548c\u7b80\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u548c\u534a\u89d2\u5b57\u6bcd\uff0c\u4e0d\u53ef\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CreateDimensionOp_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                StringBuilder sb = new StringBuilder();
                ArrayList<String> entryNumbers = new ArrayList<String>(10);
                ArrayList<String> entryRepeatNums = new ArrayList<String>(10);
                if (entryentity.size() > 0) {
                    Pattern patternCus = Pattern.compile("^(?!_)[-a-zA-Z0-9_.]+$");
                    for (DynamicObject entryDy : entryentity) {
                        String entrynumber = entryDy.getString("entrynumber");
                        Matcher matcherCus = patternCus.matcher(entrynumber);
                        if (!matcherCus.matches() || entrynumber.contains("..") || entrynumber.startsWith(".") || entrynumber.startsWith("-")) {
                            sb.append(entrynumber).append(",");
                        }
                        if (entryNumbers.contains(entrynumber)) {
                            entryRepeatNums.add(entrynumber);
                            continue;
                        }
                        entryNumbers.add(entrynumber);
                    }
                }
                if (sb.length() > 0) {
                    String msg = sb.substring(0, sb.length() - 1);
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u5c5e\u6027\u3010%s\u3011\u7684\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"CreateDimensionOp_17", (String)"fi-bcm-opplugin", (Object[])new Object[0]), msg));
                    return;
                }
                if (entryRepeatNums.size() > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u3010%s\u3011\u91cd\u590d", (String)"CreateDimensionOp_18", (String)"fi-bcm-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", entryRepeatNums)));
                    return;
                }
                long dimid = dynamicObject.getLong("id");
                boolean isEdit = QueryServiceHelper.exists((String)"bcm_dimension", (Object)dimid);
                if (!isEdit) {
                    if (this.checkNumAndShortNum(newnumber, mid)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u76f8\u540c\u7b80\u7801\u6216\u7f16\u7801\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CreateDimensionOp_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.checkName(newname, mid)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u201c\u540d\u79f0\u201d\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u3002", (String)"CreateDimensionOp_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.checkNumAndShortNum(shortnumber, mid)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u76f8\u540c\u7b80\u7801\u6216\u7f16\u7801\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CreateDimensionOp_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (!"Version".equalsIgnoreCase(newnumber) && DimTypesEnum.include((String)newnumber)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u65b0\u589e\u9884\u7f6e\u7ef4\u5ea6\u3002", (String)"CreateDimensionOp_7", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    Long id = dynamicObject.getLong("id");
                    String selectFields = "name";
                    QFilter fmodelid = new QFilter("name", "=", (Object)newname);
                    QFilter fmodelid2 = new QFilter("model", "=", (Object)mid);
                    QFilter fmodelid3 = new QFilter("id", "!=", (Object)id);
                    QFilter[] filters = new QFilter[]{fmodelid, fmodelid2, fmodelid3};
                    DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, null);
                    boolean result = false;
                    if (dcs != null && dcs.size() > 0) {
                        result = true;
                    }
                    if (result) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u201c\u540d\u79f0\u201d\u5728\u5f53\u524d\u4f53\u7cfb\u5df2\u5b58\u5728\u3002", (String)"CreateDimensionOp_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.checkNameInMember(newname, membermodel, dimId, newnumber)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\"\u540d\u79f0\"\u5728\u5f53\u524d\u7ef4\u5ea6\u7684\u6210\u5458\u4e2d\u5df2\u5b58\u5728\u3002", (String)"CreateDimensionOp_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
                List entryNums = entryentitys.stream().filter(x -> x.getLong("id") != 0L).map(y -> y.getString("entrynumber").toLowerCase(Locale.ENGLISH)).collect(Collectors.toList());
                for (DynamicObject entry : entryentitys) {
                    String entrynumber = entry.getString("entrynumber");
                    if (entry.getLong("id") != 0L || !entryNums.contains(entrynumber.toLowerCase(Locale.ENGLISH))) continue;
                    String seq = entry.getString("seq");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e3a\u3010%1$s\u3011\u81ea\u5b9a\u4e49\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u3010%2$s\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u6b21\u4fdd\u5b58", (String)"CreateDimensionOp_16", (String)"fi-bcm-opplugin", (Object[])new Object[0]), seq, entrynumber));
                    return;
                }
                QFilter filter = new QFilter("model", "=", (Object)mid);
                filter.and("isstage", "=", (Object)true);
                DynamicObject dimension = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"number", (QFilter[])filter.toArray());
                if (dimension == null || dimension.getString("number").equals(newnumber) || !dynamicObject.getBoolean("isstage")) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u3010%1$s\u3011\u5df2\u662f\u5206\u6bb5\u7ef4\u5ea6\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"CreateDimensionOp_19", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dimension.getString("number")));
                return;
            }
        }

        public boolean checkNameInMember(String name, String membermodel, Long dimId, String number) {
            boolean is = false;
            String selectFields = "id";
            QFilter fmodelid = new QFilter("dimension", "=", (Object)dimId);
            QFilter fmodelid2 = new QFilter("number", "=", (Object)number);
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObject doc = QueryServiceHelper.queryOne((String)membermodel, (String)selectFields, (QFilter[])filters);
            selectFields = "id";
            QFilter filter = new QFilter("name", "=", (Object)name);
            QFilter filter2 = new QFilter("dimension", "=", (Object)dimId);
            Long id = doc.getLong("id");
            QFilter filter3 = new QFilter("id", "!=", (Object)id);
            filters = new QFilter[]{filter, filter2, filter3};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)membermodel, (String)selectFields, (QFilter[])filters, null);
            if (dcs != null && dcs.size() > 0) {
                is = true;
            }
            return is;
        }

        public boolean checkName(String name, long modelid) {
            return this.checkInfoInModel("name", "name", name, "bcm_dimension", modelid);
        }

        public boolean checkInfoInModel(String selectField, String filter, String filvalue, String form, long modelid) {
            String selectFields = selectField;
            QFilter fmodelid = new QFilter(filter, "=", (Object)filvalue);
            QFilter fmodelid2 = new QFilter("model", "=", (Object)modelid);
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)form, (String)selectFields, (QFilter[])filters, null);
            boolean result = false;
            if (dcs != null && dcs.size() > 0) {
                result = true;
            }
            return result;
        }

        public boolean checkNumAndShortNum(String newnumber, long modelid) {
            QFilter qf = new QFilter("model", "=", (Object)modelid);
            QFilter[] qfs = new QFilter[]{qf};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])qfs);
            DynamicObject dcsExt = QueryServiceHelper.queryOne((String)"bcm_dimension_ext", (String)"number,shortnumber", (QFilter[])qfs);
            if (dcsExt != null) {
                dcs.add((Object)dcsExt);
            }
            if (dcs == null || dcs.size() == 0) {
                return false;
            }
            for (DynamicObject obj : dcs) {
                String number = obj.getString("number");
                String shortnumber = obj.getString("shortnumber");
                if (!newnumber.equalsIgnoreCase(number) && !newnumber.equalsIgnoreCase(shortnumber)) continue;
                return true;
            }
            return false;
        }
    }
}

