/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.datalock.DataLockHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.QueryTreenodeHelper;
import kd.fi.bcm.business.util.DimMemberSortUtil;
import kd.fi.bcm.business.util.UpgradeUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.prop.DefinedPropertyUtil;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.OrgStoreStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveValidator;
import kd.fi.bcm.opplugin.dimension.QueryTreenodeUtil;

public class DimensionMemberSaveOp
extends AbstractOperationServicePlugIn {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(DimensionMemberSaveOp.class);
    public static final List<String> memberModels = Arrays.asList("bcm_accountmembertree", "bcm_icmembertree", "bcm_userdefinedmembertree", "bcm_processmembertree", "bcm_audittrialmembertree", "bcm_mycompanymembertree", "bcm_rulemembertree");

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DimensionMemberSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject dyTree = e.getDataEntities()[0];
        dyTree.set("longnumber", (Object)(dyTree.get("parent.longnumber") + String.valueOf('!') + dyTree.get("number")));
        dyTree.set("status", (Object)"C");
        long modelId = dyTree.getLong("model.id");
        DimensionServiceHelper.updateParentIsLeaf((String)this.getTreeModelType(), (long)modelId, (long)dyTree.getLong("parent.id"));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        boolean isNew;
        super.afterExecuteOperationTransaction(e);
        boolean bl = isNew = ThreadCache.get((Object)"isNew") == null ? false : (Boolean)ThreadCache.get((Object)"isNew");
        if (!isNew) {
            return;
        }
        DynamicObject dyTree = e.getDataEntities()[0];
        long modelId = ((DynamicObject)dyTree.get("model")).getLong("id");
        long dimId = ((DynamicObject)dyTree.get("dimension")).getLong("id");
        log.startWatch();
        ShareNodeStructSyncHelper.optimizeResyncShareNodeStructure(Collections.singletonList(dyTree), (long)modelId, (long)dimId);
        String entityName = dyTree.getDataEntityType().getName();
        HashMap<String, Set> orgMap = new HashMap<String, Set>(16);
        if ("bcm_entitymembertree".equals(entityName)) {
            orgMap.computeIfAbsent(dyTree.getString("parent.number"), o -> new HashSet(16)).add(dyTree.getString("number"));
            LockScopeServiceHelper.addOrgToLockScope((long)modelId, orgMap);
        }
        if ("bcm_accountmembertree".equals(entityName) || "bcm_userdefinedmembertree".equals(entityName)) {
            DataLockHelper.synchroStageSetting((long)modelId);
        }
        log.infoEnd("Sync share node structure.");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String formId;
        String parent;
        boolean check;
        super.endOperationTransaction(e);
        DynamicObject memberObj = e.getDataEntities()[0];
        String parentNum = memberObj.getString("parent.number");
        long modelId = memberObj.getLong("model.id");
        String modelNum = memberObj.getString("model.number");
        long dimId = memberObj.getLong("dimension.id");
        String dimNum = MemberReader.getDimensionNumById((long)dimId);
        DynamicObject dimObj = MemberReader.getDimensionDynById((long)dimId);
        String storageType = memberObj.getString("storagetype");
        String entityName = memberObj.getDataEntityType().toString();
        String sourceId = memberObj.getString("id");
        String number = memberObj.getString("number");
        Map treesMap = QueryTreenodeHelper.getallnodeAndCopy((String)entityName, (String)String.valueOf(dimId), (String)String.valueOf(modelId));
        Set setchild = QueryTreenodeHelper.queryChildNodeCopy((String)sourceId, (Map)treesMap, new HashSet());
        setchild.remove(sourceId);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)memberObj.getDynamicObjectType().getName());
        for (String shareId : setchild) {
            boolean isSameParent;
            DynamicObject shareObj = BusinessDataReader.loadSingle((Object)shareId, (DynamicObjectType)dataEntityType);
            String oldShareName = shareObj.getString("name");
            boolean bl = isSameParent = shareObj.get("parent.number") != null && shareObj.get("parent.number").equals(parentNum);
            if (isSameParent) {
                shareObj.set("aggoprt", memberObj.get("aggoprt"));
            }
            if (!"Entity".equals(dimNum)) {
                shareObj.set("name", memberObj.get("name"));
            }
            shareObj.set("description", memberObj.get("description"));
            shareObj.set("storagetype", (Object)"3");
            List properties = DefinedPropertyUtil.getDefinedProperty((Long)dimId);
            for (String property : properties) {
                shareObj.set(property, memberObj.get(property));
            }
            if (dataEntityType.getProperties().containsKey((Object)"enumitem")) {
                shareObj.set("enumitem", memberObj.get("enumitem"));
            }
            if (!dimObj.getBoolean("issysdimension")) {
                shareObj.set("datatype", memberObj.get("datatype"));
                shareObj.set("value", memberObj.get("value"));
            }
            if ("Entity".equals(dimNum)) {
                DynamicObject entityPart;
                shareObj.set("currency", memberObj.get("currency"));
                shareObj.set("ctrlorg", memberObj.get("ctrlorg"));
                shareObj.set("isinnerorg", memberObj.get("isinnerorg"));
                shareObj.set("orgcode", memberObj.get("orgcode"));
                shareObj.set("creditcode", memberObj.get("creditcode"));
                shareObj.set("isindependentorg", memberObj.get("isindependentorg"));
                shareObj.set("shownumber", memberObj.get("shownumber"));
                shareObj.set("belongscheme", memberObj.get("belongscheme"));
                DynamicObjectCollection currencychangerds = new DynamicObjectCollection();
                DynamicObjectCollection curCols = memberObj.getDynamicObjectCollection("currencychangerds");
                for (DynamicObject curCol : curCols) {
                    currencychangerds.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)curCol, (boolean)true, (boolean)true)));
                }
                shareObj.set("currencychangerds", (Object)currencychangerds);
                Iterator nameChangeRds = memberObj.getDynamicObjectCollection("namechangerds");
                if (!StorageTypeEnum.SHARE.getOIndex().equals(storageType) && (ThreadCache.get((Object)"old_entity_name") == null || oldShareName.equals(ThreadCache.get((Object)"old_entity_name")))) {
                    shareObj.set("name", memberObj.get("name"));
                    shareObj.set("simplename", memberObj.get("simplename"));
                    shareObj.set("modifytime", (Object)TimeServiceHelper.now());
                    DynamicObjectCollection nameRecords = new DynamicObjectCollection();
                    Iterator iterator = nameChangeRds.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject record = (DynamicObject)iterator.next();
                        nameRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)record, (boolean)true, (boolean)true)));
                    }
                    shareObj.set("namechangerds", (Object)nameRecords);
                }
                if ((entityPart = shareObj.getDynamicObject("entitypart")) == null) {
                    entityPart = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
                    entityPart.set("id", (Object)DBServiceHelper.genGlobalLongId());
                    BusinessDataWriter.save((IDataEntityType)entityPart.getDataEntityType(), (Object[])new DynamicObject[]{entityPart});
                    shareObj.set("entitypart", (Object)entityPart.getLong("id"));
                }
                entityPart.set("isouterorg", (Object)memberObj.getBoolean("isouterorg"));
                entityPart.set("accounttype", memberObj.get("accounttype"));
                BusinessDataWriter.update((IDataEntityType)entityPart.getDataEntityType(), (Object[])new DynamicObject[]{entityPart});
            }
            if ("Account".equals(dimNum)) {
                shareObj.set("isaccountoffset", memberObj.get("isaccountoffset"));
                shareObj.set("islosscarry", memberObj.get("islosscarry"));
                shareObj.set("iscaltype", memberObj.get("iscaltype"));
                shareObj.set("datatype", memberObj.get("datatype"));
                shareObj.set("simplename", memberObj.get("simplename"));
                shareObj.set("accountuse", memberObj.get("accountuse"));
                shareObj.set("accounttype", memberObj.get("accounttype"));
                shareObj.set("drcrdirect", memberObj.get("drcrdirect"));
                shareObj.set("isparticipmerge", memberObj.get("isparticipmerge"));
                shareObj.set("isrelateorg", memberObj.get("isrelateorg"));
                shareObj.set("value", memberObj.get("value"));
                shareObj.set("exchange", memberObj.get("exchange"));
                shareObj.set("entryrate", memberObj.get("entryrate"));
                shareObj.set("accountpart", memberObj.get("accountpart"));
                this.updateDmMap(memberObj, sourceId, shareId, shareObj);
            }
            if ("Period".equals(dimNum)) {
                shareObj.set("simplename", memberObj.get("simplename"));
                shareObj.set("effmonth", memberObj.get("effmonth"));
                shareObj.set("effday", memberObj.get("effday"));
                shareObj.set("expmonth", memberObj.get("expmonth"));
                shareObj.set("expday", memberObj.get("expday"));
            }
            if ("AuditTrail".equals(dimNum)) {
                shareObj.set("datasource", memberObj.get("datasource"));
            }
            if ("ChangeType".equals(dimNum)) {
                shareObj.set("isyearendchargeagaint", memberObj.get("isyearendchargeagaint"));
                shareObj.set("datatype", memberObj.get("datatype"));
                shareObj.set("changeway", memberObj.get("changeway"));
                shareObj.set("isexchange", memberObj.get("isexchange"));
                shareObj.set("ismerge", memberObj.get("ismerge"));
            }
            if ("Scenario".equals(dimNum)) {
                shareObj.set("dchangetype", (Object)memberObj.getString("dchangetype"));
                shareObj.set("enablehisrec", (Object)memberObj.getString("dchangetype"));
            }
            if ("MultiGAAP".equals(dimNum) || "DataSort".equals(dimNum) || "bcm_userdefinedmembertree".equals(dataEntityType.getName())) {
                shareObj.set("ismerge", memberObj.get("ismerge"));
            }
            this.editDimensionDyObject(shareObj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{shareObj});
        }
        if ("bcm_entitymembertree".equals(entityName)) {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("number", "=", (Object)number));
            filter.and(new QFilter("status", "=", (Object)OrgStoreStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("id", "!=", (Object)memberObj.getLong("id")));
            DynamicObjectCollection dyTree3 = QueryServiceHelper.query((String)entityName, (String)"id,parent.number", (QFilter[])new QFilter[]{filter});
            if (dyTree3 != null && dyTree3.size() > 0) {
                for (DynamicObject dy : dyTree3) {
                    String pNumber = dy.getString("parent.number");
                    if (pNumber == null || !pNumber.equals(parentNum)) continue;
                    DynamicObject dyTree = BusinessDataReader.loadSingle((Object)dy.getLong("id"), (DynamicObjectType)dataEntityType);
                    DynamicObjectCollection bizChangeRds = memberObj.getDynamicObjectCollection("bizchangerds");
                    DynamicObjectCollection bizRecords = new DynamicObjectCollection();
                    for (DynamicObject biz : bizChangeRds) {
                        bizRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)biz, (boolean)true, (boolean)true)));
                    }
                    dyTree.set("bizchangerds", (Object)bizRecords);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyTree});
                }
            }
        }
        if ((check = memberObj.getBoolean("isshare")) && "false".equals(memberObj.get("startshare"))) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter qf000 = new QFilter("number", "=", (Object)number);
            QFilter qf001 = new QFilter("storagetype", "!=", (Object)"3");
            QFilter[] qfs000 = new QFilter[]{modelFilter, qf000, qf001};
            DynamicObjectCollection dcs000 = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id", (QFilter[])qfs000, null);
            String parselectid = null;
            if (dcs000.size() != 0) {
                parselectid = ((DynamicObject)dcs000.get(0)).getString("id");
            }
            String objid = memberObj.getString("parent.id");
            QueryTreenodeHelper.saveEntity((String)parselectid, (String)objid, (String)entityName, (Boolean)check, (String)String.valueOf(dimId), (String)String.valueOf(modelId), (String)sourceId);
            DynamicObject db = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)entityName);
            db.set("share", (Object)"1");
            QFilter qf006 = new QFilter("parent", "=", (Object)sourceId);
            boolean existchild = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qf006});
            if (existchild) {
                db.set("isleaf", (Object)"0");
            }
            Object[] oooob = new Object[]{db};
            SaveServiceHelper.save((IDataEntityType)db.getDataEntityType(), (Object[])oooob);
        }
        if (!check && "true".equals(memberObj.get("startshare"))) {
            List<String> liss = QueryTreenodeUtil.queryChildNodeList(sourceId, entityName, String.valueOf(dimId), String.valueOf(modelId), new ArrayList<String>());
            DeleteServiceHelper.delete((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDataEntityType(), (Object[])liss.toArray());
            DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)entityName);
            doj.set("share", (Object)"0");
            Object[] odoj = new Object[]{doj};
            SaveServiceHelper.save((IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)entityName).getDataEntityType(), (Object[])odoj);
            DynamicObject db = BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)entityName);
            db.set("isleaf", (Object)"1");
            Object[] oooob = new Object[]{db};
            SaveServiceHelper.save((IDataEntityType)db.getDataEntityType(), (Object[])oooob);
        }
        if (("Process".equals(dimNum) || "AuditTrail".equals(dimNum)) && (parent = memberObj.getString("parent.id")) != null && !parent.trim().equals("")) {
            DynamicObject[] dync;
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(parent));
            filter = filter.or(new QFilter("copyfrom", "=", (Object)Long.parseLong(parent)));
            for (DynamicObject dyn : dync = BusinessDataServiceHelper.load((String)entityName, (String)"datasource", (QFilter[])new QFilter[]{filter})) {
                String str = dyn.getString("datasource");
                if (!StringUtils.isNotEmpty((String)str)) continue;
                dyn.set("datasource", (Object)"");
            }
            SaveServiceHelper.save((DynamicObject[])dync);
        }
        if (memberModels.contains(formId = dimObj.getString("membermodel")) && !"bcm_icmembertree".equals(formId)) {
            long id = memberObj.getLong("id");
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and(new QFilter("dimension", "=", (Object)dimId));
            filter.and(new QFilter("copyfrom", "=", (Object)id));
            Set ids = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])filter.toArray()).stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] members = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)memberObj.getDynamicObjectType());
            if (members.length > 0) {
                if (memberModels.contains(formId)) {
                    for (DynamicObject member : members) {
                        member.set("assostoremem", (Object)(memberObj.get("assostoremem") == null ? 0L : ((DynamicObject)memberObj.get("assostoremem")).getLong("id")));
                    }
                }
                if ("bcm_changetypemembertree".equals(formId) || "bcm_userdefinedmembertree".equals(formId)) {
                    for (DynamicObject member : members) {
                        member.set("baldirection", (Object)memberObj.getString("baldirection"));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])members);
            }
        }
        if ("Entity".equals(dimNum)) {
            this.saveCustomProValues(memberObj);
        }
        Long cslschemeId = 0L;
        if ("Entity".equals(dimNum)) {
            cslschemeId = Long.parseLong(memberObj.get("cslscheme.id").toString());
        }
        DimMemberSortUtil.upadteDimChangeTime((Long)modelId, (Long)cslschemeId, (Long)dimId, (String)"changetime");
        if (!"bcm_entitymembertree".equals(entityName)) {
            this.createOlapMember(e);
        }
        if (StorageTypeEnum.DYNAMIC.getOIndex().equals(storageType) && !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM006")) {
            DynamicComputingServiceHelper.lockUpgradeModel((long)modelId);
        }
        if (StorageTypeEnum.DYNAMIC.getOIndex().equals(storageType)) {
            OlapServiceHelper.alterMemberStorageType((String)modelNum, (String)dimNum, (String)number, (MemberStorageTypes)MemberStorageTypes.DynamicCalc);
        } else if (!StorageTypeEnum.SHARE.getOIndex().equals(storageType) && !"bcm_icmembertree".equals(entityName)) {
            OlapServiceHelper.alterMemberStorageType((String)modelNum, (String)dimNum, (String)number, (MemberStorageTypes)MemberStorageTypes.Stored);
        }
        this.saveShieldRule(memberObj);
    }

    private void saveCustomProValues(DynamicObject dot) {
        ArrayList<DynamicObject> waitAddDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> waitUpdateDys = new ArrayList<DynamicObject>(10);
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        long modelId = dot.getLong("model.id");
        long dimId = dot.getLong("dimension.id");
        long id = dot.getLong("id");
        ArrayList<Long> allIds = new ArrayList<Long>(10);
        allIds.add(id);
        QFilter qfShare = new QFilter("copyfrom", "=", (Object)id);
        qfShare.or("id", "=", (Object)id);
        DynamicObjectCollection allDys = QueryServiceHelper.query((String)dot.getDynamicObjectType().getName(), (String)"id, copyfrom", (QFilter[])qfShare.toArray());
        List shareDys = allDys.stream().filter(x -> 0L != x.getLong("copyfrom")).collect(Collectors.toList());
        Set shareIds = shareDys.stream().map(x -> x.getLong("id")).collect(Collectors.toSet());
        allIds.addAll(shareIds);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimId);
        qFilter.and("member", "in", allIds);
        DynamicObject[] cusValues = BusinessDataServiceHelper.load((String)"bcm_dimcustompro_value", (String)"id, member, custompro, value, modifier, modifytime", (QFilter[])qFilter.toArray());
        Map<String, DynamicObject> id2CusValues = Arrays.stream(cusValues).collect(Collectors.toMap(x -> x.getLong("member.id") + "_" + x.getLong("custompro"), y -> y, (v1, v2) -> v1));
        QFilter qf = new QFilter("id", "=", (Object)dimId);
        DynamicObjectCollection entryDys = QueryServiceHelper.query((String)"bcm_dimension", (String)"entryentity.id, entryentity.entrynumber", (QFilter[])qf.toArray());
        if (entryDys.size() > 0) {
            for (DynamicObject memDy : allDys) {
                long memId = memDy.getLong("id");
                for (DynamicObject entryDy : entryDys) {
                    String entryNum = entryDy.getString("entryentity.entrynumber");
                    Long entryId = entryDy.getLong("entryentity.id");
                    if (id2CusValues.get(memId + "_" + entryId) == null) {
                        if (StringUtils.isNotEmpty((String)entryNum) && StringUtils.isNotEmpty((String)dot.getString(entryNum))) {
                            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimcustompro_value");
                            dy.set("model", (Object)modelId);
                            dy.set("dimension", (Object)dimId);
                            dy.set("member", (Object)memId);
                            dy.set("dimtype", (Object)dot.getDynamicObjectType().getName());
                            dy.set("custompro", (Object)entryId);
                            dy.set("value", (Object)dot.getString(entryNum));
                            dy.set("creator", (Object)currUserId);
                            dy.set("modifier", (Object)currUserId);
                            dy.set("createtime", (Object)date);
                            dy.set("modifytime", (Object)date);
                            dy.set("status", (Object)StatusEnum.Checked.toString());
                            dy.set("enable", (Object)"1");
                            waitAddDys.add(dy);
                        }
                        if (waitAddDys.size() != 1000) continue;
                        SaveServiceHelper.save((DynamicObject[])waitAddDys.toArray(new DynamicObject[0]));
                        waitAddDys.clear();
                        continue;
                    }
                    DynamicObject cusValueDy = id2CusValues.get(memId + "_" + entryId);
                    cusValueDy.set("value", (Object)dot.getString(entryNum));
                    cusValueDy.set("modifier", (Object)currUserId);
                    cusValueDy.set("modifytime", (Object)date);
                    waitUpdateDys.add(cusValueDy);
                    if (waitUpdateDys.size() != 1000) continue;
                    SaveServiceHelper.save((DynamicObject[])waitUpdateDys.toArray(new DynamicObject[0]));
                    waitUpdateDys.clear();
                }
            }
            if (waitAddDys.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])waitAddDys.toArray(new DynamicObject[0]));
            }
            if (waitUpdateDys.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])waitUpdateDys.toArray(new DynamicObject[0]));
            }
        }
    }

    private void createOlapMember(EndOperationTransactionArgs e) {
        DynamicObject obj = e.getDataEntities()[0];
        String modelNum = obj.getString("model.number");
        String dimNum = obj.getString("dimension.number");
        String number = obj.getString("number");
        String parentNumber = obj.getString("parent.number");
        int aggOprt = obj.getInt("aggoprt");
        OlapServiceHelper.createMember((String)modelNum, (String)dimNum, (String)number, (int)aggOprt, (String)parentNumber);
        if (ICVersionServiceHelper.isICVersion((long)obj.getLong("model.id"), (String)dimNum) && obj.getDynamicObjectCollection("forbiddenrecords").size() > 0) {
            ICVersionServiceHelper.updateMemberSlowEvolving((long)MemberReader.findModelIdByNum((String)modelNum), (String)number, (DynamicObject)obj);
        }
    }

    private void updateDmMap(DynamicObject dot, String selectid, String sharedid, DynamicObject dyTree2) {
        DynamicObjectCollection dotDmEntry;
        if (!selectid.equals(sharedid) && !CollectionUtils.isEmpty((Collection)(dotDmEntry = dot.getDynamicObjectCollection("dm_entry")))) {
            DynamicObjectCollection dmEntry = dyTree2.getDynamicObjectCollection("dm_entry");
            HashMap<Long, DynamicObject> dmMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject dm : dmEntry) {
                dmMap.put((Long)dm.getDynamicObject("dm_dim").get("id"), dm);
            }
            for (DynamicObject dotDm : dotDmEntry) {
                if (dmMap.get(dotDm.getDynamicObject("dm_dim").get("id")) != null) {
                    DynamicObject tempDyn = (DynamicObject)dmMap.get(dotDm.getDynamicObject("dm_dim").get("id"));
                    tempDyn.set("dm_valstr", dotDm.get("dm_valstr"));
                    tempDyn.set("dm_val", dotDm.get("dm_val"));
                    continue;
                }
                dmEntry.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)dotDm, (boolean)true, (boolean)true)));
            }
        }
    }

    private void saveShieldRule(DynamicObject dot) {
        String storagetype = dot.getString("storagetype");
        String modelId = dot.getString("model.id");
        String entityType = dot.getDataEntityType().toString();
        ShieldRuleBulider srb = new ShieldRuleBulider((Object)modelId);
        if (StorageTypeEnum.STORAGE.index.equals(storagetype) || StorageTypeEnum.UNSHARE.index.equals(storagetype)) {
            long srid = srb.getShieldRule((Object)dot.getString("dimension.id"), dot.getString("shielddim"));
            if ("bcm_fymembertree".equalsIgnoreCase(entityType)) {
                boolean notEditAble = UpgradeUtil.existPeriodInfo((Long)LongUtil.toLong((Object)modelId), (String)dot.getString("number"));
                if (!notEditAble) {
                    srb.save(dot.getLong("dimension.id"), dot.getLong("id"), srid);
                }
            } else {
                srb.save(dot.getLong("dimension.id"), dot.getLong("id"), srid);
            }
        }
        if (StorageTypeEnum.LABEL.index.equals(storagetype) || StorageTypeEnum.DYNAMIC.index.equals(storagetype)) {
            srb.save(dot.getLong("dimension.id"), dot.getLong("id"), 0L);
        }
    }

    public static void initDimensionDyObjectWithOrg(DynamicObject dy) {
        dy.set("status", (Object)"C");
        dy.set("enable", (Object)"1");
        RequestContext tx = RequestContext.get();
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        Date createTime = Date.from(instant);
        dy.set("createtime", (Object)createTime);
        dy.set("modifytime", (Object)createTime);
        DynamicObject user = ORM.create().newDynamicObject("bos_user");
        user.set("id", (Object)tx.getUserId());
        dy.set("creator", (Object)user);
        dy.set("modifier", (Object)user);
        DynamicObject org = ORM.create().newDynamicObject("bos_org");
        org.set("id", (Object)tx.getOrgId());
        dy.set("org", (Object)org);
    }

    public String getModelType() {
        return "";
    }

    public String getTreeModelType() {
        return "";
    }

    protected void editDimensionDyObject(DynamicObject dy) {
        dy.set("enable", (Object)"1");
        dy.set("modifytime", (Object)new Date());
        dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }
}

