/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.DimensionUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.spread.common.util.exception.MDQueryException;

public class DimensionMemberSaveValidator
extends AbstractValidator {
    protected boolean isedit = false;
    private static final String IS_ORIGINAL_CURRENCY = "isoriginalcur";

    public void validate() {
        StringBuilder msg = new StringBuilder();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        String id = dot.get("id").toString();
        this.isedit = QueryServiceHelper.exists((String)this.entityKey, (Object)id);
        if (!this.isedit) {
            String tip = this.doCheck();
            if (!StringUtils.isEmpty((String)tip)) {
                msg.append(tip);
            }
        } else {
            String tip = this.updateCheck();
            if (!StringUtils.isEmpty((String)tip)) {
                msg.append(tip);
            }
        }
        this.judgeRepeatChcek(msg, dot);
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntities[0], msg.toString());
        }
    }

    protected String doCheck() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        DynamicObject model = (DynamicObject)dot.get("model");
        DynamicObject dimension = (DynamicObject)dot.get("dimension");
        long dimId = dimension.getLong("id");
        String newnumber = (String)dot.get("number");
        String newname = dot.get("name").toString();
        long modelId = model.getLong("id");
        String msg = DimensionUtils.checkNumber((String)newnumber);
        if (msg != null) {
            return msg;
        }
        if (newnumber == null || StringUtils.isEmpty((String)newnumber.trim())) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (newname == null || StringUtils.isEmpty((String)newname.trim())) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (this.checkNumberEgnoreCase(newnumber, dimId, modelId)) {
            return ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"DimensionMemberSaveValidator_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if ("bcm_periodmembertree".equals(this.getTreeModelType())) {
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            QFilter filter2 = new QFilter("simplename", "=", (Object)dot.get("simplename").toString());
            if (!StringUtils.isEmpty((String)dot.get("simplename").toString())) {
                QFilter[] filters = new QFilter[]{filter, filter2};
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getTreeModelType(), (String)"id,simplename", (QFilter[])filters, (String)"");
                if (dcs != null && dcs.size() != 0) {
                    return ResManager.loadKDString((String)"\u671f\u95f4\u522b\u540d\u5df2\u5b58\u5728\u3002", (String)"DimensionMemberSaveValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }

    protected boolean checkNumberEgnoreCase(String newnumber, long dimId, long modelId) {
        QFilter qf = new QFilter("dimension", "=", (Object)dimId);
        QFilter modelqf = new QFilter("model", "=", (Object)modelId);
        QFilter[] qfs = new QFilter[]{qf, modelqf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getTreeModelType(), (String)"number", (QFilter[])qfs);
        if (dcs == null || dcs.size() == 0) {
            return false;
        }
        for (DynamicObject obj : dcs) {
            String number = obj.getString("number");
            if (!newnumber.equalsIgnoreCase(number)) continue;
            return true;
        }
        return false;
    }

    protected String updateCheck() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        DynamicObject model = (DynamicObject)dot.get("model");
        String newname = dot.get("name").toString();
        String modelId = model.get("id").toString();
        DynamicObject dimension = (DynamicObject)dot.get("dimension");
        String dimId = dimension.get("id").toString();
        if (StringUtils.isEmpty((String)newname.trim())) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if ("bcm_periodmembertree".equals(this.getTreeModelType())) {
            QFilter filter = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
            QFilter filter2 = new QFilter("simplename", "=", (Object)dot.get("simplename").toString());
            if (!StringUtils.isEmpty((String)dot.get("simplename").toString())) {
                QFilter filter3 = new QFilter("id", "!=", dot.get("id"));
                QFilter filter4 = new QFilter("dimension", "=", (Object)LongUtil.toLong((Object)dimId));
                QFilter[] filters = new QFilter[]{filter, filter2, filter3, filter4};
                DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getTreeModelType(), (String)"id,simplename", (QFilter[])filters, (String)"");
                if (dcs != null && dcs.size() > 0) {
                    return ResManager.loadKDString((String)"\u671f\u95f4\u522b\u540d\u5df2\u5b58\u5728\u3002", (String)"DimensionMemberSaveValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
                }
            }
        }
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)dot.getLong("id"), (String)dot.getString("dimension.memberform"), (String)"storagetype");
        String storageType = dot.getString("storagetype");
        String oldStorageType = dy.getString("storagetype");
        String dotNumber = dot.getString("number");
        QFilter filter0 = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter filter1 = new QFilter("number", "=", (Object)dotNumber);
        QFilter filter2 = new QFilter("storagetype", "=", (Object)"3");
        QFilter[] qfs00 = new QFilter[]{filter0, filter1, filter2};
        if (!oldStorageType.equals(storageType) && QueryServiceHelper.exists((String)this.getTreeModelType(), (QFilter[])qfs00) && "4".equals(dot.get("storagetype").toString())) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u5df2\u7ecf\u5b58\u5728\u5171\u4eab\u6210\u5458\uff0c\u5b58\u50a8\u7c7b\u578b\u4e0d\u53ef\u4ee5\u4fdd\u5b58\u4e3a\u4e0d\u5171\u4eab\u3002", (String)"DimensionMemberSaveValidator_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (!oldStorageType.equals(storageType) && StorageTypeEnum.LABEL.index.equals(storageType)) {
            try {
                if (OlapServiceHelper.hasOlapData((String)dot.getString("model.number"), (List)Lists.newArrayList((Object[])new String[]{dot.getString("number")}), (String)dot.getString("dimension.number"))) {
                    return ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u5b58\u50a8\u7c7b\u578b\u4e0d\u53ef\u4ee5\u4fdd\u5b58\u4e3a\u6807\u7b7e\u3002", (String)"DimensionMemberSaveValidator_7", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
                }
            }
            catch (MDQueryException e) {
                if (e.getMessage().contains("ExpressionMetadataContainer_200\u3002")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458\u52a8\u6001\u56e0\u5b50\u9519\u8bef\uff0c\u8bf7\u4fee\u590d\u56e0\u5b50\u6216\u8005\u6539\u6210\u5b58\u50a8\u7c7b\u578b\u3002", (String)"DimensionMemberSaveValidator_9", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                }
                if (!e.getMessage().contains("MetadataCollection300")) {
                    throw e;
                }
            }
            catch (Exception e) {
                throw e;
            }
        }
        return "";
    }

    protected String getTreeModelType() {
        if ("bcm_icmembertree".equals(this.entityKey)) {
            return "bcm_icmembertree";
        }
        if ("bcm_eb_accountmembertree".equals(this.entityKey)) {
            return "bcm_accountmembertree";
        }
        return this.entityKey;
    }

    protected String getModelType() {
        if ("bcm_icmembertree".equals(this.entityKey)) {
            return "bcm_intercompanymember";
        }
        if ("bcm_eb_accountmembertree".equals(this.entityKey)) {
            return "bcm_accountmember";
        }
        return this.entityKey.substring(0, this.entityKey.length() - 4);
    }

    public String getMemberId(String id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)this.getTreeModelType(), (String)"member", (QFilter[])filters, (String)"");
        if (dcs != null) {
            return ((DynamicObject)dcs.get(0)).getString("member");
        }
        return "";
    }

    private void judgeRepeatChcek(StringBuilder msg, DynamicObject dot) {
        String name = dot.getDynamicObjectType().getName();
        if ("bcm_userdefinedmembertree".equals(name)) {
            boolean flag = (Boolean)dot.get(IS_ORIGINAL_CURRENCY);
            Long modelId = (Long)((DynamicObject)dot.get("model")).get("id");
            if (flag) {
                QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
                QFilter qFilter2 = new QFilter(IS_ORIGINAL_CURRENCY, "=", (Object)"1");
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_userdefinedmembertree", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                if (dynamicObject != null) {
                    msg.append(ResManager.loadKDString((String)"\u5df2\u6709\u5176\u4ed6\u7ef4\u5ea6\u6210\u5458\u9009\u62e9\u539f\u5e01\uff0c\u4e0d\u5141\u8bb8\u518d\u9009\u62e9\u3002", (String)"DimensionMemberSaveValidator_10", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

