/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.business.dimension.helper.OlapPresetHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.ICVersionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.SlowEvolvingServiceHelper;
import kd.fi.bcm.business.util.OlapUtils;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.cache.localcache.SyncCacheUtil;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveOp;
import kd.fi.bcm.opplugin.dimension.DimensionUtil;
import kd.fi.bcm.opplugin.dimension.EntityMemberSaveValidator;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class EntityMemberSaveOp
extends DimensionMemberSaveOp {
    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EntityMemberSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        SaveDimMemberHelper.saveLog((DynamicObject)e.getDataEntities()[0]);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject dyTree = e.getDataEntities()[0];
        long id = dyTree.getLong("id");
        long modelId = dyTree.getLong("model.id");
        String modelNum = dyTree.getString("model.number");
        String number = dyTree.getString("number");
        DynamicObject oldObj = QueryServiceHelper.queryOne((String)this.getTreeModelType(), (String)"isinnerorg,entitypart.isouterorg", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (StringUtils.isEmpty((String)dyTree.getString("shownumber"))) {
            dyTree.set("shownumber", (Object)number);
        }
        this.createEntityPart(dyTree);
        this.saveModifyInfo(dyTree, oldObj != null);
        this.updateChildrenNode(dyTree);
        boolean isInner = dyTree.getBoolean("isinnerorg");
        boolean isOuter = dyTree.getBoolean("isouterorg");
        int agg = dyTree.getInt("aggoprt");
        String parentNumber = dyTree.getString("parent.number");
        this.createCurrencyMember(dyTree);
        OlapServiceHelper.createMember((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)number, (int)agg, (String)parentNumber);
        OlapServiceHelper.createMember((String)modelNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)OlapPresetHelper.getDeriveNum((DynamicObject)dyTree, (String)parentNumber));
        MemberServiceHelper.createMyCompanyMember((long)modelId, (String)number, (String)dyTree.getString("name"), (String)dyTree.getString("simplename"), (int)agg);
        this.createInterCompanyMember(dyTree);
        if (isInner && isOuter) {
            SlowEvolvingServiceHelper.tagMembers((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String)"internal", (List)Lists.newArrayList((Object[])new String[]{number}));
            SlowEvolvingServiceHelper.tagMembers((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String)"external", (List)Lists.newArrayList((Object[])new String[]{number}));
            ICVersionServiceHelper.updateMemberSlowEvolving((long)MemberReader.findModelIdByNum((String)modelNum), (String)number, null);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    private void createEntityPart(DynamicObject dyTree) {
        DynamicObject entitypart = dyTree.getDynamicObject("entitypart");
        if (entitypart == null) {
            entitypart = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
            entitypart.set("id", (Object)DBServiceHelper.genGlobalLongId());
        } else {
            entitypart = BusinessDataServiceHelper.loadSingle((Object)entitypart.getLong("id"), (String)"bcm_entitymemberpart");
        }
        entitypart.set("isouterorg", (Object)dyTree.getBoolean("isouterorg"));
        entitypart.set("accounttype", dyTree.get("accounttype"));
        dyTree.set("entitypart", (Object)entitypart.getLong("id"));
        BusinessDataWriter.save((IDataEntityType)entitypart.getDataEntityType(), (Object[])new DynamicObject[]{entitypart});
    }

    private void saveModifyInfo(DynamicObject entityData, boolean isModify) {
        int i;
        Date nowDate = TimeServiceHelper.now();
        DynamicObjectCollection namechangerds = entityData.getDynamicObjectCollection("namechangerds");
        for (int i2 = namechangerds.size() - 1; i2 >= 0; --i2) {
            Date nameeffdate;
            DynamicObject nameData = (DynamicObject)namechangerds.get(i2);
            if (i2 == namechangerds.size() - 1) {
                nameData.set("nameexpdate", null);
            }
            if (i2 > 0 && (nameeffdate = nameData.getDate("nameeffdate")) != null) {
                ((DynamicObject)namechangerds.get(i2 - 1)).set("nameexpdate", (Object)DateTimeUtils.getDayBefore((Date)nameeffdate));
            }
            if (!StringUtils.isEmpty((String)nameData.getString("namemodifier"))) continue;
            nameData.set("namemodifier", (Object)RequestContext.get().getCurrUserId());
            nameData.set("namemodifytime", (Object)nowDate);
        }
        DynamicObjectCollection currencychangerds = entityData.getDynamicObjectCollection("currencychangerds");
        if (isModify) {
            DynamicObject dynamicObject;
            if (namechangerds.size() > 0) {
                dynamicObject = (DynamicObject)namechangerds.get(namechangerds.size() - 1);
                entityData.set("name", dynamicObject.get("namerds"));
                entityData.set("simplename", dynamicObject.get("simplenamerds"));
            }
            if (currencychangerds.size() > 0) {
                dynamicObject = (DynamicObject)currencychangerds.get(currencychangerds.size() - 1);
                entityData.set("currency", dynamicObject.get("currencyrds"));
            }
        } else {
            DynamicObjectCollection nameRecords = entityData.getDynamicObjectCollection("namechangerds");
            DynamicObject newNameRd = (DynamicObject)nameRecords.get(0);
            newNameRd.set("namerds", (Object)entityData.getString("name"));
            newNameRd.set("simplenamerds", (Object)entityData.getString("simplename"));
        }
        DynamicObjectCollection bizChangerds = entityData.getDynamicObjectCollection("bizchangerds");
        for (i = bizChangerds.size() - 1; i >= 0; --i) {
            DynamicObject bizData = (DynamicObject)bizChangerds.get(i);
            if (i == bizChangerds.size() - 1) {
                bizData.set("bizexpdate", null);
            }
            if (i > 0) {
                ((DynamicObject)bizChangerds.get(i - 1)).set("bizexpdate", (Object)DateTimeUtils.getDayBefore((Date)bizData.getDate("bizeffdate")));
            }
            if (!bizData.getDataEntityState().isChanged()) continue;
            bizData.set("bizmodifier", (Object)RequestContext.get().getCurrUserId());
            bizData.set("bizmodifytime", (Object)nowDate);
        }
        for (i = currencychangerds.size() - 1; i >= 0; --i) {
            DynamicObject currencyData = (DynamicObject)currencychangerds.get(i);
            if (!StringUtils.isEmpty((String)currencyData.getString("currencymodifier"))) continue;
            currencyData.set("currencymodifier", (Object)RequestContext.get().getCurrUserId());
            currencyData.set("currencymodifytime", (Object)nowDate);
        }
    }

    @Override
    public String getModelType() {
        return "bcm_entitymember";
    }

    @Override
    public String getTreeModelType() {
        return "bcm_entitymembertree";
    }

    private void createInterCompanyMember(DynamicObject dyTree) {
        boolean isInner = dyTree.getBoolean("isinnerorg");
        boolean isOuter = dyTree.getBoolean("isouterorg");
        if (isInner && isOuter) {
            this.createICMember(dyTree, true, false);
            this.createShareICMember(dyTree);
        } else if (isInner || isOuter) {
            QFilter filter = new QFilter("model", "=", (Object)dyTree.getLong("model.id"));
            filter.and(new QFilter("number", "=", dyTree.get("number")));
            DynamicObject icMember = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"parent.number", (QFilter[])filter.toArray());
            if (icMember == null) {
                this.createICMember(dyTree, isInner, false);
            } else if (!(isInner ? "ICEntity" : "ICOEntity").equals(icMember.getString("parent.number"))) {
                this.changeICMember(dyTree, isInner);
            }
        } else {
            this.deleteICMember(dyTree);
        }
    }

    private void createShareICMember(DynamicObject dyTree) {
        long modelId = dyTree.getLong("model.id");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)dyTree.getString("number")));
        Set numbers = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"parent.number", (QFilter[])filter.toArray()).stream().map(m -> m.getString("parent.number")).collect(Collectors.toSet());
        if (numbers.contains("ICEntity") && !numbers.contains("ICOEntity")) {
            this.createICMember(dyTree, false, true);
        } else if (numbers.contains("ICOEntity") && !numbers.contains("ICEntity")) {
            this.createICMember(dyTree, true, true);
        }
    }

    private void createCurrencyMember(DynamicObject dyTree) {
        DynamicObjectCollection record = dyTree.getDynamicObjectCollection("currencychangerds");
        if (record.isEmpty()) {
            return;
        }
        DynamicObject currencyEntity = (DynamicObject)record.get(record.size() - 1);
        DynamicObject currency = ORM.create().newDynamicObject("bcm_currencymember");
        String modelId = dyTree.getString("model.id");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)currency);
        this.initModelAndDimension(currency, "Currency", modelId);
        DynamicObject currencyrds = currencyEntity.getDynamicObject("currencyrds");
        String currencyNumber = currencyrds.getString("number");
        QFilter filter1 = new QFilter("number", "=", (Object)currencyNumber);
        QFilter filter2 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)"bcm_currencymembertree", (QFilter[])filters)) {
            currency.set("number", (Object)currencyNumber);
            currency.set("name", currencyrds.get("name"));
            Object[] currencys = new Object[]{currency};
            currencys = BusinessDataWriter.save((IDataEntityType)currency.getDynamicObjectType(), (Object[])currencys);
            DynamicObject currencyTree = ORM.create().newDynamicObject("bcm_currencymembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)currencyTree);
            this.initModelAndDimension(currencyTree, "Currency", modelId);
            currencyTree.set("member", (Object)currency);
            currencyTree.set("number", currency.get("number"));
            currencyTree.set("name", currency.get("name"));
            currencyTree.set("storagetype", (Object)4);
            currencyTree.set("aggoprt", (Object)5);
            currencyTree.set("isleaf", (Object)1);
            currencyTree.set("level", (Object)2);
            String parentTreeid = DimensionUtil.getParentid(currencyTree.getString("model.id"), "bcm_currencymembertree", "Currency", ((Object)((Object)this)).getClass().getName());
            currencyTree.set("longnumber", (Object)("Currency!" + currencyTree.getString("number")));
            currencyTree.set("parent", (Object)parentTreeid);
            currencyTree.set("dseq", (Object)this.getDSeq(Long.parseLong(parentTreeid), "bcm_currencymembertree"));
            currencyTree.set("member", currencys[0]);
            currencyTree.set("issysmember", (Object)9);
            Object[] currencyTrees = new Object[]{currencyTree};
            BusinessDataWriter.save((IDataEntityType)currencyTree.getDynamicObjectType(), (Object[])currencyTrees);
            OlapServiceHelper.createMember((String)dyTree.getString("model.number"), (String)"Currency", (String)currencyNumber, (int)currencyTree.getInt("aggoprt"), (String)"Currency");
            this.createProcessMember(currencyTree, dyTree.getString("model.number"));
        }
    }

    private void createProcessMember(DynamicObject memberTree, String modelName) {
        DynamicObject process = ORM.create().newDynamicObject("bcm_processmember");
        String modelId = memberTree.getString("model.id");
        DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)process);
        this.initModelAndDimension(process, "TCF", modelId);
        QFilter filter1 = new QFilter("number", "=", memberTree.get("number"));
        QFilter filter2 = new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        if (!QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])filters)) {
            process.set("number", memberTree.get("number"));
            process.set("name", memberTree.get("name"));
            Object[] processs = new Object[]{process};
            processs = BusinessDataWriter.save((IDataEntityType)process.getDynamicObjectType(), (Object[])processs);
            DynamicObject processTree = ORM.create().newDynamicObject("bcm_processmembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)processTree);
            this.initModelAndDimension(processTree, "Process", modelId);
            processTree.set("member", (Object)process);
            processTree.set("number", memberTree.get("number"));
            processTree.set("name", memberTree.get("name"));
            processTree.set("storagetype", (Object)4);
            processTree.set("aggoprt", (Object)5);
            processTree.set("isleaf", (Object)1);
            processTree.set("level", (Object)3);
            String parentTreeid = DimensionUtil.getParentid(modelId, "bcm_processmembertree", "TCF", ((Object)((Object)this)).getClass().getName());
            processTree.set("longnumber", (Object)("Process!TCF!" + processTree.getString("number")));
            processTree.set("parent", (Object)parentTreeid);
            processTree.set("dseq", (Object)this.getDSeq(Long.parseLong(parentTreeid), "bcm_processmembertree"));
            processTree.set("member", processs[0]);
            processTree.set("issysmember", (Object)9);
            memberTree.set("issysmember", (Object)9);
            Object[] processTrees = new Object[]{processTree};
            BusinessDataWriter.save((IDataEntityType)processTree.getDynamicObjectType(), (Object[])processTrees);
            OlapServiceHelper.createMember((String)modelName, (String)"Process", (String)memberTree.getString("number"), (int)processTree.getInt("aggoprt"), (String)"TCF");
        }
    }

    private void initModelAndDimension(DynamicObject dy, String number, String modelId) {
        DynamicObject modelOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
        DynamicObject dimensionOb = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
        modelOb.set("id", (Object)modelId);
        String selectFields = "id";
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)selectFields, (QFilter[])filters);
        if (dcs != null && dcs.size() == 1) {
            String dimensionId = ((DynamicObject)dcs.get(0)).getString("id");
            dimensionOb.set("id", (Object)dimensionId);
        }
        dy.set("model", (Object)modelOb);
        dy.set("dimension", (Object)dimensionOb);
    }

    private void updateChildrenNode(DynamicObject dyTree) {
        DynamicObject[] allChildren;
        QFilter filter = new QFilter("model", "=", (Object)dyTree.getLong("model.id"));
        filter.and(new QFilter("longnumber", "like", (Object)(dyTree.getString("longnumber") + "!%")));
        if (dyTree.getBoolean("isindependentorg") && !dyTree.getBoolean("isleaf")) {
            for (DynamicObject child : allChildren = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,isindependentorg", (QFilter[])filter.toArray())) {
                child.set("isindependentorg", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])allChildren);
        }
        if (dyTree.get("expdate") != null) {
            for (DynamicObject child : allChildren = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,isindependentorg", (QFilter[])filter.toArray())) {
                child.set("expdate", dyTree.get("expdate"));
                child.set("isclearorg", dyTree.get("isclearorg"));
            }
            SaveServiceHelper.save((DynamicObject[])allChildren);
        }
    }

    private boolean createICMember(DynamicObject dyTree, boolean isInner, boolean isShare) {
        long modelId = dyTree.getLong("model.id");
        String number = dyTree.getString("number");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and(new QFilter("number", "=", (Object)number));
        Long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)"InternalCompany");
        DynamicObjectCollection existsDocs = QueryServiceHelper.query((String)"bcm_icmembertree", (String)"id,parent.number", (QFilter[])filter.toArray());
        if (!isShare && existsDocs.size() > 0) {
            return false;
        }
        DynamicObject memberTree = ORM.create().newDynamicObject("bcm_icmembertree");
        DimensionServiceHelper.initDimensionDyObject((DynamicObject)memberTree);
        memberTree.set("member", (Object)0);
        memberTree.set("number", (Object)number);
        memberTree.set("simplename", dyTree.get("simplename"));
        memberTree.set("name", dyTree.get("name"));
        memberTree.set("storagetype", (Object)(isShare ? StorageTypeEnum.SHARE.getOIndex() : StorageTypeEnum.STORAGE.getOIndex()));
        memberTree.set("copyfrom", (Object)(isShare ? ((DynamicObject)existsDocs.get(0)).getLong("id") : 0L));
        memberTree.set("aggoprt", dyTree.get("aggoprt"));
        memberTree.set("model", (Object)modelId);
        memberTree.set("dimension", (Object)dimId);
        memberTree.set("issysmember", (Object)0);
        memberTree.set("isleaf", (Object)1);
        memberTree.set("level", (Object)4);
        if (isShare) {
            DynamicObject storageMember = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)existsDocs.get(0)).getLong("id"), (String)"bcm_icmembertree");
            DynamicObjectCollection storageRecords = new DynamicObjectCollection();
            DynamicObjectCollection records = memberTree.getDynamicObjectCollection("forbiddenrecords");
            DynamicObject item = records.addNew();
            item.set("forbiddentype", (Object)(isInner ? "0" : "1"));
            item.set("forbiddenmodifier", (Object)RequestContext.get().getCurrUserId());
            item.set("forbiddenmodifytime", (Object)new Date());
            item.set("forbiddeneffdate", (Object)EntityVersioningUtil.getModelBeginDate((Object)modelId));
            storageRecords.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)item, (boolean)true, (boolean)true)));
            storageMember.set("forbiddenrecords", (Object)storageRecords);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{storageMember});
        }
        QFBuilder filterParent = new QFBuilder("model", "=", (Object)modelId);
        filterParent.add("number", "=", (Object)(isInner ? "ICEntity" : "ICOEntity"));
        DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id, isleaf,longnumber", (QFilter[])filterParent.toArray());
        long parentId = parent.getLong("id");
        memberTree.set("parent", (Object)parentId);
        memberTree.set("longnumber", (Object)(parent.getString("longnumber") + '!' + number));
        memberTree.set("dseq", (Object)this.getDSeq(parentId, "bcm_icmembertree"));
        SaveServiceHelper.save((IDataEntityType)memberTree.getDynamicObjectType(), (Object[])new DynamicObject[]{memberTree});
        if (parent.getBoolean("isleaf")) {
            DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"isleaf", (QFilter[])new QFBuilder("id", "=", (Object)parentId).toArray());
            parentObj.set("isleaf", (Object)0);
            SaveServiceHelper.save((IDataEntityType)parentObj.getDynamicObjectType(), (Object[])new DynamicObject[]{parentObj});
        }
        if (!isShare) {
            OlapServiceHelper.createMember((String)dyTree.getString("model.number"), (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)number, (int)dyTree.getInt("aggoprt"), (String)(isInner ? "ICEntity" : "ICOEntity"));
        }
        return true;
    }

    private void deleteICMember(DynamicObject dyTree) {
        boolean needCheck;
        DynamicObject model = (DynamicObject)dyTree.get("model");
        String modelNum = model.getString("number");
        long modelId = model.getLong("id");
        long dimId = MemberReader.getDimensionIdByNum((long)modelId, (String)DimTypesEnum.INTERCOMPANY.getNumber());
        String number = dyTree.getString("number");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("dimension", "=", (Object)dimId);
        filter.and("number", "=", (Object)number);
        Object[] memberTree = BusinessDataServiceHelper.load((String)"bcm_icmembertree", (String)"id,member", (QFilter[])filter.toArray());
        if (memberTree == null || memberTree.length == 0) {
            return;
        }
        boolean bl = needCheck = !ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isSkipOlapCheck");
        if (needCheck && OlapServiceHelper.hasOlapData((String)modelNum, (List)Lists.newArrayList((Object[])new String[]{number}), (String)"InternalCompany")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u5df2\u7ecf\u5b58\u5728\u62a5\u8868\u6570\u636e(\u4f59\u989d)\uff0c\u4e0d\u80fd\u53d6\u6d88\u5f80\u6765\u7ec4\u7ec7\u5c5e\u6027\u3002", (String)"EntityMemberSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> memberIds = new ArrayList<Long>(memberTree.length);
        for (int i = 0; i < memberTree.length; ++i) {
            memberIds.add(memberTree[i].getLong("member.id"));
        }
        if (memberTree.length > 0) {
            if (SyncCacheUtil.isIncrementCache((String)"bcm_icmembertree")) {
                SyncCacheUtil.saveMemberCache((Long)modelId, (Long)dimId, Arrays.stream(memberTree).map(m -> m.getLong("id")).collect(Collectors.toSet()));
            }
            BusinessDataWriter.delete((IDataEntityType)memberTree[0].getDynamicObjectType(), (Object[])memberTree);
            BusinessDataWriter.delete((String)"bcm_intercompanymember", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)memberIds.toArray())});
            OlapServiceHelper.dropDimensionMember((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)number);
        }
    }

    private void changeICMember(DynamicObject dyTree, boolean isInner) {
        Long modelId = ((DynamicObject)dyTree.get("model")).getLong("id");
        String modelNum = ((DynamicObject)dyTree.get("model")).getString("number");
        String number = dyTree.getString("number");
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("number", "=", (Object)(isInner ? "ICEntity" : "ICOEntity"));
        DynamicObject parent = QueryServiceHelper.queryOne((String)"bcm_icmembertree", (String)"id,longnumber", (QFilter[])new QFilter[]{filter, filter2});
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"number,aggoprt,longnumber,parent", (QFilter[])new QFilter[]{filter, filter1});
        dot.set("parent", (Object)parent.getLong("id"));
        dot.set("longnumber", (Object)(parent.getString("longnumber") + '!' + number));
        BusinessDataWriter.save((IDataEntityType)dot.getDataEntityType(), (Object[])new DynamicObject[]{dot});
        if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM060")) {
            SlowEvolvingServiceHelper.untagMembers((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String[])PresetConstant.TAG_IC_TOTAL, (List)Lists.newArrayList((Object[])new String[]{number}));
            SlowEvolvingServiceHelper.tagMembers((String)modelNum, (String)PresetConstant.INTERNALCOMPANY_DIM, (String)(isInner ? "internal" : "external"), (List)Lists.newArrayList((Object[])new String[]{number}));
        } else {
            ArrayList<AggFactorMetadataItem> factorList = new ArrayList<AggFactorMetadataItem>(16);
            factorList.add(OlapUtils.createAggFactorMetadataItem((String)dot.getString("number"), (int)dot.getInt("aggoprt")));
            OlapServiceHelper.dropAggFactor((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)(isInner ? "ICOEntity" : "ICEntity"), factorList);
            OlapServiceHelper.createAggFactor((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), (String)(isInner ? "ICEntity" : "ICOEntity"), factorList);
        }
    }

    public int getDSeq(long id, String entity) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }
}

