/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveValidator;

public class EntityMemberSaveValidator
extends DimensionMemberSaveValidator {
    private static final String namechangerds = "namechangerds";
    private static final String bizchangerds = "bizchangerds";
    private static final String currencychangerds = "currencychangerds";

    @Override
    protected String doCheck() {
        String message = "";
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        DynamicObject model = (DynamicObject)dot.get("model");
        DynamicObject dimension = (DynamicObject)dot.get("dimension");
        long dimId = dimension.getLong("id");
        String newnumber = (String)dot.get("number");
        String newname = dot.get("name").toString();
        if (newnumber == null || StringUtils.isEmpty((String)newnumber.trim())) {
            message = ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EntityMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            return message;
        }
        if (newname == null || StringUtils.isEmpty((String)newname.trim())) {
            message = ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EntityMemberSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            return message;
        }
        String regEx = "^(?!_)[-a-zA-Z0-9.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(newnumber);
        if (!matcher.matches()) {
            message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"EntityMemberSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        } else if (newnumber.contains("..") || newnumber.startsWith(".") || newnumber.startsWith("-")) {
            message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"EntityMemberSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)message) && this.checkNumberEgnoreCase(newnumber, dimId, model.getLong("id"))) {
            message = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"EntityMemberSaveValidator_9", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)message)) {
            message = this.check();
        }
        return message;
    }

    private String currencyChangeCheck() {
        String currNumberOfDb;
        DynamicObject dot = this.getDataEntities()[0].getDataEntity();
        Long modelId = dot.getDynamicObject("model").getLong("id");
        DynamicObjectCollection records = dot.getDynamicObjectCollection(currencychangerds);
        String currNumberOfPage = ((DynamicObject)records.get(records.size() - 1)).getString("currencyrds.number");
        QFilter qfModel = new QFilter("model", "=", (Object)modelId);
        QFilter qfId = new QFilter("id", "=", (Object)dot.getLong("id"));
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,name,currency,currencychangerds,currencychangerds.currencyrds", (QFilter[])new QFilter[]{qfId, qfModel});
        DynamicObjectCollection currencyRecords = org.getDynamicObjectCollection(currencychangerds);
        if (currencyRecords.size() != 0 && StringUtils.isNotEmpty((String)(currNumberOfDb = ((DynamicObject)currencyRecords.get(currencyRecords.size() - 1)).getString("currencyrds.number"))) && !currNumberOfDb.equals(currNumberOfPage)) {
            HashSet<String> members = new HashSet<String>();
            members.add(dot.getString("number"));
            String modelNumber = MemberReader.findModelNumberById((Object)modelId);
            Map queryData = OlapServiceHelper.judgeExistMDDataByMember((String)modelNumber, (String)"Entity", members);
            for (String member : members) {
                if (!((Boolean)queryData.get(member)).booleanValue()) continue;
                return ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5df2\u7ecf\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\u4ea7\u751f\u6570\u636e\uff0c\u9700\u6e05\u9664\u6570\u636e\u540e\u4fee\u6539\u3002", (String)"EntityMemberSaveValidator_11", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Override
    protected String updateCheck() {
        String message = super.updateCheck();
        if (StringUtils.isEmpty((String)message)) {
            message = this.check();
        }
        if (StringUtils.isEmpty((String)message)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            DynamicObject org = dataEntities[0].getDataEntity();
            this.checkUpdateHasOutIC(org);
        }
        if (StringUtils.isEmpty((String)message)) {
            message = this.currencyChangeCheck();
        }
        return message;
    }

    private void checkUpdateHasOutIC(DynamicObject org) {
        boolean checkData;
        boolean bl = checkData = !ConfigServiceHelper.getBoolParam((Long)org.getDynamicObject("model").getLong("id"), (String)"isAdjustHierarchyIC");
        if (checkData && (org.getBoolean("isinnerorg") || org.getBoolean("isouterorg"))) {
            boolean outOrgFlag;
            String number = org.getString("number");
            DynamicObject oldOrg = BusinessDataReader.loadSingle((Object)org.getLong("id"), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)org.getDynamicObjectType().getName()));
            boolean existsOutIC = QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])new QFBuilder("model", "=", (Object)org.getDynamicObject("model").getLong("id")).add("number", "=", (Object)number).toArray());
            boolean bl2 = outOrgFlag = oldOrg.getDynamicObject("entitypart") != null && oldOrg.getDynamicObject("entitypart").getBoolean("isouterorg");
            if (!oldOrg.getBoolean("isinnerorg") && !outOrgFlag && existsOutIC) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u7ec4\u7ec7\u3002", (String)"EntityMemberSaveValidator_10", (String)"fi-bcm-opplugin", (Object[])new Object[0]), number));
            }
        }
    }

    private String check() {
        String msg = this.checkDate(namechangerds, ResManager.loadKDString((String)"\u540d\u79f0\u53d8\u66f4\u8bb0\u5f55", (String)"EntityMemberSaveValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]), "nameeffdate");
        if (StringUtils.isEmpty((String)msg) && StringUtils.isEmpty((String)(msg = this.checkDate(bizchangerds, ResManager.loadKDString((String)"\u4e1a\u52a1\u53d8\u66f4\u8bb0\u5f55", (String)"EntityMemberSaveValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]), "bizeffdate")))) {
            DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
            long modelId = ((DynamicObject)dataEntity.get("model")).getLong("id");
            msg = EntityVersioningUtil.checkChangetype((DynamicObjectCollection)dataEntity.getDynamicObjectCollection(bizchangerds), (Object)dataEntity.get("id"), (long)modelId);
        }
        return msg;
    }

    private String checkDate(String tableName, String tableText, String feild) {
        DynamicObject dot = this.getDataEntities()[0].getDataEntity();
        String modelId = dot.getDynamicObject("model").getString("id");
        DynamicObjectCollection records = dot.getDynamicObjectCollection(tableName);
        for (int i = records.size() - 1; i >= 0; --i) {
            Date date = ((DynamicObject)records.get(i)).getDate(feild);
            if (this.isedit && namechangerds.equals(tableName) && StringUtils.isEmpty((String)((DynamicObject)records.get(i)).getString("namerds"))) {
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u6761\u8bb0\u5f55\u7684\u540d\u79f0\u3002", (String)"EntityMemberSaveValidator_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]), tableText, i + 1);
            }
            if (i > 0) {
                Date beforeDate = ((DynamicObject)records.get(i - 1)).getDate(feild);
                if (i != 1 && date != null && beforeDate != null && date.compareTo(beforeDate) <= 0) {
                    return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u6761\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u6761\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"EntityMemberSaveValidator_7", (String)"fi-bcm-opplugin", (Object[])new Object[0]), tableText, i + 1);
                }
                if (date != null) continue;
                return String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u6761\u8bb0\u5f55\u7684\u751f\u6548\u65e5\u671f\u3002", (String)"EntityMemberSaveValidator_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]), tableText, i + 1);
            }
            String message = EntityVersioningUtil.checkModelDate((Object)modelId, (Date)date);
            if (!StringUtils.isNotEmpty((String)message)) continue;
            return message;
        }
        return "";
    }
}

