/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.util.DateUtils;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveValidator;

public class InterCompanyMemberSaveValidator
extends DimensionMemberSaveValidator {
    @Override
    public void validate() {
        String msg;
        super.validate();
        DynamicObject dataEntity = this.getDataEntities()[0].getDataEntity();
        if (ConfigServiceHelper.getBoolParam((Long)dataEntity.getLong("model.id"), (String)"CM060") && (msg = this.checkContinuity(dataEntity)) != null) {
            this.addErrorMessage(this.getDataEntities()[0], msg);
        }
    }

    private String checkContinuity(DynamicObject record) {
        QFilter filter = new QFilter("model", "=", (Object)record.getLong("model.id"));
        filter.and("number", "=", (Object)record.getString("number"));
        filter.and("storagetype", "=", (Object)"3");
        if (!QueryServiceHelper.exists((String)"bcm_icmembertree", (QFilter[])filter.toArray())) {
            return null;
        }
        PairList pairList = new PairList();
        record.getDynamicObjectCollection("forbiddenrecords").forEach(i -> pairList.addPair((Object)i.getDate("forbiddeneffdate"), (Object)i.getDate("forbiddenexpdate")));
        if (pairList.size() == 0) {
            return ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u914d\u7f6e\u4e00\u6761\u7981\u7528\u8bb0\u5f55\u3002", (String)"InterCompanyMemberSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        List periods = pairList.toList();
        if (periods.stream().anyMatch(p -> p.p1 == null)) {
            return ResManager.loadKDString((String)"\u7981\u7528\u8bb0\u5f55\u65e5\u671f\u4e0d\u8fde\u7eed\u6216\u8005\u5b58\u5728\u91cd\u53e0\u65e5\u671f\u3002", (String)"InterCompanyMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        periods.sort(Comparator.comparing(p -> (Date)p.p1));
        Pair first = (Pair)periods.get(0);
        Date modelBeginDate = EntityVersioningUtil.getModelBeginDate((Object)record.getLong("model.id"));
        if (((Date)first.p1).after(modelBeginDate)) {
            return ResManager.loadKDString((String)"\u7981\u7528\u8bb0\u5f55\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4f53\u7cfb\u7684\u8d77\u59cb\u65e5\u671f\u3002", (String)"InterCompanyMemberSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        Date end = (Date)first.p2;
        for (int i2 = 1; i2 < pairList.size(); ++i2) {
            if (end == null || ((Date)pairList.getPair((int)i2).p1).compareTo(DateUtils.getNextDay((Date)end, (int)1)) != 0) {
                return ResManager.loadKDString((String)"\u7981\u7528\u8bb0\u5f55\u65e5\u671f\u4e0d\u8fde\u7eed\u6216\u8005\u5b58\u5728\u91cd\u53e0\u65e5\u671f\u3002", (String)"InterCompanyMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            end = (Date)pairList.getPair((int)i2).p2;
        }
        if (end != null) {
            return ResManager.loadKDString((String)"\u7981\u7528\u8bb0\u5f55\u65e5\u671f\u4e0d\u8fde\u7eed\u6216\u8005\u5b58\u5728\u91cd\u53e0\u65e5\u671f\u3002", (String)"InterCompanyMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

