/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.dimension.util.ModelDataClearUtils;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.formplugin.model.transfer.core.ModelTransferServiceHelper;
import kd.fi.bcm.opplugin.dimension.ModelDeleteValidator;

public class ModelDeleteOp
extends AbstractOperationServicePlugIn {
    private static final WatchLogger LOG = BcmLogFactory.getWatchLogInstance(ModelDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ModelDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dys = e.getDataEntities();
        ArrayList<Long> modelpkids = new ArrayList<Long>(10);
        for (DynamicObject dy : dys) {
            long modelId = (Long)dy.getPkValue();
            modelpkids.add(modelId);
            String modelNumber = dy.getString("number");
            Long datasource = dy.getLong("datasource.id");
            this.queryIsQuote(modelId, datasource);
            if (!OlapServiceHelper.isExistCube((String)modelNumber)) continue;
            OlapServiceHelper.dropCubeSchemes((String)modelNumber);
        }
        if (modelpkids != null && !modelpkids.isEmpty()) {
            ModelDataClearUtils.clearModels((Object[])modelpkids.toArray());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List filedkey = e.getFieldKeys();
        filedkey.add("number");
        filedkey.add("datasource");
        filedkey.add("reporttype");
    }

    private void queryIsQuote(Long model, Long datasource) {
        QFilter qf1 = new QFilter("id", "!=", (Object)model);
        QFilter qf2 = new QFilter("datasource", "=", (Object)datasource);
        boolean exist = QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{qf1, qf2});
        if (!exist) {
            // empty if block
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dys = e.getDataEntities();
        if (dys != null) {
            for (DynamicObject dy : dys) {
                String modelId = dy.getPkValue().toString();
                Long model = Long.valueOf(modelId);
                BcmFunPermissionHelper.delPermBymodelId((Long)model);
                BcmFunPermissionHelper.delPermUserRoleByModelId((Long)model);
                PermissionServiceHelper.clearAllCache();
            }
        }
        try {
            ModelDataClearUtils.deleteEpbsTableDatas((DynamicObject[])dys, (List)ModelTransferServiceHelper.addEntitys);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public List<String> getAllMemberTree(String modelId) {
        ArrayList<String> ls = new ArrayList<String>();
        QFilter filter = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bcm_dimension", (String)"membermodel", (QFilter[])filters, (String)"");
        if (dcs != null && dcs.size() != 0) {
            for (DynamicObject dyo : dcs) {
                ls.add(dyo.getString("membermodel"));
            }
        }
        return ls;
    }

    public List<String> getAllMember(List<String> ls) {
        ArrayList<String> memberls = new ArrayList<String>(ls.size());
        for (String str : ls) {
            String str2 = "bcm_icmembertree".equals(str) ? "bcm_intercompanymember" : str.substring(0, str.length() - 4);
            memberls.add(str2);
        }
        return memberls;
    }

    public void deleteOlap(String modelNumber) {
        OlapServiceHelper.dropCubeSchemes((String)modelNumber);
    }

    public void deleteTableAllMember(String modelId, List<String> ls) {
        ArrayList<String> list = new ArrayList<String>();
        for (String form : ls) {
            QFilter filter = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelId));
            QFilter[] filters = new QFilter[]{filter};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)form, (String)"id", (QFilter[])filters, (String)"");
            if (dcs == null) continue;
            if (dcs.size() != 0) {
                for (DynamicObject dc : dcs) {
                    list.add(dc.getString("id"));
                }
            }
            Object[] pks = list.toArray();
            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)form), (Object[])pks);
            list.clear();
        }
    }

    public void deleteDimension(String modelId) {
        QFilter filter = new QFilter("model.id", "=", (Object)LongUtil.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bcm_dimension", (String)"id", (QFilter[])filters, (String)"");
        if (dcs != null) {
            ArrayList<String> list = new ArrayList<String>();
            if (dcs.size() != 0) {
                for (DynamicObject dc : dcs) {
                    list.add(dc.getString("id"));
                }
            }
            Object[] pks = list.toArray();
            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_dimension"), (Object[])pks);
        }
    }
}

