/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.business.bd.model.ModelSyncHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.dimension.helper.InitModelServiceHelper;
import kd.fi.bcm.business.dimension.predimensionhelper.PreDimensionUtil;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationSetHelper;
import kd.fi.bcm.business.olap.dynamic.DynamicOlapHelper;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.DimProcessEntity;
import kd.fi.bcm.common.AppUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FyEnum;
import kd.fi.bcm.common.enums.PeriodLangENEnum;
import kd.fi.bcm.common.util.DataConnectCacheUtil;
import kd.fi.bcm.common.util.DatasourceModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.opplugin.AbstractBcmBaseOpServicePlugin;
import kd.fi.bcm.opplugin.dimension.ModelSaveValidator;

public class ModelSaveOp
extends AbstractBcmBaseOpServicePlugin {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ModelSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject model = e.getDataEntities()[0];
        this.initCommmonInformation(model);
        this.configModelParam(model);
        DataConnectCacheUtil.checkDataSource((String)model.getString("datasource.number"));
        DatasourceModel datasourcemodel = new DatasourceModel(model.getString("datasource.dataconnect"), model.getString("datasource.username"), model.getString("datasource.password"));
        DataConnectCacheUtil.cacheDataSource((String)model.getString("number"), (DatasourceModel)datasourcemodel);
        InitModelServiceHelper.preSetModelPerm((DynamicObject)model);
        this.preDims(model);
        InvRelationSetHelper.saveRelationParam((long)model.getLong("id"));
        InvChangeTypeServiceHelper.setDefaultChangeType((Long)model.getLong("id"));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject model = e.getDataEntities()[0];
                ApplicationTypeEnum app = null;
                String reporttype = model.getString("reporttype");
                app = ApplicationTypeEnum.RPT.getOIndex().equals(reporttype) ? ApplicationTypeEnum.RPT : ApplicationTypeEnum.CM;
                long id = DBServiceHelper.genGlobalLongId();
                model.set("id", (Object)id);
                if (AppUtil.isEpmAppId((String)app.getAppnum())) {
                    String _modelId = String.valueOf(id);
                    String _userId = RequestContext.get().getUserId();
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"EPMPermissionService", (String)"addEPMPermByUser", (Object[])new Object[]{_modelId, _userId, app.getAppnum()});
                } else {
                    BcmFunPermissionHelper.addAllRootPermByUser((String)String.valueOf(id), (String)RequestContext.get().getUserId(), (ApplicationTypeEnum)app);
                }
            }
            catch (Throwable e1) {
                tx.markRollback();
                throw new KDBizException(ThrowableHelper.printError((Throwable)e1));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject model = e.getDataEntities()[0];
        if (model.getBoolean("monthinclude13")) {
            // empty if block
        }
        long modelId = model.getLong("id");
        String cube = model.getString("number");
        if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM006")) {
            DynamicOlapHelper.setDynamicModel((long)modelId, (String)cube, (boolean)true);
            DimProcessEntity.aggEIRptAndEAdj((String)cube);
        }
        ModelSyncHelper.saveEpbsModel((Long)modelId, (String)model.getString("reporttype"));
    }

    private void preDims(DynamicObject model) {
        ApplicationTypeEnum app = null;
        app = ApplicationTypeEnum.RPT.getOIndex().equals(model.getString("reporttype")) ? ApplicationTypeEnum.RPT : ApplicationTypeEnum.CM;
        PreDimensionUtil pre = new PreDimensionUtil(model, app);
        List dimemtrees = pre.resolveDimemTrees();
        pre.afterModelSave(dimemtrees);
        this.changeRatePreset(model);
    }

    private void changeRatePreset(DynamicObject model) {
        QFilter qFilter = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter qFilter2 = new QFilter("number", "in", (Object)new String[]{"RatePreset", "RateEntity"});
        DynamicObject[] dyc = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"dseq,cslscheme,number,ISEXCHANGERATE", (QFilter[])new QFilter[]{qFilter, qFilter2});
        QFilter qf = new QFilter("number", "=", (Object)"DefaultRateScheme").and("model", "=", (Object)model.getLong("id"));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{qf});
        for (DynamicObject dot : dyc) {
            dot.set("cslscheme", (Object)dy.getLong("id"));
            dot.set("dseq", (Object)10000);
            dot.set("ISEXCHANGERATE", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])dyc);
        this.setParentChildren(model);
    }

    private void setParentChildren(DynamicObject model) {
        String[] parntChildNums = new String[]{DimTypesEnum.ENTITY.getNumber() + "_" + "RateEntity", "RateEntity_RatePreset"};
        OlapServiceHelper.batchCreateDimensionMembers((String)model.getString("number"), (String)DimTypesEnum.ENTITY.getNumber(), (String[])parntChildNums);
    }

    private void initCommmonInformation(DynamicObject model) {
        String beginyearofmonth = model.getString("beginyearofmonth");
        String beginperiod = model.getString("beginperiod");
        model.set("beginperiodtext", (Object)(FyEnum.getValue((String)beginyearofmonth) + PeriodLangENEnum.getMouthByIndex((int)Integer.parseInt(beginperiod))));
        model.set("number", (Object)("CUBE" + model.getString("shownumber").trim() + model.getString("id")));
        model.set("status", (Object)"C");
    }

    private void configModelParam(DynamicObject model) {
        QFilter qf = new QFilter("id", "=", (Object)model.getLong("datasource.id"));
        DynamicObject ds = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"serveraddress,port,username,password", (QFilter[])qf.toArray());
        boolean isDy = OlapServiceHelper.checkDSIsEnableDynamic((String)ds.getString("serveraddress"), (String)ds.getString("port"), (String)ds.getString("username"), (String)ds.getString("password"));
        try (TXHandle tx = TX.requiresNew((String)"ParamSettingUtils");){
            try {
                ParamSettingServiceHelper.save((long)model.getLong("id"), (String)"CM006", value -> isDy);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
            }
        }
    }
}

