/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveOp;
import kd.fi.bcm.opplugin.dimension.SceneMemberSaveValidator;

public class SceneMemberSaveOp
extends DimensionMemberSaveOp {
    Pair<Long, String> oldScenequote;

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SceneMemberSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject dot = e.getDataEntities()[0];
        DynamicObject old = BusinessDataServiceHelper.loadSingle((String)this.getTreeModelType(), (String)"scenequote.id, scenequote.number, sceneperiod", (QFilter[])new QFilter("id", "=", dot.get("id")).toArray());
        if (old != null) {
            DynamicObjectCollection oldSceneperiods = old.getDynamicObjectCollection("sceneperiod");
            this.compareAndSyncSceneperiod(oldSceneperiods, dot);
            if (old.getLong("scenequote.id") != 0L) {
                this.oldScenequote = Pair.onePair((Object)old.getLong("scenequote.id"), (Object)old.getString("scenequote.number"));
            }
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dys;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dy : dys = e.getDataEntities()) {
            SaveDimMemberHelper.saveLog((DynamicObject)dy);
        }
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block9: {
            super.endOperationTransaction(e);
            DynamicObject dot = e.getDataEntities()[0];
            long modelId = dot.getLong("model.id");
            String modelNumber = dot.getString("model.number");
            String dimNumber = dot.getString("dimension.number");
            String number = dot.getString("number");
            try {
                if (dot.getBoolean("isversioned")) {
                    DynamicObject scenequote = dot.getDynamicObject("scenequote");
                    long quoteId = scenequote.getLong("id");
                    String quoteNumber = scenequote.getString("number");
                    if (this.oldScenequote == null) {
                        OlapServiceHelper.createAggFactor((String)modelNumber, (String)dimNumber, (String)quoteNumber, (int)1, (String)number);
                        OlapServiceHelper.alterMemberStorageType((String)modelNumber, (String)dimNumber, (String)number, (MemberStorageTypes)MemberStorageTypes.DynamicCalc);
                        try {
                            OlapServiceHelper.createOrgPiecewise((String)modelNumber, (String)number, (String)quoteNumber);
                            OlapServiceHelper.addOrgPointScope((String)modelNumber, (String)number, (PairList)OrgServiceHelper.getAllRateOrgPairList((Long)modelId));
                            break block9;
                        }
                        catch (Exception ex) {
                            OlapServiceHelper.dropAggFactor((String)modelNumber, (String)dimNumber, (String)quoteNumber, (int)1, (String)number);
                            throw ex;
                        }
                    }
                    if (quoteId != (Long)this.oldScenequote.p1) {
                        OlapServiceHelper.dropAggFactor((String)modelNumber, (String)dimNumber, (String)((String)this.oldScenequote.p2), (int)1, (String)number);
                        OlapServiceHelper.createAggFactor((String)modelNumber, (String)dimNumber, (String)quoteNumber, (int)1, (String)number);
                    }
                    OlapServiceHelper.alterMemberStorageType((String)modelNumber, (String)dimNumber, (String)number, (MemberStorageTypes)MemberStorageTypes.DynamicCalc);
                    boolean isExists = OlapServiceHelper.findOrgPiecewise((String)modelNumber, (String)dimNumber, (String)number);
                    if (!isExists) {
                        OlapServiceHelper.createOrgPiecewise((String)modelNumber, (String)number, (String)quoteNumber);
                        OlapServiceHelper.addOrgPointScope((String)modelNumber, (String)number, (PairList)OrgServiceHelper.getAllRateOrgPairList((Long)modelId));
                    }
                    break block9;
                }
                if (this.oldScenequote != null) {
                    OlapServiceHelper.dropAggFactor((String)modelNumber, (String)dimNumber, (String)((String)this.oldScenequote.p2), (int)1, (String)number);
                }
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
    }

    @Override
    public String getModelType() {
        return "bcm_scenemember";
    }

    @Override
    public String getTreeModelType() {
        return "bcm_scenemembertree";
    }

    private void compareAndSyncSceneperiod(DynamicObjectCollection oldSceneperiods, DynamicObject dot) {
        DynamicObjectCollection sceneperiods = dot.getDynamicObjectCollection("sceneperiod");
        Set oldIds = oldSceneperiods.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        Set ids = sceneperiods.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
        boolean flag = false;
        if (oldIds.size() == ids.size()) {
            for (Long oldNumber : oldIds) {
                if (ids.contains(oldNumber)) continue;
                flag = true;
                break;
            }
        } else {
            flag = true;
        }
        if (flag) {
            long id = dot.getLong("id");
            QFilter qf = new QFilter("scenequote", "=", (Object)id);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bcm_scenemembertree", (String)"id, sceneperiod", (QFilter[])qf.toArray());
            if (load == null || load.length == 0) {
                return;
            }
            for (DynamicObject dynamicObject : load) {
                DynamicObjectCollection sceneperiod = dynamicObject.getDynamicObjectCollection("sceneperiod");
                sceneperiod.clear();
                DynamicObjectCollection dys = new DynamicObjectCollection();
                for (DynamicObject sp : sceneperiods) {
                    dys.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)sp, (boolean)true, (boolean)true)));
                }
                sceneperiod.addAll((Collection)dys);
            }
            SaveServiceHelper.save((DynamicObject[])load);
            ThreadCache.put((Object)"sync_msg", (Object)"success");
        }
    }
}

