/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.dimension;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.util.CodeRuleUtil;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveOp;

public class UserDefinedMemberSaveOp
extends DimensionMemberSaveOp {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dys;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dy : dys = e.getDataEntities()) {
            SaveDimMemberHelper.saveLog((DynamicObject)dy);
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.seqLogic(e);
        super.afterExecuteOperationTransaction(e);
    }

    private void seqLogic(AfterOperationArgs e) {
        DynamicObject dyTree = e.getDataEntities()[0];
        if (dyTree.getBoolean("isseq")) {
            int oldNum;
            Long pkValue = (Long)dyTree.getPkValue();
            ArrayList<DynamicObject> waitSaveDyns = new ArrayList<DynamicObject>(16);
            ArrayList waitSaveMemberDyns = new ArrayList(16);
            DynamicObject oldValue = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"bcm_userdefinedmembertree");
            int newCusSeq = dyTree.getInt("cusseq");
            int needNewNum = newCusSeq - (oldNum = ORM.create().count(((Object)((Object)this)).getClass().getName(), "bcm_userdefinedmembertree", new QFilter[]{new QFilter("parent.id", "=", (Object)pkValue)}));
            if (needNewNum > 0) {
                String[] dimensionNumbers = CodeRuleUtil.getDimensionNumber((String)"bcm_userdefinedmembertree", (DynamicObject)dyTree, (int)needNewNum);
                pkValue = oldValue.getLong("id");
                for (int i = 0; i < needNewNum; ++i) {
                    this.newNode(pkValue, "bcm_userdefinedmembertree", dyTree, waitSaveDyns, String.valueOf(oldNum + i + 1), dimensionNumbers[i]);
                }
                boolean isleaf = dyTree.getBoolean("isleaf");
                if (isleaf) {
                    dyTree.set("isleaf", (Object)Boolean.FALSE);
                    waitSaveDyns.add(dyTree);
                }
                if (waitSaveDyns.size() > 0) {
                    DynamicObject[] array = waitSaveDyns.toArray(new DynamicObject[waitSaveDyns.size()]);
                    try (TXHandle th = TX.requiresNew();){
                        try {
                            SaveServiceHelper.save((DynamicObject[])waitSaveMemberDyns.toArray(new DynamicObject[0]));
                            SaveServiceHelper.save((DynamicObject[])array);
                            ArrayList<Tuple> list = new ArrayList<Tuple>(array.length);
                            for (DynamicObject treeMember : array) {
                                list.add(Tuple.create((Object)treeMember.getString("number"), (Object)treeMember.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)dyTree.getDynamicObjectType().getName(), (Object)treeMember.get("parent"))));
                            }
                            OlapServiceHelper.batchCreateDimensionMembers((String)dyTree.getDynamicObject("model").getString("number"), (String)dyTree.getDynamicObject("dimension").getString("number"), (String[])dimensionNumbers);
                        }
                        catch (Exception ex) {
                            th.markRollback();
                        }
                    }
                }
            }
            QFilter filter = new QFilter("parent.id", "=", (Object)pkValue);
            filter.and(new QFilter("ismerge", "!=", (Object)dyTree.getBoolean("ismerge")));
            DynamicObject[] updates = BusinessDataServiceHelper.load((String)"bcm_userdefinedmembertree", (String)"ismerge", (QFilter[])filter.toArray());
            if (updates != null && updates.length > 0) {
                for (DynamicObject u : updates) {
                    u.set("ismerge", (Object)dyTree.getBoolean("ismerge"));
                }
                SaveServiceHelper.update((DynamicObject[])updates);
            }
        }
    }

    private void newNode(Long pkValue, String entityName, DynamicObject copyValue, List<DynamicObject> waitSaveDyns, String name, String number) {
        DynamicObject newDynamic = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        newDynamic.set("number", (Object)number);
        newDynamic.set("name", (Object)name);
        newDynamic.set("simplename", (Object)name);
        newDynamic.set("isleaf", (Object)Boolean.TRUE);
        newDynamic.set("storagetype", (Object)4);
        newDynamic.set("aggoprt", (Object)1);
        newDynamic.set("datatype", (Object)0);
        newDynamic.set("dseq", (Object)name);
        newDynamic.set("status", (Object)"C");
        newDynamic.set("enable", (Object)1);
        newDynamic.set("level", (Object)(copyValue.getInt("level") + 1));
        newDynamic.set("longnumber", (Object)(copyValue.getString("longnumber") + "!" + number));
        newDynamic.set("fullname", (Object)(copyValue.getString("fullname") + "." + name));
        newDynamic.set("parent_id", (Object)pkValue);
        newDynamic.set("parent", (Object)pkValue);
        newDynamic.set("createtime", (Object)new Date());
        newDynamic.set("modifytime", (Object)new Date());
        newDynamic.set("dimension", copyValue.get("dimension"));
        newDynamic.set("model", copyValue.get("model"));
        newDynamic.set("issysmember", (Object)0);
        newDynamic.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDynamic.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newDynamic.set("ismerge", copyValue.get("ismerge"));
        waitSaveDyns.add(newDynamic);
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Integer newCusSeq;
                ExtendedDataEntity[] dataEntities2 = this.getDataEntities();
                ExtendedDataEntity dynamicObject = dataEntities2[0];
                if (((Boolean)dynamicObject.getValue("isseq")).booleanValue() && (newCusSeq = (Integer)dynamicObject.getValue("cusseq")) <= 0) {
                    this.addMessage(dynamicObject, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e8f\u53f7", (String)"UserDefinedMemberSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    @Override
    public String getTreeModelType() {
        return "bcm_userdefinedmembertree";
    }
}

