/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.exchangerate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateCopyServiceHelper;
import kd.fi.bcm.business.exchangeRate.ExchangeRateShareSceneHelper;
import kd.fi.bcm.business.model.FixedItem;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.log.OpItemEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.opplugin.exchangerate.ExchangeRatePlanSaveValidator;

public class ExchangeRatePlanSaveOp
extends AbstractOperationServicePlugIn {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExchangeRatePlanSaveOp.class);
    private static final String SCENE = "scene";
    private static final String FY = "fy";
    private static final String PERIOD = "period";
    private static final String SYSTEM_TYPE = "fi-bcm-opplugin";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ExchangeRatePlanSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String ctxStr = this.getOption().getVariableValue("context");
        FixedItem ctx = (FixedItem)ObjectSerialUtil.deSerializedBytes((String)ctxStr);
        DynamicObject dot = e.getDataEntities()[0];
        long modelId = dot.getLong("model.id");
        String modelNumber = dot.getString("model.number");
        QFilter filter = new QFilter("number", "=", (Object)dot.getString("number"));
        filter.and("model", "=", (Object)modelId);
        DynamicObject rateorg = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,name,model,issharescene", (QFilter[])filter.toArray());
        String opName = OpItemEnum.ADD.getName();
        String result = ResultStatusEnum.SUCCESS.getName();
        String rateNumer = "";
        if (rateorg == null) {
            DynamicObject rateMember = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymember");
            DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)rateMember);
            rateMember.set("name", dot.get("name"));
            rateNumer = dot.getString("number");
            rateMember.set("number", (Object)rateNumer);
            rateMember.set("model", dot.get("model"));
            rateMember.set("dimension", dot.get("dimension"));
            BusinessDataWriter.save((IDataEntityType)rateMember.getDynamicObjectType(), (Object[])new Object[]{rateMember});
            DynamicObject rateTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            DimensionServiceHelper.initDimensionDyObject((DynamicObject)rateTree);
            rateTree.set("model", dot.get("model"));
            rateTree.set("dimension", dot.get("dimension"));
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)"RateEntity");
            DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,name,model,permclass,issharescene", (QFilter[])new QFilter[]{qFilter});
            rateTree.set("parent", (Object)entity);
            rateTree.set("level", (Object)3);
            rateTree.set("member", (Object)rateMember);
            rateTree.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
            rateTree.set("isleaf", (Object)Boolean.TRUE);
            rateTree.set("longnumber", (Object)("Entity!RateEntity!" + dot.getString("number")));
            rateTree.set("number", (Object)dot.getString("number"));
            rateTree.set("name", dot.get("name"));
            rateTree.set("issharescene", dot.get("issharescene"));
            rateTree.set("issysmember", (Object)"0");
            rateTree.set("isexchangerate", (Object)Boolean.TRUE);
            rateTree.set("dseq", (Object)(this.getDseqByDim(dot.get("dimension.id")) + 1));
            QFilter qf = new QFilter("number", "=", (Object)"DefaultRateScheme").and("model", "=", (Object)modelId);
            DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"id", (QFilter[])new QFilter[]{qf});
            rateTree.set("cslscheme", (Object)dy.getLong("id"));
            DynamicObjectType entityType = rateTree.getDynamicObjectCollection("bizchangerds").getDynamicObjectType();
            DynamicObject tmpData = new DynamicObject(entityType);
            tmpData.set("bizmodifytime", (Object)new Date());
            RequestContext tx = RequestContext.get();
            tmpData.set("bizmodifier", (Object)tx.getUserId());
            tmpData.set("bizeffdate", (Object)MemberReader.findModelBeginDate((String)MemberReader.findModelNumberById((Object)modelId)));
            tmpData.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
            rateTree.getDynamicObjectCollection("bizchangerds").add((Object)tmpData);
            BusinessDataWriter.save((IDataEntityType)rateTree.getDynamicObjectType(), (Object[])new Object[]{rateTree});
            if (dot.getBoolean("issharescene")) {
                this.saveScene(ctx, rateTree.getLong("id"), dot.getDynamicObjectCollection("mulscene"), Boolean.FALSE);
            }
            PermClassEntityHelper.savePermClass((String)"bcm_entitymembertree", (Object)rateTree.getLong("id"), (Object)modelId, (Object)dot.getDynamicObject("permclass"));
            OlapServiceHelper.createMember((String)modelNumber, (String)dot.getDynamicObject("dimension").getString("number"), (String)dot.getString("number"), (int)5, (String)"RateEntity");
            QFilter sqf = new QFilter("model", "=", (Object)modelId);
            sqf.and("isversioned", "=", (Object)true);
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bcm_scenemembertree", (String)"number", (QFilter[])sqf.toArray());
            PairList allRateOrgPairList = OrgServiceHelper.getAllRateOrgPairList((Long)modelId);
            for (DynamicObject dyn : dyns) {
                try {
                    OlapServiceHelper.addOrgPointScope((String)modelNumber, (String)dyn.getString("number"), (PairList)allRateOrgPairList);
                    OlapServiceHelper.dropRateOrgPointScope((String)modelNumber, (String)dyn.getString("number"));
                }
                catch (Exception ex) {
                    log.error("versioned scene set blacklist error:", (Throwable)ex);
                }
            }
        } else {
            opName = OpItemEnum.EDIT.getName();
            rateorg.set("name", dot.get("name"));
            rateNumer = rateorg.getString("number");
            BusinessDataWriter.save((IDataEntityType)rateorg.getDynamicObjectType(), (Object[])new Object[]{rateorg});
            PermClassEntityHelper.savePermClass((String)"bcm_entitymembertree", (Object)rateorg.getLong("id"), (Object)modelId, (Object)dot.getDynamicObject("permclass"));
            if (dot.getBoolean("issharescene")) {
                this.saveScene(ctx, rateorg.getLong("id"), dot.getDynamicObjectCollection("mulscene"), Boolean.TRUE);
            }
        }
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        String prefix = ResManager.loadKDString((String)"\u7f16\u53f7", (String)"ExchangeRatePlanSaveOp_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String opDescription = String.format("%s%s\uff0c%s%s", prefix, rateNumer, opName, result);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)modelId, (String)"bcm_exchangerateplan_edit");
        logService.addLog(logInfo);
    }

    private void updateSceneHandle(FixedItem ctx, List<String> oldSceneNumbers, List<String> newSceneNumbers) {
        if (CollectionUtils.isEmpty(oldSceneNumbers) && CollectionUtils.isEmpty(newSceneNumbers)) {
            return;
        }
        List<String> listToDelete = oldSceneNumbers.stream().filter(item -> !newSceneNumbers.contains(item)).collect(Collectors.toList());
        List<String> listToAdd = newSceneNumbers.stream().filter(item -> !oldSceneNumbers.contains(item)).collect(Collectors.toList());
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u5171\u4eab\u60c5\u666f", (String)"ExchangeRatePlanSaveOp_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7531%1$s\u53d8\u66f4\u6210%2$s\u3002", (String)"ExchangeRatePlanSaveOp_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", oldSceneNumbers), String.join((CharSequence)",", newSceneNumbers)), (Long)ctx.getModelId(), (String)"bcm_exchangerateplan_edit");
        this.handleDeleteScene(ctx, listToDelete);
        this.handleAddScene(ctx, listToAdd);
    }

    private void handleDeleteScene(FixedItem ctx, List<String> listToDelete) {
        if (CollectionUtils.isEmpty(listToDelete)) {
            return;
        }
        String number = ctx.getModelNum();
        listToDelete.forEach(s -> {
            IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)number, (String)s);
            SimpleItem scenario = SimpleItem.newOne((Object)node.getId(), (String)s);
            FixedItem tgtCtx = FixedItem.newOne((SimpleItem)ctx.getModel(), (SimpleItem)scenario, (SimpleItem)ctx.getFy(), (SimpleItem)ctx.getPeriod(), (SimpleItem)ctx.getEntity());
            ExchangeRateCopyServiceHelper.deleteExchangeRate((FixedItem)tgtCtx);
        });
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u5171\u4eab\u60c5\u666f", (String)"ExchangeRatePlanSaveOp_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5220\u9664\u60c5\u666f%s\u7684\u591a\u7ef4\u5e93\u6570\u636e\u3002", (String)"ExchangeRatePlanSaveOp_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", listToDelete)), (Long)ctx.getModelId(), (String)"bcm_exchangerateplan_edit");
    }

    private void handleAddScene(FixedItem ctx, List<String> listToAdd) {
        if (CollectionUtils.isEmpty(listToAdd)) {
            return;
        }
        String number = ctx.getModelNum();
        FixedItem srcctx = ctx;
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)srcctx.getModelId());
        qfBuilder.add(SCENE, "=", (Object)srcctx.getScenarioId());
        qfBuilder.add(FY, "=", (Object)srcctx.getFyId());
        qfBuilder.add(PERIOD, "=", (Object)srcctx.getPeriodId());
        qfBuilder.add("entity", "=", (Object)ctx.getEntityId());
        Set fields = EntityMetadataCache.getDataEntityType((String)"bcm_exchagerate").getAllFields().keySet();
        Map originRatesMap = BusinessDataServiceHelper.loadFromCache((String)"bcm_exchagerate", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray());
        ArrayList rows = new ArrayList(originRatesMap.values());
        listToAdd.forEach(s -> {
            IDNumberTreeNode node = MemberReader.findScenaMemberByNum((String)number, (String)s);
            SimpleItem scenario = SimpleItem.newOne((Object)node.getId(), (String)s);
            FixedItem tgtCtx = FixedItem.newOne((SimpleItem)ctx.getModel(), (SimpleItem)scenario, (SimpleItem)ctx.getFy(), (SimpleItem)ctx.getPeriod(), (SimpleItem)ctx.getEntity());
            ExchangeRateShareSceneHelper.saveOlap4Rows((List)rows, (boolean)false, (FixedItem)tgtCtx, null, (OlapSourceEnum)OlapSourceEnum.M1);
        });
        OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u66f4\u65b0\u5171\u4eab\u60c5\u666f", (String)"ExchangeRatePlanSaveOp_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u589e\u52a0\u60c5\u666f\u201c%s\u201d\u7684\u591a\u7ef4\u5e93\u6570\u636e\u3002", (String)"ExchangeRatePlanSaveOp_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), String.join((CharSequence)",", listToAdd)), (Long)ctx.getModelId(), (String)"bcm_exchangerateplan_edit");
    }

    private void saveScene(FixedItem ctx, Long rateSchemeId, DynamicObjectCollection newmulscene, Boolean isUpdate) {
        DynamicObjectCollection originScenes = ExchangeRateShareSceneHelper.getShareScenes((Long)rateSchemeId);
        QFBuilder qf = new QFBuilder("rateplan", "=", (Object)rateSchemeId);
        ArrayList<DynamicObject> scenes = new ArrayList<DynamicObject>(newmulscene.size());
        ArrayList<String> newNumbers = new ArrayList<String>(newmulscene.size());
        for (DynamicObject obj : newmulscene) {
            DynamicObject temp = BusinessDataServiceHelper.newDynamicObject((String)"bcm_rateplanscenes");
            temp.set("rateplan", (Object)rateSchemeId);
            temp.set(SCENE, (Object)obj.getLong("fbasedataid_id"));
            scenes.add(temp);
            newNumbers.add(obj.getDynamicObject("fbasedataid").getString("number"));
        }
        DeleteServiceHelper.delete((String)"bcm_rateplanscenes", (QFilter[])qf.toArray());
        SaveServiceHelper.save((DynamicObject[])scenes.toArray(new DynamicObject[0]));
        ExchangeRateShareSceneHelper.clearCommonCacheForRateOrgShareSceneNumberByModelId((long)ctx.getModelId());
        if (isUpdate.booleanValue()) {
            List<String> oldNumbers = originScenes.stream().map(s -> s.getString("number")).collect(Collectors.toList());
            this.updateSceneHandle(ctx, oldNumbers, newNumbers);
        } else {
            OperationLogUtil.writeOperationLog((String)ResManager.loadKDString((String)"\u65b0\u589e\u5171\u4eab\u60c5\u666f", (String)"ExchangeRatePlanSaveOp_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)String.join((CharSequence)",", newNumbers), (Long)ctx.getModelId(), (String)"bcm_exchangerateplan_edit");
        }
    }

    private int getDseqByDim(Object dimensionId) {
        QFilter filter1 = new QFilter("dimension", "=", dimensionId);
        QFilter filter2 = new QFilter("isexchangerate", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"dseq", (QFilter[])new QFilter[]{filter1, filter2}, (String)"dseq desc");
        if (dcs.size() > 0) {
            return ((DynamicObject)dcs.get(0)).getInt("dseq");
        }
        return 0;
    }
}

