/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.exchangerate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.DimensionUtils;
import kd.fi.bcm.opplugin.dimension.DimensionMemberSaveValidator;

public class ExchangeRatePlanSaveValidator
extends DimensionMemberSaveValidator {
    @Override
    public void validate() {
        String entityNumber = this.entityKey;
        this.entityKey = "bcm_entitymembertree";
        StringBuilder msg = new StringBuilder();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        String id = dot.get("id").toString();
        boolean isedit = QueryServiceHelper.exists((String)this.entityKey, (Object)id);
        if (!isedit) {
            String tip = this.doCheck();
            if (!StringUtils.isEmpty((String)tip)) {
                msg.append(tip);
            }
        } else {
            String tip = this.updateCheck();
            if (!StringUtils.isEmpty((String)tip)) {
                msg.append(tip);
            }
        }
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntities[0], msg.toString());
        }
        this.entityKey = entityNumber;
    }

    @Override
    protected String updateCheck() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        String newname = dot.getString("name");
        if (StringUtils.isEmpty((String)newname)) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ExchangeRatePlanSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    protected String doCheck() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        DynamicObject model = (DynamicObject)dot.get("model");
        DynamicObject dimension = (DynamicObject)dot.get("dimension");
        long dimId = dimension.getLong("id");
        String newnumber = (String)dot.get("number");
        String newname = dot.get("name").toString();
        long modelId = model.getLong("id");
        String msg = DimensionUtils.checkNumber((String)newnumber);
        if (msg != null) {
            return msg;
        }
        if (newnumber == null || StringUtils.isEmpty((String)newnumber.trim())) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        String regEx = "^(?!_)[-a-zA-Z0-9.]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(newnumber);
        if (!matcher.matches()) {
            return ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionMemberSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (newnumber.contains("..") || newnumber.startsWith(".") || newnumber.startsWith("-")) {
            return ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DimensionMemberSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (newname == null || StringUtils.isEmpty((String)newname.trim())) {
            return ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (this.checkNumberEgnoreCase(newnumber, dimId, modelId)) {
            return ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\u3002", (String)"DimensionMemberSaveValidator_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

