/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.integration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class DataSourceCatalogConfirmValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dyObj = dataEntities[0].getDataEntity();
        String number = dyObj.get("number").toString();
        if (StringUtils.isEmpty((String)number)) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"SchemeCatalogConfirmValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return;
        }
        String name = dyObj.get("name").toString();
        DynamicObject model = (DynamicObject)dyObj.get("model");
        if (StringUtils.isEmpty((String)name)) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"SchemeCatalogConfirmValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return;
        }
        String regEx = "[A-Za-z0-9_]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\u3002", (String)"SchemeCatalogConfirmValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return;
        }
        Long id = dyObj.getLong("id");
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("name", "=", (Object)name);
        QFilter filter3 = new QFilter("model", "=", (Object)model.getLong("id"));
        QFilter filter4 = new QFilter("id", "!=", (Object)id);
        StringBuilder msg = new StringBuilder();
        boolean isEdit = QueryServiceHelper.exists((String)this.getEntityKey(), (Object)id);
        boolean numberFlag = false;
        if (!isEdit) {
            QFilter[] qFilters1 = new QFilter[]{filter1, filter3};
            numberFlag = QueryServiceHelper.exists((String)this.getEntityKey(), (QFilter[])qFilters1);
        }
        QFilter[] qFilters2 = new QFilter[]{filter2, filter3, filter4};
        boolean nameFlag = QueryServiceHelper.exists((String)this.getEntityKey(), (QFilter[])qFilters2);
        if (nameFlag && numberFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        } else if (numberFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        } else if (nameFlag) {
            msg.append(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u91cd\u590d\u3002", (String)"SchemeCatalogConfirmValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
        }
        if (msg.length() > 0) {
            this.addErrorMessage(dataEntities[0], msg.toString());
        }
    }

    public String getEntityKey() {
        return "bcm_datasourcecatalog";
    }
}

