/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.integration;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integration.mapping.ExtendDim4ISSchemeService;
import kd.fi.bcm.business.integration.mapping.MappingContext;
import kd.fi.bcm.business.integration.mapping.MappingService;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.opplugin.integration.ISSchemeSaveValidator;

public class ISSchemeSaveOp
extends AbstractOperationServicePlugIn {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(ISSchemeSaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject schemeDy = e.getDataEntities()[0];
        String tableName = schemeDy.getString("extendstable");
        String realTableName = tableName.toUpperCase(Locale.ENGLISH);
        QFilter qf = new QFilter("extendstable", "=", (Object)realTableName);
        if (schemeDy.getDynamicObject("extendsmodel") != null && !QueryServiceHelper.exists((String)"bcm_isscheme", (Object)schemeDy.get("id")) && !QueryServiceHelper.exists((String)"bcm_isscheme", (QFilter[])qf.toArray())) {
            ExtendDim4ISSchemeService extendService = new ExtendDim4ISSchemeService(schemeDy);
            extendService.insertDimPerData();
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        try {
            for (DynamicObject d : dataEntities) {
                if (!QueryServiceHelper.exists((String)"bcm_isbaseentlist", (QFilter[])QFilter.of((String)"scheme = ?", (Object[])new Object[]{d.getPkValue()}).toArray()) && d.getDynamicObject("issrc") != null && d.getDynamicObject("istarg") != null && d.getDynamicObject("extendsmodel") == null) {
                    MappingContext context = new MappingContext(d);
                    context.getSource().preOutEntityData(d);
                    context.getTarget().preOutEntityData(d);
                    MappingService service = new MappingService(d, true);
                    service.insertDimPreData();
                }
                Long permClassId = d.getDynamicObject("permclass") == null ? null : Long.valueOf(d.getDynamicObject("permclass").getLong("id"));
                PermClassEntityHelper.savePermClass((String)"bcm_isscheme", (Object)d.getLong("id"), (Object)d.getDynamicObject("model").getLong("id"), (Object)permClassId);
            }
        }
        catch (Exception ex) {
            log.error("ISSchemeSaveOp error: " + ex);
            String error = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u90e8\u5206\u521b\u5efa\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:%s,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ISSchemeSaveOp_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ex.getMessage());
            throw new KDBizException(error);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ISSchemeSaveValidator());
    }
}

