/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.integration;

import java.math.BigDecimal;
import java.util.Calendar;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.common.util.QFBuilder;

public class ISSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject d = dataEntity.getDataEntity();
            if (d.getDate("expiringdate") != null && d.getDate("effectivedate").after(d.getDate("expiringdate"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u586b\u5199\u7684\u201c\u5931\u6548\u65e5\u671f\u201d\u4e0d\u80fd\u65e9\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"ISSchemeSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            }
            QFBuilder qf = new QFBuilder("model", "=", (Object)d.getLong("model_id"));
            qf.add("number", "=", (Object)d.getString("number"));
            qf.add("id", "!=", (Object)d.getLong("id"));
            qf.add("versionnumber", "in", (Object)new BigDecimal[]{d.getBigDecimal("versionnumber").add(new BigDecimal(1)), d.getBigDecimal("versionnumber").add(new BigDecimal(-1))});
            DynamicObjectCollection schemes = QueryServiceHelper.query((String)"bcm_isscheme", (String)"effectivedate,expiringdate,versionnumber", (QFilter[])qf.toArray(), (String)"versionnumber");
            for (DynamicObject scheme : schemes) {
                boolean iscovered = false;
                Calendar time1 = Calendar.getInstance();
                Calendar time2 = Calendar.getInstance();
                if (scheme.getBigDecimal("versionnumber").compareTo(d.getBigDecimal("versionnumber")) < 0) {
                    if (scheme.getDate("expiringdate") == null) {
                        iscovered = true;
                    } else {
                        time1.setTime(scheme.getDate("expiringdate"));
                        time2.setTime(d.getDate("effectivedate"));
                        iscovered = time1.compareTo(time2) >= 0;
                    }
                } else if (d.getDate("expiringdate") == null) {
                    iscovered = true;
                } else {
                    time1.setTime(scheme.getDate("effectivedate"));
                    time2.setTime(d.getDate("expiringdate"));
                    boolean bl = iscovered = time1.compareTo(time2) <= 0;
                }
                if (!iscovered) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0e\u7248\u672c%s\u91cd\u53e0\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ISSchemeSaveValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]), String.format("V%.1f", Float.valueOf(scheme.getBigDecimal("versionnumber").floatValue()))));
            }
        }
    }
}

