/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.integration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SchemeInfoConfirmValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            if (StringUtils.isEmpty((String)number)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeInfoConfirmValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)dynamicObject.getString("name"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeInfoConfirmValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)dynamicObject.getString("sourcedatasys"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeInfoConfirmValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            } else if (StringUtils.isEmpty((String)dynamicObject.getString("targetdatasys"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u76ee\u6807\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeInfoConfirmValidator_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            }
            String regEx = "[A-Za-z0-9_]+";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            if (!matcher.matches()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\u3002", (String)"SchemeInfoConfirmValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qcfnumber = new QFilter("number", "=", (Object)number);
            DynamicObject model = (DynamicObject)dynamicObject.get("model");
            if (model == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"SchemeInfoConfirmValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filtermodel = new QFilter("model", "=", (Object)model.getLong("id"));
            boolean isEdit = QueryServiceHelper.exists((String)"bcm_schemeentity", (Object)dynamicObject.getPkValue());
            if (isEdit || !QueryServiceHelper.exists((String)"bcm_schemeentity", (QFilter[])new QFilter[]{qcfnumber, filtermodel})) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\u3002", (String)"SchemeInfoConfirmValidator_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

