/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.invest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.util.KDAssert;

public class InvChangeTypeAddNewOp
extends AbstractOperationServicePlugIn {
    private static final String CUR_APP = "fi-bcm-opplugin";
    private static final String NUMBER = "number";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        long modelId = e.getDataEntities()[0].getLong("model.id");
        String[] perm = this.getPerm("bar_save", "bcm_invchangetype");
        KDAssert.assertFalse((perm != null && !InvRelationSearchService.checkModelPermission((long)modelId, (String)"bcm_invchangetype", (String)perm[1]) ? 1 : 0) != 0, () -> new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"InvChangeTypeAddNewOp_2", (String)CUR_APP, (Object[])new Object[0])));
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List numbers = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getString(NUMBER)).collect(Collectors.toList());
        Map<String, Object> number2Name = Arrays.stream(e.getDataEntities()).collect(Collectors.toMap(t -> t.getString(NUMBER), t -> t.get("name")));
        if (!numbers.isEmpty()) {
            InvRelationTypeHelper.addRelationType((long)modelId, number2Name);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.numberRule(dataEntity);
                    this.nonNullRule(dataEntity);
                }
            }

            private void numberRule(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                String number = dy.getString(InvChangeTypeAddNewOp.NUMBER);
                if (StringUtils.isNotEmpty((String)number)) {
                    if (!BCMNumberRule.checkNumber((String)number)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TemplateBaseInfoConfirmValidator_00", (String)InvChangeTypeAddNewOp.CUR_APP, (Object[])new Object[0]));
                    }
                    if (InvChangeTypeServiceHelper.isDefaultNumber((String)number)) {
                        String msg = ResManager.loadKDString((String)"%1$s\u4e3a\u7cfb\u7edf\u9ed8\u8ba4\u7f16\u7801,\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TemplateBaseInfoConfirmValidator_01", (String)InvChangeTypeAddNewOp.CUR_APP, (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, String.format(msg, number));
                    }
                }
            }

            private void nonNullRule(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                String change = dy.getString("change");
                DynamicObject relatedchangetype = (DynamicObject)dy.get("relatedchangetype");
                if (StringUtils.isEmpty((String)change) && Objects.isNull(relatedchangetype)) {
                    String msg = ResManager.loadKDString((String)"\u5408\u5e76\u8303\u56f4\u53d8\u52a8\u3001\u5173\u8054\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"InvChangeTypeAddNewOp_1", (String)InvChangeTypeAddNewOp.CUR_APP, (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        });
    }

    private String[] getPerm(String opKey, String entityId) {
        Map permItem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permItem.get(entityId);
        if (map == null || map.get(opKey) == null) {
            return null;
        }
        String[] perm = ((String)map.get(opKey)).split("@");
        if (perm.length < 2) {
            return null;
        }
        return perm;
    }
}

