/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.invest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.service.operation.validate.BaseDataDeleteValidator;
import kd.fi.bcm.business.invest.helper.InvRelationTypeHelper;

public class InvChangeTypeDeleteOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        List numbers = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getString("number")).collect(Collectors.toList());
        if (!numbers.isEmpty()) {
            long changeTypeId = dataEntities[0].getLong("id");
            InvRelationTypeHelper.deleteRelationType((long)changeTypeId, numbers);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.add(new BaseDataDeleteValidator(){

            public void validate() {
                Map<Object, ExtendedDataEntity> objMap = this.getCheckDataEntities();
                Map relation2changeType = InvRelationTypeHelper.queryRelationType(objMap.keySet());
                BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
                checker.setDraftValidReference(false);
                checker.setBdCreateTime(null);
                Object[] ids = relation2changeType.keySet().toArray(new Object[0]);
                ArrayList<String> fieldKeys = new ArrayList<String>();
                fieldKeys.add("name");
                fieldKeys.add("number");
                DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"bcm_invrelatype", fieldKeys);
                Map checkResult = checker.checkRef((BasedataEntityType)subDataEntityType, ids);
                checkResult.forEach((k, referenceResult) -> {
                    if (referenceResult != null && referenceResult.isRefence()) {
                        String msg = this.buildRefMessage((BaseDataCheckRefrenceResult)referenceResult);
                        this.addErrorMessage((ExtendedDataEntity)objMap.get(relation2changeType.getOrDefault(k, 0L)), msg);
                    }
                });
            }

            private Map<Object, ExtendedDataEntity> getCheckDataEntities() {
                if (this.dataEntities != null && this.dataEntities.length != 0) {
                    PKFieldProp pkProp = (PKFieldProp)this.getValidateContext().getSubEntityType().getPrimaryKey();
                    if (pkProp == null) {
                        return new HashMap<Object, ExtendedDataEntity>(0);
                    }
                    HashMap<Object, ExtendedDataEntity> dataEntityMap = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
                    for (ExtendedDataEntity dataObj : this.dataEntities) {
                        if (this.validateContext.getValidateResults().getErrorDataIndexs().contains(dataObj.getDataEntityIndex())) continue;
                        Object idValue = dataObj.getBillPkId();
                        if (pkProp.getValueComparator().compareValue(idValue)) continue;
                        dataEntityMap.put(idValue, dataObj);
                    }
                    return dataEntityMap;
                }
                return new HashMap<Object, ExtendedDataEntity>(0);
            }

            private String buildRefMessage(BaseDataCheckRefrenceResult referenceResult) {
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)referenceResult.getRefenceKey().getRefEntityKey());
                String billName = refMainType.getDisplayName().toString();
                String tableName = referenceResult.getRefenceKey().getRefTable();
                String fieldName = referenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (this.equalsFieldName(property, tableName, fieldName)) {
                        fieldName = property.getDisplayName().toString();
                        break;
                    }
                    if (!this.equalsMulBaseDataFieldName(property, tableName, fieldName)) continue;
                    fieldName = property.getDisplayName().toString();
                    break;
                }
                return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"InvChangeTypeDeleteOp_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]), billName, fieldName);
            }

            private boolean equalsFieldName(IDataEntityProperty property, String tableName, String fieldName) {
                if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)fieldName)) {
                        return false;
                    }
                    String propTableName = property.getParent().getAlias();
                    if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                        propTableName = propTableName + "_" + property.getTableGroup();
                    }
                    return StringUtils.equalsIgnoreCase((CharSequence)propTableName, (CharSequence)tableName);
                }
                return false;
            }

            private boolean equalsMulBaseDataFieldName(IDataEntityProperty property, String tableName, String fieldName) {
                if (!(property instanceof MulBasedataProp)) {
                    return false;
                }
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
                    return StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)"fbasedataid") && StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)mulBasedataProp.getItemType().getAlias());
                }
                return false;
            }
        });
    }
}

