/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.invest;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.validate.BaseDataDeleteValidator;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.invest.helper.InvShareCaseHelper;
import kd.fi.bcm.business.invest.model.InvShareCase;
import kd.fi.bcm.business.invest.shareholder.InvShareRelaService;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.QFBuilder;

public class InvShareCaseDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String CUR_APP = "fi-bcm-opplugin";
    private static String[] ignoreRefEntityIds = new String[]{"bcm_invsharerela", "bcm_invsharerela_report", "bcm_invstructuretable"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        validators.stream().filter(BaseDataDeleteValidator.class::isInstance).forEach(validator -> validator.getOption().setVariableValue("ignorerefentityids", String.join((CharSequence)",", ignoreRefEntityIds)));
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ExtendedDataEntity entity = dataEntities[0];
                DynamicObject invShareCaseDy = entity.getDataEntity();
                long modelId = InvShareCaseDeleteOp.this.getModelIdBy(invShareCaseDy);
                Set modelIds = MemberPermHelper.getLimitedModelListByUser();
                if (modelIds.contains(modelId)) {
                    return;
                }
                Map<Long, ExtendedDataEntity> entityMap = Arrays.stream(dataEntities).collect(Collectors.toMap(el -> el.getDataEntity().getLong("id"), el -> el));
                Set<Long> deleteIds = entityMap.keySet();
                this.shareCaseReadWriteCheck(deleteIds, entityMap);
                this.investedCompanyReadWriteCheck(modelId, deleteIds, entityMap);
            }

            private void investedCompanyReadWriteCheck(long modelId, Set<Long> deleteIds, Map<Long, ExtendedDataEntity> entityMap) {
                long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)PresetConstant.ENTITY_DIM);
                PermissionService permissionService = PermissionServiceImpl.getInstance((Long)modelId);
                QFBuilder qfBuilder = InvShareRelaService.getQFilter((long)modelId, deleteIds);
                String selectProperties = String.join((CharSequence)",", "investeecompany", "sharecase");
                DynamicObject[] query = InvShareRelaService.loadInvShareRela((String)selectProperties, (QFBuilder)qfBuilder);
                HashMap<Long, Set> distinctSet = new HashMap<Long, Set>(deleteIds.size());
                for (DynamicObject dyn : query) {
                    DynamicObject shareCaseDy = dyn.getDynamicObject("sharecase");
                    long currentRowId = shareCaseDy.getLong("id");
                    DynamicObject orgDy = dyn.getDynamicObject("investeecompany");
                    long orgId = orgDy.getLong("id");
                    String orgNumber = orgDy.getString("number");
                    Set orgSet = distinctSet.computeIfAbsent(currentRowId, k -> new HashSet(16));
                    if (!orgSet.add(orgNumber) || permissionService.hasWritePerm(Long.valueOf(dimensionId), Long.valueOf(orgId))) continue;
                    String content = ResManager.loadKDString((String)"\u80a1\u6743\u5173\u7cfb\u88ab\u6295\u5355\u4f4d%1$s %2$s\u65e0\u5199\u5165\u6743\u9650\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"InvShareCaseDeleteOp_1", (String)InvShareCaseDeleteOp.CUR_APP, (Object[])new Object[0]);
                    ExtendedDataEntity dataEntity = entityMap.get(currentRowId);
                    this.addErrorMessage(dataEntity, String.format(content, orgNumber, orgDy.getString("name")));
                }
            }

            private void shareCaseReadWriteCheck(Set<Long> deleteIds, Map<Long, ExtendedDataEntity> entityMap) {
                DynamicObjectCollection invShareCaseDys = InvShareCaseHelper.queryBy(deleteIds);
                List invShareCases = InvShareCase.genEntityBy((Collection)invShareCaseDys);
                invShareCases.stream().filter(InvShareCaseHelper::isReadOnly).forEach(invShareCase -> {
                    ExtendedDataEntity dataEntity = (ExtendedDataEntity)entityMap.get(invShareCase.getId());
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u80a1\u6743\u65b9\u6848\u5199\u5165\u6743\u9650\u3002", (String)"InvShareCaseDeleteOp_0", (String)InvShareCaseDeleteOp.CUR_APP, (Object[])new Object[0]));
                    deleteIds.remove(invShareCase.getId());
                });
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject invShareCaseDy = dataEntities[0];
        InvShareCase invShareCase = InvShareCaseHelper.getInvShareCaseById((long)ConvertUtil.convertObjToLong((Object)invShareCaseDy.getPkValue()));
        long modelId = invShareCase.getModelId();
        Set deleteIds = Arrays.stream(dataEntities).map(el -> el.getLong("id")).collect(Collectors.toSet());
        QFBuilder qfBuilder = InvShareRelaService.getQFilter((long)modelId, deleteIds);
        QFilter[] qFilters = qfBuilder.toArray();
        BusinessDataWriter.delete((String)"bcm_invsharerela", (QFilter[])qFilters);
        BusinessDataWriter.delete((String)"bcm_invsharerela_report", (QFilter[])qFilters);
        BusinessDataWriter.delete((String)"bcm_invstructuretable", (QFilter[])qFilters);
        DynamicObject dynamicObject = invShareCase.getDynamicObject();
        DynamicObject entity = PermClassEntityHelper.getPermissionClassEntity((DynamicObject)dynamicObject);
        if (Objects.nonNull(entity)) {
            DeleteServiceHelper.delete((IDataEntityType)entity.getDynamicObjectType(), (Object[])new Object[]{entity.getPkValue()});
        }
    }

    private long getModelIdBy(DynamicObject invShareCaseDy) {
        InvShareCase invShareCase = InvShareCase.genEntityBy((DynamicObject)invShareCaseDy);
        return invShareCase.getModelId();
    }
}

