/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.invtemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.cache.MemberReader;

public class InvTemplateSaveOp
extends AbstractOperationServicePlugIn {
    public static final String FI_BCM_OPPLUGIN = "fi-bcm-opplugin";
    private static final String NUMBER = "billno";
    private final Map<String, String> userdefineMap2Nums = new HashMap<String, String>();

    public InvTemplateSaveOp() {
        this.userdefineMap2Nums.put("dim1", "userdefine1");
        this.userdefineMap2Nums.put("dim2", "userdefine2");
        this.userdefineMap2Nums.put("dim3", "userdefine3");
        this.userdefineMap2Nums.put("dim4", "userdefine4");
        this.userdefineMap2Nums.put("dim5", "userdefine5");
        this.userdefineMap2Nums.put("dim6", "userdefine6");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject dynamicObject;
                    DynamicObject dyn = dataEntity.getDataEntity();
                    DynamicObject model = dyn.getDynamicObject("model");
                    boolean existAuditTrail = MemberReader.isExistAuditTrailDimension((long)model.getLong("id"));
                    boolean existChangeType = MemberReader.isExistChangeTypeDimension((long)model.getLong("id"));
                    if (model != null) {
                        boolean bFromDb = dyn.getDataEntityState().getFromDatabase();
                        if (!bFromDb) {
                            this.numberRule(dataEntity);
                        }
                        if (this.uniCheck(dataEntity, dyn, model)) continue;
                        this.entryDimCheck(dataEntity, dyn, model, existAuditTrail, existChangeType);
                    }
                    if ((dynamicObject = dyn.getDynamicObject("invrelatypebase")) != null && QueryServiceHelper.exists((String)dynamicObject.getDataEntityType().getName(), (Object)dynamicObject.getPkValue())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6301\u80a1\u6bd4\u4f8b\u7c7b\u578b\u4e3a\u7a7a\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvTemplateSaveOp_11", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]));
                }
            }

            private void entryDimCheck(ExtendedDataEntity dataEntity, DynamicObject dyn, DynamicObject model, boolean existAuditTrail, boolean existChangeType) {
                Map numMapped = DimensionServiceHelper.getDimensionNumMapped((Object)model.getLong("id"));
                boolean isspptdatasort = model.getBoolean("isspptdatasort");
                boolean isspptmultrule = model.getBoolean("isspptmultrule");
                boolean isAdjustment = dyn.getBoolean("adjustment");
                boolean existsMyCompanyDim = DimensionServiceHelper.existsMyCompanyDim((long)model.getLong("id"));
                List userDefineds = DimensionServiceHelper.getUserDefineDimensionNumListByModel((Object)model.getLong("id"));
                DynamicObjectCollection invTplEntry = dyn.getDynamicObjectCollection("invelimtplentry");
                if (invTplEntry != null && invTplEntry.size() > 0) {
                    int index = 1;
                    for (DynamicObject row : invTplEntry) {
                        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6295\u8d44\u62b5\u9500\u5206\u5f55\u201d\u7b2c%1$d\u884c\u201c%2$s\u201d\u5b57\u6bb5", (String)"InvTemplateSaveOp_0", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]);
                        if (existChangeType && row.get("changetype") == null) {
                            this.addErrorMessage(dataEntity, String.format(msg, index, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"InvTemplateSaveOp_7", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0])));
                        }
                        if (existAuditTrail && row.get("audittrail") == null) {
                            this.addErrorMessage(dataEntity, String.format(msg, index, ResManager.loadKDString((String)"\u5ba1\u8ba1\u7ebf\u7d22", (String)"InvTemplateSaveOp_8", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0])));
                        }
                        if (isspptdatasort && row.get("datasource") == null) {
                            this.addErrorMessage(dataEntity, String.format(msg, index, ResManager.loadKDString((String)"\u6570\u636e\u5206\u7c7b", (String)"InvTemplateSaveOp_1", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0])));
                        }
                        if (isspptmultrule && row.get("multigaap") == null) {
                            this.addErrorMessage(dataEntity, String.format(msg, index, ResManager.loadKDString((String)"\u51c6\u5219", (String)"InvTemplateSaveOp_2", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0])));
                        }
                        if (existsMyCompanyDim && row.get("mycompany") == null) {
                            this.addErrorMessage(dataEntity, String.format(msg, index, ResManager.loadKDString((String)"\u6211\u65b9\u7ec4\u7ec7", (String)"InvTemplateSaveOp_3", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0])));
                        }
                        for (int i = 1; i <= userDefineds.size(); ++i) {
                            if (row.get((String)InvTemplateSaveOp.this.userdefineMap2Nums.get(numMapped.get(userDefineds.get(i - 1)))) != null) continue;
                            this.addErrorMessage(dataEntity, String.format(msg, index, userDefineds.get(i - 1)));
                        }
                        if (isAdjustment && "2".equals(row.get("entitycomb"))) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u6a21\u677f\uff0c\u7b2c%d\u884c\u201c\u7ec4\u7ec7\u201d\u5b57\u6bb5\u53ea\u80fd\u9009\u62e9\u6295\u8d44\u5355\u4f4d", (String)"InvTemplateSaveOp_5", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]), index));
                        }
                        ++index;
                    }
                } else {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6295\u8d44\u62b5\u9500\u5206\u5f55\u3002", (String)"InvTemplateSaveOp_4", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]));
                }
            }

            private boolean uniCheck(ExtendedDataEntity dataEntity, DynamicObject dyn, DynamicObject model) {
                String billno = dyn.getString(InvTemplateSaveOp.NUMBER);
                Object id = dyn.get("id");
                QFilter qf = new QFilter(InvTemplateSaveOp.NUMBER, "=", (Object)billno);
                qf.and("model", "=", model.get("id"));
                qf.and("id", "!=", id);
                boolean isExsist = QueryServiceHelper.exists((String)"bcm_invelimtemplate", (QFilter[])qf.toArray());
                if (isExsist) {
                    String numbermsg = ResManager.loadKDString((String)"\"\u5355\u636e\u7f16\u53f7\"\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InvTemplateSaveOp_6", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]);
                    this.addFatalErrorMessage(dataEntity, numbermsg);
                    return true;
                }
                return false;
            }

            private void numberRule(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                String number = dy.getString(InvTemplateSaveOp.NUMBER);
                if (StringUtils.isEmpty((String)number) || !BCMNumberRule.checkNumber((String)number)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"InvTemplateSaveOp_9", (String)InvTemplateSaveOp.FI_BCM_OPPLUGIN, (Object[])new Object[0]));
                }
            }
        });
    }
}

