/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.papertemplate;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.util.BCMNumberRule;
import kd.fi.bcm.common.util.QFBuilder;

public class PaperTemplateSaveOp
extends AbstractOperationServicePlugIn {
    private static final String MODEL = "model";
    private static final String NUMBER = "number";
    private static final String TEMPLATE_CATALOG = "templatecatalog";
    private static final String GROUP = "group";
    private static final String LONG_NUMBER = "longnumber";
    private static final String NAME = "name";
    private static final String CUR_APP = "fi-bcm-opplugin";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.isNullCheck(dataEntity);
                    this.numberRule(dataEntity);
                }
                this.repeatCheck(dataEntities);
            }

            private void numberRule(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                String number = dy.getString(PaperTemplateSaveOp.NUMBER);
                if (StringUtils.isNotEmpty((String)number) && !BCMNumberRule.checkNumber((String)number)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TemplateBaseInfoConfirmValidator_00", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                }
            }

            private void isNullCheck(ExtendedDataEntity dataEntity) {
                DynamicObject dy = dataEntity.getDataEntity();
                if (StringUtils.isEmpty((String)dy.getString(PaperTemplateSaveOp.NUMBER))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateBaseInfoConfirmValidator_0", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((String)dy.getString(PaperTemplateSaveOp.NAME))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateBaseInfoConfirmValidator_1", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                }
                if (Objects.isNull(dy.getDynamicObject(PaperTemplateSaveOp.TEMPLATE_CATALOG))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvSheetTemplateSaveOp_1", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                }
            }

            private void repeatCheck(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dy = dataEntity.getDataEntity();
                    Object modelId = dy.getDynamicObject(PaperTemplateSaveOp.MODEL).getPkValue();
                    String number = dy.getString(PaperTemplateSaveOp.NUMBER);
                    DynamicObject catalog = dy.getDynamicObject(PaperTemplateSaveOp.TEMPLATE_CATALOG);
                    String longNumber = catalog.getString(PaperTemplateSaveOp.LONG_NUMBER);
                    String[] split = longNumber.split("\\.");
                    if (split.length < 2) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u4e0d\u5408\u6cd5\u3002", (String)"InvSheetTemplateSaveOp_0", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                        continue;
                    }
                    long group = dy.getLong(PaperTemplateSaveOp.GROUP);
                    QFBuilder qfBuilder = new QFBuilder(PaperTemplateSaveOp.MODEL, "=", modelId).and(PaperTemplateSaveOp.NUMBER, "=", (Object)number).and("templatecatalog.longnumber", "like", (Object)(split[0] + "." + split[1] + "%")).and(PaperTemplateSaveOp.GROUP, "!=", (Object)group);
                    if (!QueryServiceHelper.exists((String)dy.getDataEntityType().getName(), (QFilter[])qfBuilder.toArray())) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"TemplateBaseInfoConfirmValidator_2", (String)PaperTemplateSaveOp.CUR_APP, (Object[])new Object[0]));
                }
            }
        });
    }
}

