/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.task;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.opplugin.task.TaskCatalogSaveValidator;

public class TaskCatalogSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TaskCatalogSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject catalog = e.getDataEntities()[0];
        Object catalogid = catalog.getPkValue();
        ArrayList<Long> list = new ArrayList<Long>();
        boolean isExist = QueryServiceHelper.exists((String)"bcm_taskcatalog", (Object)catalogid);
        boolean issys = catalog.getBoolean("issystaskexplain");
        if (isExist) {
            QFilter filter1 = new QFilter("taskcatalog", "=", catalogid);
            QFilter filter2 = new QFilter("tasktype", "=", (Object)2);
            QFilter filter3 = new QFilter("number", "=", (Object)"root");
            DynamicObject roottask = BusinessDataServiceHelper.loadSingle((String)"bcm_taskconfig", (String)"name,modifier,modifytime", (QFilter[])new QFilter[]{filter1, filter3});
            roottask.set("name", (Object)catalog.getString("name"));
            roottask.set("modifier", (Object)RequestContext.get().getUserId());
            roottask.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roottask});
            QFilter[] filters = new QFilter[]{filter1, filter2};
            if (issys && !QueryServiceHelper.exists((String)"bcm_taskconfig", (QFilter[])filters)) {
                this.saveDefaultTaskConf(catalog, ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"TaskCatalogSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]), "rootdiscribe", roottask.getLong("id"), "root.rootdiscribe", 1, 1, catalogid, 2, true);
            } else if (!issys) {
                DeleteServiceHelper.delete((String)"bcm_taskconfig", (QFilter[])filters);
                QFilter filter4 = new QFilter("taskcatalog", "=", catalogid);
                DeleteServiceHelper.delete((String)"bcm_taskexplain", (QFilter[])new QFilter[]{filter4});
            }
        } else {
            Object[] pks = this.saveDefaultTaskConf(catalog, catalog.getString("name"), "root", 0, "root", 0, 1, catalogid, 0, false);
            DynamicObject roottask = (DynamicObject)pks[0];
            this.saveDefaultTaskConf(catalog, ResManager.loadKDString((String)"\u8bf7\u70b9\u51fb\u914d\u7f6e\u4efb\u52a1\u53c2\u6570\u3002", (String)"TaskCatalogSaveOp_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]), "rootparam", roottask.getLong("id"), "root.rootparam", 1, 2, catalogid, 1, true);
            if (issys) {
                this.saveDefaultTaskConf(catalog, ResManager.loadKDString((String)"\u4efb\u52a1\u8bf4\u660e", (String)"TaskCatalogSaveOp_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]), "rootdiscribe", roottask.getLong("id"), "root.rootdiscribe", 1, 1, catalogid, 2, true);
            }
            list.add(catalog.getLong("id"));
        }
        this.operationResult.setSuccessPkIds(list);
    }

    private Object[] saveDefaultTaskConf(DynamicObject catalog, String name, String number, Object parentid, String longnumber, int level, int seq, Object taskcatalogid, int tasktype, boolean isleaf) {
        DynamicObject taskconf = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskconfig");
        taskconf.set("name", (Object)new LocaleString(name));
        taskconf.set("number", (Object)number);
        taskconf.set("parent", parentid);
        taskconf.set("longnumber", (Object)longnumber);
        taskconf.set("level", (Object)level);
        taskconf.set("isleaf", (Object)isleaf);
        taskconf.set("kseq", (Object)seq);
        taskconf.set("taskcatalog", taskcatalogid);
        taskconf.set("tasktype", (Object)tasktype);
        taskconf.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
        taskconf.set("creator", (Object)RequestContext.get().getUserId());
        taskconf.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
        taskconf.set("modifier", (Object)RequestContext.get().getUserId());
        taskconf.set("model", catalog.getDynamicObject("model").getPkValue());
        return SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskconf});
    }
}

