/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.task;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.task.TaskUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.opplugin.task.TaskConfigSaveValidator;

public class TaskConfigSaveOp
extends AbstractOperationServicePlugIn {
    protected WatchLogger log;
    private DynamicObject dy;
    private Object[] preTasks;
    private Object[] taskTemplates;
    private Object[] objPreTaskIds;
    private Object[] objTaskTemIds;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TaskConfigSaveValidator());
        this.log = BcmLogFactory.getWatchLogInstance(((Object)((Object)this)).getClass());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.log.startWatch();
        DynamicObject dynamicObject = e.getDataEntities()[0];
        String saveType = dynamicObject.getString("savetype");
        int taskType = dynamicObject.getInt("tasktype");
        if ("baritemaddsub".equals(saveType) || "baritemaddlevel".equals(saveType)) {
            this.dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_taskconfig");
            this.assembleTaskTabObject(this.dy, dynamicObject);
            TaskUtil.initNewDimensionDyObject((DynamicObject)this.dy);
            if (taskType == 3 || taskType == 5) {
                this.assembleTaskConfigObject(this.dy, dynamicObject);
            }
        } else if ("edit".equals(saveType)) {
            long id = Long.parseLong(dynamicObject.getString("tablefkid"));
            this.dy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bcm_taskconfig");
            this.assembleTaskTabObject(this.dy, dynamicObject);
            if (taskType == 3 || taskType == 5) {
                this.assembleTaskConfigObject(this.dy, dynamicObject);
                this.objPreTaskIds = TaskUtil.getTaskForPreEntryId((long)id);
                this.objTaskTemIds = TaskUtil.getTaskTemEntryId((long)id);
            }
        }
        this.log.info("beforeExecuteOperationTransaction\u8017\u65f6---------------------------------");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.log.info("beginOperationTransaction\u8017\u65f6---------------------------------");
        Object[] objs = new Object[]{this.dy};
        objs = SaveServiceHelper.save((IDataEntityType)this.dy.getDataEntityType(), (Object[])objs);
        DynamicObject dynamicObject = e.getDataEntities()[0];
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("parent.id"), (String)"bcm_taskconfig", (String)"isleaf");
        parent.set("isleaf", (Object)1);
        DynamicObject[] parents = new DynamicObject[]{parent};
        SaveServiceHelper.save((DynamicObject[])parents);
        long id = ((DynamicObject)objs[0]).getLong("id");
        this.assembleArrayId(id, this.preTasks);
        this.assembleArrayId(id, this.taskTemplates);
        if (this.objTaskTemIds != null && this.objTaskTemIds.length > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_tasktem"), (Object[])this.objTaskTemIds);
        }
        if (this.taskTemplates != null && this.taskTemplates.length > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)this.taskTemplates[0]).getDataEntityType(), (Object[])this.taskTemplates);
        }
        if (this.objPreTaskIds != null && this.objPreTaskIds.length > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bcm_taskforpre"), (Object[])this.objPreTaskIds);
        }
        if (this.preTasks != null && this.preTasks.length > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)this.preTasks[0]).getDataEntityType(), (Object[])this.preTasks);
        }
        this.log.info("beginOperationTransaction\u8017\u65f6end---------------------------------");
        DynamicObject[] tasks = new DynamicObject[]{this.dy};
        MyTaskStatusHelper.refreshTaskStatusRecord((DynamicObject[])tasks);
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(id);
        this.operationResult.setSuccessPkIds(list);
        this.log.info("\u4efb\u52a1\u72b6\u6001\u8017\u65f6end---------------------------------");
    }

    private void assembleTaskTabObject(DynamicObject dy, DynamicObject dynamicObject) {
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        int tasktype = dynamicObject.getInt("tasktype");
        String description = dynamicObject.getString("description");
        long taskcatalogId = dynamicObject.getLong("taskcatalog");
        long modelId = Long.parseLong(dynamicObject.getString("model"));
        int level = dynamicObject.getInt("level");
        int kseq = dynamicObject.getInt("kseq");
        int isleaf = dynamicObject.getInt("isleaf");
        long parentId = dynamicObject.getLong("parent.id");
        String longNumber = dynamicObject.getString("longnumber");
        dy.set("number", (Object)number);
        dy.set("name", (Object)name);
        dy.set("tasktype", (Object)tasktype);
        dy.set("discription", (Object)description);
        dy.set("taskcatalog", (Object)taskcatalogId);
        dy.set("model", (Object)modelId);
        dy.set("level", (Object)level);
        dy.set("kseq", (Object)kseq);
        dy.set("isleaf", (Object)isleaf);
        dy.set("parent", (Object)parentId);
        String saveType = dynamicObject.getString("savetype");
        if (!"edit".equals(saveType)) {
            dy.set("longnumber", (Object)(longNumber + "." + number));
        }
        DimensionServiceHelper.assemModifyField((DynamicObject)this.dy);
    }

    private void assembleTaskConfigObject(DynamicObject dy, DynamicObject dynamicObject) {
        Date startTime = dynamicObject.getDate("starttime");
        Date endTime = dynamicObject.getDate("endTime");
        int planUseTime = dynamicObject.getInt("planusetime");
        dy.set("starttime", (Object)startTime);
        dy.set("endtime", (Object)endTime);
        dy.set("planusetime", (Object)planUseTime);
        DynamicObjectCollection dcs = dynamicObject.getDynamicObjectCollection("reporttemplates");
        this.accembleObjectArray(dcs, "bcm_tasktem");
        dcs = dynamicObject.getDynamicObjectCollection("pretasks");
        this.accembleObjectArray(dcs, "bcm_taskforpre");
        this.assemWarningField(dy, dynamicObject);
    }

    private void accembleObjectArray(DynamicObjectCollection dcs, String entityName) {
        String str = "";
        if (dcs != null && dcs.size() > 0) {
            if ("bcm_taskforpre".equals(entityName)) {
                str = "taskforpre";
                this.preTasks = new Object[dcs.size()];
            } else {
                str = "template";
                this.taskTemplates = new Object[dcs.size()];
            }
            int i = 0;
            for (DynamicObject dy : dcs) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                dynamicObject.set(str, (Object)((DynamicObject)dy.get(1)).getLong("id"));
                if ("taskforpre".equals(str)) {
                    str = "taskforpre";
                    this.preTasks[i] = dynamicObject;
                } else {
                    str = "template";
                    this.taskTemplates[i] = dynamicObject;
                }
                ++i;
            }
        }
    }

    private void assembleArrayId(long id, Object[] objs) {
        if (objs != null && objs.length > 0) {
            for (int i = 0; i < objs.length; ++i) {
                ((DynamicObject)objs[i]).set("taskconfig", (Object)id);
                ((DynamicObject)objs[i]).set("kseq", (Object)i);
            }
        }
    }

    private void assemWarningField(DynamicObject dy, DynamicObject dynamicObject) {
        int value = dynamicObject.getInt("radiogroupfield");
        this.assembleWarningBeginTime(dy, value, dynamicObject);
        value = dynamicObject.getInt("radiogroupfield1");
        this.assembleWarningFrequency(dy, value, dynamicObject);
        value = dynamicObject.getInt("radiogroupfield11");
        this.assembleOutFrequency(dy, value, dynamicObject);
    }

    private void assembleWarningBeginTime(DynamicObject dy, int value, DynamicObject dynamicObject) {
        switch (value) {
            case 1: {
                dy.set("warningbegintime", null);
                dy.set("warningbegintype", (Object)1);
                break;
            }
            case 2: {
                Date date = dynamicObject.getDate("endtime");
                Date newdate = new Date(date.getTime());
                int leftTime = dynamicObject.getInt("integerfield");
                newdate.setTime(date.getTime() - (long)((leftTime - 1) * 24 * 60 * 60 * 1000));
                dy.set("warningbegintime", (Object)newdate);
                dy.set("warningbegintype", (Object)2);
                break;
            }
            case 3: {
                dy.set("warningbegintime", (Object)dynamicObject.getDate("datefield"));
                dy.set("warningbegintype", (Object)3);
            }
        }
    }

    private void assembleWarningFrequency(DynamicObject dy, int value, DynamicObject dynamicObject) {
        switch (value) {
            case 1: {
                dy.set("warningfrequency", (Object)2);
                break;
            }
            case 2: {
                dy.set("warningfrequency", (Object)4);
                break;
            }
            case 3: {
                dy.set("warningfrequency", (Object)6);
                break;
            }
            case 4: {
                dy.set("warningfrequency", (Object)8);
            }
        }
    }

    private void assembleOutFrequency(DynamicObject dy, int value, DynamicObject dynamicObject) {
        switch (value) {
            case 1: {
                dy.set("outfrequency", (Object)2);
                break;
            }
            case 2: {
                dy.set("outfrequency", (Object)4);
                break;
            }
            case 3: {
                dy.set("outfrequency", (Object)6);
                break;
            }
            case 4: {
                dy.set("outfrequency", (Object)8);
            }
        }
    }
}

