/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.task;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.task.TaskUtil;

public class TaskConfigSaveValidator
extends AbstractValidator {
    public void validate() {
        boolean isNumberOnly;
        String regEx;
        Pattern pattern;
        Matcher matcher;
        StringBuilder msg = new StringBuilder();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        String saveType = dot.getString("savetype");
        String number = dot.getString("number");
        String name = dot.getString("name");
        long modelId = Long.parseLong(dot.getString("model"));
        boolean isError = this.showWarningMessage(msg, this.checkNullField(dot), dataEntities, dot);
        if (isError) {
            return;
        }
        int taskType = dot.getInt("tasktype");
        if (taskType == 3 || taskType == 5) {
            String message = this.checkEndAndStartTime(dot);
            isError = this.showWarningMessage(msg, message, dataEntities, dot);
            if (isError) {
                return;
            }
            message = this.warningTimeCheck(dot);
            isError = this.showWarningMessage(msg, message, dataEntities, dot);
            if (isError) {
                return;
            }
            message = this.checkCirclePre(dot);
            isError = this.showWarningMessage(msg, message, dataEntities, dot);
            if (isError) {
                return;
            }
            message = this.isEndTimeLatedToPredStart(dot);
            isError = this.showWarningMessage(msg, message, dataEntities, dot);
            if (isError) {
                return;
            }
        }
        if (!(matcher = (pattern = Pattern.compile(regEx = "^(?!_)[-a-zA-Z0-9_.]+$")).matcher(number)).matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            this.showWarningMessage(msg, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskConfigSaveValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dataEntities, dot);
            return;
        }
        if (!"edit".equals(saveType) && (isNumberOnly = this.isNumberOnly(number, modelId, "bcm_taskconfig"))) {
            this.showWarningMessage(msg, ResManager.loadKDString((String)"\"\u7f16\u7801\"\u5df2\u5b58\u5728\u3002", (String)"TaskConfigSaveValidator_15", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dataEntities, dot);
            return;
        }
        boolean isNameOnly = this.isNameOnly(name, modelId, "bcm_taskconfig");
        if (isNameOnly) {
            this.showWarningMessage(msg, ResManager.loadKDString((String)"\"\u540d\u79f0\"\u5df2\u5b58\u5728\u3002", (String)"TaskConfigSaveValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dataEntities, dot);
            return;
        }
        DynamicObjectCollection tamplates = (DynamicObjectCollection)dot.get("reporttemplates");
    }

    private boolean showWarningMessage(StringBuilder msg, String message, ExtendedDataEntity[] dataEntities, DynamicObject dot) {
        if (!StringUtils.isEmpty((String)message)) {
            msg.append(message);
            this.addErrorMessage(dataEntities[0], msg.toString());
            return true;
        }
        return false;
    }

    private boolean isNumberOnly(String number, long modelId, String entityName) {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        QFilter filter1 = new QFilter("number", "=", (Object)number);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter filter3 = new QFilter("id", "!=", (Object)dot.getLong("tablefkid"));
        QFilter filter4 = new QFilter("taskcatalog.id", "=", (Object)dot.getLong("taskcatalog"));
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3, filter4};
        boolean isNumberOnly = QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
        if (!isNumberOnly) {
            filter1 = new QFilter("number", "=", (Object)number);
            filter2 = new QFilter("id", "=", (Object)dot.getLong("taskcatalog"));
            qFilters = new QFilter[]{filter1, filter2};
            isNumberOnly = QueryServiceHelper.exists((String)"bcm_taskcatalog", (QFilter[])qFilters);
        }
        return isNumberOnly;
    }

    private boolean isNameOnly(String name, long modelId, String entityName) {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject dot = dataEntities[0].getDataEntity();
        QFilter filter1 = new QFilter("name", "=", (Object)name);
        QFilter filter2 = new QFilter("model.id", "=", (Object)modelId);
        QFilter filter3 = new QFilter("id", "!=", (Object)dot.getLong("tablefkid"));
        QFilter filter4 = new QFilter("taskcatalog.id", "=", (Object)dot.getLong("taskcatalog"));
        QFilter[] qFilters = new QFilter[]{filter1, filter2, filter3, filter4};
        boolean isNameOnly = QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters);
        return isNameOnly;
    }

    private String warningTimeCheck(DynamicObject dynamicObject) {
        String message = "";
        int value = dynamicObject.getInt("radiogroupfield");
        if (value == 2) {
            int leafWarningTime = dynamicObject.getInt("integerfield");
            if (leafWarningTime == 0) {
                return ResManager.loadKDString((String)"\u8ba1\u5212\u8017\u65f6\u5269\u4f59\u5929\u6570\u4e0d\u80fd\u5c0f\u4e8e1\u3002", (String)"TaskConfigSaveValidator_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            int planUseTime = dynamicObject.getInt("planusetime");
            if (leafWarningTime > planUseTime) {
                return ResManager.loadKDString((String)"\u5f00\u59cb\u9884\u8b66\u5269\u4f59\u5929\u6570\u53ea\u53ef\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u4efb\u52a1\u7684\u8ba1\u5212\u8017\u65f6\u3002", (String)"TaskConfigSaveValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
        } else if (value == 3) {
            Date warningBeginDate = dynamicObject.getDate("datefield");
            Date startTime = dynamicObject.getDate("starttime");
            Date endTime = dynamicObject.getDate("endtime");
            if (warningBeginDate == null) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u9884\u8b66\u65f6\u95f4\u3002", (String)"TaskConfigSaveValidator_51", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            if (TaskUtil.compareDate((Date)warningBeginDate, (Date)startTime) <= -1 || TaskUtil.compareDate((Date)warningBeginDate, (Date)endTime) >= 1) {
                return ResManager.loadKDString((String)"\u9884\u8b66\u5f00\u59cb\u65e5\u671f\u9700\u5728\u5f53\u524d\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e4b\u95f4\u3002", (String)"TaskConfigSaveValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
        }
        return message;
    }

    private String checkEndAndStartTime(DynamicObject dynamicObject) {
        Date endTime;
        String message = "";
        Date startTime = dynamicObject.getDate("starttime");
        if (!startTime.before(endTime = dynamicObject.getDate("endtime")) && !startTime.equals(endTime)) {
            return ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u5f53\u524d\u4efb\u52a1\u7684\u5f00\u59cb\u65f6\u95f4\u3002", (String)"TaskConfigSaveValidator_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        return message;
    }

    private String checkCirclePre(DynamicObject dynamicObject) {
        DynamicObjectCollection dcs = dynamicObject.getDynamicObjectCollection("pretasks");
        for (DynamicObject dy : dcs) {
            boolean isCirclePre = TaskUtil.isCirclePre((long)dynamicObject.getLong("tablefkid"), (long)((DynamicObject)dy.get(1)).getLong("id"), (String)((Object)((Object)this)).getClass().getName());
            if (!isCirclePre) continue;
            return ResManager.loadKDString((String)"\u4e0d\u53ef\u5faa\u73af\u524d\u7f6e\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u4efb\u52a1\u7684\u524d\u7f6e\u4efb\u52a1\u540e\u91cd\u8bd5\u3002", (String)"TaskConfigSaveValidator_7", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String checkNullField(DynamicObject dynamicObject) {
        int taskType = dynamicObject.getInt("tasktype");
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        if (StringUtils.isEmpty((String)number)) {
            return ResManager.loadKDString((String)"\"\u7f16\u7801\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResManager.loadKDString((String)"\"\u540d\u79f0\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_9", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
        }
        if (taskType == 3 || taskType == 5) {
            DynamicObjectCollection reporttemplates = dynamicObject.getDynamicObjectCollection("reporttemplates");
            Date starttime = dynamicObject.getDate("starttime");
            Date endtime = dynamicObject.getDate("endtime");
            int planusetime = dynamicObject.getInt("planusetime");
            if (reporttemplates != null && reporttemplates.size() == 0) {
                return ResManager.loadKDString((String)"\"\u62a5\u8868\u6a21\u677f\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_10", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            if (starttime == null) {
                return ResManager.loadKDString((String)"\"\u5f00\u59cb\u65f6\u95f4\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_11", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            if (endtime == null) {
                return ResManager.loadKDString((String)"\"\u7ed3\u675f\u65f6\u95f4\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_12", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
            if (planusetime == 0) {
                return ResManager.loadKDString((String)"\"\u8ba1\u5212\u8017\u65f6\"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskConfigSaveValidator_13", (String)"fi-bcm-opplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String isEndTimeLatedToPredStart(DynamicObject dynamicObject) {
        Date endtime = dynamicObject.getDate("endtime");
        QFilter filter = new QFilter("taskforpre.id", "=", (Object)dynamicObject.getLong("tablefkid"));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_taskforpre", (String)"taskconfig", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return "";
        }
        Date previousStartTime = null;
        List ids = dys.stream().map(dy -> dy.getLong("taskconfig")).collect(Collectors.toList());
        filter = new QFilter("id", "in", ids);
        dys = QueryServiceHelper.query((String)"bcm_taskconfig", (String)"starttime", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dy2 : dys) {
            Date starttime = dy2.getDate("starttime");
            if (previousStartTime == null) {
                previousStartTime = starttime;
                continue;
            }
            if (TaskUtil.compareDate((Date)previousStartTime, (Date)starttime) < 0) continue;
            previousStartTime = starttime;
        }
        if (TaskUtil.compareDate(previousStartTime, (Date)endtime) < 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = formatter.format(previousStartTime);
            return String.format(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u88ab\u5176\u4ed6\u4efb\u52a1\u524d\u7f6e\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u665a\u4e8e%s\u3002", (String)"TaskConfigSaveValidator_14", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dateString);
        }
        return "";
    }
}

