/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.serviceHelper.MyTaskStatusHelper;
import kd.fi.bcm.business.sql.util.QCfilterUtils;
import kd.fi.bcm.business.task.TaskUtil;
import kd.fi.bcm.common.enums.PeriodTypeEnum;

public class TaskCopyOp
extends AbstractOperationServicePlugIn {
    private DynamicObject params;
    private DynamicObject explain;
    private DynamicObject[] taskconfigs;
    private DynamicObject[] userDistributes;
    private DynamicObject catalog;
    private String modelId;
    private List<DynamicObject> allParams = new ArrayList<DynamicObject>();
    private List<DynamicObject> allExplains = new ArrayList<DynamicObject>();
    private List<DynamicObject> allTaskconfigs = new ArrayList<DynamicObject>();
    private List<DynamicObject> allUserDistributes = new ArrayList<DynamicObject>();
    private List<DynamicObject> allCatalogs = new ArrayList<DynamicObject>();

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dys;
        for (DynamicObject dy : dys = e.getDataEntities()) {
            if (dy.getString("number").endsWith("copy")) continue;
            this.modelId = dy.getString("model.id");
            this.copyCatalog(dy);
            this.copyExplain(dy);
            this.copyParam(dy);
            this.copyTaskConfig(this.catalog.getLong("id"), dy.getLong("id"));
            this.copyUserDistribute(this.catalog.getLong("id"), dy.getLong("id"));
            if (this.params == null) continue;
            this.allCatalogs.add(this.catalog);
            this.allParams.add(this.params);
            if (this.explain != null) {
                this.allExplains.add(this.explain);
            }
            this.allTaskconfigs.addAll(Arrays.asList(this.taskconfigs));
            this.allUserDistributes.addAll(Arrays.asList(this.userDistributes));
        }
    }

    private void copyParam(DynamicObject dy) {
        DynamicObject dyObj;
        QFilter filter = new QFilter("taskcatalog.copyfrom", "=", (Object)dy.getLong("id"));
        DynamicObject[] dyObjs = BusinessDataServiceHelper.load((String)"bcm_taskparam", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_taskparam").getAllFields().keySet()), (QFilter[])new QFilter[]{filter}, (String)"year.number desc,period.number desc", (int)1);
        if (dyObjs != null && dyObjs.length > 0 && (dyObj = dyObjs[0]) != null) {
            String modelId = dy.getString("model.id");
            String yearId = dyObj.getString("year.id");
            String periodId = dyObj.getString("period.id");
            String[] nextPeriod = QCfilterUtils.getNextPeriod((String)modelId, (String)yearId, (String)periodId, (String)PeriodTypeEnum.NEXT.getIndex());
            DynamicObject copyparam = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyObj, (boolean)false, (boolean)true);
            copyparam.set("id", (Object)DBServiceHelper.genGlobalLongId());
            if (nextPeriod == null) {
                this.params = null;
                return;
            }
            DynamicObject fyYear = BusinessDataServiceHelper.loadSingle((String)"bcm_fymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nextPeriod[0]))});
            DynamicObject periodObj = BusinessDataServiceHelper.loadSingle((String)"bcm_periodmembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(nextPeriod[1]))});
            copyparam.set("year", (Object)fyYear);
            copyparam.set("period", (Object)periodObj);
            DynamicObject scenario = BusinessDataServiceHelper.loadSingle((String)"bcm_scenemembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dyObj.getLong("scenario.id"))});
            DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bcm_currencymembertree", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dyObj.getLong("currency.id"))});
            copyparam.set("scenario", (Object)scenario);
            copyparam.set("currency", (Object)currency);
            this.catalog.set("name", (Object)(fyYear.getString("name") + periodObj.getString("name") + scenario.getString("name") + currency.getString("name") + this.catalog.getString("describe")));
            this.params = copyparam;
            this.params.set("taskcatalog", (Object)this.catalog);
        }
    }

    private void copyExplain(DynamicObject dy) {
        QFilter filter = new QFilter("taskcatalog", "=", (Object)dy.getLong("id"));
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)"bcm_taskexplain", (String)"id,text,taskcatalog", (QFilter[])new QFilter[]{filter});
        if (dyObj != null) {
            this.explain = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyObj, (boolean)false, (boolean)true);
            this.explain.set("id", (Object)DBServiceHelper.genGlobalLongId());
            this.explain.set("taskcatalog", (Object)this.catalog);
        }
    }

    private void copyCatalog(DynamicObject dy) {
        dy = BusinessDataServiceHelper.loadSingle((Object)dy.getLong("id"), (String)"bcm_taskcatalog");
        this.catalog = (DynamicObject)OrmUtils.clone((IDataEntityBase)dy, (boolean)false, (boolean)true);
        this.catalog.set("id", (Object)DBServiceHelper.genGlobalLongId());
        this.catalog.set("number", (Object)TaskUtil.getSeriaNextNumber((String)this.modelId));
    }

    private void copyTaskConfig(long copyCatalogId, long catalogId) {
        QFilter filter1 = new QFilter("taskcatalog.id", "=", (Object)catalogId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"bcm_taskconfig", (String)this.getTaskConfigFiledStr(), (QFilter[])new QFilter[]{filter1});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (dys != null && dys.length > 0) {
            this.taskconfigs = new DynamicObject[dys.length];
            for (int i = 0; i < dys.length; ++i) {
                DynamicObject dy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dys[i], (boolean)false, (boolean)true);
                dy.set("taskcatalog", (Object)this.catalog);
                dy.set("id", (Object)DBServiceHelper.genGlobalLongId());
                this.taskconfigs[i] = dy;
                map.put(dy.getString("longnumber"), dy);
            }
            for (int j = 0; j < this.taskconfigs.length; ++j) {
                this.taskconfigs[j].set("taskcatalog", (Object)this.catalog);
                String longnumber = this.taskconfigs[j].getString("longnumber");
                String number = this.taskconfigs[j].getString("number");
                if (this.params == null) continue;
                String periodName = this.getNameById(this.params.getLong("period.id"), "bcm_periodmembertree");
                String fyName = this.getNameById(this.params.getLong("year.id"), "bcm_fymembertree");
                String scenceName = this.params.getString("scenario.name");
                String cyName = this.params.getString("currency.name");
                if (!"root".equals(longnumber)) {
                    this.assembleSysField(this.taskconfigs[j]);
                    this.taskconfigs[j].set("parent", map.get(TaskUtil.getParentLongNumber((String)longnumber)));
                    if (!"rootparam".equals(number)) continue;
                    this.taskconfigs[j].set("name", (Object)(fyName + periodName + scenceName + cyName));
                    continue;
                }
                this.taskconfigs[j].set("name", (Object)this.catalog.getString("name"));
            }
        }
    }

    private void copyUserDistribute(long copyCatalogId, long catalogId) {
        QFilter filter = new QFilter("taskcatalog.id", "=", (Object)catalogId);
        this.userDistributes = BusinessDataServiceHelper.load((String)"bcm_userdistribute", (String)(this.getUserDistributeFiledStr() + ",userdisentry.seq"), (QFilter[])new QFilter[]{filter});
        if (this.userDistributes != null && this.userDistributes.length > 0) {
            for (int i = 0; i < this.userDistributes.length; ++i) {
                DynamicObject dy = (DynamicObject)OrmUtils.clone((IDataEntityBase)this.userDistributes[i], (boolean)false, (boolean)true);
                dy.set("taskcatalog", (Object)this.catalog);
                this.userDistributes[i] = dy;
            }
        }
    }

    private String getUserDistributeFiledStr() {
        return String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_userdistribute").getAllFields().keySet());
    }

    private String getTaskConfigFiledStr() {
        return "createtime,creator,modifytime,modifier,model,longnumber,level,isleaf,parent,taskcatalog,kseq,finishstatus,number,name,tasktype,discription,templates,templates.template,pretasks,pretasks.taskconf,starttime,endtime,planusetime,warningbegintime,warningbegintype,warningfrequency,outfrequency";
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        BusinessDataServiceHelper.save((IDataEntityType)this.catalog.getDataEntityType(), (Object[])this.allCatalogs.toArray(new DynamicObject[this.allCatalogs.size()]));
        if (this.explain != null) {
            BusinessDataServiceHelper.save((IDataEntityType)this.explain.getDataEntityType(), (Object[])this.allExplains.toArray(new DynamicObject[this.allExplains.size()]));
        }
        if (this.params != null) {
            BusinessDataServiceHelper.save((IDataEntityType)this.params.getDataEntityType(), (Object[])this.allParams.toArray(new DynamicObject[this.allParams.size()]));
        }
        BusinessDataServiceHelper.save((IDataEntityType)this.taskconfigs[0].getDataEntityType(), (Object[])this.allTaskconfigs.toArray(new DynamicObject[this.allTaskconfigs.size()]));
        if (this.userDistributes != null && this.userDistributes.length > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)this.userDistributes[0].getDataEntityType(), (Object[])this.allUserDistributes.toArray(new DynamicObject[this.allUserDistributes.size()]));
        }
        MyTaskStatusHelper.refreshTaskStatusRecord((DynamicObject[])this.allTaskconfigs.toArray(new DynamicObject[this.allTaskconfigs.size()]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    private void assembleSysField(DynamicObject dy) {
        dy.set("createtime", (Object)TimeServiceHelper.getCurrentSystemTime());
        dy.set("creator", (Object)RequestContext.get().getUserId());
        dy.set("modifytime", (Object)TimeServiceHelper.getCurrentSystemTime());
        dy.set("modifier", (Object)RequestContext.get().getUserId());
    }

    private String getNameById(long id, String entityName) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)"name", (QFilter[])new QFilter[]{filter});
        if (dynamicObject != null) {
            return dynamicObject.getString("name");
        }
        return "";
    }
}

