/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.opplugin.template;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ExcelUtils;

public class TemplateDimSettingConfirmValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<Long> dimIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkLessOneRowAndNotNull(dataEntity, "viewentry", ResManager.loadKDString((String)"\u89c6\u70b9\u7ef4\u81f3\u5c11\u9700\u8bbe\u7f6e\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateDimSettingConfirmValidator_0", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dimIds);
            this.checkLessOneRowAndNotNull(dataEntity, "pageentry", ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u81f3\u5c11\u9700\u8bbe\u7f6e\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateDimSettingConfirmValidator_1", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dimIds);
            this.checkLessOneRowAndNotNull(dataEntity, "areaentry", ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u81f3\u5c11\u9700\u8bbe\u7f6e\u4e00\u4e2a\u8303\u56f4\u533a\u57df\u3002", (String)"TemplateDimSettingConfirmValidator_2", (String)"fi-bcm-opplugin", (Object[])new Object[0]), dimIds);
            if (this.getValidateResult() == null || !this.getValidateResult().isSuccess() || dimIds.size() <= 0) continue;
            ORM orm = ORM.create();
            QFilter q1 = new QFilter("model", "=", (Object)159036643012000768L);
            QFilter q2 = new QFilter("id", "not in", (Object)dimIds.toArray(new Long[0]));
            QFilter[] filters = new QFilter[]{q1, q2};
            DynamicObjectCollection coll = orm.query("bcm_dimension", "id,number,name,shortnumber", filters);
            StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d,\u8fd8\u5b58\u5728\u7ef4\u5ea6:", (String)"TemplateDimSettingConfirmValidator_3", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            if (coll.size() <= 0) continue;
            for (DynamicObject d : coll) {
                msg.append('[').append(d.getString("name")).append("]\u3001");
            }
            msg.deleteCharAt(msg.length() - 1);
            msg.append(ResManager.loadKDString((String)"\u672a\u9009\u62e9!", (String)"TemplateDimSettingConfirmValidator_4", (String)"fi-bcm-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(dataEntity, msg.toString());
        }
    }

    private void checkLessOneRowAndNotNull(ExtendedDataEntity dataEntity, String entryKey, String errMsg, Set<Long> dimIds) {
        DynamicObject dynaObj = dataEntity.getDataEntity();
        DynamicObjectCollection entry = dynaObj.getDynamicObjectCollection(entryKey);
        if (entry == null || entry.size() <= 0 && "areaentry".equals(entryKey)) {
            this.addErrorMessage(dataEntity, errMsg);
            return;
        }
        for (DynamicObject row : entry) {
            switch (entryKey) {
                case "viewentry": {
                    if (row.get("viewdimension") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u89c6\u70b9\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_5", (String)"fi-bcm-opplugin", (Object[])new Object[0]), new Object[0]));
                    } else if (row.get("viewmemb") == null && row.get("viewmemb_Id") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u89c6\u70b9\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_7", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    }
                    this.collectDimIds(t -> t.get("viewdimension") != null, dimIds, row, "viewdimension", "viewdimension", false);
                    break;
                }
                case "pageentry": {
                    if (row.get("pagedimension") == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_8", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    } else if (row.get("pagememb") == null || row.getDynamicObjectCollection("pagememb").size() == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_6", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    }
                    this.collectDimIds(t -> t.get("pagedimension") != null, dimIds, row, "pagedimension", "pagedimension", false);
                    break;
                }
                case "areaentry": {
                    if (row.get("rowdim") == null || row.getDynamicObjectCollection("rowdim").size() == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_9", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    } else if (row.get("coldim") == null || row.getDynamicObjectCollection("coldim").size() == 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_9", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    } else if (StringUtils.isEmpty((String)row.getString("arearange"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u533a\u57df\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_10", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    } else if (StringUtils.isEmpty((String)row.getString("startpoint"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u6570\u636e\u5f00\u59cb\u5355\u5143\u683c\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDimSettingConfirmValidator_11", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
                    }
                    this.collectDimIds(t -> t.get("rowdim") != null && t.getDynamicObjectCollection("rowdim").size() > 0, dimIds, row, "rowdim", "FBasedataId", true);
                    this.collectDimIds(t -> t.get("coldim") != null && t.getDynamicObjectCollection("coldim").size() > 0, dimIds, row, "coldim", "FBasedataId", true);
                    this.checkAreaRangeValidata(dataEntity, row);
                }
            }
        }
    }

    private void checkAreaRangeValidata(ExtendedDataEntity dataEntity, DynamicObject row) {
        String areaRange = row.getString("arearange");
        String startPoint = row.getString("startpoint");
        String[] split = areaRange.split(":");
        if (split.length != 2) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u533a\u57df\u8303\u56f4\u8bbe\u7f6e\u9519\u8bef\u3002\u8bf7\u5728\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u81f3\u5c11\u5305\u542b\u5f00\u59cb\u548c\u7ed3\u675f\u5355\u5143\u683c\u4f4d\u7f6e\u3002", (String)"TemplateDimSettingConfirmValidator_12", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq")));
        } else {
            String msg = ExcelUtils.checkPosValidata((String)split[0], (String)split[1], (String)startPoint);
            if (msg.length() > 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u8bbe\u7f6e\u4e2d\u7b2c%d\u884c\u533a\u57df\u8303\u56f4\u8bbe\u7f6e\u9519\u8bef,%s", (String)"TemplateDimSettingConfirmValidator_13", (String)"fi-bcm-opplugin", (Object[])new Object[0]), row.getInt("seq"), msg));
            }
        }
        if (this.getValidateResult().isSuccess()) {
            row.set("arearange", (Object)areaRange.toUpperCase(Locale.ENGLISH));
            row.set("startpoint", (Object)startPoint.toUpperCase(Locale.ENGLISH));
        }
    }

    private void collectDimIds(Predicate<DynamicObject> p, Set<Long> ids, DynamicObject row, String colKey, String itemKey, boolean isMultiSelected) {
        if (isMultiSelected) {
            if (p.test(row)) {
                DynamicObjectCollection tempColl = row.getDynamicObjectCollection(colKey);
                for (DynamicObject d : tempColl) {
                    ids.add(d.getDynamicObject(itemKey).getLong("id"));
                }
            }
        } else if (p.test(row)) {
            ids.add(row.getDynamicObject(colKey).getLong("id"));
        }
    }

    public String getEntityKey() {
        return "bcm_template_dimsetting";
    }
}

