/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.impl.ThreadPoolImpl;

public class BatchProcessHelper {
    private static ThreadPool ASYNC_THREAD_POOL = null;

    private BatchProcessHelper() {
    }

    public static void handleAsync(Runnable runnable) {
        ASYNC_THREAD_POOL.execute(runnable, RequestContext.get());
    }

    static {
        int asyncThreadSize = 2;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(asyncThreadSize, asyncThreadSize, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread newt = new Thread(r, "/fi/bcm/batchprocesshelper/async-" + this.atomicInteger.incrementAndGet());
                newt.setPriority(Math.min(newt.getPriority(), 2));
                return newt;
            }
        });
        executor.allowCoreThreadTimeOut(true);
        ASYNC_THREAD_POOL = new ThreadPoolImpl(ThreadLifeCycleManager.wrapExecutorService((ExecutorService)executor), OperationContext.get(), x -> {});
    }

    public static enum Scene {
        IO,
        CPU;

    }
}

