/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.fi.bcm.business.util.CurrencyTool;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class CellDimFilterUtil {
    public static void cellDimFilterBuild(SpreadManager sm) {
        Object curNum = null;
        Object orgNum = null;
        Object bpNum = null;
        ArrayList dimensionList = new ArrayList(10);
        dimensionList.addAll(sm.getFilter().getPageDomain().getDimensions());
        dimensionList.addAll(sm.getFilter().getViewPointDomain().getDimensions());
        boolean hasEntityDim = false;
        boolean hasCurrencyDim = false;
        boolean hasProcessDim = false;
        for (IDimension d : dimensionList) {
            if ("Entity".equals(d.getNumber())) {
                hasEntityDim = true;
            }
            if ("Currency".equals(d.getNumber())) {
                hasCurrencyDim = true;
            }
            if (!"Process".equals(d.getNumber())) continue;
            hasProcessDim = true;
        }
        if (hasCurrencyDim) {
            if (hasEntityDim && hasProcessDim) {
                return;
            }
            if (!hasEntityDim && !hasProcessDim) {
                sm.getBook().getSheet(0).iteratorCells(c -> {
                    String currencyNumber;
                    if (c.isMdDataDomain() && CurrencyTool.isTransCurrency((String)(currencyNumber = ((IDimMember)CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.CURRENCY, dimensionList).getMembers().get(0)).getNumber()))) {
                        IDimension currencyIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.CURRENCY, dimensionList);
                        c.setAssistDim(currencyIDimension.getMembers());
                    }
                });
            } else if (hasEntityDim) {
                sm.getBook().getSheet(0).iteratorCells(c -> {
                    if (c.isMdDataDomain()) {
                        ArrayList list = new ArrayList(16);
                        IDimension currencyIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.CURRENCY, dimensionList);
                        list.addAll(currencyIDimension.getMembers());
                        IDimension entityIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.ENTITY, dimensionList);
                        list.addAll(entityIDimension.getMembers());
                        c.setAssistDim(list);
                    }
                });
            } else {
                sm.getBook().getSheet(0).iteratorCells(c -> {
                    if (c.isMdDataDomain()) {
                        ArrayList list = new ArrayList(16);
                        IDimension currencyIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.CURRENCY, dimensionList);
                        list.addAll(currencyIDimension.getMembers());
                        IDimension processIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.PROCESS, dimensionList);
                        list.addAll(processIDimension.getMembers());
                        c.setAssistDim(list);
                    }
                });
            }
        } else if (hasEntityDim && hasProcessDim) {
            sm.getBook().getSheet(0).iteratorCells(c -> {
                if (c.isMdDataDomain()) {
                    ArrayList list = new ArrayList(16);
                    IDimension entityIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.ENTITY, dimensionList);
                    list.addAll(entityIDimension.getMembers());
                    IDimension processIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.PROCESS, dimensionList);
                    list.addAll(processIDimension.getMembers());
                    c.setAssistDim(list);
                }
            });
        } else if (hasEntityDim || hasProcessDim) {
            if (hasEntityDim) {
                sm.getBook().getSheet(0).iteratorCells(c -> {
                    if (c.isMdDataDomain()) {
                        IDimension entityIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.ENTITY, dimensionList);
                        c.setAssistDim(entityIDimension.getMembers());
                    }
                });
            } else {
                sm.getBook().getSheet(0).iteratorCells(c -> {
                    if (c.isMdDataDomain()) {
                        IDimension processIDimension = CellDimFilterUtil.getDimensionInAllDomain(DimTypesEnum.PROCESS, dimensionList);
                        c.setAssistDim(processIDimension.getMembers());
                    }
                });
            }
        }
    }

    protected static IDimension getDimensionInAllDomain(DimTypesEnum dimType, List<IDimension> list) {
        for (IDimension dimension : list) {
            if (!dimType.getNumber().equals(dimension.getNumber())) continue;
            return dimension;
        }
        return null;
    }
}

