/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;
import kd.fi.bcm.spread.util.DynamicUtils;

public class ReportSpecialVariableUtil {
    public static final String ALREADYCACHEPERIODSUPPLIER = "alreadycacheperiodsupplier";
    public static final String ALREADYDESERPERIODSUPPLIER = "alreadydeserperiodsupplier";

    private static void addSingleDimSpecialQueryFilter(Set<String> specialMembers, SelectCommandInfo queryInfo, String dimNum) {
        if (!specialMembers.isEmpty()) {
            queryInfo.getFilter().stream().forEach(f -> {
                if (dimNum.equals(f.getName())) {
                    for (String fy : specialMembers) {
                        if (f.getValues().contains(fy)) continue;
                        f.getValues().add(fy);
                    }
                    return;
                }
            });
        }
    }

    public static void addSpecialQueryFilter(SpreadManager sm, SelectCommandInfo queryInfo, String modelNumber, IRelaMembSupplier<String, String> periodSupplier) {
        String currentYear = "";
        String currentPeriod = "";
        if (periodSupplier == null) {
            return;
        }
        currentYear = periodSupplier.getCurrentYear();
        currentPeriod = periodSupplier.getCurrentPeriod();
        boolean hasFy = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.FY_DIM);
        boolean hasPeriod = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.PERIOD_DIM);
        if (hasFy && hasPeriod) {
            return;
        }
        HashSet<String> yearSet = new HashSet<String>(16);
        HashSet<String> periodSet = new HashSet<String>(16);
        ReportSpecialVariableUtil.tranSimpleSpecialVar(yearSet, periodSet, currentYear, currentPeriod, hasFy, hasPeriod, modelNumber, queryInfo);
        ReportSpecialVariableUtil.addSingleDimSpecialQueryFilter(yearSet, queryInfo, PresetConstant.FY_DIM);
        ReportSpecialVariableUtil.addSingleDimSpecialQueryFilter(periodSet, queryInfo, PresetConstant.PERIOD_DIM);
    }

    public static void cachePeriodSupplier(SpreadManager sm, IRelaMembSupplier<String, String> periodSupplier) {
        if (ThreadCache.get((Object)ALREADYCACHEPERIODSUPPLIER) != null) {
            return;
        }
        if (periodSupplier != null) {
            sm.getBook().getSheet(0).putUserObject("periodSupplier", (Object)ObjectSerialUtil.toByteSerialized(periodSupplier));
            ThreadCache.put((Object)ALREADYCACHEPERIODSUPPLIER, (Object)ALREADYCACHEPERIODSUPPLIER);
        } else {
            sm.getBook().getSheet(0).putUserObject("periodSupplier", null);
        }
    }

    public static IRelaMembSupplier<String, String> getPeriodSupplierFromSm(SpreadManager sm) {
        return (IRelaMembSupplier)ThreadCache.get((Object)ALREADYDESERPERIODSUPPLIER, () -> {
            if (sm.getBook().getSheet(0).getUserObject("periodSupplier") != null) {
                return (IRelaMembSupplier)ObjectSerialUtil.deSerializedBytes((String)((String)sm.getBook().getSheet(0).getUserObject("periodSupplier")));
            }
            return null;
        });
    }

    private static void tranSimpleSpecialVar(Set<String> yearSet, Set<String> periodSet, String currentYear, String currentPeriod, boolean hasFy, boolean hasPeriod, String modelNumber, SelectCommandInfo queryInfo) {
        queryInfo.getFilter().forEach(e -> {
            if (!hasFy && PresetConstant.FY_DIM.equals(e.getName())) {
                Optional lastYear;
                if (e.getValues().contains("CurrentYear")) {
                    yearSet.add(currentYear);
                }
                if (e.getValues().contains("LastYear") && (lastYear = PeriodUtils.getLastYear((String)modelNumber, (String)currentYear)).isPresent()) {
                    yearSet.add((String)lastYear.get());
                }
            } else if (!hasPeriod && PresetConstant.PERIOD_DIM.equals(e.getName()) && e.getValues().contains("CurrentPeriod")) {
                periodSet.add(currentPeriod);
            }
        });
    }

    public static String getRealMemNumber(String dimNum, String memNum, boolean fyIsPv, IRelaMembSupplier<String, String> periodSupplier) {
        if (periodSupplier != null) {
            if (PresetConstant.FY_DIM.equals(dimNum)) {
                Optional specificFy;
                if (("CurrentYear".equals(memNum) || "LastYear".equals(memNum)) && (specificFy = PeriodUtils.trans2SpecificFy((String)periodSupplier.getModelNumber(), (String)periodSupplier.getCurrentYear(), (String)memNum)).isPresent()) {
                    return (String)specificFy.get();
                }
            } else if (PresetConstant.PERIOD_DIM.equals(dimNum)) {
                if ("CurrentPeriod".equals(memNum)) {
                    return periodSupplier.getCurrentPeriod();
                }
                if ("LastPeriod".equals(memNum) && fyIsPv) {
                    Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)periodSupplier.getModelNumber(), (String)periodSupplier.getCurrentScenario(), (String)periodSupplier.getCurrentPeriod(), (String)periodSupplier.getCurrentYear(), (String)"LastPeriod");
                    if (periodSupplier.getCurrentYear().equals(yearAndPeriod.p1) && !Objects.isNull(yearAndPeriod.p2)) {
                        memNum = (String)yearAndPeriod.p2;
                    }
                }
            }
        }
        return memNum;
    }

    public static boolean isPageAndViewFilterForFp(SpreadManager sm, String dimNum) {
        return (Boolean)ThreadCache.get((Object)(sm.hashCode() + dimNum), () -> sm.getFilter().getPageDomain().getAllMembers().stream().anyMatch(e -> dimNum.equals(e.getDimension().getNumber())) || sm.getFilter().getViewPointDomain().getAllMembers().stream().anyMatch(e -> dimNum.equals(e.getDimension().getNumber())));
    }

    public static void dealSpecialPeriodOrFyForSm(SpreadManager sm, IRelaMembSupplier<String, String> periodSupplier, Object param) {
        boolean fyIsPv = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.FY_DIM);
        boolean periodIsPV = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.PERIOD_DIM);
        if (periodSupplier == null) {
            periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm(sm);
        }
        if (periodSupplier == null || fyIsPv && periodIsPV) {
            return;
        }
        String pageFYNum = periodSupplier.getCurrentYear();
        String pagePNum = periodSupplier.getCurrentPeriod();
        String pageSNum = periodSupplier.getCurrentScenario();
        String modelNumber = periodSupplier.getModelNumber();
        RangeModel rangeModel = null;
        if (param instanceof RangeModel) {
            rangeModel = (RangeModel)param;
        } else {
            PositionInfo ps = null;
            if (param instanceof PositionInfo) {
                ps = (PositionInfo)param;
                rangeModel = new RangeModel(ps.getAreaRange());
            }
            ReportSpecialVariableUtil.tranSpecialVarForFixMembers(sm, ps);
            ReportSpecialVariableUtil.tranSpecialVarForDomain(sm, ps);
        }
        sm.getBook().getSheet(0).iteratorRangeCells(rangeModel, false, cell -> {
            if (Objects.nonNull(cell.getMemberFromUserObject())) {
                AtomicBoolean flag = new AtomicBoolean(false);
                IDimMember fyDMember = null;
                IDimMember lastPeriodDMember = null;
                String currentYear = fyIsPv ? pageFYNum : "";
                String currentScenario = pageSNum;
                List memberFromUserObject = cell.getMemberFromUserObject();
                Iterator iterator = memberFromUserObject.iterator();
                while (iterator.hasNext()) {
                    String dimNum = ((IDimMember)iterator.next()).getDimension().getNumber();
                    if ((!"Year".equals(dimNum) || !fyIsPv) && (!"Period".equals(dimNum) || !periodIsPV)) continue;
                    iterator.remove();
                }
                for (IDimMember e : memberFromUserObject) {
                    String memNum = e.getNumber();
                    if (PresetConstant.FY_DIM.equals(e.getDimension().getNumber())) {
                        if ("CurrentYear".equals(memNum)) {
                            flag.set(true);
                            e.setNumber(pageFYNum);
                        } else if ("LastYear".equals(memNum)) {
                            Optional lastYear = PeriodUtils.getLastYear((String)modelNumber, (String)pageFYNum);
                            if (lastYear.isPresent()) {
                                flag.set(true);
                                e.setNumber((String)lastYear.get());
                            }
                        } else if (!Arrays.asList("AllYear", "Year").contains(memNum)) {
                            currentYear = memNum;
                        }
                        if (flag.get()) {
                            ((DimMember)e).setOriNumber(memNum);
                            currentYear = e.getNumber();
                        }
                        fyDMember = e;
                        continue;
                    }
                    if (!PresetConstant.PERIOD_DIM.equals(e.getDimension().getNumber())) continue;
                    if ("CurrentPeriod".equals(memNum)) {
                        ((DimMember)e).setOriNumber(memNum);
                        e.setNumber(pagePNum);
                        continue;
                    }
                    if (!"LastPeriod".equals(memNum)) continue;
                    lastPeriodDMember = e;
                }
                if (lastPeriodDMember != null) {
                    if (StringUtils.isEmpty((String)currentYear)) {
                        return;
                    }
                    String memNum = lastPeriodDMember.getNumber();
                    Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)modelNumber, (String)currentScenario, (String)pagePNum, (String)currentYear, (String)memNum);
                    if (fyDMember != null || fyIsPv) {
                        if (!currentYear.equals(yearAndPeriod.p1) && StringUtils.isNotEmpty((String)((String)yearAndPeriod.p1))) {
                            if (fyDMember != null) {
                                Dimension fyDimension = new Dimension(TemplateUtil.getDimName((Long)MemberReader.findModelIdByNum((String)modelNumber), (String)PresetConstant.FY_DIM), PresetConstant.FY_DIM, DimEntityNumEnum.YEAR.getEntityNum());
                                DimMember newFyMember = new DimMember(null, (String)yearAndPeriod.p1, null, (IDimension)fyDimension);
                                int yearIndex = memberFromUserObject.indexOf(fyDMember);
                                memberFromUserObject.remove(yearIndex);
                                newFyMember.setNumber((String)yearAndPeriod.p1);
                                if (!Arrays.asList("LastPeriod", "LastYear", "CurrentYear", "CurrentPeriod").contains(((DimMember)fyDMember).getOriNumber())) {
                                    newFyMember.setOriNumber(fyDMember.getNumber());
                                } else {
                                    newFyMember.setOriNumber(((DimMember)fyDMember).getOriNumber());
                                }
                                memberFromUserObject.add(yearIndex, newFyMember);
                            } else {
                                return;
                            }
                        }
                        if (StringUtils.isNotEmpty((String)((String)yearAndPeriod.p2))) {
                            Dimension periodDimension = new Dimension(TemplateUtil.getDimName((Long)MemberReader.findModelIdByNum((String)modelNumber), (String)PresetConstant.PERIOD_DIM), PresetConstant.PERIOD_DIM, DimEntityNumEnum.PERIOD.getEntityNum());
                            DimMember newLastPMember = new DimMember(null, (String)yearAndPeriod.p2, null, (IDimension)periodDimension);
                            int periodIndex = memberFromUserObject.indexOf(lastPeriodDMember);
                            memberFromUserObject.remove(periodIndex);
                            newLastPMember.setNumber((String)yearAndPeriod.p2);
                            newLastPMember.setOriNumber(memNum);
                            memberFromUserObject.add(periodIndex, newLastPMember);
                        }
                    }
                }
            }
        });
    }

    private static void tranSpecialVarForDomain(SpreadManager sm, PositionInfo ps) {
        boolean fyIsPv = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.FY_DIM);
        boolean periodIsPV = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.PERIOD_DIM);
        if (fyIsPv && periodIsPV) {
            return;
        }
        IRelaMembSupplier<String, String> periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm(sm);
        if (periodSupplier == null) {
            return;
        }
        if (ps != null) {
            Tuple tuple = sm.getAreaManager().getRowAndColDomainByPosition(ps);
            if (tuple != null) {
                ReportSpecialVariableUtil.dealSingleDomain((Domain)tuple.k, periodSupplier, fyIsPv);
                ReportSpecialVariableUtil.dealSingleDomain((Domain)tuple.v, periodSupplier, fyIsPv);
            }
        } else {
            sm.getAreaManager().iterator().forEachRemaining(entry -> {
                ReportSpecialVariableUtil.dealSingleDomain((Domain)((Tuple)entry.getValue()).k, periodSupplier, fyIsPv);
                ReportSpecialVariableUtil.dealSingleDomain((Domain)((Tuple)entry.getValue()).v, periodSupplier, fyIsPv);
            });
        }
    }

    public static boolean hasLastPeriodVar(SpreadManager sm) {
        boolean flag = false;
        if (ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.PERIOD_DIM)) {
            return flag;
        }
        Iterator iterator = sm.getAreaManager().iterator();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)((Map.Entry)iterator.next()).getValue();
            Predicate<IDimMember> predicate = new Predicate<IDimMember>(){

                @Override
                public boolean test(IDimMember e) {
                    return PresetConstant.PERIOD_DIM.equals(e.getDimension().getNumber()) && "LastPeriod".equals(e.getNumber());
                }
            };
            if (!((RowDimDomain)tuple.k).getAllMembers().stream().anyMatch(predicate) && !((ColumnDimDomain)tuple.v).getAllMembers().stream().anyMatch(predicate)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static void dealSingleDomain(Domain domain, IRelaMembSupplier<String, String> periodSupplier, boolean fyIsPv) {
        domain.getAllMembers().forEach(e -> {
            String realMemNumber;
            String memNum;
            if (Arrays.asList(PresetConstant.PERIOD_DIM, PresetConstant.FY_DIM).contains(e.getDimension().getNumber()) && !(memNum = e.getNumber()).equals(realMemNumber = ReportSpecialVariableUtil.getRealMemNumber(e.getDimension().getNumber(), memNum, fyIsPv, periodSupplier)) && StringUtils.isNotEmpty((String)realMemNumber)) {
                e.setNumber(realMemNumber);
                if (!Arrays.asList("LastPeriod", "LastYear", "CurrentYear", "CurrentPeriod").contains(((DimMember)e).getOriNumber())) {
                    ((DimMember)e).setOriNumber(memNum);
                }
            }
        });
    }

    private static void tranSpecialVarForFixMembers(SpreadManager sm, PositionInfo ps) {
        boolean fyIsPv = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.FY_DIM);
        boolean periodIsPV = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.PERIOD_DIM);
        if (fyIsPv && periodIsPV) {
            return;
        }
        IRelaMembSupplier<String, String> periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm(sm);
        if (periodSupplier == null) {
            return;
        }
        if (DynamicUtils.isDynamicReport((SpreadManager)sm)) {
            if (ps != null) {
                ReportSpecialVariableUtil.tranSpecialVarForBasePoints(periodSupplier, ps.getBasePoints(), fyIsPv);
            } else {
                sm.getAreaManager().getPostionInfoSet().forEach(e -> ReportSpecialVariableUtil.tranSpecialVarForBasePoints(periodSupplier, e.getBasePoints(), fyIsPv));
            }
        }
    }

    private static void tranSpecialVarForBasePoints(IRelaMembSupplier<String, String> periodSupplier, List<BasePointInfo> basePoints, boolean fyIsPv) {
        if (!basePoints.isEmpty()) {
            basePoints.forEach(b -> {
                Map fixMemberPosition = b.getFixMemberPosition();
                if (!fixMemberPosition.isEmpty()) {
                    fixMemberPosition.forEach((k, v) -> v.forEach(iDimMember -> {
                        String realMemNumber;
                        String dimNum = iDimMember.getDimension().getNumber();
                        String memNum = iDimMember.getNumber();
                        if (Arrays.asList(PresetConstant.PERIOD_DIM, PresetConstant.FY_DIM).contains(dimNum) && !memNum.equals(realMemNumber = ReportSpecialVariableUtil.getRealMemNumber(dimNum, memNum, fyIsPv, periodSupplier)) && StringUtils.isNotEmpty((String)realMemNumber)) {
                            iDimMember.setNumber(realMemNumber);
                            if (!Arrays.asList("LastPeriod", "LastYear", "CurrentYear", "CurrentPeriod").contains(((DimMember)iDimMember).getOriNumber())) {
                                ((DimMember)iDimMember).setOriNumber(memNum);
                            }
                        }
                    }));
                }
            });
        }
    }

    public static void tranSpecialVar(List<Pair<String, String>> k, SpreadManager sm) {
        IRelaMembSupplier<String, String> periodSupplier = ReportSpecialVariableUtil.getPeriodSupplierFromSm(sm);
        if (periodSupplier != null) {
            boolean fyIsPv = ReportSpecialVariableUtil.isPageAndViewFilterForFp(sm, PresetConstant.FY_DIM);
            Pair yearPair = null;
            Pair periodPair = null;
            boolean hasLastPeriod = false;
            Pair<String, String> orignYearPair = null;
            Pair<String, String> orignPeriodPair = null;
            String currentYear = fyIsPv ? periodSupplier.getCurrentYear() : "";
            for (Pair<String, String> pair : k) {
                if (PresetConstant.PERIOD_DIM.equals(pair.p1)) {
                    orignPeriodPair = pair;
                    if ("CurrentPeriod".equals(pair.p2)) {
                        periodPair = Pair.onePair((Object)PresetConstant.PERIOD_DIM, (Object)periodSupplier.getCurrentYear());
                        continue;
                    }
                    if (!"LastPeriod".equals(pair.p2)) continue;
                    hasLastPeriod = true;
                    continue;
                }
                if (!PresetConstant.FY_DIM.equals(pair.p1)) continue;
                orignYearPair = pair;
                if ("CurrentYear".equals(pair.p2) || "LastYear".equals(pair.p2)) {
                    Optional specificFy = PeriodUtils.trans2SpecificFy((String)periodSupplier.getModelNumber(), (String)periodSupplier.getCurrentYear(), (String)((String)pair.p2));
                    if (!specificFy.isPresent()) continue;
                    currentYear = (String)specificFy.get();
                    yearPair = Pair.onePair((Object)PresetConstant.FY_DIM, specificFy.get());
                    continue;
                }
                if (Arrays.asList("AllYear", "Year").contains(pair.p2)) continue;
                currentYear = (String)pair.p2;
            }
            if (hasLastPeriod && StringUtils.isNotEmpty((String)currentYear)) {
                Pair yearAndPeriod = PeriodUtils.trans2SpecificPeriodForReport((String)periodSupplier.getModelNumber(), (String)periodSupplier.getCurrentScenario(), (String)periodSupplier.getCurrentPeriod(), (String)currentYear, (String)"LastPeriod");
                if (yearAndPeriod.p1 != null && !fyIsPv && !currentYear.equals(yearAndPeriod.p1)) {
                    ReportSpecialVariableUtil.adjustPair(orignYearPair, (Pair<String, String>)Pair.onePair((Object)PresetConstant.FY_DIM, (Object)yearAndPeriod.p1), k);
                }
                if (yearAndPeriod.p2 != null) {
                    ReportSpecialVariableUtil.adjustPair(orignPeriodPair, (Pair<String, String>)Pair.onePair((Object)PresetConstant.PERIOD_DIM, (Object)yearAndPeriod.p2), k);
                }
            } else {
                ReportSpecialVariableUtil.adjustPair(orignYearPair, yearPair, k);
                ReportSpecialVariableUtil.adjustPair(orignPeriodPair, periodPair, k);
            }
        }
    }

    private static void adjustPair(Pair<String, String> orignPair, Pair<String, String> newPair, List<Pair<String, String>> k) {
        if (orignPair != null && newPair != null) {
            int index = k.indexOf(orignPair);
            k.remove(index);
            k.add(index, newPair);
        }
    }

    public static boolean hasLastSpecialVar(Cell cell) {
        Predicate<IDimMember> predicate = new Predicate<IDimMember>(){

            @Override
            public boolean test(IDimMember e) {
                List<String> numbers = Arrays.asList(e.getNumber(), ((DimMember)e).getOriNumber());
                return PresetConstant.FY_DIM.equals(e.getDimension().getNumber()) && numbers.contains("LastYear") || PresetConstant.PERIOD_DIM.equals(e.getDimension().getNumber()) && numbers.contains("LastPeriod");
            }
        };
        return cell.getMemberFromUserObject().stream().anyMatch(predicate);
    }

    public static boolean isAllowClearCellVaue(Cell cell) {
        return cell.isMdDataDomain() && cell.getUserObject("p") == null && cell.getUserObject("r") == null && !ReportSpecialVariableUtil.hasLastSpecialVar(cell);
    }
}

