/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionComparator;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.PrintLogger;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class FreeStyleTemplateBuilderNew {
    private SpreadManager spread;
    private Map<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>> posMap;

    public FreeStyleTemplateBuilderNew(SpreadManager spread) {
        this.spread = spread;
        this.posMap = new HashMap<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>>(spread.getAreaManager().getPositionSize());
    }

    public void doBuildReport(boolean is) {
        this.collectRowAndColMemberInfo();
        this.cross();
        if (is) {
            this.delRowAndColDim();
        }
        PrintLogger.outputLogFile((Sheet)this.getEffectiveSheet());
        this.shrinkShellModel();
    }

    private void shrinkShellModel() {
        this.getEffectiveSheet().shrinkSheetModel(false);
    }

    private void delRowAndColDim() {
        ArrayList ps = new ArrayList(this.spread.getAreaManager().getPostionInfoSet());
        ps.sort(new PositionComparator(true));
        ArrayList psre = new ArrayList();
        ps.forEach(p -> {
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] startxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[0]);
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            this.getEffectiveSheet().delRangeRows(startxy[0], endxy[0], dataxy[1] - 1, 1);
            this.getEffectiveSheet().delRangeCols(startxy[1], endxy[1] - 1, dataxy[0] - 1, 1);
            AdjustRangeEvent adjustrow = new AdjustRangeEvent(dataxy[1] - 1, 0, -1);
            AdjustRangeEvent adjustcol = new AdjustRangeEvent(dataxy[0] - 1, 1, -1);
            p.adjustRange(adjustrow);
            p.adjustRange(adjustcol);
            psre.forEach(c -> {
                if (SpreadAreaUtil.isUpArea((String)p.getAreaRange(), (String)c.getAreaRange())) {
                    c.adjustRange(adjustrow);
                }
                if (SpreadAreaUtil.isLeftArea((String)p.getAreaRange(), (String)c.getAreaRange())) {
                    c.adjustRange(adjustcol);
                }
            });
            psre.add(p);
        });
    }

    private Sheet getEffectiveSheet() {
        return this.spread.getBook().getSheet(0);
    }

    private void cross() {
        Sheet sheet = this.getEffectiveSheet();
        this.posMap.entrySet().forEach(e -> {
            if (!((List)((Tuple)e.getValue()).k).isEmpty() && !((List)((Tuple)e.getValue()).v).isEmpty()) {
                ((List)((Tuple)e.getValue()).k).forEach(r -> ((List)((Tuple)e.getValue()).v).forEach(c -> {
                    sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).clearMembersOfUserObject();
                    sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).addDims2UserObject(((DimensionMemberInfo)r).members);
                    sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).addDims2UserObject(((DimensionMemberInfo)c).members);
                    sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c).setMdDataDomain(true);
                }));
            }
        });
    }

    private void collectRowAndColMemberInfo() {
        boolean isDynamic = false;
        int dynaDirect = -1;
        for (PositionInfo p : this.spread.getAreaManager().getPostionInfoSet()) {
            IDimension newOne;
            List<Object> members;
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            int startCol = dataxy[0] - 1;
            HashMap<Integer, List<Object>> fixMemberPosition = new HashMap<Integer, List<Object>>();
            isDynamic = !p.getBasePoints().isEmpty();
            dynaDirect = isDynamic ? ((BasePointInfo)p.getBasePoints().get(0)).getDirect() : -1;
            int FixMemberPosition = -1;
            RowDimDomain rowDomain = new RowDimDomain();
            ArrayList<DimensionMemberInfo> rows = new ArrayList<DimensionMemberInfo>();
            for (int r = dataxy[1]; r <= endxy[1]; ++r) {
                members = this.getEffectiveSheet().getCell(r, startCol).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<IDimMember>(members);
                rows.add(new DimensionMemberInfo(r, startCol, members));
                for (IDimMember iDimMember : members) {
                    if (!rowDomain.containsDimension(iDimMember.getDimension())) {
                        newOne = iDimMember.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(iDimMember.getDimension()).addMember(iDimMember);
                }
                if (!isDynamic || dynaDirect != 1) continue;
                fixMemberPosition.put(FixMemberPosition, members);
            }
            ColumnDimDomain colDomain = new ColumnDimDomain();
            ArrayList<DimensionMemberInfo> cols = new ArrayList<DimensionMemberInfo>();
            int startRow = dataxy[1] - 1;
            FixMemberPosition = -1;
            for (int c = dataxy[0]; c <= endxy[0]; ++c) {
                members = this.getEffectiveSheet().getCell(startRow, c).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList<Object>(members);
                cols.add(new DimensionMemberInfo(startRow, c, members));
                for (IDimMember iDimMember : members) {
                    if (!colDomain.containsDimension(iDimMember.getDimension())) {
                        newOne = iDimMember.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(iDimMember.getDimension()).addMember(iDimMember);
                }
                if (!isDynamic || dynaDirect != 2) continue;
                fixMemberPosition.put(FixMemberPosition, members);
            }
            this.posMap.put(p, (Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>)Tuple.newOne(rows, cols));
            this.spread.getAreaManager().addArea(p, rowDomain, colDomain);
            p.getBasePoints().forEach(bp -> bp.setFixMemberPosition(fixMemberPosition));
        }
    }

    static class DimensionMemberInfo {
        private int r;
        private int c;
        private List<IDimMember> members;

        DimensionMemberInfo(int r, int c, List<IDimMember> members) {
            this.r = r;
            this.c = c;
            this.members = members;
        }
    }
}

