/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.ColDimensionEntryExt;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.MembSettingBaseDetail;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.util.SerialSpliter;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.formplugin.workingpaper.model.Column;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.PrintLogger;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class FreeStyleTemplateFinalBuilder {
    private SpreadManager spread;
    private Map<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>> posMap;
    private boolean isStoreCrossNums = false;
    private TemplateModel template;

    public FreeStyleTemplateFinalBuilder(SpreadManager spread, TemplateModel template) {
        this.spread = spread;
        this.template = template;
        this.posMap = new HashMap<PositionInfo, Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>>(spread.getAreaManager().getPositionSize());
    }

    public void doBuildReport(boolean isShrink, boolean isStoreCrossNums) {
        this.isStoreCrossNums = isStoreCrossNums;
        this.collectRowAndColMemberInfo();
        this.cross();
        PrintLogger.outputLogFile((Sheet)this.getEffectiveSheet());
        if (isShrink) {
            this.shrinkShellModel();
        }
    }

    private void shrinkShellModel() {
        this.getEffectiveSheet().shrinkContent(true);
        this.getEffectiveSheet().shrinkSheetModel(false);
    }

    private Sheet getEffectiveSheet() {
        return this.spread.getBook().getSheet(0);
    }

    private void cross() {
        boolean isWp;
        Sheet sheet = this.getEffectiveSheet();
        int wpRowDimSize = 0;
        boolean bl = isWp = this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType();
        if (isWp) {
            for (AreaRangeEntry areaRangeEntry : this.template.getAreaRangeEntries()) {
                List rowDimEntries = areaRangeEntry.getRowDimEntries();
                if (rowDimEntries.isEmpty()) continue;
                wpRowDimSize = rowDimEntries.size();
                break;
            }
        }
        int finalWpRowDimSize = wpRowDimSize;
        this.posMap.entrySet().forEach(e -> {
            if (!((List)((Tuple)e.getValue()).k).isEmpty() && !((List)((Tuple)e.getValue()).v).isEmpty()) {
                ((List)((Tuple)e.getValue()).k).forEach(r -> {
                    if (!isWp || ((DimensionMemberInfo)r).members != null && ((DimensionMemberInfo)r).members.size() == finalWpRowDimSize && isWp) {
                        ((List)((Tuple)e.getValue()).v).forEach(c -> {
                            Cell cell = sheet.getCell(((DimensionMemberInfo)r).r, ((DimensionMemberInfo)c).c);
                            if (!((Boolean)cell.getUserObject("not_cross", (Object)Boolean.FALSE)).booleanValue()) {
                                cell.clearMembersOfUserObject();
                                cell.addDims2UserObject(((DimensionMemberInfo)r).members);
                                cell.addDims2UserObject(((DimensionMemberInfo)c).members);
                                if (this.isStoreCrossNums) {
                                    cell.setUserObject("cross_nums", (Object)this.collectMembNums(((DimensionMemberInfo)r).members, ((DimensionMemberInfo)c).members));
                                }
                                cell.setMdDataDomain(true);
                            }
                        });
                    }
                });
            }
        });
    }

    private String collectMembNums(List<IDimMember> ... list) {
        StringBuilder sb = new StringBuilder();
        for (List<IDimMember> l : list) {
            l.forEach(m -> {
                String number = m.getNumber();
                if (DimTypesEnum.ENTITY.getNumber().equals(m.getDimension().getNumber()) && StringUtils.isNotEmpty((String)m.getPar_SonNum())) {
                    number = m.getPar_SonNum();
                }
                sb.append(m.getDimension().getNumber()).append(':').append(number).append('#');
            });
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private void collectRowAndColMemberInfo() {
        boolean isDynamic = false;
        int dynaDirect = -1;
        for (PositionInfo p : this.spread.getAreaManager().getPostionInfoSet()) {
            IDimension newOne;
            ArrayList<Object> markmembers;
            List members;
            boolean isWp;
            AreaRangeEntry area = this.getAreaByStratpoint(p.getStartPosition());
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            int startCol = dataxy[0];
            boolean bl = isWp = this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType();
            if (isWp) {
                Column column;
                List columnList = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.spread.getBook().getSheet(0).getUserObject("column_list")));
                Iterator iterator = columnList.iterator();
                while (iterator.hasNext() && (column = (Column)iterator.next()).hasFormula()) {
                    ++startCol;
                }
            }
            HashMap<Integer, ArrayList<Object>> fixMemberPosition = new HashMap<Integer, ArrayList<Object>>();
            isDynamic = !p.getBasePoints().isEmpty();
            dynaDirect = isDynamic ? ((BasePointInfo)p.getBasePoints().get(0)).getDirect() : -1;
            int FixMemberPosition = -1;
            RowDimDomain rowDomain = new RowDimDomain();
            ArrayList<DimensionMemberInfo> rows = new ArrayList<DimensionMemberInfo>();
            for (int r = dataxy[1]; r <= endxy[1]; ++r) {
                members = this.getEffectiveSheet().getCell(r, startCol).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList(members);
                markmembers = new ArrayList<IDimMember>();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("row", m.getDimension().getNumber(), area)) continue;
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    rows.add(new DimensionMemberInfo(r, startCol, markmembers));
                }
                if (!isDynamic || dynaDirect != 1) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            ColumnDimDomain colDomain = new ColumnDimDomain();
            ArrayList<DimensionMemberInfo> cols = new ArrayList<DimensionMemberInfo>();
            int startRow = dataxy[1];
            FixMemberPosition = -1;
            for (int c = dataxy[0]; c <= endxy[0]; ++c) {
                members = this.getEffectiveSheet().getCell(startRow, c).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList(members);
                markmembers = new ArrayList();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("col", m.getDimension().getNumber(), area)) continue;
                    if (!colDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    cols.add(new DimensionMemberInfo(startRow, c, markmembers));
                }
                if (!isDynamic || dynaDirect != 2) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            if (this.template.getTemplateType() == null || this.template.getTemplateType().intValue() != TemplateTypeEnum.MSN.getType()) {
                AreaRangeEntry areaEntry = this.template.findAreaByArea(p.getAreaRange());
                RowDimDomain rowDomain2 = rowDomain;
                ColumnDimDomain colDomain2 = colDomain;
                int dimSize = areaEntry.getRowDimEntries().size() + areaEntry.getColDimEntries().size();
                this.getEffectiveSheet().iteratorRangeCells(dataxy[1], endxy[1], dataxy[0], endxy[0], cell -> {
                    if (cell.isMdDataDomain()) {
                        List members2 = cell.getMemberFromUserObject();
                        if (members2 != null && !members2.isEmpty() && !((Boolean)cell.getUserObject("not_cross", (Object)Boolean.FALSE)).booleanValue()) {
                            this.appendMember2RowOrColDomain(cell.getMemberFromUserObject(), areaEntry, rowDomain2, colDomain2, null, null);
                        } else {
                            SerialSpliter spliter;
                            String serial = (String)cell.getUserObject("cross_nums", (Object)"");
                            if (StringUtils.isNotEmpty((String)serial) && serial.split(String.valueOf('#')).length == dimSize && (spliter = new SerialSpliter(serial)).getPairs().size() == dimSize) {
                                ArrayList<DimMember> newmembers = new ArrayList<DimMember>(dimSize);
                                for (int i = 0; i < spliter.getPairs().size(); ++i) {
                                    kd.fi.bcm.spread.model.Dimension dim = new kd.fi.bcm.spread.model.Dimension(null, (String)spliter.getPairs().getPair((int)i).p1, null);
                                    DimMember member = new DimMember(null, (String)spliter.getPairs().getPair((int)i).p2, null, (IDimension)dim);
                                    newmembers.add(member);
                                }
                                cell.clearMembersOfUserObject();
                                cell.addDims2UserObject(newmembers);
                                this.appendMember2RowOrColDomain(cell.getMemberFromUserObject(), areaEntry, rowDomain2, colDomain2, null, null);
                            }
                        }
                    }
                });
            }
            this.posMap.put(p, (Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>)Tuple.newOne(rows, cols));
            this.spread.getAreaManager().addArea(p, rowDomain, colDomain);
            p.getBasePoints().forEach(bp -> bp.setFixMemberPosition(fixMemberPosition));
        }
    }

    private void appendMember2RowOrColDomain(List<IDimMember> members, AreaRangeEntry areaEntry, RowDimDomain rowDomain, ColumnDimDomain colDomain, Consumer<IDimMember> rowCons, Consumer<IDimMember> colCons) {
        if (members != null && !members.isEmpty()) {
            areaEntry.getRowDimEntries().forEach(row -> members.forEach(m -> {
                if (row.getDimension().getNumber().equals(m.getDimension().getNumber())) {
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        IDimension newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember(m);
                    if (rowCons != null) {
                        rowCons.accept((IDimMember)m);
                    }
                }
            }));
            areaEntry.getColDimEntries().forEach(col -> members.forEach(m -> {
                if (col.getDimension().getNumber().equals(m.getDimension().getNumber())) {
                    if (!colDomain.containsDimension(m.getDimension())) {
                        IDimension newOne = m.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(m.getDimension()).addMember(m);
                    if (colCons != null) {
                        colCons.accept((IDimMember)m);
                    }
                }
            }));
        }
    }

    public void rebuildRowAndColDimMember() {
        boolean isDynamic = false;
        int dynaDirect = -1;
        for (PositionInfo p : this.spread.getAreaManager().getPostionInfoSet()) {
            IDimension newOne;
            ArrayList<Object> markmembers;
            List members;
            AreaRangeEntry area = this.getAreaByStratpoint(p.getStartPosition());
            int[] dataxy = ExcelUtils.pos2XY((String)p.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)p.getAreaRange().split(":")[1]);
            int startCol = dataxy[0];
            HashMap<Integer, ArrayList<Object>> fixMemberPosition = new HashMap<Integer, ArrayList<Object>>();
            isDynamic = !p.getBasePoints().isEmpty();
            dynaDirect = isDynamic ? ((BasePointInfo)p.getBasePoints().get(0)).getDirect() : -1;
            int FixMemberPosition = -1;
            RowDimDomain rowDomain = new RowDimDomain();
            ArrayList<DimensionMemberInfo> rows = new ArrayList<DimensionMemberInfo>();
            for (int r = dataxy[1]; r <= endxy[1]; ++r) {
                members = this.getEffectiveSheet().getCell(r, startCol).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList(members);
                markmembers = new ArrayList<IDimMember>();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("row", m.getDimension().getNumber(), area)) continue;
                    if (!rowDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        rowDomain.addDimension(newOne);
                    }
                    rowDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    rows.add(new DimensionMemberInfo(r, startCol, markmembers));
                }
                if (!isDynamic || dynaDirect != 1) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            ColumnDimDomain colDomain = new ColumnDimDomain();
            ArrayList<DimensionMemberInfo> cols = new ArrayList<DimensionMemberInfo>();
            int startRow = dataxy[1];
            FixMemberPosition = -1;
            for (int c = dataxy[0]; c <= endxy[0]; ++c) {
                members = this.getEffectiveSheet().getCell(startRow, c).getMemberFromUserObject();
                ++FixMemberPosition;
                if (members == null || members.isEmpty()) continue;
                members = new ArrayList(members);
                markmembers = new ArrayList();
                for (IDimMember m : members) {
                    if (!this.checkColAndRow("col", m.getDimension().getNumber(), area)) continue;
                    if (!colDomain.containsDimension(m.getDimension())) {
                        newOne = m.getDimension().copy();
                        colDomain.addDimension(newOne);
                    }
                    colDomain.getDimension(m.getDimension()).addMember(m);
                    markmembers.add(m);
                }
                if (!markmembers.isEmpty()) {
                    cols.add(new DimensionMemberInfo(startRow, c, markmembers));
                }
                if (!isDynamic || dynaDirect != 2) continue;
                fixMemberPosition.put(FixMemberPosition, markmembers);
            }
            this.posMap.put(p, (Tuple<List<DimensionMemberInfo>, List<DimensionMemberInfo>>)Tuple.newOne(rows, cols));
            this.spread.getAreaManager().addArea(p, rowDomain, colDomain);
            p.getBasePoints().forEach(bp -> bp.setFixMemberPosition(fixMemberPosition));
        }
    }

    private AreaRangeEntry getAreaByStratpoint(String sp) {
        for (AreaRangeEntry ar : this.template.getAreaRangeEntries()) {
            if (!ar.getStartPosition().equals(sp)) continue;
            return ar;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u533a\u57df", (String)"FreeStyleTemplateFinalBuilder_0", (String)"fi-bcm-report", (Object[])new Object[0]));
    }

    private boolean checkColAndRow(String type, String dim, AreaRangeEntry area) {
        if (this.template.getTemplateType() != null && this.template.getTemplateType().intValue() == TemplateTypeEnum.MSN.getType() && "col".equals(type)) {
            List aa = area.getColDimEntriesExt();
            ColDimensionEntryExt firstEntry = (ColDimensionEntryExt)aa.get(0);
            for (Pair pair : firstEntry.getDimMembers()) {
                if (!dim.equals(((Dimension)pair.p1).getNumber())) continue;
                return true;
            }
        } else {
            List aa = "col".equals(type) ? area.getColDimEntries() : area.getRowDimEntries();
            for (int i = 0; i < aa.size(); ++i) {
                MembSettingBaseDetail mb = (MembSettingBaseDetail)aa.get(i);
                if (!dim.equals(mb.getDimension().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    static class DimensionMemberInfo {
        private int r;
        private int c;
        private List<IDimMember> members;

        DimensionMemberInfo(int r, int c, List<IDimMember> members) {
            this.r = r;
            this.c = c;
            this.members = members;
        }
    }
}

