/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.IReportDataRefleshService;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.dao.MDDataHandleService;

public class ReportDataRefleshService
implements IReportDataRefleshService {
    @Override
    public boolean reflesh(SpreadManager sm, String cubecatalog, IRelaMembSupplier<String, String> orgSupplier, IRelaMembSupplier<String, String> periodSupplier) {
        ReportSpecialVariableUtil.dealSpecialPeriodOrFyForSm(sm, periodSupplier, null);
        Map<String, Map<String, Object>> cellSets = MDDataHandleService.query(sm, null, cubecatalog, orgSupplier, periodSupplier);
        MDDataHandleService.updateCellValues(sm, null, cellSets, orgSupplier);
        return true;
    }

    public boolean refleshByPosition(SpreadManager sm, PositionInfo pos, RangeModel rangeModel, String cubecatalog, IRelaMembSupplier<String, String> orgSupplier, IRelaMembSupplier<String, String> periodSupplier) {
        ReportSpecialVariableUtil.dealSpecialPeriodOrFyForSm(sm, periodSupplier, pos);
        Map<String, Map<String, Object>> cellSets = MDDataHandleService.query(sm, pos, cubecatalog, orgSupplier, periodSupplier);
        MDDataHandleService.updateCellValues(sm, rangeModel, cellSets, orgSupplier);
        return true;
    }

    public List<Map<String, Object>> getStyleCells(SpreadManager sm, String cubecatalog, IRelaMembSupplier<String, String> orgSupplier, IRelaMembSupplier<String, String> periodSupplier) {
        sm.getBook().getSheet(0).getUserObject().put("issource", true);
        ReportSpecialVariableUtil.dealSpecialPeriodOrFyForSm(sm, periodSupplier, null);
        Map<String, Map<String, Object>> cellSets = MDDataHandleService.query(sm, null, cubecatalog, orgSupplier, periodSupplier);
        Table<Integer, Integer, Object> cells = MDDataHandleService.updateCellValues(sm, null, cellSets, orgSupplier, true);
        sm.getBook().getSheet(0).getUserObject().remove("issource");
        if (!cells.isEmpty()) {
            Map<String, List<Pair<Integer, Integer>>> valuemaps = ReportDataRefleshService.analyCells(cells);
            ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(valuemaps.size());
            for (Map.Entry<String, List<Pair<Integer, Integer>>> valuemap : valuemaps.entrySet()) {
                HashMap<String, Object> parameter = new HashMap<String, Object>(6);
                ArrayList rangedetails = new ArrayList(valuemap.getValue().size());
                valuemap.getValue().forEach(rc -> {
                    HashMap<String, Object> rangedetail = new HashMap<String, Object>(4);
                    rangedetail.put("r", rc.p1);
                    rangedetail.put("c", rc.p2);
                    rangedetail.put("rc", 1);
                    rangedetail.put("cc", 1);
                    rangedetails.add(rangedetail);
                });
                parameter.put("range", rangedetails.toArray());
                parameter.put("vi", true);
                parameter.put("text", valuemap.getKey());
                parameter.put("bc", "#5582f3");
                parameter.put("fc", "white");
                parameter.put("pos", new int[]{3});
                parameters.add(parameter);
            }
            return parameters;
        }
        return null;
    }

    private static Map<String, List<Pair<Integer, Integer>>> analyCells(Table<Integer, Integer, Object> cells) {
        HashMap<String, List<Pair<Integer, Integer>>> maps = new HashMap<String, List<Pair<Integer, Integer>>>();
        cells.cellSet().forEach(c -> {
            Object value = c.getValue();
            String text = OlapSourceEnum.getNumber((Object)value);
            maps.computeIfAbsent(text, k -> new ArrayList()).add(Pair.onePair((Object)c.getRowKey(), (Object)c.getColumnKey()));
        });
        return maps;
    }
}

