/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder;

import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.builder.AbstractBuilder;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.SpanInfo;

public class ViewTemplateBuilder
extends AbstractBuilder {
    public ViewTemplateBuilder(Sheet sheet, FilterView filter, RowDimDomain rowDimDoman, ColumnDimDomain _colDimDomain) {
        super(sheet, filter, rowDimDoman, _colDimDomain);
    }

    @Override
    public void buildStruct() {
        this.buildTable();
    }

    private void buildTable() {
        this._rowDimDomain.extendStructure();
        this._colDimDomain.extendStructure();
        if (!this.IsOkByCheckCondition()) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ViewTemplateBuilder_0", (String)"fi-bcm-report", (Object[])new Object[0]));
        }
        int maxRows = this._rowDimDomain.getSpanInfo().getRowcount() + this._colDimDomain.getSpanInfo().getRowcount();
        int maxColumns = this._rowDimDomain.getSpanInfo().getColcount() + this._colDimDomain.getSpanInfo().getColcount();
        this._sheet.addRows(maxRows);
        this._sheet.addColumns(maxColumns);
        this.buildRowDimDomain();
        this.buildColDimDomain();
        this.buildDataDomain();
    }

    private void buildRowDimDomain() {
        Cell cell;
        SpanInfo spanInfo;
        int titleSpanRowCount = this._colDimDomain.getSpanInfo().getRowcount();
        int colCount = this._rowDimDomain.getSpanInfo().getColcount();
        for (int i = 0; i < colCount; ++i) {
            spanInfo = null;
            if (titleSpanRowCount > 1) {
                spanInfo = new SpanInfo();
                spanInfo.setRowcount(titleSpanRowCount);
                spanInfo.setColcount(1);
            }
            for (int k = 0; k < titleSpanRowCount; ++k) {
                cell = this._sheet.getCell(k, i);
                if (spanInfo != null) {
                    cell.setSpanInfo(spanInfo);
                }
                cell.setValue((Object)this._rowDimDomain.getDimension(i).getName());
            }
        }
        int rowCount = this._rowDimDomain.getSpanInfo().getRowcount();
        int divCount = 1;
        for (int c = 0; c < colCount; ++c) {
            int members = this._rowDimDomain.getDimension(c).getMembers().size();
            int spanRows = rowCount / (divCount *= this._rowDimDomain.getDimension(c).getMembers().size());
            int startRow = titleSpanRowCount;
            int times = rowCount / (members * spanRows);
            for (int time = 0; time < times; ++time) {
                for (int k = 0; k < members; ++k) {
                    spanInfo = null;
                    if (spanRows > 1) {
                        spanInfo = new SpanInfo();
                        spanInfo.setRowcount(spanRows);
                        spanInfo.setColcount(1);
                    }
                    int end = startRow + spanRows;
                    for (int r = startRow; r < end; ++r) {
                        cell = this._sheet.getCell(r, c);
                        cell.setValue((Object)((IDimMember)this._rowDimDomain.getDimension(c).getMembers().get(k)).getName());
                        cell.addDim2UserObject((IDimMember)this._rowDimDomain.getDimension(c).getMembers().get(k));
                        if (spanInfo == null) continue;
                        cell.setSpanInfo(spanInfo);
                    }
                    startRow = end;
                }
            }
        }
    }

    private void buildColDimDomain() {
        int rowCount = this._colDimDomain.getSpanInfo().getRowcount();
        int colCount = this._colDimDomain.getSpanInfo().getColcount();
        int divCount = 1;
        for (int r = 0; r < rowCount; ++r) {
            int members = this._colDimDomain.getDimension(r).getMembers().size();
            int spanCol = colCount / (divCount *= this._colDimDomain.getDimension(r).getMembers().size());
            int times = colCount / (members * spanCol);
            int startCol = this._rowDimDomain.getSpanInfo().getColcount();
            for (int time = 0; time < times; ++time) {
                for (int k = 0; k < members; ++k) {
                    SpanInfo spanInfo = null;
                    if (spanCol > 1) {
                        spanInfo = new SpanInfo();
                        spanInfo.setRowcount(1);
                        spanInfo.setColcount(spanCol);
                    }
                    int end = startCol + spanCol;
                    for (int c = startCol; c < end; ++c) {
                        Cell cell = this._sheet.getCell(r, c);
                        cell.setValue((Object)((IDimMember)this._colDimDomain.getDimension(r).getMembers().get(k)).getName());
                        cell.addDim2UserObject((IDimMember)this._colDimDomain.getDimension(r).getMembers().get(k));
                        if (spanInfo == null) continue;
                        cell.setSpanInfo(spanInfo);
                    }
                    startCol = end;
                }
            }
        }
    }

    private void buildDataDomain() {
        int drStart = this._colDimDomain.getSpanInfo().getRowcount();
        int drEnd = this._rowDimDomain.getSpanInfo().getRowcount() + drStart;
        int dcStart = this._rowDimDomain.getSpanInfo().getColcount();
        int dcEnd = this._colDimDomain.getSpanInfo().getColcount() + dcStart;
        int rcStart = 0;
        int rcEnd = this._rowDimDomain.getSpanInfo().getColcount() + rcStart;
        int crStart = 0;
        int crEnd = this._colDimDomain.getSpanInfo().getRowcount() + crStart;
        for (int dr = drStart; dr < drEnd; ++dr) {
            for (int dc = dcStart; dc < dcEnd; ++dc) {
                Cell cell = this._sheet.getCell(dr, dc);
                for (int rc = rcStart; rc < rcEnd; ++rc) {
                    cell.copyDimMember2UserObject(this._sheet.getCell(dr, rc));
                }
                for (int cr = crStart; cr < crEnd; ++cr) {
                    cell.copyDimMember2UserObject(this._sheet.getCell(cr, dc));
                }
                cell.setMdDataDomain(true);
            }
        }
    }

    private boolean IsOkByCheckCondition() {
        SpanInfo span = this._rowDimDomain.getSpanInfo();
        if (span.getRowcount() <= 0 || span.getColcount() <= 0) {
            return false;
        }
        span = this._colDimDomain.getSpanInfo();
        return span.getRowcount() > 0 && span.getColcount() > 0;
    }
}

