/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model.dao;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.business.paramsetting.ParamSettingServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.ExtDataUtil;
import kd.fi.bcm.business.extdata.model.ExtendsModel;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EDRow;
import kd.fi.bcm.business.extdata.sql.EDSaveComInfo;
import kd.fi.bcm.business.extdata.sql.EDSortInfo;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.extdata.sql.exception.EDSaveException;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.cache.VersionParam;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.ProcessUtils;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.DataSetUtil;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.report.ExtMergeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.spread.datacollect.EDFormulaUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;

public class ExtDataHandleService {
    private Map<String, String> message = new HashMap<String, String>(16);
    private List<String> mergeMessage = new ArrayList<String>(16);
    private Map<String, List<Long>> oriPos2DelRows = new HashMap<String, List<Long>>(16);
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ExtDataHandleService.class);
    private Set<String> lockAreas = new HashSet<String>(16);
    private Table<String, String, Map<String, Integer>> dataModel2OriPosUniques = HashBasedTable.create();
    public static final String DATAMODEL2DATASETCACHEID = "datamodel2datasetcacheid";
    public static final String ORIGINRANGE2CURSORS = "originRange2Cursors";
    public static final String SELECTORIGINRANGE = "selectoriginRange";
    public static final String FIRSTOPEN = "firstopen";
    public static final String NONESELPOS = "noneselpos";
    public static final int pageSize = 1000;
    private static final String CONFIG_NUM = "config_num";
    public static final String ONCEUSE = "onceuse";

    public static Map<PositionInfo, EDResultSet> queryExtData(SpreadManager sm, String cube, IRelaMembSupplier<String, String> orgSupplier) {
        List<DataModelDataSetInfo> dataSetInfos = ExtDataHandleService.queryExtDataByDataSet(false, sm, cube, (OrgRelaMembSupplier)orgSupplier, false, ExtDataHandleService.getPageSizeSetting(MemberReader.findModelIdByNum((String)cube)));
        HashMap<PositionInfo, EDResultSet> pos2EDResult = new HashMap<PositionInfo, EDResultSet>(16);
        for (DataModelDataSetInfo dataSetInfo : dataSetInfos) {
            pos2EDResult.put(dataSetInfo.positionInfo, dataSetInfo.edResultSet);
        }
        return pos2EDResult;
    }

    public static Map<PositionInfo, EDResultSet> transDataSetInfo2PResult(List<DataModelDataSetInfo> dataSetInfos) {
        HashMap<PositionInfo, EDResultSet> pos2EDResult = new HashMap<PositionInfo, EDResultSet>(16);
        for (DataModelDataSetInfo dataSetInfo : dataSetInfos) {
            pos2EDResult.put(dataSetInfo.positionInfo, dataSetInfo.edResultSet);
        }
        return pos2EDResult;
    }

    public static Map<String, String> transDataSetInfo2DataModelNumCacheId(List<DataModelDataSetInfo> dataSetInfos) {
        HashMap<String, String> originRange2CacheId = new HashMap<String, String>(16);
        for (DataModelDataSetInfo dataSetInfo : dataSetInfos) {
            originRange2CacheId.put(dataSetInfo.positionInfo.getOriginalAreaRange(), dataSetInfo.cacheId);
        }
        return originRange2CacheId;
    }

    public static Map<String, Integer> transDataSetInfo2OriginRange2Cursors(List<DataModelDataSetInfo> dataSetInfos) {
        HashMap<String, Integer> originRange2Cursors = new HashMap<String, Integer>(16);
        for (DataModelDataSetInfo dataSetInfo : dataSetInfos) {
            originRange2Cursors.put(dataSetInfo.positionInfo.getOriginalAreaRange(), dataSetInfo.cursor);
        }
        return originRange2Cursors;
    }

    public static List<DataModelDataSetInfo> queryExtDataByDataSet(boolean isOnlyRead, SpreadManager sm, String cube, OrgRelaMembSupplier orgSupplier, boolean isSplitPage, int bizPageSize) {
        return ExtDataHandleService.queryExtDataByDataSet(isOnlyRead, sm, cube, orgSupplier, isSplitPage, null, bizPageSize, true);
    }

    public static Integer getPageSizeSetting(long modelId) {
        Map jsonMap = (Map)ThreadCache.get((Object)(ConfigEnum.CM047.getNumber() + modelId), () -> {
            JSONObject map = ParamSettingServiceHelper.getJSON((long)modelId, (String)ConfigEnum.CM047.getNumber());
            if (map == null) {
                HashMap<String, Integer> defalutmap = new HashMap<String, Integer>();
                defalutmap.put(CONFIG_NUM, 1000);
                return defalutmap;
            }
            return map;
        });
        return jsonMap.getOrDefault(CONFIG_NUM, 1000);
    }

    public static List<DataModelDataSetInfo> queryExtDataByDataSet(boolean isOnlyRead, SpreadManager sm, String cube, OrgRelaMembSupplier orgSupplier, boolean isSplitPage, ExtMergeEnum extmerge, int bizPageSize, boolean isNeedFilterRange) {
        boolean forOrgSave = extmerge != null;
        Map pos2EDResultCacheId = (Map)ThreadCache.get((Object)DATAMODEL2DATASETCACHEID, () -> new HashMap(16));
        Map originRange2Cursors = (Map)ThreadCache.get((Object)ORIGINRANGE2CURSORS, () -> new HashMap(16));
        String sel_oriRange = (String)ThreadCache.get((Object)SELECTORIGINRANGE, () -> NONESELPOS);
        ArrayList<DataModelDataSetInfo> dataSetInfos = new ArrayList<DataModelDataSetInfo>(16);
        Map sumdata = null;
        HashMap<String, BigDecimal> sumvalues = new HashMap<String, BigDecimal>();
        EDFormulaUtil.checkSumFormula((SpreadManager)sm);
        if (sm.getBook().getSheet(0).getUserObject(EDFormulaUtil.SUMDATA) != null) {
            sumdata = (Map)sm.getBook().getSheet(0).getUserObject(EDFormulaUtil.SUMDATA);
        }
        for (Map.Entry entry : sm.getAreaManager()) {
            EdQueryComInfo edQueryComInfo;
            PositionInfo posInfo;
            block20: {
                ExtendInfo extendInfo;
                boolean canSave;
                posInfo = (PositionInfo)entry.getKey();
                if (forOrgSave && !(canSave = ExtDataHandleService.checkMergeOrgSave(orgSupplier, posInfo)) || (extendInfo = posInfo.getExtendInfo()) == null || !NONESELPOS.equals(sel_oriRange) && !posInfo.getOriginalAreaRange().equals(sel_oriRange)) continue;
                edQueryComInfo = new EdQueryComInfo(cube, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
                edQueryComInfo.setDataUseInQuery(sm.isSheetOnlyRead());
                edQueryComInfo.setUseForOrgSave(forOrgSave);
                ExtDataHandleService.buildQueryFilter((Domain)sm.getFilter().getPageDomain(), edQueryComInfo);
                ExtDataHandleService.buildQueryFilter((Domain)sm.getFilter().getViewPointDomain(), edQueryComInfo);
                String oriBpNum = "";
                String oriCurNum = "";
                for (Map.Entry dimFilter : edQueryComInfo.getDimFilter().entrySet()) {
                    if (((String)dimFilter.getKey()).equals(DimTypesEnum.PROCESS.getNumber())) {
                        oriBpNum = ((String[])dimFilter.getValue())[0];
                        continue;
                    }
                    if (!((String)dimFilter.getKey()).equals(DimTypesEnum.CURRENCY.getNumber())) continue;
                    oriCurNum = ((String[])dimFilter.getValue())[0];
                }
                if (isNeedFilterRange) {
                    Map.Entry dimFilter;
                    dimFilter = extendInfo.getFloatdims().iterator();
                    while (dimFilter.hasNext()) {
                        FloatDimInfo floatdim = (FloatDimInfo)dimFilter.next();
                        ArrayList numbers = new ArrayList();
                        if (floatdim.isFixMember() && floatdim.getMember() != null) {
                            edQueryComInfo.addDimFilter(floatdim.getMember().getDimension().getNumber(), new String[]{floatdim.getMember().getNumber()});
                            continue;
                        }
                        if (floatdim.getDynaMembScopes().isEmpty()) continue;
                        String sceneNum = ((String[])edQueryComInfo.getDimFilter().get(DimTypesEnum.SCENARIO.getNumber()))[0];
                        String yearNum = ((String[])edQueryComInfo.getDimFilter().get(DimTypesEnum.YEAR.getNumber()))[0];
                        String periodNum = ((String[])edQueryComInfo.getDimFilter().get(DimTypesEnum.PERIOD.getNumber()))[0];
                        long sceneId = MemberReader.findScenaMemberByNum((String)edQueryComInfo.getModelNum(), (String)sceneNum).getId();
                        long yearId = MemberReader.findFyMemberByNum((String)edQueryComInfo.getModelNum(), (String)yearNum).getId();
                        long periodId = MemberReader.findPeriodMemberByNum((String)edQueryComInfo.getModelNum(), (String)periodNum).getId();
                        VersionParam verParam = new VersionParam(edQueryComInfo.getModelId().longValue(), sceneId, yearId, periodId);
                        for (DynaMembScopeInfo scope : floatdim.getDynaMembScopes()) {
                            if (scope.getMember() == null) continue;
                            IDNumberTreeNode membNode = MemberReader.findMemberById((long)edQueryComInfo.getModelId(), (String)scope.getMember().getDimension().getUqCode(), (Long)scope.getMember().getId());
                            String longnumber = membNode.getLongNumber();
                            MembRangeItem item = new MembRangeItem(scope.getMember().getDimension().getUqCode(), Long.valueOf(scope.getMember().getId()), longnumber, scope.getMember().getNumber(), scope.getRangeId(), scope.isCustom(), (Object)edQueryComInfo.getModelId());
                            ArrayList finalNumbers = numbers;
                            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(scope.getMember().getDimension().getNumber())) {
                                item.matchItem4Ic(verParam, c -> finalNumbers.add(c.getNumber()));
                                continue;
                            }
                            item.matchItems(c -> finalNumbers.add(c.getNumber()));
                        }
                        edQueryComInfo.addDimFilter(floatdim.getDimension().getNumber(), numbers.toArray(new String[0]));
                    }
                }
                OrgRelaMembSupplier orgRelaMembSupplier = orgSupplier;
                String realCurNum = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)orgRelaMembSupplier.get_modelId().longValue(), (long)orgRelaMembSupplier.get_mainOrgId().longValue(), (String)oriBpNum, (String)oriCurNum, (long)0L, (long)0L).p2;
                IDNumberTreeNode treeNode = MemberReader.findMemberById((long)orgRelaMembSupplier.get_modelId(), (String)"bcm_entitymembertree", (Long)orgRelaMembSupplier.get_mainOrgId());
                String parentOrgNum = "";
                if (treeNode.getParent() != null) {
                    parentOrgNum = treeNode.getParent().getNumber();
                }
                edQueryComInfo.setParentOrg(parentOrgNum);
                edQueryComInfo.setNeedSum(isOnlyRead);
                for (Map.Entry dimFilter : edQueryComInfo.getDimFilter().entrySet()) {
                    if (((String)dimFilter.getKey()).equals(DimTypesEnum.PROCESS.getNumber()) || !((String)dimFilter.getKey()).equals(DimTypesEnum.CURRENCY.getNumber())) continue;
                    ((String[])dimFilter.getValue())[0] = realCurNum;
                }
                ArrayList floatDimNums = Lists.newArrayList((Iterable)extendInfo.getFloatDimNums());
                if (!forOrgSave && extendInfo.isShowDataSourceOrg()) {
                    floatDimNums.add(DimTypesEnum.ENTITY.getNumber());
                }
                if (ExtMergeEnum.KEEPENTITY == extmerge) {
                    floatDimNums.add(DimTypesEnum.ENTITY.getNumber());
                }
                edQueryComInfo.setDimselects(floatDimNums.toArray(new String[0]));
                List<String> extcols = extendInfo.getCols().stream().filter(c -> !floatDimNums.contains(c)).collect(Collectors.toList());
                edQueryComInfo.setExtselects(extcols.toArray(new String[0]));
                if (sumdata != null) {
                    Set scs = EDFormulaUtil.getSumColByModel((Map)sumdata, (String)edQueryComInfo.getDatamodel());
                    edQueryComInfo.setSumcols(scs);
                }
                if (isSplitPage) {
                    try {
                        String cacheId = (String)pos2EDResultCacheId.get(posInfo.getOriginalAreaRange());
                        if (cacheId != null) {
                            int startIndex = (Integer)originRange2Cursors.get(posInfo.getOriginalAreaRange());
                            edQueryComInfo.setTransDate(true);
                            EDResultSet edResultSet = ExtDataServiceHelper.fillRows((List)DataSetUtil.getData((String)cacheId, (int)startIndex, (int)bizPageSize), (EdQueryComInfo)edQueryComInfo);
                            DataModelDataSetInfo dataSetInfo = new DataModelDataSetInfo(extendInfo.getExtModelNumber(), cacheId, posInfo, edResultSet, startIndex + edResultSet.getFetchSize());
                            dataSetInfos.add(dataSetInfo);
                            break block20;
                        }
                        ThreadCache.put((Object)FIRSTOPEN, (Object)"1");
                        Pair<String, EDResultSet> edResultSet = ExtDataHandleService.queryData(edQueryComInfo, extendInfo, 0, bizPageSize, orgSupplier);
                        DataModelDataSetInfo dataSetInfo = new DataModelDataSetInfo(extendInfo.getExtModelNumber(), (String)edResultSet.p1, posInfo, (EDResultSet)edResultSet.p2, bizPageSize);
                        dataSetInfos.add(dataSetInfo);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                } else {
                    Pair<String, EDResultSet> edResultSet = ExtDataHandleService.queryData(edQueryComInfo, extendInfo, 0, -1, orgSupplier);
                    DataModelDataSetInfo dataSetInfo = new DataModelDataSetInfo(extendInfo.getExtModelNumber(), (String)edResultSet.p1, posInfo, (EDResultSet)edResultSet.p2, -1);
                    dataSetInfos.add(dataSetInfo);
                    DataSetUtil.close((String)((String)edResultSet.p1));
                }
            }
            HashMap<String, BigDecimal> sumValue = EDFormulaUtil.getSumValue((EdQueryComInfo)edQueryComInfo);
            if (!sumValue.isEmpty()) {
                HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(16);
                sumValue.forEach((k, v) -> result.put(k + "|" + posInfo.getAreaRange(), (BigDecimal)v));
                sumValue = result;
            }
            sumvalues.putAll(sumValue);
        }
        EDFormulaUtil.fixSumValueToSm((SpreadManager)sm, (Map)sumdata, sumvalues);
        return dataSetInfos;
    }

    public static Pair<String, EDResultSet> queryData(EdQueryComInfo comInfo, ExtendInfo extendInfo, int startIndex, int bizPageSize, OrgRelaMembSupplier orgSupplier) {
        EDResultSet result;
        if (extendInfo != null) {
            EDSortInfo esi = new EDSortInfo();
            esi.setSortInfos(extendInfo.getSortInfos());
            esi.setTopField(extendInfo.getTopField());
            esi.setTopCount(extendInfo.getTopCount());
            if (orgSupplier != null) {
                QFBuilder qfBuilder = new QFBuilder("id", "=", (Object)orgSupplier.get_mainOrgId());
                DynamicObject entityObj = QueryServiceHelper.queryOne((String)"bcm_entitymembertree", (String)"cslscheme", (QFilter[])qfBuilder.toArray());
                esi.setCslschemeId(entityObj.getLong("cslscheme"));
            }
            HashMap<String, PositionInfo.FloatMemDisplayPattern> st = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(extendInfo.getFloatdims().size());
            for (FloatDimInfo fd : extendInfo.getFloatdims()) {
                st.put(fd.getDimension().getNumber(), fd.getFloatMemDisplayPattern());
            }
            esi.setShowType(st);
            comInfo.setSortInfo(esi);
            comInfo.setShowWholeRowZero(extendInfo.isShowWholeRowZero());
            comInfo.setFilterZeroFields(extendInfo.getZeroNotShowCols());
            if (!extendInfo.isShowWholeRowZero() && orgSupplier != null && !comInfo.isDataUseInQuery()) {
                IDNumberTreeNode orgNode = MemberReader.findMemberById((long)comInfo.getModelId(), (String)"bcm_entitymembertree", (Long)orgSupplier.get_mainOrgId());
                boolean isMerge = !orgNode.isLeaf() && comInfo.getGroupObject().getBoolean("isparticipmerge");
                comInfo.setShowWholeRowZero(!isMerge);
            }
        }
        if (orgSupplier != null) {
            comInfo.setMainOrgId(orgSupplier.get_mainOrgId().longValue());
        }
        DataSet ds = ExtDataServiceHelper.queryDataset((EdQueryComInfo)comInfo);
        String cache = DataSetUtil.cacheDataSet((DataSet)ds);
        comInfo.setTransDate(true);
        if (bizPageSize > 0) {
            result = ExtDataServiceHelper.fillRows((List)DataSetUtil.getData((String)cache, (int)startIndex, (int)bizPageSize), (EdQueryComInfo)comInfo);
            Pair pair = Pair.onePair((Object)cache, (Object)result);
            return pair;
        }
        result = ExtDataServiceHelper.fillRows((List)DataSetUtil.getAllData((String)cache), (EdQueryComInfo)comInfo);
        Pair pair = Pair.onePair((Object)cache, (Object)result);
        return pair;
    }

    public static Integer getHasDataRowMaxCount(SpreadManager sm, PositionInfo pos) {
        RangeModel rangeModel = new RangeModel(pos.getAreaRange());
        int y_start = rangeModel.getY_start();
        int y_end = rangeModel.getY_end();
        int x_start = rangeModel.getX_start();
        int x_end = rangeModel.getX_end();
        Sheet sheet = sm.getBook().getSheet(0);
        int lastHasVauleIndex = -1;
        for (int cur_Index = y_end; cur_Index >= y_start; --cur_Index) {
            for (Cell cell : sheet.getRow(cur_Index)) {
                if (cell.getCol() < x_start || cell.getCol() > x_end || cell.getValue() == null) continue;
                lastHasVauleIndex = cur_Index;
                break;
            }
            if (lastHasVauleIndex != -1) break;
        }
        return lastHasVauleIndex < 0 ? 0 : lastHasVauleIndex - y_start + 1;
    }

    private static void buildQueryFilter(Domain domain, EdQueryComInfo edQueryComInfo) {
        HashSet<String> memberSets = new HashSet<String>(16);
        for (IDimension d : domain.getDimensions()) {
            memberSets.clear();
            if (!ExtDataUtil.fixDims.contains(d.getNumber())) continue;
            for (IDimMember m : d.getMembers()) {
                if (m == null) continue;
                memberSets.add(m.getNumber());
            }
            if (memberSets.isEmpty()) continue;
            if (edQueryComInfo.isUseForOrgSave()) {
                ExtDataHandleService.addFilterForOrgSave(edQueryComInfo, d.getNumber(), memberSets.toArray(new String[0]));
                continue;
            }
            edQueryComInfo.addDimFilter(d.getNumber(), memberSets.toArray(new String[0]));
        }
    }

    private static Map<String, String> buildSaveFilter(Domain domain, EDSaveComInfo edSaveComInfo) {
        LinkedHashMap<String, String> mddDim = new LinkedHashMap<String, String>(16);
        for (IDimension d : domain.getDimensions()) {
            for (IDimMember m : d.getMembers()) {
                if (ExtDataUtil.fixDims.contains(m.getDimension().getNumber())) {
                    edSaveComInfo.addfixedDimension(d.getNumber(), m.getNumber());
                    continue;
                }
                mddDim.put(d.getNumber(), m.getNumber());
            }
        }
        return mddDim;
    }

    public Map<PositionInfo, EDResultSet> saveExtData(SpreadManager sm, String showNumber, IRelaMembSupplier<String, String> orgSupplier, Map<String, String> dataModelNum2CacheId) {
        HashMap<PositionInfo, EDResultSet> pos2EDResult = new HashMap<PositionInfo, EDResultSet>(16);
        Map disableExtModels = ExtDataUtil.getAllDisableEXTModel((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
        this.dataModel2OriPosUniques.clear();
        for (Map.Entry entry : sm.getAreaManager()) {
            long[] ids;
            PositionInfo posInfo = (PositionInfo)entry.getKey();
            ExtendInfo extendInfo = posInfo.getExtendInfo();
            if (this.getLockAreas().contains(posInfo.getOriginalAreaRange()) || extendInfo == null) continue;
            if (disableExtModels.containsKey(extendInfo.getExtModelNumber())) {
                this.message.put(posInfo.getAreaRange(), extendInfo.getExtModelNumber());
                continue;
            }
            EDSaveComInfo edSaveComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            Pair<Set<Long>, List<Integer>> del_newRows = this.buildSaveInfo(sm, (OrgRelaMembSupplier)orgSupplier, edSaveComInfo, posInfo, dataModelNum2CacheId);
            if (del_newRows == null) continue;
            EDSaveComInfo edclearComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            edclearComInfo.setFixDim(edSaveComInfo.getfixedDimension());
            edclearComInfo.setParentOrg(edSaveComInfo.getParentOrg());
            edclearComInfo.setDims(edSaveComInfo.getDims());
            edclearComInfo.setCols(edSaveComInfo.getCols());
            try (TXHandle th = TX.requiresNew();){
                try {
                    ExtDataServiceHelper.deleteDataBySaveInfo((Collection)((Collection)del_newRows.p1), (EDSaveComInfo)edclearComInfo);
                    ids = ExtDataServiceHelper.saveData((EDSaveComInfo)edSaveComInfo);
                }
                catch (Exception e) {
                    th.markRollback();
                    throw new EDSaveException((Throwable)e, new ErrorCode("", String.join((CharSequence)"\n", ThrowableHelper.generatekernelMessage((Throwable)e, (int)2))), new Object[0]);
                }
            }
            Sheet sheet = sm.getBook().getSheet(0);
            RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
            int startColIndex = rangeModel.getX_start();
            int endColIndex = rangeModel.getX_end();
            Integer entityIndex = sm.getExtEntityHeadCol(posInfo);
            if (entityIndex != -1 && !((Set)del_newRows.p1).isEmpty()) {
                for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
                    Cell cell = sheet.getCell(i, entityIndex.intValue());
                    if (!((Set)del_newRows.p1).contains(cell.getEXTROWPKID())) continue;
                    cell.setValue(null);
                    for (int j = rangeModel.getX_start(); j <= rangeModel.getX_end(); ++j) {
                        cell = sheet.getCell(i, j);
                        cell.removeUserObject("extrowpkid");
                    }
                }
            }
            if (ids == null || ids.length <= 0) continue;
            PositionInfo.FloatMemDisplayPattern orgisplayEnum = extendInfo.getOrgDisplayPattern();
            for (int i = 0; i < ((List)del_newRows.p2).size(); ++i) {
                for (Cell cell : sheet.getRow(((Integer)((List)del_newRows.p2).get(i)).intValue())) {
                    if (entityIndex.intValue() == cell.getCol()) {
                        IDNumberTreeNode org = MemberReader.findMemberById((String)edSaveComInfo.getModelNum(), (String)"bcm_entitymembertree", (Long)((OrgRelaMembSupplier)orgSupplier).get_mainOrgId());
                        DimMember member = new DimMember(org.getName(), org.getNumber(), null, (IDimension)new Dimension("", org.getDimNumber(), null));
                        if (cell.getMemberFromUserObject() != null) {
                            cell.getMemberFromUserObject().clear();
                        }
                        cell.addDim2UserObject((IDimMember)member);
                        cell.setValue((Object)cell.displayDimMsg(orgisplayEnum.getIndex()));
                    }
                    if (startColIndex > cell.getCol() || endColIndex < cell.getCol()) continue;
                    cell.getUserObject().put((Object)"extrowpkid", (Object)ids[i]);
                    cell.getUserObject().put((Object)"extrowSpkid", (Object)"1");
                }
            }
        }
        return pos2EDResult;
    }

    public static void saveExtDatasForExcelClient(String showNumber, IRelaMembSupplier<String, String> orgSupplier, PositionInfo posInfo, EDSaveComInfo edSaveComInfo, List<String> sourceOrgs, List<String> headSeqExtCols, List<Long> delIds) {
        Map disableExtModels = ExtDataUtil.getAllDisableEXTModel((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
        ExtendInfo extendInfo = posInfo.getExtendInfo();
        if (extendInfo != null) {
            if (disableExtModels.containsKey(extendInfo.getExtModelNumber())) {
                return;
            }
            ExtDataHandleService.correctFilter((OrgRelaMembSupplier)orgSupplier, edSaveComInfo);
            ExtDataHandleService service = new ExtDataHandleService();
            service.checkExtDataByExtModel(null, edSaveComInfo, posInfo, sourceOrgs, null, (Pair<Set<Long>, List<Integer>>)Pair.onePair(new HashSet(4), new ArrayList(4)));
            ExtDataHandleService.autoDataAgg(edSaveComInfo, posInfo, headSeqExtCols);
            List<Long> del_pkIds = delIds;
            del_pkIds.add(0L);
            Map updateRows = edSaveComInfo.getUpdateValues();
            for (Map.Entry valueRow : updateRows.entrySet()) {
                boolean isEffectiveRow = false;
                for (Object o : (Object[])valueRow.getValue()) {
                    if (o == null) continue;
                    isEffectiveRow = true;
                }
                if (isEffectiveRow) continue;
                del_pkIds.add((Long)valueRow.getKey());
            }
            EDSaveComInfo edclearComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            edclearComInfo.setFixDim(edSaveComInfo.getfixedDimension());
            edclearComInfo.setParentOrg(edSaveComInfo.getParentOrg());
            edclearComInfo.setDims(edSaveComInfo.getDims());
            edclearComInfo.setCols(edSaveComInfo.getCols());
            boolean canSave = ExtDataHandleService.checkMergeOrgSave((OrgRelaMembSupplier)orgSupplier, posInfo);
            if (!canSave) {
                return;
            }
            TXHandle th = TX.requiresNew();
            Object object = null;
            try {
                try {
                    ExtDataServiceHelper.deleteDataBySaveInfo(del_pkIds, (EDSaveComInfo)edclearComInfo);
                    ExtDataServiceHelper.saveData((EDSaveComInfo)edSaveComInfo);
                }
                catch (Exception e) {
                    th.markRollback();
                    throw new EDSaveException((Throwable)e, new ErrorCode("", "Extend Data Error."), new Object[0]);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (th != null) {
                    if (object != null) {
                        try {
                            th.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        th.close();
                    }
                }
            }
        }
    }

    public void clearExtData(SpreadManager sm, String showNumber, IRelaMembSupplier<String, String> orgSupplier) {
        Map disableExtModels = ExtDataUtil.getAllDisableEXTModel((long)((OrgRelaMembSupplier)orgSupplier).get_modelId());
        for (Map.Entry entry : sm.getAreaManager()) {
            PositionInfo posInfo = (PositionInfo)entry.getKey();
            ExtendInfo extendInfo = posInfo.getExtendInfo();
            if (extendInfo == null) continue;
            if (disableExtModels.containsKey(extendInfo.getExtModelNumber())) {
                this.message.put(posInfo.getAreaRange(), extendInfo.getExtModelNumber());
                continue;
            }
            EDSaveComInfo edclearComInfo = new EDSaveComInfo(showNumber, extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            Map<String, String> mddPVDim = ExtDataHandleService.buildSaveFilter((Domain)sm.getFilter().getPageDomain(), edclearComInfo);
            mddPVDim.putAll(ExtDataHandleService.buildSaveFilter((Domain)sm.getFilter().getViewPointDomain(), edclearComInfo));
            ExtDataHandleService.correctFilter((OrgRelaMembSupplier)orgSupplier, edclearComInfo);
            TXHandle th = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    ExtDataServiceHelper.deleteDataBySaveInfo((EDSaveComInfo)edclearComInfo);
                }
                catch (Exception e) {
                    th.markRollback();
                    throw new EDSaveException((Throwable)e, new ErrorCode("", "Extend Data Error."), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (th == null) continue;
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                th.close();
            }
        }
    }

    public static boolean checkMergeOrgSave(OrgRelaMembSupplier orgSupplier, PositionInfo posInfo) {
        if (posInfo.getExtendInfo() == null) {
            return false;
        }
        OrgRelaMembSupplier orgRelaMembSupplier = orgSupplier;
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)orgRelaMembSupplier.get_modelId(), (String)"bcm_entitymembertree", (Long)orgRelaMembSupplier.get_mainOrgId());
        boolean isLeaf = treeNode.isLeaf();
        String extGroup = posInfo.getExtendInfo().getExtGroup();
        QFilter modelQF = new QFilter("model.id", "=", (Object)orgRelaMembSupplier.get_modelId());
        QFilter numQF = new QFilter("number", "=", (Object)extGroup);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_structofextend", (String)"isparticipmerge", (QFilter[])new QFilter[]{modelQF, numQF});
        return isLeaf || !dy.getBoolean("isparticipmerge");
    }

    private Pair<Set<Long>, List<Integer>> buildSaveInfo(SpreadManager sm, OrgRelaMembSupplier orgSupplier, EDSaveComInfo edSaveComInfo, PositionInfo posInfo, Map<String, String> dataModelNum2CacheId) {
        Map<String, String> mddPVDim = ExtDataHandleService.buildSaveFilter((Domain)sm.getFilter().getPageDomain(), edSaveComInfo);
        mddPVDim.putAll(ExtDataHandleService.buildSaveFilter((Domain)sm.getFilter().getViewPointDomain(), edSaveComInfo));
        ExtDataHandleService.correctFilter(orgSupplier, edSaveComInfo);
        if (ExtDataServiceHelper.checkDataLocked((EDSaveComInfo)edSaveComInfo)) {
            return null;
        }
        ArrayList pvMddDims = new ArrayList(16);
        List mddColDims = posInfo.getExtendInfo().getFloatdims().stream().map(f -> f.getDimension().getNumber()).collect(Collectors.toList());
        List extCols = posInfo.getExtendInfo().getCols().stream().filter(c -> !mddColDims.contains(c)).collect(Collectors.toList());
        int startRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[0]);
        int startColIndex = ExcelUtils.pos2X((String)posInfo.getAreaRange().split(":")[0]);
        int endRowIndex = ExcelUtils.pos2Y((String)posInfo.getAreaRange().split(":")[1]);
        int endColIndex = ExcelUtils.pos2X((String)posInfo.getAreaRange().split(":")[1]);
        int headerRow = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
        ArrayList<String> headSeqMddCols = new ArrayList<String>(16);
        ArrayList<String> headSeqExtCols = new ArrayList<String>(16);
        ArrayList<Integer> headMddColIndexs = new ArrayList<Integer>(16);
        ArrayList<Integer> headExtColIndexs = new ArrayList<Integer>(16);
        HashMap<Integer, String> headExtColIndexs2col = new HashMap<Integer, String>(16);
        HashMap<String, String> mddDdim2FixMembers = new HashMap<String, String>(16);
        Map multiF7ValueByExtMems = ExtDataUtil.getMultiF7ValueByExtMems(extCols, (long)edSaveComInfo.getModelId());
        for (FloatDimInfo floatdim : posInfo.getExtendInfo().getFloatdims()) {
            if (!floatdim.isFixMember()) continue;
            mddDdim2FixMembers.put(floatdim.getDimension().getNumber(), floatdim.getMember().getNumber());
        }
        int sourceOrgIndex = -1;
        RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
        Sheet sheet = sm.getBook().getSheet(0);
        for (Cell cell : sheet.getRow(headerRow)) {
            if (cell.getCol() < rangeModel.getX_start() || cell.getCol() > rangeModel.getX_end() || cell.getEXTColNumber().isEmpty()) continue;
            if (mddColDims.contains(cell.getEXTColNumber())) {
                headSeqMddCols.add(cell.getEXTColNumber());
                headMddColIndexs.add(cell.getCol());
                continue;
            }
            if (extCols.contains(cell.getEXTColNumber())) {
                headSeqExtCols.add(cell.getEXTColNumber());
                headExtColIndexs.add(cell.getCol());
                headExtColIndexs2col.put(cell.getCol(), cell.getEXTColNumber());
                continue;
            }
            if (!"Entity".equals(cell.getEXTColNumber())) continue;
            sourceOrgIndex = cell.getCol();
        }
        edSaveComInfo.setCols(headSeqExtCols.toArray(new String[0]));
        headSeqMddCols.addAll(pvMddDims);
        edSaveComInfo.setDims(headSeqMddCols.toArray(new String[0]));
        int mddDimSize = headMddColIndexs.size() + pvMddDims.size();
        ArrayList<String> sourceOrgs = new ArrayList<String>(16);
        HashSet<Long> del_pkIds = new HashSet<Long>(16);
        ArrayList<Integer> newRows = new ArrayList<Integer>(16);
        ArrayList<Object[]> sheetExtRows = new ArrayList<Object[]>(16);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            boolean isEffectiveRow;
            long pkId;
            String[] dimValueRow;
            Object[] valueRow;
            block21: {
                valueRow = new Object[headExtColIndexs.size()];
                dimValueRow = new String[mddDimSize];
                int extV = 0;
                int mddV = 0;
                pkId = 0L;
                List row = sheet.getRow(i, true);
                for (Object[] cell : row) {
                    int col = cell.getCol();
                    if (col < startColIndex || col > endColIndex) continue;
                    if (headExtColIndexs.contains(col)) {
                        Object v = multiF7ValueByExtMems.containsKey(headExtColIndexs2col.get(col)) ? (cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty() ? cell.getValue() : ((IDimMember)cell.getMemberFromUserObject().get(0)).getNumber()) : cell.getValue();
                        valueRow[extV] = v;
                        ++extV;
                    } else if (headMddColIndexs.contains(col)) {
                        String string = dimValueRow[mddV] = cell.getMemberFromUserObject() == null || cell.getMemberFromUserObject().isEmpty() ? "" : ((IDimMember)cell.getMemberFromUserObject().get(0)).getNumber();
                        if (mddDdim2FixMembers.containsKey(headSeqMddCols.get(headMddColIndexs.indexOf(col)))) {
                            String fixMemNum;
                            dimValueRow[mddV] = fixMemNum = (String)mddDdim2FixMembers.get(headSeqMddCols.get(headMddColIndexs.indexOf(col)));
                        }
                        ++mddV;
                    } else if (sourceOrgIndex == col) {
                        sourceOrgs.add(cell.getMemberFromUserObject() == null ? (String)edSaveComInfo.getfixedDimension().get(DimTypesEnum.ENTITY.getNumber()) : ((IDimMember)cell.getMemberFromUserObject().get(0)).getNumber());
                    }
                    if (pkId != 0L) continue;
                    Object object = cell.getUserObject("extrowpkid");
                    pkId = object != null ? (object instanceof Long ? (Long)object : (long)((Integer)object).intValue()) : 0L;
                }
                isEffectiveRow = false;
                for (Object o : valueRow) {
                    if (o == null) continue;
                    isEffectiveRow = true;
                    break;
                }
                try {
                    if (isEffectiveRow) break block21;
                    int index = 0;
                    for (String o : dimValueRow) {
                        String headDim = (String)headSeqMddCols.get(index);
                        ++index;
                        if (mddDdim2FixMembers.containsKey(headDim) || !StringUtils.isNotEmpty((String)o) || mddDdim2FixMembers.containsKey(o)) continue;
                        isEffectiveRow = true;
                        break;
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            if (isEffectiveRow) {
                Object[] extRow = edSaveComInfo.getRowValue(valueRow, dimValueRow);
                sheetExtRows.add(extRow);
            }
            if (!sheet.getChangedRows().contains(i)) continue;
            if (isEffectiveRow) {
                if (pkId == 0L) {
                    newRows.add(i);
                    edSaveComInfo.addValue(valueRow, dimValueRow);
                    continue;
                }
                edSaveComInfo.putUpdateValues(pkId, valueRow, dimValueRow);
                continue;
            }
            if (pkId == 0L) continue;
            del_pkIds.add(pkId);
        }
        if (this.oriPos2DelRows.get(posInfo.getOriginalAreaRange()) != null) {
            del_pkIds.addAll((Collection)this.oriPos2DelRows.get(posInfo.getOriginalAreaRange()));
        }
        Pair del_AddRows = Pair.onePair(del_pkIds, newRows);
        this.checkExtDataByExtModel(sheetExtRows, edSaveComInfo, posInfo, sourceOrgs, dataModelNum2CacheId, (Pair<Set<Long>, List<Integer>>)del_AddRows);
        ExtDataHandleService.autoDataAgg(edSaveComInfo, posInfo, headSeqExtCols);
        return del_AddRows;
    }

    private void checkAllExtdataByExtModel(EDSaveComInfo edSaveComInfo, PositionInfo posInfo, List<String> notNumUniques, Map<String, String> dataModelNum2CacheId, Pair<Set<Long>, List<Integer>> del_AddRows) {
        if (dataModelNum2CacheId == null) {
            return;
        }
        String cacheId = dataModelNum2CacheId.get(posInfo.getOriginalAreaRange());
        if (cacheId == null) {
            return;
        }
        ExtendInfo extendInfo = posInfo.getExtendInfo();
        if (extendInfo != null) {
            EdQueryComInfo edQueryComInfo = new EdQueryComInfo(edSaveComInfo.getShowNumber(), extendInfo.getExtGroup(), extendInfo.getExtModelNumber());
            for (Map.Entry entry : edSaveComInfo.getfixedDimension().entrySet()) {
                edQueryComInfo.addDimFilter((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
            for (FloatDimInfo floatdim : extendInfo.getFloatdims()) {
                ArrayList numbers = new ArrayList();
                if (floatdim.isFixMember() && floatdim.getMember() != null) {
                    edQueryComInfo.addDimFilter(floatdim.getMember().getDimension().getNumber(), new String[]{floatdim.getMember().getNumber()});
                    continue;
                }
                for (DynaMembScopeInfo scope : floatdim.getDynaMembScopes()) {
                    if (scope.isCustom()) {
                        numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scope.getMember().getDimension().getUqCode(), (Long)scope.getMember().getId(), (String)scope.getMember().getNumber(), (int)scope.getRangeId(), (String)String.valueOf(edQueryComInfo.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                        continue;
                    }
                    if (scope.getMember() == null) continue;
                    numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scope.getMember().getDimension().getUqCode(), (Long)scope.getMember().getId(), (String)scope.getMember().getNumber(), (int)scope.getRangeId(), (String)String.valueOf(edQueryComInfo.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                }
                edQueryComInfo.addDimFilter(floatdim.getDimension().getNumber(), numbers.toArray(new String[0]));
            }
            edQueryComInfo.setParentOrg(edSaveComInfo.getParentOrg());
            ArrayList arrayList = Lists.newArrayList((Iterable)extendInfo.getFloatDimNums());
            if (extendInfo.isShowDataSourceOrg()) {
                arrayList.add(DimTypesEnum.ENTITY.getNumber());
            }
            edQueryComInfo.setDimselects(arrayList.toArray(new String[0]));
            List<String> extcols = extendInfo.getCols().stream().filter(c -> !floatDimNums.contains(c)).collect(Collectors.toList());
            edQueryComInfo.setExtselects(extcols.toArray(new String[0]));
            if (cacheId != null) {
                edQueryComInfo.setTransDate(true);
                EDResultSet edResultSet = ExtDataServiceHelper.fillRows((List)DataSetUtil.getAllData((String)cacheId), (EdQueryComInfo)edQueryComInfo);
                List<EDRow> rows = ExtDataHandleService.getRows(edResultSet);
                Set updatePkIDs = edSaveComInfo.getUpdateValues().keySet();
                Map<String, Integer> key2Rows = this.getExtModelPosKey2Rows(extendInfo.getExtModelNumber(), posInfo.getOriginalAreaRange());
                int sheetLoadRowSize = key2Rows.size() - ((List)del_AddRows.p2).size();
                int cursor = 0;
                for (EDRow row : rows) {
                    if (++cursor <= sheetLoadRowSize + ((Set)del_AddRows.p1).size() || updatePkIDs.contains(row.getPkId())) continue;
                    StringBuilder sb = new StringBuilder();
                    if (notNumUniques.size() <= 0) continue;
                    for (String unique : notNumUniques) {
                        Object value = row.getOriginalValue(unique);
                        if (value instanceof Integer && EDSaveComInfo.dateError == (Integer)value || value instanceof Number && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                            sb.append("null").append("|");
                            continue;
                        }
                        sb.append(value).append("|");
                    }
                    String key = sb.toString();
                    if (key2Rows.containsKey(key)) {
                        int rowIndex = key2Rows.get(key);
                        if (rowIndex == -1) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u6570\u636e\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u8bf7\u5c55\u5f00\u5168\u90e8\u6570\u636e\u68c0\u67e5\u540e\u518d\u4fdd\u5b58\u3002", (String)"ExtDataHandleService_05", (String)"fi-bcm-report", (Object[])new Object[0]));
                        }
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u552f\u4e00\u6027\u6821\u9a8c\uff0cLine:%s \u6570\u636e\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"ExtDataHandleService_04", (String)"fi-bcm-report", (Object[])new Object[0]), rowIndex));
                    }
                    key2Rows.put(key, -1);
                }
            }
        }
    }

    private void checkExtDataByExtModel(List<Object[]> sheetExtRows, EDSaveComInfo edSaveComInfo, PositionInfo posInfo, List<String> sourceOrgs, Map<String, String> dataModelNum2CacheId, Pair<Set<Long>, List<Integer>> del_AddRows) {
        String extModelNum = posInfo.getExtendInfo().getExtModelNumber();
        QFilter extModelFileter = new QFilter("number", "=", (Object)extModelNum);
        extModelFileter.and(new QFilter("model", "=", (Object)edSaveComInfo.getModelId()));
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bcm_extendsmodel", (String)"id,name", (QFilter[])new QFilter[]{extModelFileter});
        String extModelName = dy.getString("name");
        ExtendsModel extModel = new ExtendsModel(Long.valueOf(dy.getLong("id")));
        List fieldList = extModel.getFieldEntry();
        ArrayList cols = Lists.newArrayList();
        ArrayList dims = Lists.newArrayList();
        cols.addAll(Lists.newArrayList((Object[])edSaveComInfo.getCols()));
        dims.addAll(Lists.newArrayList((Object[])edSaveComInfo.getDims()));
        fieldList.removeIf(f -> !cols.contains(f.getNumber()) && !dims.contains(f.getNumber()));
        cols.addAll(Lists.newArrayList((Object[])edSaveComInfo.getDims()));
        Map<String, String> num2Names = fieldList.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v.getName()));
        List inputList = fieldList.stream().filter(f -> f.getIsNecessary()).map(f -> f.getNumber()).collect(Collectors.toList());
        List uniqueList = fieldList.stream().filter(f -> f.getUniqueCheck()).map(f -> f.getNumber()).collect(Collectors.toList());
        ArrayList<String> notNumUniques = new ArrayList<String>(16);
        notNumUniques.addAll(uniqueList);
        Map<String, Integer> key2Rows = this.getExtModelKey2Rows(posInfo.getExtendInfo().getExtModelNumber());
        int rowIndex = 0;
        for (Object[] row : sheetExtRows != null ? sheetExtRows : edSaveComInfo.getAllValues()) {
            ++rowIndex;
            StringBuilder sb = new StringBuilder();
            if (notNumUniques.size() > 0) {
                for (String unique : notNumUniques) {
                    if (cols.indexOf(unique) < 0) continue;
                    Object value = row[cols.indexOf(unique)];
                    if (value instanceof Integer && EDSaveComInfo.dateError == (Integer)value || value instanceof Number && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0) {
                        sb.append("null").append("|");
                        continue;
                    }
                    sb.append(value).append("|");
                }
                String key = sb.toString();
                RangeModel rangeModel = new RangeModel(posInfo.getAreaRange());
                int y_index = rangeModel.getY_start() + rowIndex;
                if (key2Rows.containsKey(key)) {
                    if (key2Rows.get(key) == -1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u6570\u636e\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u8bf7\u5c55\u5f00\u5168\u90e8\u6570\u636e\u68c0\u67e5\u540e\u518d\u4fdd\u5b58\u3002", (String)"ExtDataHandleService_05", (String)"fi-bcm-report", (Object[])new Object[0]));
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u552f\u4e00\u6027\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u518d\u4fdd\u5b58\uff1aLine:%1$s\u4e0eLine:%2$s\u91cd\u590d\u3002", (String)"ExtDataHandleService_03", (String)"fi-bcm-report", (Object[])new Object[0]), key2Rows.get(key), y_index));
                }
                key2Rows.put(key, y_index);
            }
            ArrayList<String> mustInput = new ArrayList<String>(16);
            for (String input : inputList) {
                if (cols.indexOf(input) < 0) continue;
                if (row[cols.indexOf(input)] == null || StringUtils.isEmpty((String)row[cols.indexOf(input)].toString())) {
                    mustInput.add(input + "|" + num2Names.get(input));
                }
                if (mustInput.isEmpty()) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6570\u636e\u533a\u57df\u6240\u5c5e\u7684\u62d3\u5c55\u6570\u636e\u6a21\u578b%1$s\u8bbe\u7f6e\u4e86%2$s\u4e3a\u5fc5\u5f55\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"ExtDataHandleService_02", (String)"fi-bcm-report", (Object[])new Object[0]), posInfo.getExtendInfo().getExtModelNumber() + "|" + extModelName, String.join((CharSequence)"\u3001", mustInput)));
            }
        }
        this.dataModel2OriPosUniques.put((Object)posInfo.getExtendInfo().getExtModelNumber(), (Object)posInfo.getOriginalAreaRange(), key2Rows);
        this.checkAllExtdataByExtModel(edSaveComInfo, posInfo, notNumUniques, dataModelNum2CacheId, del_AddRows);
    }

    private Map<String, Integer> getExtModelKey2Rows(String dataModelNum) {
        Map rows = this.dataModel2OriPosUniques.row((Object)dataModelNum);
        HashMap<String, Integer> key2Rows = new HashMap<String, Integer>(16);
        if (rows != null) {
            for (Map.Entry entry : rows.entrySet()) {
                key2Rows.putAll((Map)entry.getValue());
            }
        }
        return key2Rows;
    }

    private Map<String, Integer> getExtModelPosKey2Rows(String dataModelNum, String oriPosRange) {
        Map rows = this.dataModel2OriPosUniques.row((Object)dataModelNum);
        Map<String, Integer> key2Rows = new HashMap<String, Integer>(16);
        if (rows != null && rows.get(oriPosRange) != null) {
            key2Rows = (Map)rows.get(oriPosRange);
        }
        return key2Rows;
    }

    private static void autoDataAgg(EDSaveComInfo edSaveComInfo, PositionInfo posInfo, List<String> headSeqExtCols) {
        if (!posInfo.getExtendInfo().isRepAutoAgg()) {
            return;
        }
        Map fieldMaps = edSaveComInfo.getFieldMappedForCols(posInfo.getExtendInfo().getCols().toArray(new String[0]));
        ArrayList<Integer> numCols = new ArrayList<Integer>(16);
        ArrayListMultimap key2Rows = ArrayListMultimap.create();
        for (Map.Entry fieldMap : fieldMaps.entrySet()) {
            if (fieldMap.getValue() == null || !((String)fieldMap.getValue()).startsWith("num")) continue;
            numCols.add(headSeqExtCols.indexOf(fieldMap.getKey()));
        }
        for (Object[] row : edSaveComInfo.getValue()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < row.length; ++i) {
                if (numCols.contains(i)) continue;
                sb.append(row[i] == null ? "" : row[i].toString());
            }
            key2Rows.put((Object)sb.toString(), (Object)row);
        }
        edSaveComInfo.getValue().clear();
        for (String key : key2Rows.keySet()) {
            List group = key2Rows.get((Object)key);
            if (group.size() > 1) {
                for (Integer numCol : numCols) {
                    BigDecimal aggNum = BigDecimal.ZERO;
                    for (Object[] row : group) {
                        if (row[numCol] == null) continue;
                        aggNum = aggNum.add((BigDecimal)row[numCol]);
                    }
                    ((Object[])group.get((int)0))[numCol.intValue()] = aggNum;
                }
                continue;
            }
            edSaveComInfo.getValue().add(group.get(0));
        }
    }

    private static void showNumSum(EDSaveComInfo edSaveComInfo, PositionInfo posInfo, List<String> headSeqExtCols) {
        if (!posInfo.getExtendInfo().isNumShowSum()) {
            return;
        }
        Map fieldMaps = edSaveComInfo.getFieldMappedForCols(posInfo.getExtendInfo().getCols().toArray(new String[0]));
        ArrayList<Integer> numCols = new ArrayList<Integer>(16);
        ArrayListMultimap key2Rows = ArrayListMultimap.create();
        for (Map.Entry fieldMap : fieldMaps.entrySet()) {
            if (fieldMap.getValue() == null || !((String)fieldMap.getValue()).startsWith("num")) continue;
            numCols.add(headSeqExtCols.indexOf(fieldMap.getKey()));
        }
        Object[] sumRow = new Object[((Object[])edSaveComInfo.getValue().get(0)).length];
        for (Integer numCol : numCols) {
            BigDecimal aggNum = BigDecimal.ZERO;
            for (Object[] row : edSaveComInfo.getValue()) {
                if (row[numCol] == null) continue;
                aggNum = aggNum.add((BigDecimal)row[numCol]);
            }
            sumRow[numCol.intValue()] = aggNum;
        }
        edSaveComInfo.getValue().add(sumRow);
    }

    public static void correctFilter(OrgRelaMembSupplier orgSupplier, EDSaveComInfo edSaveComInfo) {
        String oriBpNum = "";
        String oriCurNum = "";
        for (Map.Entry dimFilter : edSaveComInfo.getfixedDimension().entrySet()) {
            if (((String)dimFilter.getKey()).equals(DimTypesEnum.PROCESS.getNumber())) {
                oriBpNum = (String)dimFilter.getValue();
                continue;
            }
            if (!((String)dimFilter.getKey()).equals(DimTypesEnum.CURRENCY.getNumber())) continue;
            oriCurNum = (String)dimFilter.getValue();
        }
        OrgRelaMembSupplier orgRelaMembSupplier = orgSupplier;
        String realCurNum = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)orgRelaMembSupplier.get_modelId().longValue(), (long)orgRelaMembSupplier.get_mainOrgId().longValue(), (String)oriBpNum, (String)oriCurNum, (long)0L, (long)0L).p2;
        String realBpNum = ProcessUtils.getRealProcess((String)oriBpNum);
        IDNumberTreeNode treeNode = MemberReader.findMemberById((long)orgRelaMembSupplier.get_modelId(), (String)"bcm_entitymembertree", (Long)orgRelaMembSupplier.get_mainOrgId());
        String parentOrgNum = "";
        if (treeNode.getParent() != null) {
            parentOrgNum = treeNode.getParent().getNumber();
        }
        edSaveComInfo.setParentOrg(parentOrgNum);
        for (Map.Entry entry : edSaveComInfo.getfixedDimension().entrySet()) {
            if (((String)entry.getKey()).equals(DimTypesEnum.PROCESS.getNumber()) || !((String)entry.getKey()).equals(DimTypesEnum.CURRENCY.getNumber())) continue;
            entry.setValue(realCurNum);
        }
    }

    private static List<EDRow> getRows(EDResultSet setmap) {
        ArrayList<EDRow> rows = new ArrayList<EDRow>(16);
        while (setmap.next()) {
            rows.add(setmap.getRow());
        }
        return rows;
    }

    public Map<String, String> getMessage() {
        return this.message;
    }

    public List<String> getMergeMessage() {
        return this.mergeMessage;
    }

    public Map<String, List<Long>> getOriPos2DelRows() {
        return this.oriPos2DelRows;
    }

    public void setOriPos2DelRows(Map<String, List<Long>> oriPos2DelRows) {
        this.oriPos2DelRows = oriPos2DelRows;
    }

    private static void addFilterForOrgSave(EdQueryComInfo edQueryComInfo, String col, String ... values) {
        if (DimTypesEnum.PROCESS.getNumber().equals(col)) {
            values = new String[]{"EIRpt"};
        }
        if (DimTypesEnum.AUDITTRIAL.getNumber().equals(col)) {
            values = new String[]{"EntityInput"};
        }
        edQueryComInfo.addDimFilter(col, values);
    }

    public Set<String> getLockAreas() {
        return this.lockAreas;
    }

    public void putLockAreas(Set<String> lockAreas) {
        this.lockAreas.addAll(lockAreas);
    }

    public static class DataModelDataSetInfo {
        public String dataModelNumber;
        public String cacheId;
        public Integer cursor;
        public PositionInfo positionInfo;
        public EDResultSet edResultSet;

        public DataModelDataSetInfo(String dataModelNumber, String cacheId, PositionInfo positionInfo, EDResultSet edResultSet, Integer cursor) {
            this.dataModelNumber = dataModelNumber;
            this.cacheId = cacheId;
            this.positionInfo = positionInfo;
            this.edResultSet = edResultSet;
            this.cursor = cursor;
        }
    }
}

