/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model.dao;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.olap.OrgRelaMembSupplier;
import kd.fi.bcm.business.olap.verify.VerifyResult;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.serviceHelper.dc.DCQueryHelper;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.util.AssoStorageMemUtil;
import kd.fi.bcm.business.util.ProcessUtils;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.OrgRelaProcessMembPool;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.OlapSourceEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.OlapCommandUtil;
import kd.fi.bcm.common.util.PeriodUtils;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.spread.common.SheetConstant;
import kd.fi.bcm.spread.common.util.ReportSpecialVariableUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;
import kd.fi.bcm.spread.util.FillDataUtils;
import kd.fi.bcm.spread.util.SpreadMemberUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class MDDataHandleService {
    public static final String SAVEOLAPENUMKEY = "mdsave.ose";
    private static final Log log = LogFactory.getLog(MDDataHandleService.class);
    public static final Map<String, String> processMap = new HashMap<String, String>(16);
    public static final List<String> ct_process = new ArrayList<String>(16);

    private static int getCurrencyIndex(String[] dimKey) {
        for (int i = 0; i < dimKey.length; ++i) {
            if (!StringUtil.equals((String)SysDimensionEnum.Currency.getNumber(), (String)dimKey[i])) continue;
            return i;
        }
        return 10000;
    }

    private static Set<Tuple<String[], Object>> filterByPeriod(long modelId, Tuple<String, String> entityTuple, SaveCommandInfo info, Set<Tuple<String[], Object>> kvSets) {
        if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012")) {
            return kvSets;
        }
        QFBuilder qfBuilder = new QFBuilder();
        String qfilter = "name,number";
        qfBuilder.add(new QFilter("id", "=", (Object)modelId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)qfilter, (QFilter[])qfBuilder.toArray());
        String modelNum = dynamicObject.getString("number");
        String entity = (String)entityTuple.v;
        String scene = null;
        String year = null;
        String period = null;
        List fixedDimensions = info.getFixedDimensions();
        for (FixedDimension dimension : fixedDimensions) {
            if (PresetConstant.SCENE_DIM.equals(dimension.getName())) {
                scene = dimension.getValue();
            }
            if (PresetConstant.FY_DIM.equals(dimension.getName())) {
                year = dimension.getValue();
            }
            if (!PresetConstant.PERIOD_DIM.equals(dimension.getName())) continue;
            period = dimension.getValue();
        }
        List dimensions = info.getDimensions();
        ArrayList<Tuple<String[], Object>> isCloseList = new ArrayList<Tuple<String[], Object>>(10);
        HashSet<Tuple<String[], Object>> saveSet = new HashSet<Tuple<String[], Object>>(1);
        for (Tuple<String[], Object> t : kvSets) {
            for (int i = 0; i < dimensions.size(); ++i) {
                String dim = (String)dimensions.get(i);
                if (PresetConstant.SCENE_DIM.equals(dim)) {
                    scene = ((String[])t.k)[i];
                }
                if (PresetConstant.FY_DIM.equals(dim)) {
                    year = ((String[])t.k)[i];
                }
                if (!PresetConstant.PERIOD_DIM.equals(dim)) continue;
                period = ((String[])t.k)[i];
            }
            IDNumberTreeNode sceneMemberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.SCENE_DIM, (String)scene);
            IDNumberTreeNode yearMemberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.FY_DIM, (String)year);
            IDNumberTreeNode periodMemberByNumber = MemberReader.findMemberByNumber((String)modelNum, (String)PresetConstant.PERIOD_DIM, (String)period);
            boolean isOpen = PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)entity, (long)sceneMemberByNumber.getId(), (long)yearMemberByNumber.getId(), (long)periodMemberByNumber.getId(), (String)"datastatus");
            if (isOpen) continue;
            isCloseList.add(t);
        }
        if (isCloseList.size() > 0) {
            for (Tuple<String[], Object> kv : kvSets) {
                if (isCloseList.contains(kv)) continue;
                saveSet.add(kv);
            }
        } else {
            return kvSets;
        }
        return saveSet;
    }

    public static VerifyResult save(SpreadManager sm, String cubecatalog, IRelaMembSupplier<String, String> s, IRelaMembSupplier<String, String> c) {
        return MDDataHandleService.save(sm, cubecatalog, s, c, true);
    }

    public static VerifyResult save(SpreadManager sm, String cubecatalog, IRelaMembSupplier<String, String> s, IRelaMembSupplier<String, String> c, IRelaMembSupplier<String, String> periodSupplier) {
        ReportSpecialVariableUtil.dealSpecialPeriodOrFyForSm(sm, periodSupplier, null);
        return MDDataHandleService.save(sm, cubecatalog, s, c, true);
    }

    /*
     * WARNING - void declaration
     */
    public static VerifyResult save(SpreadManager sm, String cubecatalog, IRelaMembSupplier<String, String> s, IRelaMembSupplier<String, String> c, boolean needClearDynaDelVals) {
        boolean isCWP;
        if (sm.getAreaManager().getPositionSize() <= 0) {
            return null;
        }
        ViewPointDimDomain viewPointDomain = sm.getFilter().getViewPointDomain();
        PageDimDomain pageDomain = sm.getFilter().getPageDomain();
        boolean isRemoveCurr = MDDataHandleService.isRemoveCurr((Domain)viewPointDomain, (Domain)pageDomain);
        boolean isRemoveEntity = MDDataHandleService.isRemoveEntity((Domain)viewPointDomain, (Domain)pageDomain);
        boolean isRemoveProcess = MDDataHandleService.isRemoveProcess((Domain)viewPointDomain, (Domain)pageDomain);
        boolean isViewEntity = MDDataHandleService.isViewDim((Domain)viewPointDomain, (Domain)pageDomain, "Entity");
        List<Tuple<String, String>> viewTuples = MDDataHandleService.genTuples((Domain)sm.getFilter().getViewPointDomain());
        List<Tuple<String, String>> pageTuples = MDDataHandleService.genTuples((Domain)sm.getFilter().getPageDomain());
        boolean isMoveMC = MDDataHandleService.moveMC2RCFromPV(cubecatalog, viewTuples, pageTuples);
        long modelId = MemberReader.findModelIdByNum((String)cubecatalog);
        boolean isExceptionOrg = false;
        boolean cm043 = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM043");
        Object orgnum = ThreadCache.get((Object)"orgnum");
        if (cm043 && !(isCWP = MDDataHandleService.isCWP(viewTuples, pageTuples))) {
            Set exceptOrgs = MemberPermHelper.getExceptOrgs((Long)modelId, (String)"CM043");
            isExceptionOrg = exceptOrgs.contains(orgnum);
        }
        boolean canRedict = cm043 && !isExceptionOrg;
        HashMultimap<PositionInfo, Tuple<String[], Object>> kvMaps = MDDataHandleService.genCellSetParams(sm, cubecatalog, canRedict);
        SaveCommandInfo info = new SaveCommandInfo();
        if (sm.getFilter().isHasReactFixMember()) {
            ArrayList<Tuple<String, String>> redirectViewTuples = new ArrayList<Tuple<String, String>>(16);
            Table<String, String, String> assoMembs = MDDataHandleService.getAssoMembs(cubecatalog);
            for (Tuple<String, String> tuple : viewTuples) {
                if (canRedict || ((String)tuple.k).equals(DimTypesEnum.MYCOMPANY.getNumber())) {
                    redirectViewTuples.add((Tuple<String, String>)Tuple.newOne((Object)tuple.k, (Object)(assoMembs.contains(tuple.k, tuple.v) ? (String)assoMembs.get(tuple.k, tuple.v) : (String)tuple.v)));
                    continue;
                }
                redirectViewTuples.add((Tuple<String, String>)Tuple.newOne((Object)tuple.k, (Object)tuple.v));
            }
            viewTuples = redirectViewTuples;
            ArrayList<Tuple<String, String>> redirectPageTuples = new ArrayList<Tuple<String, String>>(16);
            for (Tuple<String, String> tuple : pageTuples) {
                if (canRedict || ((String)tuple.k).equals(DimTypesEnum.MYCOMPANY.getNumber())) {
                    redirectPageTuples.add((Tuple<String, String>)Tuple.newOne((Object)tuple.k, (Object)(assoMembs.contains(tuple.k, tuple.v) ? (String)assoMembs.get(tuple.k, tuple.v) : (String)tuple.v)));
                    continue;
                }
                redirectPageTuples.add((Tuple<String, String>)Tuple.newOne((Object)tuple.k, (Object)tuple.v));
            }
            pageTuples = redirectPageTuples;
        }
        Tuple<String, String> pv_currencyTuple = MDDataHandleService.getTupleDim(viewTuples, pageTuples, DimTypesEnum.CURRENCY.getNumber());
        Tuple<String, String> pv_entityTuple = MDDataHandleService.getTupleDim(viewTuples, pageTuples, DimTypesEnum.ENTITY.getNumber());
        Tuple<String, String> pv_processTuple = MDDataHandleService.getTupleDim(viewTuples, pageTuples, DimTypesEnum.PROCESS.getNumber());
        Object var28_26 = null;
        Object var29_30 = null;
        Tuple<String, String> processTuple = null;
        if (isRemoveCurr) {
            Tuple<String, String> tuple = MDDataHandleService.rejectDim(viewTuples, pageTuples, "Currency");
        }
        if (isRemoveEntity) {
            Tuple<String, String> tuple = MDDataHandleService.rejectDim(viewTuples, pageTuples, "Entity");
        }
        if (isRemoveProcess) {
            processTuple = MDDataHandleService.rejectDim(viewTuples, pageTuples, "Process");
        }
        MDDataHandleService.addFiexdDimension(info, viewTuples);
        MDDataHandleService.addFiexdDimension(info, pageTuples);
        List itFixe = info.getFixedDimensions();
        int index = -1;
        for (int i = 0; i < itFixe.size(); ++i) {
            FixedDimension fixe = (FixedDimension)itFixe.get(i);
            if (!"Currency".equals(fixe.getName())) continue;
            String currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((String)cubecatalog, (long)((OrgRelaMembSupplier)s).get_mainOrgId().longValue(), (String)SpreadMemberUtil.getDimNumberBySm((SpreadManager)sm, (DimTypesEnum)DimTypesEnum.PROCESS), (String)SpreadMemberUtil.getDimNumberBySm((SpreadManager)sm, (DimTypesEnum)DimTypesEnum.CURRENCY), (long)0L, (long)0L).p2;
            if (StringUtils.isBlank((CharSequence)currencyNumber)) {
                throw new RuntimeException("real Currency dimension is null");
            }
            info.addfixedDimension(new String[]{fixe.getName(), currencyNumber});
            index = i;
            break;
        }
        if (index != -1) {
            info.getFixedDimensions().remove(index);
        }
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        if (ThreadCache.exists((Object)SAVEOLAPENUMKEY)) {
            OlapCommandUtil.addSourceMeasure((String)cubecatalog, (CommandInfo)info, (OlapSourceEnum)((OlapSourceEnum)ThreadCache.get((Object)SAVEOLAPENUMKEY)));
        } else {
            OlapCommandUtil.addSourceMeasure((String)cubecatalog, (CommandInfo)info, (OlapSourceEnum)OlapSourceEnum.M1);
        }
        VerifyResult vr = new VerifyResult();
        for (Map.Entry entry : sm.getAreaManager()) {
            void var29_32;
            void var28_28;
            Tuple tuple = (Tuple)entry.getValue();
            List<Tuple<String, String>> rowTuples = MDDataHandleService.genTuples((Domain)tuple.k);
            List<Tuple<String, String>> colTuples = MDDataHandleService.genTuples((Domain)tuple.v);
            if (rowTuples.isEmpty() || colTuples.isEmpty()) continue;
            List<String> dimKeySet = MDDataHandleService.genDimKeySet(rowTuples, colTuples);
            boolean isOpen = (Boolean)ThreadCache.get((Object)(cubecatalog + ConfigEnum.CM043.getNumber()), () -> ConfigServiceHelper.getBoolParam((String)cubecatalog, (String)ConfigEnum.CM043.getNumber()));
            if (isOpen && !dimKeySet.contains(DimTypesEnum.MYCOMPANY.getNumber()) && isMoveMC) {
                dimKeySet.add(DimTypesEnum.MYCOMPANY.getNumber());
            }
            ArrayList<String> originalDimKeySet = new ArrayList<String>(dimKeySet);
            if (var28_28 != null && !dimKeySet.contains(var28_28.k)) {
                dimKeySet.add((String)var28_28.k);
            }
            if (var29_32 != null && !dimKeySet.contains(var29_32.k)) {
                dimKeySet.add((String)var29_32.k);
            }
            if (processTuple != null && !dimKeySet.contains(processTuple.k)) {
                dimKeySet.add((String)processTuple.k);
            }
            int process_index = MDDataHandleService.getDimIndexOnRowColDim(originalDimKeySet, DimTypesEnum.PROCESS);
            int entity_index = MDDataHandleService.getDimIndexOnRowColDim(originalDimKeySet, DimTypesEnum.ENTITY);
            String[] dimKey = dimKeySet.toArray(new String[0]);
            int currency_index = MDDataHandleService.getCurrencyIndex(dimKey);
            info.setDimensions(dimKey);
            Set<Tuple<String[], Object>> kvSets = kvMaps.removeAll(entry.getKey());
            Set dynaDelKvSets = sm.getAreaManager().getDelDynaValsByPos((PositionInfo)entry.getKey());
            MDDataHandleService.checkMemberExit(entry, dimKeySet, dynaDelKvSets, cubecatalog);
            if ((kvSets == null || kvSets.isEmpty()) && (dynaDelKvSets == null || dynaDelKvSets.isEmpty())) continue;
            if (kvSets == null || kvSets.isEmpty()) {
                kvSets = dynaDelKvSets;
            } else if (dynaDelKvSets != null && !dynaDelKvSets.isEmpty() && kvSets != null && !kvSets.isEmpty()) {
                HashMap snapshot = new HashMap(16);
                HashMap dynaSnapshot = new HashMap(16);
                kvSets.forEach(t -> snapshot.put(Joiner.on((String)"|").join((Object[])t.k), t));
                dynaDelKvSets.forEach(t -> dynaSnapshot.put(Joiner.on((String)"|").join((Object[])t.k), t));
                dynaSnapshot.entrySet().forEach(e -> snapshot.putIfAbsent(e.getKey(), e.getValue()));
                kvSets = new HashSet(snapshot.values());
            }
            CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            cellSets.setFromQuery(false);
            if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012")) {
                kvSets = var29_32 == null ? (isViewEntity ? MDDataHandleService.filterByPeriod(modelId, pv_entityTuple, info, kvSets) : MDDataHandleService.filterByPeriod(modelId, MDDataHandleService.getTupleDim(rowTuples, colTuples, "Entity"), info, kvSets)) : MDDataHandleService.filterByPeriod(modelId, (Tuple<String, String>)var29_32, info, kvSets);
            }
            for (Tuple tuple2 : kvSets) {
                String[] dest;
                String currencyNumber;
                String[] dest2;
                String currencyNumber2;
                if (pv_currencyTuple != null) {
                    if (pv_entityTuple != null && pv_processTuple != null) {
                        cellSets.set((String[])tuple2.k, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                        continue;
                    }
                    if (pv_entityTuple == null && pv_processTuple == null) {
                        String[] dest22 = (String[])tuple2.k;
                        if (OrgRelaProcessMembPool.isRelaProcess((String)((String[])tuple2.k)[process_index])) {
                            dest22[entity_index] = (String)s.access((Object)dest22[entity_index]);
                        }
                        currencyNumber2 = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)MemberReader.findEntityMemberByNum((String)cubecatalog, (String)dest22[entity_index]).getId().longValue(), (String)((String[])tuple2.k)[process_index], (String)((String)pv_currencyTuple.v), (long)0L, (long)0L).p2;
                        dest22 = MDDataHandleService.appendCurrencyMen((String[])tuple2.k, currencyNumber2);
                        dest22[process_index] = ProcessUtils.getRealProcess((String)dest22[process_index]);
                        cellSets.set(dest22, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                        continue;
                    }
                    if (pv_entityTuple == null) {
                        String currencyNumber22;
                        dest2 = (String[])tuple2.k;
                        if (OrgRelaProcessMembPool.isRelaProcess((String)((String)pv_processTuple.v))) {
                            dest2[entity_index] = (String)s.access((Object)dest2[entity_index]);
                        }
                        if ((currencyNumber22 = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)MemberReader.findEntityMemberByNum((String)cubecatalog, (String)dest2[entity_index]).getId().longValue(), (String)((String)pv_processTuple.v), (String)((String)pv_currencyTuple.v), (long)0L, (long)0L).p2) == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u5e01\u79cd\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u5e01\u79cd\u3002", (String)"MDDataHandleService_1", (String)"fi-bcm-report", (Object[])new Object[0]));
                        }
                        dest2 = MDDataHandleService.appendCurrencyMen((String[])tuple2.k, currencyNumber22);
                        dest2 = MDDataHandleService.appendMemb(dest2, ProcessUtils.getRealProcess((String)((String)pv_processTuple.v)));
                        cellSets.set(dest2, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                        continue;
                    }
                    currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)((OrgRelaMembSupplier)s).get_mainOrgId().longValue(), (String)((String[])tuple2.k)[process_index], (String)((String)pv_currencyTuple.v), (long)0L, (long)0L).p2;
                    dest = MDDataHandleService.appendCurrencyMen((String[])tuple2.k, currencyNumber);
                    dest[process_index] = ProcessUtils.getRealProcess((String)dest[process_index]);
                    dest = OrgRelaProcessMembPool.isRelaProcess((String)((String[])tuple2.k)[process_index]) ? MDDataHandleService.appendMemb(dest, (String)s.access(pv_entityTuple.v)) : MDDataHandleService.appendMemb(dest, (String)pv_entityTuple.v);
                    cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                    continue;
                }
                if (pv_entityTuple != null && pv_processTuple != null) {
                    currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)((OrgRelaMembSupplier)s).get_mainOrgId().longValue(), (String)((String)pv_processTuple.v), (String)((String[])tuple2.k)[currency_index], (long)0L, (long)0L).p2;
                    dest = MDDataHandleService.replaceCurrencyMen((String[])tuple2.k, currency_index, currencyNumber);
                    dest = OrgRelaProcessMembPool.isRelaProcess((String)((String)pv_processTuple.v)) ? MDDataHandleService.appendMemb(dest, (String)s.access(pv_entityTuple.v)) : MDDataHandleService.appendMemb(dest, (String)pv_entityTuple.v);
                    dest = MDDataHandleService.appendMemb(dest, ProcessUtils.getRealProcess((String)((String)pv_processTuple.v)));
                    cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                    continue;
                }
                if (pv_entityTuple == null && pv_processTuple == null) {
                    dest2 = (String[])tuple2.k;
                    if (OrgRelaProcessMembPool.isRelaProcess((String)((String[])tuple2.k)[process_index])) {
                        dest2[entity_index] = (String)s.access((Object)dest2[entity_index]);
                    }
                    currencyNumber2 = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)MemberReader.findEntityMemberByNum((String)cubecatalog, (String)dest2[entity_index]).getId().longValue(), (String)((String[])tuple2.k)[process_index], (String)((String[])tuple2.k)[currency_index], (long)0L, (long)0L).p2;
                    dest2 = MDDataHandleService.replaceCurrencyMen((String[])tuple2.k, currency_index, currencyNumber2);
                    dest2[process_index] = ProcessUtils.getRealProcess((String)dest2[process_index]);
                    cellSets.set(dest2, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                    continue;
                }
                if (pv_entityTuple == null) {
                    dest2 = (String[])tuple2.k;
                    if (OrgRelaProcessMembPool.isRelaProcess((String)((String)pv_processTuple.v))) {
                        dest2[entity_index] = (String)s.access((Object)dest2[entity_index]);
                    }
                    currencyNumber2 = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)MemberReader.findEntityMemberByNum((String)cubecatalog, (String)dest2[entity_index]).getId().longValue(), (String)((String)pv_processTuple.v), (String)((String[])tuple2.k)[currency_index], (long)0L, (long)0L).p2;
                    dest2 = MDDataHandleService.replaceCurrencyMen((String[])tuple2.k, currency_index, currencyNumber2);
                    dest2 = MDDataHandleService.appendMemb(dest2, ProcessUtils.getRealProcess((String)((String)pv_processTuple.v)));
                    cellSets.set(dest2, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
                    continue;
                }
                currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)((OrgRelaMembSupplier)s).get_mainOrgId().longValue(), (String)((String[])tuple2.k)[process_index], (String)((String[])tuple2.k)[currency_index], (long)0L, (long)0L).p2;
                dest = MDDataHandleService.replaceCurrencyMen((String[])tuple2.k, currency_index, currencyNumber);
                dest[process_index] = ProcessUtils.getRealProcess((String)dest[process_index]);
                dest = OrgRelaProcessMembPool.isRelaProcess((String)((String[])tuple2.k)[process_index]) ? MDDataHandleService.appendMemb(dest, (String)s.access(pv_entityTuple.v)) : MDDataHandleService.appendMemb(dest, (String)pv_entityTuple.v);
                cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), tuple2.v);
            }
            MDDataHandleService.collectAndSaveTXTData(info, cellSets, cubecatalog);
            vr.mergeVerifyResult(OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)cubecatalog));
        }
        if (needClearDynaDelVals) {
            sm.getAreaManager().clearDynaDelVals();
        }
        return vr;
    }

    public static void collectAndSaveTXTData(SaveCommandInfo info, CellSet cellSets, String cubeNumber) {
        Long modelId = MemberReader.findModelIdByNum((String)cubeNumber);
        if (!ConfigServiceHelper.getBoolParam((Long)modelId, (String)"isSaveConInput")) {
            return;
        }
        try {
            List dims = info.getDimensions();
            List fixedDimensions = info.getFixedDimensions();
            List seq_dims = DimensionServiceHelper.getAllDim((Long)modelId);
            seq_dims.remove("Extends");
            Map userDefines = MemberReader.getUsetDefineDimNumberMapNameById((long)modelId);
            ArrayList<String> dimlist = new ArrayList<String>();
            dimlist.addAll(DataTypeEnum.getDataTypePerSetDims((Object)modelId));
            dimlist.addAll(userDefines.keySet());
            Map<String, DataTypeEnum> dataTypeCache = MDDataHandleService.getDataTypeMap(modelId, dimlist);
            HashMap<String, String> cellDim = new HashMap<String, String>(16);
            for (FixedDimension fixedDimension : fixedDimensions) {
                cellDim.put(fixedDimension.getName(), fixedDimension.getValue());
            }
            ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(16);
            String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
            HashSet<String> scenes = new HashSet<String>(16);
            HashSet<String> orgs = new HashSet<String>(16);
            HashSet<String> years = new HashSet<String>(16);
            HashSet<String> periods = new HashSet<String>(16);
            HashSet<String> cys = new HashSet<String>(16);
            for (String measure : info.getMeasures()) {
                if (!measure.equals(fMoney)) {
                    return;
                }
                Iterator it = cellSets.getMutableMetricEntries(fMoney);
                while (it.hasNext()) {
                    boolean isCWP;
                    kotlin.Pair entry = (kotlin.Pair)it.next();
                    Object value = entry.getSecond();
                    MembersKey key = (MembersKey)entry.getFirst();
                    for (int i = 0; i < dims.size(); ++i) {
                        cellDim.put((String)dims.get(i), key.get(i).toString());
                    }
                    DataTypeEnum dimCellDataType = MDDataHandleService.getDimCellDataType(dataTypeCache, cellDim, dimlist);
                    if (DataTypeEnum.TXT != dimCellDataType || value instanceof String && ((String)value).isEmpty()) continue;
                    IDNumberTreeNode node = MemberReader.findEntityMemberByNum((String)cubeNumber, (String)((String)cellDim.get(DimTypesEnum.ENTITY.getNumber())));
                    boolean bl = isCWP = "ERAdj".equals(cellDim.get(DimTypesEnum.PROCESS.getNumber())) || "RAdj".equals(cellDim.get(DimTypesEnum.PROCESS.getNumber())) && "CWP".equals(cellDim.get(DimTypesEnum.AUDITTRIAL.getNumber()));
                    if (node.isLeaf() || !isCWP) continue;
                    LinkedHashMap<String, String> linkMap = MDDataHandleService.trans2LinkMap(cellDim, seq_dims);
                    String orgNum = linkMap.get(DimTypesEnum.ENTITY.getNumber());
                    String sceneNum = linkMap.get(DimTypesEnum.SCENARIO.getNumber());
                    String yearNum = linkMap.get(DimTypesEnum.YEAR.getNumber());
                    String periodNum = linkMap.get(DimTypesEnum.PERIOD.getNumber());
                    String cyNum = linkMap.get(DimTypesEnum.CURRENCY.getNumber());
                    scenes.add(sceneNum);
                    orgs.add(orgNum);
                    years.add(yearNum);
                    periods.add(periodNum);
                    cys.add(cyNum);
                    DynamicObject record_cwp = MDDataHandleService.buildDataRecordDy(cubeNumber, linkMap, value);
                    linkMap.put(DimTypesEnum.PROCESS.getNumber(), "EIRpt");
                    linkMap.put(DimTypesEnum.AUDITTRIAL.getNumber(), "EntityInput");
                    DynamicObject record_input = MDDataHandleService.buildDataRecordDy(cubeNumber, linkMap, value);
                    records.add(record_cwp);
                    records.add(record_input);
                }
            }
            DynamicObjectCollection doc = MDDataHandleService.getDataRecoverRecords(cubeNumber, scenes, orgs, years, periods, cys);
            HashMap<String, Object> key2Dys = new HashMap<String, Object>(16);
            for (Object dy : doc) {
                key2Dys.put(dy.getString("json"), dy);
            }
            ArrayList<Long> delIds = new ArrayList<Long>(16);
            for (DynamicObject dy : records) {
                if (!key2Dys.containsKey(dy.getString("json"))) continue;
                delIds.add(((DynamicObject)key2Dys.get(dy.getString("json"))).getLong("id"));
            }
            records.removeIf(r -> StringUtils.isEmpty((CharSequence)r.getString("data")));
            try (TXHandle tx = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)"bcm_datacoverrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", delIds)});
                    SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static DynamicObjectCollection getDataRecoverRecords(String cube, Set<String> scenes, Set<String> orgs, Set<String> years, Set<String> periods, Set<String> cys) {
        QFilter filter = new QFilter("cube", "=", (Object)cube);
        filter.and("org", "in", orgs);
        filter.and("scene", "in", scenes);
        filter.and("year", "in", years);
        filter.and("period", "in", periods);
        filter.and("currency", "in", cys);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_datacoverrecord", (String)"id,json", (QFilter[])filter.toArray());
        return doc;
    }

    public static LinkedHashMap<String, String> trans2LinkMap(Map<String, String> cellDim, List<String> seq_dims) {
        LinkedHashMap<String, String> linkMap = new LinkedHashMap<String, String>(16);
        for (String seq_dim : seq_dims) {
            linkMap.put(seq_dim, cellDim.get(seq_dim));
        }
        return linkMap;
    }

    private static DynamicObject buildDataRecordDy(String cubeNumber, Map<String, String> cellDim, Object value) {
        DynamicObject record = ORM.create().newDynamicObject("bcm_datacoverrecord");
        record.set("cube", (Object)cubeNumber);
        record.set("org", (Object)cellDim.get(DimTypesEnum.ENTITY.getNumber()));
        record.set("scene", (Object)cellDim.get(DimTypesEnum.SCENARIO.getNumber()));
        record.set("year", (Object)cellDim.get(DimTypesEnum.YEAR.getNumber()));
        record.set("period", (Object)cellDim.get(DimTypesEnum.PERIOD.getNumber()));
        record.set("currency", (Object)cellDim.get(DimTypesEnum.CURRENCY.getNumber()));
        record.set("json", (Object)JSONObject.toJSONString(cellDim));
        record.set("data", value);
        return record;
    }

    private static Map<String, DataTypeEnum> getDataTypeMap(Long modelId, List<String> dimNumbers) {
        HashMap<String, DataTypeEnum> dataTypeCache = new HashMap<String, DataTypeEnum>();
        for (String dimNum : dimNumbers) {
            Map dataTypeMap = MemberReader.getMemberDataType((long)modelId, (String)DimEntityNumEnum.getEntieyNumByNumber((String)dimNum), (String)dimNum);
            dataTypeCache.putAll(dataTypeMap);
        }
        return dataTypeCache;
    }

    private static DataTypeEnum getDimCellDataType(Map<String, DataTypeEnum> dataTypeCache, Map<String, String> cellDim, List<String> dimList) {
        for (String dimNum : dimList) {
            DataTypeEnum dataTypeEnum = dataTypeCache.get(dimNum + "_" + cellDim.get(dimNum));
            if (dataTypeEnum == null) continue;
            if (DataTypeEnum.ENUMTP == dataTypeEnum) {
                return dataTypeCache.get(dimNum + "_" + cellDim.get(dimNum) + "_item");
            }
            return dataTypeEnum;
        }
        return DataTypeEnum.CURRENCY;
    }

    private static boolean isCWP(List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples) {
        boolean isCWP;
        String bpNum = "";
        String atNum = "";
        for (Tuple<String, String> viewTuple : viewTuples) {
            if (DimTypesEnum.PROCESS.getNumber().equals(viewTuple.k)) {
                bpNum = (String)viewTuple.v;
                continue;
            }
            if (!DimTypesEnum.AUDITTRIAL.getNumber().equals(viewTuple.k)) continue;
            atNum = (String)viewTuple.v;
        }
        for (Tuple<String, String> pageTuple : pageTuples) {
            if (DimTypesEnum.PROCESS.getNumber().equals(pageTuple.k)) {
                bpNum = (String)pageTuple.v;
                continue;
            }
            if (!DimTypesEnum.AUDITTRIAL.getNumber().equals(pageTuple.k)) continue;
            atNum = (String)pageTuple.v;
        }
        boolean isBPAT_IN_RC = StringUtils.isEmpty((CharSequence)bpNum) || StringUtils.isEmpty((CharSequence)atNum);
        boolean bl = isCWP = "CWP".equals(atNum) && "ERAdj".equals(bpNum);
        if (isBPAT_IN_RC) {
            isCWP = false;
        }
        return isCWP;
    }

    public static boolean moveMC2RCFromPV(String cubecatalog, List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples) {
        boolean isOpen = (Boolean)ThreadCache.get((Object)(cubecatalog + ConfigEnum.CM043.getNumber()), () -> ConfigServiceHelper.getBoolParam((String)cubecatalog, (String)ConfigEnum.CM043.getNumber()));
        boolean isMoveMC = false;
        if (isOpen) {
            isMoveMC = isMoveMC || viewTuples.removeIf(f -> DimTypesEnum.MYCOMPANY.getNumber().equals(f.k));
            isMoveMC = isMoveMC || pageTuples.removeIf(f -> DimTypesEnum.MYCOMPANY.getNumber().equals(f.k));
        }
        return isMoveMC;
    }

    public static Table<String, String, String> getAssoMembs(String cubecatalog) {
        Table assoMembs = (Table)ThreadCache.get((Object)"assoMembInModel", () -> AssoStorageMemUtil.getAllAssoMembers((String)cubecatalog));
        return assoMembs;
    }

    public static VerifyResult saveDimensionDatas(SpreadManager sm, List<Row> rows, List<String> floatnumbers, Map<Integer, List<IDimMember>> fixmemset, String modelNumber, IRelaMembSupplier<String, String> orgRelaMembSupplier, boolean needClearDynaDelVals) {
        if (rows.size() <= 0) {
            return null;
        }
        List<Tuple<String, String>> viewTuples = MDDataHandleService.genTuples((Domain)sm.getFilter().getViewPointDomain());
        List<Tuple<String, String>> pageTuples = MDDataHandleService.genTuples((Domain)sm.getFilter().getPageDomain());
        SaveCommandInfo info = new SaveCommandInfo();
        MDDataHandleService.addFiexdDimension(info, viewTuples);
        MDDataHandleService.addFiexdDimension(info, pageTuples);
        List itFixe = info.getFixedDimensions();
        int index = -1;
        for (int i = 0; i < itFixe.size(); ++i) {
            FixedDimension fixe = (FixedDimension)itFixe.get(i);
            if (!"Currency".equals(fixe.getName())) continue;
            String currencyNumber = (String)TransMemberUtil.transOrgAndCurbyOrgId((String)modelNumber, (long)((OrgRelaMembSupplier)orgRelaMembSupplier).get_mainOrgId().longValue(), (String)SpreadMemberUtil.getDimNumberBySm((SpreadManager)sm, (DimTypesEnum)DimTypesEnum.PROCESS), (String)SpreadMemberUtil.getDimNumberBySm((SpreadManager)sm, (DimTypesEnum)DimTypesEnum.CURRENCY), (long)0L, (long)0L).p2;
            if (StringUtils.isBlank((CharSequence)currencyNumber)) {
                throw new RuntimeException("real Currency dimension is null");
            }
            info.addfixedDimension(new String[]{fixe.getName(), currencyNumber});
            index = i;
            break;
        }
        if (index != -1) {
            info.getFixedDimensions().remove(index);
        }
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        HashSet<String> dimKeys = new HashSet<String>(floatnumbers);
        info.setDimensions(new ArrayList<String>(dimKeys));
        for (IDimMember iDimMember : fixmemset.get(0)) {
            info.addDimensions(new String[]{iDimMember.getDimension().getNumber()});
            dimKeys.add(iDimMember.getDimension().getNumber());
        }
        String[] dimKey = new String[dimKeys.size()];
        dimKeys.toArray(dimKey);
        VerifyResult vr = new VerifyResult();
        CellSet cellSets = new CellSet(dimKey, new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        for (Row row : rows) {
            String[] dest = new String[dimKey.length];
            for (int i = 0; i < dimKey.length; ++i) {
                dest[i] = row.getString(dimKey[i]);
            }
            cellSets.set(dest, FacTabFieldDefEnum.FIELD_MONEY.getField(), null);
        }
        vr.mergeVerifyResult(OlapServiceHelper.saveData((SaveCommandInfo)info, (CellSet)cellSets, (String)modelNumber));
        if (needClearDynaDelVals) {
            sm.getAreaManager().clearDynaDelVals();
        }
        return vr;
    }

    public static String dealSaveProcess(String dimNumber, String memNumber) {
        if (dimNumber.equals(DimTypesEnum.PROCESS.getNumber()) && processMap.containsKey(memNumber)) {
            return processMap.get(memNumber);
        }
        return memNumber;
    }

    private static void checkMemberExit(Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> entry, List<String> dimKeySet, Set<Tuple<String[], Object>> dynaDelKvSets, String cubecatalog) {
        int index;
        if (dynaDelKvSets == null) {
            return;
        }
        HashMap<Integer, String> indexmap = new HashMap<Integer, String>(16);
        for (Object bp : entry.getKey().getBasePoints()) {
            for (BasePointInnerLineInfo basePointInnerLineInfo : bp.getBasePointInnerLineInfo()) {
                if (!basePointInnerLineInfo.isFloated()) continue;
                index = dimKeySet.indexOf(basePointInnerLineInfo.getDimension().getNumber());
                indexmap.put(index, basePointInnerLineInfo.getDimension().getNumber());
            }
        }
        HashMultimap numberMap = HashMultimap.create();
        for (Tuple tuple : dynaDelKvSets) {
            Iterator iterator = indexmap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                numberMap.put((Object)i, (Object)((String[])tuple.k)[i]);
            }
        }
        HashMap<Integer, List<String>> unExit = new HashMap<Integer, List<String>>(indexmap.size());
        for (Map.Entry entry2 : indexmap.entrySet()) {
            index = (Integer)entry2.getKey();
            Set un = OlapServiceHelper.batCheckMemberIsExistOlap((String)((String)entry2.getValue()), (String[])numberMap.get((Object)index).toArray(new String[0]), (String)cubecatalog);
            String[] unString = un.toArray(new String[un.size()]);
            unExit.put(index, Arrays.asList(unString));
        }
        HashSet<Tuple<String[], Object>> hashSet = new HashSet<Tuple<String[], Object>>(16);
        block5: for (Tuple<String[], Object> tt : dynaDelKvSets) {
            Iterator iterator = indexmap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean bl = ((List)unExit.get(i)).contains(((String[])tt.k)[i]);
                if (!bl) continue;
                hashSet.add(tt);
                continue block5;
            }
        }
        dynaDelKvSets.removeAll(hashSet);
    }

    private static String[] appendMemb(String[] src, String orgMember) {
        String[] dest = new String[src.length + 1];
        System.arraycopy(src, 0, dest, 0, src.length);
        dest[dest.length - 1] = orgMember;
        return dest;
    }

    private static String[] appendCurrencyMen(String[] src, String currency) {
        String[] dest = new String[src.length + 1];
        System.arraycopy(src, 0, dest, 0, src.length);
        dest[dest.length - 1] = currency;
        return dest;
    }

    private static String[] replaceCurrencyMen(String[] src, int currency_index, String currency) {
        String[] dest = new String[src.length];
        System.arraycopy(src, 0, dest, 0, src.length);
        dest[currency_index] = currency;
        return dest;
    }

    private static int getDimIndexOnRowColDim(List<String> crossKeys, DimTypesEnum dimType) {
        int size = crossKeys.size();
        for (int i = 0; i < size; ++i) {
            if (!crossKeys.get(i).equals(dimType.getNumber())) continue;
            return i;
        }
        return -1;
    }

    private static void addFiexdDimension(SaveCommandInfo info, List<Tuple<String, String>> tuples) {
        for (Tuple<String, String> t : tuples) {
            info.addfixedDimension(new String[]{(String)t.k, (String)t.v});
        }
    }

    public static Tuple<String, String> getTupleDim(List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples, String type) {
        int i;
        Tuple<String, String> Tuple2 = null;
        for (i = viewTuples.size() - 1; i >= 0; --i) {
            if (!((String)viewTuples.get((int)i).k).equals(type)) continue;
            Tuple2 = viewTuples.get(i);
            break;
        }
        if (Tuple2 == null) {
            for (i = pageTuples.size() - 1; i >= 0; --i) {
                if (!((String)pageTuples.get((int)i).k).equals(type)) continue;
                Tuple2 = pageTuples.get(i);
                break;
            }
        }
        return Tuple2;
    }

    private static Tuple<String, String> rejectDim(List<Tuple<String, String>> viewTuples, List<Tuple<String, String>> pageTuples, String dimType) {
        int i;
        Tuple<String, String> tuple = null;
        for (i = viewTuples.size() - 1; i >= 0; --i) {
            if (!((String)viewTuples.get((int)i).k).equals(dimType)) continue;
            tuple = viewTuples.remove(i);
            break;
        }
        if (tuple == null) {
            for (i = pageTuples.size() - 1; i >= 0; --i) {
                if (!((String)pageTuples.get((int)i).k).equals(dimType)) continue;
                tuple = pageTuples.remove(i);
                break;
            }
        }
        return tuple;
    }

    private static boolean isRemoveCurr(Domain viewPointDomain, Domain pageDomain) {
        boolean isViewCurrency = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Currency");
        boolean isViewEntity = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Entity");
        boolean isViewProcess = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Process");
        return isViewCurrency && (!isViewEntity || !isViewProcess);
    }

    private static boolean isRemoveEntity(Domain viewPointDomain, Domain pageDomain) {
        boolean isViewCurrency = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Currency");
        boolean isViewEntity = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Entity");
        boolean isViewProcess = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Process");
        return isViewEntity && (!isViewCurrency || !isViewProcess);
    }

    private static boolean isRemoveProcess(Domain viewPointDomain, Domain pageDomain) {
        boolean isViewCurrency = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Currency");
        boolean isViewEntity = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Entity");
        boolean isViewProcess = MDDataHandleService.isViewDim(viewPointDomain, pageDomain, "Process");
        return isViewProcess && (!isViewEntity || !isViewCurrency);
    }

    public static boolean isViewDim(Domain viewPointDomain, Domain pageDomain, String dimType) {
        return viewPointDomain.getAllMembers().stream().anyMatch(e -> e.getDimension().getNumber().equals(dimType)) || pageDomain.getAllMembers().stream().anyMatch(e -> e.getDimension().getNumber().equals(dimType));
    }

    public static Map<String, Map<String, Object>> query(SpreadManager sm, PositionInfo pos, String cube, IRelaMembSupplier<String, String> orgSupplier, IRelaMembSupplier<String, String> periodSupplier) {
        if (sm.getAreaManager().getPositionSize() <= 0) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        List<Tuple<String, String>> rowTuples = null;
        List<Tuple<String, String>> colTuples = null;
        ViewPointDimDomain viewPointDomain = sm.getFilter().getViewPointDomain();
        PageDimDomain pageDomain = sm.getFilter().getPageDomain();
        MDDataHandleService.checkPageOrg(cube, (OrgRelaMembSupplier)orgSupplier, pageDomain);
        String[] measureKeys = new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
        if (sm.getBook().getSheet(0).getUserObject().containsKey("issource")) {
            measureKeys = new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()};
        }
        boolean periodIsPY = viewPointDomain.getDimensions().stream().anyMatch(v -> PresetConstant.PERIOD_DIM.equals(v.getNumber())) || pageDomain.getDimensions().stream().anyMatch(p -> PresetConstant.PERIOD_DIM.equals(p.getNumber()));
        HashMap<String, Map<String, Object>> allSets = new HashMap<String, Map<String, Object>>(16);
        List<Map<String, Set<String>>> colDimMemList = MDDataHandleService.getColDimMemList(sm);
        for (Map.Entry e : sm.getAreaManager()) {
            boolean isPeriodEmpty;
            if (pos != null && !((PositionInfo)e.getKey()).getOriginalAreaRange().equals(pos.getOriginalAreaRange())) continue;
            rowTuples = MDDataHandleService.genTuples((Domain)sm.getAreaManager().getRowDimDoman((PositionInfo)e.getKey()));
            colTuples = MDDataHandleService.genTuples((Domain)sm.getAreaManager().getColDimDomain((PositionInfo)e.getKey()));
            if (rowTuples.size() == 0 || colTuples.size() == 0) continue;
            List<String> selectDimKey = MDDataHandleService.genDimKeySet(rowTuples, colTuples);
            SelectCommandInfo queryInfo = new SelectCommandInfo();
            queryInfo.addDims(selectDimKey.toArray(new String[0]));
            queryInfo.addMeasures(measureKeys);
            MDDataHandleService.buildQueryFilter((Domain)viewPointDomain, queryInfo, sm, periodIsPY);
            MDDataHandleService.buildQueryFilter((Domain)pageDomain, queryInfo, sm, periodIsPY);
            MDDataHandleService.buildQueryFilter((Domain)((Tuple)e.getValue()).k, queryInfo, sm, periodIsPY);
            if (colDimMemList.isEmpty()) {
                MDDataHandleService.buildQueryFilter((Domain)((Tuple)e.getValue()).v, queryInfo, sm, periodIsPY);
                ReportSpecialVariableUtil.addSpecialQueryFilter(sm, queryInfo, cube, periodSupplier);
            }
            if (periodSupplier != null && (isPeriodEmpty = MDDataHandleService.removePeriod(sm, cube, queryInfo, periodSupplier))) continue;
            if (!colDimMemList.isEmpty()) {
                for (Map<String, Set<String>> colDimMem : colDimMemList) {
                    boolean isPeriodEmpty2;
                    MDDataHandleService.replaceColDimMem(colDimMem, queryInfo);
                    ReportSpecialVariableUtil.addSpecialQueryFilter(sm, queryInfo, cube, periodSupplier);
                    if (periodSupplier != null && (isPeriodEmpty2 = MDDataHandleService.removePeriod(sm, cube, queryInfo, periodSupplier))) continue;
                    Map queryData = DCQueryHelper.queryData((SelectCommandInfo)queryInfo, (String)cube, (long)((OrgRelaMembSupplier)orgSupplier).get_mainOrgId(), periodSupplier);
                    if (allSets.get(((PositionInfo)e.getKey()).getAreaRange()) == null) {
                        allSets.put(((PositionInfo)e.getKey()).getAreaRange(), queryData);
                        continue;
                    }
                    ((Map)allSets.get(((PositionInfo)e.getKey()).getAreaRange())).putAll(queryData);
                }
                continue;
            }
            allSets.put(((PositionInfo)e.getKey()).getAreaRange(), DCQueryHelper.queryData((SelectCommandInfo)queryInfo, (String)cube, (long)((OrgRelaMembSupplier)orgSupplier).get_mainOrgId(), periodSupplier));
        }
        return allSets;
    }

    public static void replaceColDimMem(Map<String, Set<String>> map, SelectCommandInfo queryInfo) {
        if (!queryInfo.getFilter().stream().anyMatch(dimensionFilterItem -> map.containsKey(dimensionFilterItem.getName()))) {
            map.forEach((k, v) -> queryInfo.addFilter(k, v.toArray(new String[0])));
        } else {
            queryInfo.getFilter().forEach(dimensionFilterItem -> {
                String dimNum = dimensionFilterItem.getName();
                Set memberSet = (Set)map.get(dimNum);
                if (memberSet != null) {
                    List values = dimensionFilterItem.getValues();
                    values.clear();
                    if (!memberSet.isEmpty()) {
                        values.addAll(memberSet);
                    }
                }
            });
        }
    }

    public static List<Map<String, Set<String>>> getColDimMemList(SpreadManager sm) {
        List<Map<String, Set<String>>> colDimMemList = new ArrayList<Map<String, Set<String>>>(16);
        Object object = sm.getBook().getSheet(0).getUserObject("colDimMemListforolap");
        if (Objects.nonNull(object)) {
            colDimMemList = (List)ObjectSerialUtil.deSerializedBytes((String)object.toString());
        }
        return colDimMemList;
    }

    private static boolean removePeriod(SpreadManager spreadManager, String cube, SelectCommandInfo queryInfo, IRelaMembSupplier<String, String> s) {
        AtomicBoolean isEmpty = new AtomicBoolean(false);
        if (ConfigServiceHelper.getBoolParam((String)cube, (String)"isOnlyShowBefCurPeriod")) {
            boolean isOnlyShowBefCurPeriod;
            boolean bl = isOnlyShowBefCurPeriod = spreadManager.getBook().getSheet(0).getUserObject(SheetConstant.ISONLYSHOWBEFCURPERIOD) == null ? false : (Boolean)spreadManager.getBook().getSheet(0).getUserObject(SheetConstant.ISONLYSHOWBEFCURPERIOD);
            if (isOnlyShowBefCurPeriod) {
                queryInfo.getFilter().forEach(f -> {
                    if (DimTypesEnum.PERIOD.getNumber().equals(f.getName())) {
                        f.getValues().removeAll(PeriodUtils.getAfterPeriod((String)cube, (String)((String)s.access((Object)"CurrentPeriod"))));
                        if (f.getValues().isEmpty()) {
                            isEmpty.set(true);
                        }
                    }
                });
            }
        }
        return isEmpty.get();
    }

    private static void checkPageOrg(String cube, OrgRelaMembSupplier orgSupplier, PageDimDomain pageDomain) {
        pageDomain.getDimensions().forEach(p -> {
            if (DimTypesEnum.ENTITY.getNumber().equals(p.getNumber())) {
                IDNumberTreeNode orgNode = MemberReader.findEntityMemberById((String)cube, (Long)orgSupplier.get_mainOrgId());
                ((DimMember)p.getMembers().get(0)).setPar_SonNum(orgNode.getParent() != null ? orgNode.getParent().getNumber() + "_" + orgNode.getNumber() : orgNode.getNumber());
            }
        });
    }

    public static Table<Integer, Integer, Object> updateCellValues(SpreadManager sm, RangeModel rangeModel, Map<String, Map<String, Object>> allCellSets, IRelaMembSupplier<String, String> s) {
        return MDDataHandleService.updateCellValues(sm, rangeModel, allCellSets, s, false);
    }

    public static Table<Integer, Integer, Object> updateCellValues(SpreadManager sm, RangeModel rangeModel, Map<String, Map<String, Object>> allCellSets, IRelaMembSupplier<String, String> s, boolean packdata) {
        HashBasedTable table = HashBasedTable.create();
        Sheet sheet = sm.getBook().getSheet(0);
        if (rangeModel != null) {
            for (Map.Entry<String, Map<String, Object>> entry : allCellSets.entrySet()) {
                sheet.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), arg_0 -> MDDataHandleService.lambda$updateCellValues$18(entry, packdata, (Table)table, arg_0));
            }
        } else {
            for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
                String area = ps.getAreaRange();
                RangeModel rm = new RangeModel(area);
                Map<String, Object> cellSets = allCellSets.get(area);
                if (cellSets == null) continue;
                sheet.iteratorRangeCells(rm.getY_start(), rm.getY_end(), rm.getX_start(), rm.getX_end(), arg_0 -> MDDataHandleService.lambda$updateCellValues$19(cellSets, packdata, (Table)table, arg_0));
            }
        }
        return table;
    }

    private static boolean canUpdate(Cell cell) {
        if (cell.getUserObject("notupdata") != null && cell.getUserObject("notupdata").equals(Boolean.TRUE)) {
            return false;
        }
        return cell.getUserObject("csv") == null || !cell.getUserObject("csv").equals(Boolean.TRUE);
    }

    public static PairList<Point, Point> parserFixPositionOfDynaArea(PositionInfo p) {
        PairList list = new PairList();
        if (p.isFloatPosition()) {
            BasePointInfo[] bps = p.getBasePoints().toArray(new BasePointInfo[0]);
            RangeModel area = SpreadAreaUtil.getRangModel((String)p.getAreaRange());
            boolean isDirectHoriz = bps[0].isDirectHoriz();
            RangeModel first = SpreadAreaUtil.getRangModel((String)bps[0].getDynaRange());
            RangeModel sec = null;
            for (int i = 0; i < bps.length - 1; ++i) {
                sec = SpreadAreaUtil.getRangModel((String)bps[i + 1].getDynaRange());
                MDDataHandleService.calcAreaPoistion(first.getEndPoint(), sec.getStartPoint(), isDirectHoriz, area, (PairList<Point, Point>)list, false);
            }
            if (sec == null) {
                sec = SpreadAreaUtil.getRangModel((String)bps[bps.length - 1].getDynaRange());
            }
            MDDataHandleService.calcAreaPoistion(sec.getEndPoint(), area.getEndPoint(), isDirectHoriz, area, (PairList<Point, Point>)list, true);
        }
        return list;
    }

    private static void calcAreaPoistion(Point first, Point sec, boolean isDirectHoriz, RangeModel area, PairList<Point, Point> list, boolean isLastArea) {
        int endCol;
        int fromRow;
        int fromCol = isDirectHoriz ? first.x + 1 : area.getX_start();
        int n = fromRow = isDirectHoriz ? area.getY_start() : first.y + 1;
        int n2 = isDirectHoriz ? (isLastArea ? sec.x : sec.x - 1) : (endCol = area.getX_end());
        int endRow = isDirectHoriz ? area.getY_end() : (isLastArea ? sec.y : sec.y - 1);
        list.addPair((Object)new Point(fromCol, fromRow), (Object)new Point(endCol, endRow));
    }

    private static void buildQueryFilter(Domain domain, SelectCommandInfo queryInfo, SpreadManager sm, boolean periodIsPy) {
        HashSet<String> memberSets = new HashSet<String>();
        HashMap<String, IDimMember> dim2FilterMembs = new HashMap<String, IDimMember>(16);
        if (sm.getFilter().getFilterDomain() != null) {
            for (IDimension dimension : sm.getFilter().getFilterDomain().getDimensions()) {
                for (IDimMember member : dimension.getMembers()) {
                    dim2FilterMembs.put(dimension.getNumber(), member);
                }
            }
        }
        for (IDimension d : domain.getDimensions()) {
            memberSets.clear();
            if (dim2FilterMembs.get(d.getNumber()) != null) {
                for (IDimMember m : d.getMembers()) {
                    if (m == null || m.isTemp() || !m.getNumber().equals("$Cur")) continue;
                    memberSets.add(FillDataUtils.getNumberForDCTrain((IDimMember)dim2FilterMembs.get(d.getNumber()), !periodIsPy));
                }
            }
            for (IDimMember m : d.getMembers()) {
                if (m == null || m.isTemp() || "$Cur".equals(m.getNumber())) continue;
                memberSets.add(FillDataUtils.getNumberForDCTrain(m, !periodIsPy));
            }
            if (memberSets.isEmpty()) continue;
            queryInfo.addFilter(d.getNumber(), memberSets.toArray(new String[0]));
        }
    }

    private static HashMultimap<PositionInfo, Tuple<String[], Object>> genCellSetParams(SpreadManager sm, String cubecatalog, boolean canRedict) {
        HashMultimap setSets = HashMultimap.create();
        Table<String, String, String> assoMembs = MDDataHandleService.getAssoMembs(cubecatalog);
        Recorder orgNum = new Recorder((Object)sm.getFilter().getDimMember(DimTypesEnum.ENTITY.getNumber()));
        String mcNum = sm.getFilter().getDimMember(DimTypesEnum.MYCOMPANY.getNumber());
        boolean isMCInPV = sm.getFilter().isDimInCommonFilter(DimTypesEnum.MYCOMPANY.getNumber());
        boolean isOrgInPV = sm.getFilter().isDimInCommonFilter(DimTypesEnum.ENTITY.getNumber());
        boolean isOpen = (Boolean)ThreadCache.get((Object)(cubecatalog + ConfigEnum.CM043.getNumber()), () -> ConfigServiceHelper.getBoolParam((String)cubecatalog, (String)ConfigEnum.CM043.getNumber()));
        sm.getAreaManager().getPostionInfoSet().forEach(p -> {
            String[] range = p.getAreaRange().split(":");
            Point start = ExcelUtils.pos2Point((String)range[0]);
            Point end = ExcelUtils.pos2Point((String)range[1]);
            List rangeModels = p.getFloatDataArea();
            String covertNum = MDDataHandleService.getMCConvertNum(p.getMyCompanyAutoConvent(), cubecatalog);
            sm.getBook().getSheet(0).iteratorRangeCells(start.y, end.y, start.x, end.x, cell -> {
                if (cell.isMdDataDomain() && cell.isChangeVal() && ReportSpecialVariableUtil.isAllowClearCellVaue(cell)) {
                    boolean hasTempMember = false;
                    if (cell.getMemberFromUserObject() != null) {
                        hasTempMember = cell.getMemberFromUserObject().stream().anyMatch(IDimMember::isTemp);
                    }
                    if (!hasTempMember) {
                        if (cell.hasReactMember() || isOpen) {
                            ArrayList<Object> arrs = new ArrayList<Object>();
                            int mcIndex = -1;
                            if (cell.getMemberFromUserObject() != null) {
                                for (IDimMember m : cell.getMemberFromUserObject()) {
                                    if (DimTypesEnum.MYCOMPANY.getNumber().equals(m.getDimension().getNumber())) {
                                        mcIndex = arrs.size();
                                    }
                                    if (!isOrgInPV && DimTypesEnum.ENTITY.getNumber().equals(m.getDimension().getNumber())) {
                                        orgNum.setRecord((Object)m.getNumber());
                                    }
                                    if (canRedict && !DimTypesEnum.MYCOMPANY.getNumber().equals(m.getDimension().getNumber()) && assoMembs.contains((Object)m.getDimension().getNumber(), (Object)m.getNumber()) && StringUtils.isNotEmpty((CharSequence)((CharSequence)assoMembs.get((Object)m.getDimension().getNumber(), (Object)m.getNumber())))) {
                                        arrs.add(assoMembs.get((Object)m.getDimension().getNumber(), (Object)m.getNumber()));
                                        continue;
                                    }
                                    arrs.add(m.getNumber());
                                }
                            }
                            if (isOpen) {
                                String dimCovertNum;
                                if (PositionInfo.isInArea((List)rangeModels, (Cell)cell)) {
                                    BasePointInfo basePoint;
                                    if (isMCInPV) {
                                        if ("MyCompany".equals(mcNum)) {
                                            basePoint = p.getBasePoint(cell);
                                            String bpCovertNum = MDDataHandleService.getMCConvertNum(basePoint.getMyCompanyAutoConvent(p), cubecatalog);
                                            if ("MCNone".equals(bpCovertNum)) {
                                                arrs.add(bpCovertNum);
                                            } else if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(bpCovertNum)) {
                                                arrs.add(orgNum.getRecord());
                                            } else {
                                                arrs.add(mcNum);
                                            }
                                        } else {
                                            arrs.add(mcNum);
                                        }
                                    } else {
                                        basePoint = p.getBasePoint(cell);
                                        if (basePoint != null) {
                                            BasePointInnerLineInfo mcLine = basePoint.getBasePointInnerLineInfo().stream().filter(l -> "MyCompany".equals(l.getDimension().getNumber())).findFirst().orElse(null);
                                            if (mcIndex != -1 && mcLine != null && mcLine.isFloated() && mcLine.isIshide() && "Entity".equals(mcLine.getNumberfrom())) {
                                                arrs.set(mcIndex, orgNum.getRecord());
                                            }
                                        }
                                    }
                                } else if (isMCInPV) {
                                    if ("MyCompany".equals(mcNum)) {
                                        dimCovertNum = (String)assoMembs.get((Object)"MyCompany", (Object)"MyCompany");
                                        if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(dimCovertNum)) {
                                            arrs.add(orgNum.getRecord());
                                        } else if (SystemVarsEnum.CURRENT.getNumber().equals(dimCovertNum)) {
                                            arrs.add(mcNum);
                                        } else {
                                            arrs.add(dimCovertNum == null ? mcNum : dimCovertNum);
                                        }
                                    } else {
                                        arrs.add(mcNum);
                                    }
                                } else if (mcIndex != -1 && "MyCompany".equals(arrs.get(mcIndex))) {
                                    dimCovertNum = (String)assoMembs.get((Object)"MyCompany", (Object)"MyCompany");
                                    if (SystemVarsEnum.RELATE_ENTITY.getNumber().equals(dimCovertNum)) {
                                        arrs.set(mcIndex, orgNum.getRecord());
                                    } else if (!SystemVarsEnum.CURRENT.getNumber().equals(dimCovertNum) && dimCovertNum != null) {
                                        arrs.set(mcIndex, dimCovertNum);
                                    }
                                }
                            }
                            setSets.put(p, (Object)Tuple.newOne((Object)arrs.toArray(new String[0]), (Object)cell.getValue()));
                        } else {
                            setSets.put(p, (Object)Tuple.newOne((Object)cell.toSaveFormat(), (Object)cell.getValue()));
                        }
                    }
                }
            });
        });
        return setSets;
    }

    public static List<String> genDimKeySet(List<Tuple<String, String>> ... lists) {
        ArrayList<String> keySets = new ArrayList<String>(10);
        HashSet<Object> repeatCheck = new HashSet<Object>(16);
        for (List<Tuple<String, String>> l : lists) {
            for (Tuple<String, String> t : l) {
                if (!repeatCheck.add(t.k)) continue;
                keySets.add((String)t.k);
            }
        }
        return keySets;
    }

    public static List<Tuple<String, String>> genTuples(Domain domain) {
        ArrayList<Tuple<String, String>> tuples = new ArrayList<Tuple<String, String>>(10);
        if (domain == null) {
            return tuples;
        }
        for (IDimMember m : domain.getAllMembers()) {
            if (m == null) continue;
            tuples.add((Tuple<String, String>)Tuple.newOne((Object)m.getDimension().getNumber(), (Object)m.getNumber()));
        }
        return tuples;
    }

    public static String getMCConvertNum(PositionInfo.MyCompanyAutoConvent autoConvent, String cubecatalog) {
        try {
            if (autoConvent == PositionInfo.MyCompanyAutoConvent.MCNONE) {
                return "MCNone";
            }
            if (autoConvent == PositionInfo.MyCompanyAutoConvent.ECUR) {
                return "$ECur";
            }
            Table<String, String, String> assoMembs = MDDataHandleService.getAssoMembs(cubecatalog);
            String covertNum = (String)assoMembs.get((Object)"MyCompany", (Object)"MyCompany");
            if (SystemVarsEnum.CURRENT.getNumber().equals(covertNum)) {
                covertNum = "";
            }
            return covertNum;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }

    private static /* synthetic */ void lambda$updateCellValues$19(Map cellSets, boolean packdata, Table table, Cell cell) {
        if (cell.isMdDataDomain() && MDDataHandleService.canUpdate(cell)) {
            Object value = cellSets.get(FillDataUtils.combineKeyForDC(cell));
            if (packdata) {
                if (value != null) {
                    table.put((Object)cell.getRow(), (Object)cell.getCol(), value);
                }
            } else {
                cell.setValue(value);
            }
        }
    }

    private static /* synthetic */ void lambda$updateCellValues$18(Map.Entry entry, boolean packdata, Table table, Cell cell) {
        if (cell.isMdDataDomain() && MDDataHandleService.canUpdate(cell)) {
            Object value = ((Map)entry.getValue()).get(FillDataUtils.combineKeyForDC(cell));
            if (packdata) {
                if (value != null) {
                    table.put((Object)cell.getRow(), (Object)cell.getCol(), value);
                }
            } else {
                cell.setValue(value);
            }
        }
    }

    static {
        processMap.put("EIRpt", "IRpt");
        processMap.put("ERAdj", "RAdj");
        processMap.put("ERpt", "Rpt");
        ct_process.add("CT");
        ct_process.add("CSTE");
        ct_process.add("SRPT");
        ct_process.add("ADJT");
        ct_process.add("SADJ");
        ct_process.add("SCADJ");
        ct_process.add("SCCADJ");
        ct_process.add("DADJ");
        ct_process.add("EJET");
        ct_process.add("SEJE");
        ct_process.add("DEJE");
    }

    static class Pair<W, O>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private W p1;
        private O p2;

        private Pair(W p1, O p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public String toString() {
            return ToStringHelper.reflectionToString((Object)this);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.p1).append(this.p2).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return new EqualsBuilder().append(this.p1, p.p1).append(this.p2, p.p2).isEquals();
        }
    }
}

