/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model.dao;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.fi.bcm.business.sql.util.TypeConversionUtils;
import kd.fi.bcm.spread.model.dao.IMDResultSet;
import kd.fi.bcm.spread.model.dao.MDResultSetMetaData;
import kd.fi.bcm.spread.model.dao.Row;

public class MDResultSet
implements IMDResultSet {
    protected int cursorPos = 0;
    protected int numRows = 0;
    protected Row[] rows;
    protected MDResultSetMetaData metaData;
    protected Map<String, Integer> cache;

    public MDResultSet() {
    }

    public MDResultSet(MDResultSetMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.cursorPos < 0 || this.cursorPos > this.numRows + 1) {
            throw new SQLException("Invalid Cursor position");
        }
        return this.internalNext();
    }

    protected boolean internalNext() {
        boolean flag = false;
        if (this.cursorPos < this.numRows) {
            ++this.cursorPos;
            flag = true;
        } else if (this.cursorPos == this.numRows) {
            ++this.cursorPos;
            flag = false;
        }
        return flag;
    }

    @Override
    public void beforeFirst() {
        this.cursorPos = 0;
    }

    @Override
    public void populate(ResultSet rs) throws SQLException {
        ResultSetMetaData RSMD = rs.getMetaData();
        int colCount = RSMD.getColumnCount();
        int currentRowIndex = -1;
        this.rows = new Row[rs.getFetchSize()];
        this.numRows = rs.getFetchSize();
        StringBuilder temp = new StringBuilder();
        while (rs.next()) {
            this.rows[++currentRowIndex] = new Row();
            for (int i = 0; i < colCount; ++i) {
                String colName = RSMD.getColumnName(i);
                this.rows[currentRowIndex].addColumn(colName, rs.getObject(colName));
            }
            if (this.metaData == null) continue;
            if (this.cache == null) {
                this.cache = new HashMap<String, Integer>();
            }
            temp.setLength(0);
            for (String n : this.metaData.toArray()) {
                temp.append(rs.getString(n));
            }
            this.cache.put(temp.toString(), currentRowIndex);
        }
    }

    @Override
    public int getFetchSize() {
        return this.rows == null ? 0 : this.rows.length;
    }

    @Override
    public String getString(String colName) throws SQLException {
        this.checkCursor();
        Object obj = this.getCurrRow().getColValue(colName);
        return TypeConversionUtils.objToString((Object)obj);
    }

    @Override
    public Date getDate(String colName) throws SQLException {
        this.checkCursor();
        Object obj = this.getCurrRow().getColValue(colName);
        return TypeConversionUtils.objToDate((Object)obj);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) throws SQLException {
        this.checkCursor();
        Object obj = this.getCurrRow().getColValue(colName);
        return TypeConversionUtils.objToBigDecimal((Object)obj);
    }

    @Override
    public int getInt(String colName) throws SQLException {
        this.checkCursor();
        Object obj = this.getCurrRow().getColValue(colName);
        return TypeConversionUtils.objToInt((Object)obj);
    }

    protected void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException("Invalid cursor position");
        }
    }

    private Row getCurrRow() {
        return this.rows[this.cursorPos - 1];
    }

    private boolean isAfterLast() {
        return this.cursorPos == this.numRows + 1 && this.numRows > 0;
    }

    private boolean isBeforeFirst() {
        return this.cursorPos == 0 && this.numRows > 0;
    }

    @Override
    public Row getRow() {
        return this.getCurrRow();
    }

    @Override
    public void close() {
        this.rows = null;
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public Row getRowFromCache(String key) {
        return this.cache == null ? null : (this.cache.get(key) != null ? this.rows[this.cache.get(key)] : null);
    }

    @Override
    public void cacheThroughMetaData(MDResultSetMetaData meta) {
        if (this.cache == null) {
            this.cache = new HashMap<String, Integer>(this.rows.length);
            int index = 0;
            StringBuilder temp = new StringBuilder();
            for (Row r : this.rows) {
                for (String n : meta.toArray()) {
                    temp.append(r.getColValue(n));
                    this.cache.put(temp.toString(), index++);
                }
                temp.setLength(0);
            }
        }
    }
}

