/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.MDResultSetMetaData;
import kd.fi.bcm.spread.model.query.AbstractQueryParser;
import kd.fi.bcm.spread.model.query.IDimDataQueryCondition;
import kd.fi.bcm.spread.model.query.QueryPostman;
import kd.fi.bcm.spread.model.schema.DimTableDef;
import kd.fi.bcm.spread.model.schema.TableSchemaHelper;

public class SQLQueryParser
extends AbstractQueryParser {
    protected SQLBuilder4RDB sql = new SQLBuilder4RDB();
    private List<IDimension> dimensions;

    public SQLQueryParser(IDimDataQueryCondition condition) {
        super(condition);
    }

    @Override
    public QueryPostman parser() {
        this.buildSQLSelectPart();
        this.buildSQLFromPart();
        this.buildSQLCommonWherePart();
        this.buildSQLVariateWherePart();
        QueryPostman postman = new QueryPostman(this.sql.getSQL(), this.sql.getParams());
        MDResultSetMetaData metaData = new MDResultSetMetaData();
        for (IDimMember m : this.condition.getDataFilterMembers()) {
            metaData.addColumMeta(DimTableDef.searchByCode(m.getDimension().getUqCode()).getTblColName());
        }
        postman.setMetaData(metaData);
        return postman;
    }

    private void buildSQLSelectPart() {
        this.sql.select().append(DimTableDef.FACT.getFacFkName()).append(",");
        boolean hasMoreOne = false;
        for (IDimension dim : this.collectDimension()) {
            if (hasMoreOne) {
                this.sql.append(",");
            }
            this.sql.append(TableSchemaHelper.getFacTblFkName(dim));
            hasMoreOne = true;
        }
        this.sql.newLine();
    }

    private List<IDimension> collectDimension() {
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<IDimension>();
            ArrayList<IDimMember> members = new ArrayList<IDimMember>();
            members.addAll(this.condition.getCommomFilterMembers());
            members.addAll(this.condition.getDataFilterMembers());
            this.dimensions = TableSchemaHelper.collectDimension(members);
        }
        return this.dimensions;
    }

    private void buildSQLFromPart() {
        List<IDimension> dimensions = this.collectDimension();
        this.sql.from().append(TableSchemaHelper.getFacTblName(this.condition.getMDModual().getNumber())).blank();
        for (IDimension dim : dimensions) {
            this.sql.joinInner(TableSchemaHelper.getDimTblName(dim, this.condition.getMDModual()), DimTableDef.searchByCode(dim.getUqCode()).getPK(), TableSchemaHelper.getFacTblFkName(dim)).newLine();
        }
    }

    private void buildSQLCommonWherePart() {
        this.sql.where();
        boolean hasMoreOne = false;
        for (IDimMember member : this.condition.getCommomFilterMembers()) {
            if (hasMoreOne) {
                this.sql.and();
            }
            this.sql.equal(DimTableDef.searchByCode(member.getDimension().getUqCode()).getFacFkName(), (Object)member.getNumber()).newLine();
            hasMoreOne = true;
        }
    }

    private void buildSQLVariateWherePart() {
        this.sql.and();
        this.sql.append("(");
        boolean hasMoreOne = false;
        List<IDimension> dimensions = this.collectDimension();
        HashSet<String> params = new HashSet<String>();
        for (IDimension dim : dimensions) {
            if (hasMoreOne) {
                this.sql.and();
            }
            params.clear();
            for (IDimMember member : dim.getMembers()) {
                params.add(member.getNumber());
            }
            this.sql.in(DimTableDef.searchByCode(dim.getUqCode()).getFacFkName(), params).newLine();
            hasMoreOne = true;
        }
        this.sql.append(")");
    }
}

