/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.olap.IRelaMembSupplier;
import kd.fi.bcm.business.util.VirtualCurrencyUtil;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.enums.CurrencyEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Row;
import kd.fi.bcm.spread.model.schema.DimTableDef;

public class FillDataUtils {
    String cyDimName = ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FillDataUtils_0", (String)"fi-bcm-report", (Object[])new Object[0]);

    public static boolean matched(Cell cell, Row row) {
        return FillDataUtils.matched(cell.getMemberFromUserObject(), row);
    }

    public static boolean matched(List<IDimMember> members, Row row) {
        return members.stream().allMatch(member -> {
            String memkey = DimTableDef.searchByCode(member.getDimension().getUqCode()).getTblColName();
            return row.constainColName(memkey) && row.getColValue(memkey).equals(member.getNumber());
        });
    }

    public static String combineMemberKey(Cell cell, List<DimMember> virtualCurr) {
        ArrayList<String> key = new ArrayList<String>();
        List memberFromUserObject = cell.getMemberFromUserObject();
        if (memberFromUserObject != null) {
            for (IDimMember m : memberFromUserObject) {
                if (m == null) continue;
                if (virtualCurr != null && virtualCurr.size() == 2 && SysDimensionEnum.Currency.getNumber().equals(m.getDimension().getNumber())) {
                    if (StringUtil.equals((String)CurrencyEnum.EC.getNumber(), (String)m.getNumber())) {
                        m = (IDimMember)virtualCurr.get(0);
                    } else if (StringUtil.equals((String)CurrencyEnum.PC.getNumber(), (String)m.getNumber())) {
                        m = (IDimMember)virtualCurr.get(1);
                    }
                }
                key.add(m.getNumber());
            }
        }
        return String.join((CharSequence)"|", key);
    }

    public static String combineOrgEcKey(Cell cell, IRelaMembSupplier<String, String> orgTranEcSupplier) {
        StringBuilder sb = new StringBuilder();
        String currencyCode = "";
        for (IDimMember m : cell.getMemberFromUserObject()) {
            if (m == null) continue;
            sb.append(m.getNumber());
            if (!SysDimensionEnum.Entity.getNumber().equals(m.getDimension().getNumber())) continue;
            currencyCode = (String)orgTranEcSupplier.access((Object)m.getNumber());
        }
        sb.append(currencyCode);
        return sb.toString();
    }

    public static String combineKey(Cell cell) {
        ArrayList<String> key = new ArrayList<String>();
        for (IDimMember m : cell.getMemberFromUserObjectWithAssistDim()) {
            if (m == null) continue;
            key.add(m.getNumber());
        }
        return String.join((CharSequence)"|", key);
    }

    public static List<DimMember> getVirtualCurr(Object orgid) {
        ArrayList<DimMember> virtualCurr = new ArrayList<DimMember>(10);
        if (orgid != null) {
            List virtualCurrs = VirtualCurrencyUtil.getVirtualCurr((Object)orgid);
            Dimension currency = new Dimension(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FillDataUtils_0", (String)"fi-bcm-report", (Object[])new Object[0]), SysDimensionEnum.Currency.getNumber(), "");
            virtualCurr.add(new DimMember(((DynamicObject)virtualCurrs.get(0)).getString("currency.name"), ((DynamicObject)virtualCurrs.get(0)).getString("currency.number"), "", (IDimension)currency));
            virtualCurr.add(new DimMember(((DynamicObject)virtualCurrs.get(1)).getString("currency.name"), ((DynamicObject)virtualCurrs.get(1)).getString("currency.number"), "", (IDimension)currency));
        }
        return virtualCurr;
    }

    public List<DimMember> getVirtualCurr_EXP(Object orgid) {
        ArrayList<DimMember> virtualCurr = new ArrayList<DimMember>(10);
        if (orgid != null) {
            List virtualCurrs = VirtualCurrencyUtil.getVirtualCurr((Object)orgid);
            Dimension currency = new Dimension(this.cyDimName, SysDimensionEnum.Currency.getNumber(), "");
            virtualCurr.add(new DimMember(((DynamicObject)virtualCurrs.get(0)).getString("currency.name"), ((DynamicObject)virtualCurrs.get(0)).getString("currency.number"), "", (IDimension)currency));
            virtualCurr.add(new DimMember(((DynamicObject)virtualCurrs.get(1)).getString("currency.name"), ((DynamicObject)virtualCurrs.get(1)).getString("currency.number"), "", (IDimension)currency));
        }
        return virtualCurr;
    }

    public static String combineMemberKey(Cell cell) {
        ArrayList<String> key = new ArrayList<String>();
        for (IDimMember m : cell.getMemberFromUserObject()) {
            if (m == null) continue;
            key.add(m.getNumber());
        }
        return String.join((CharSequence)"|", key);
    }

    public static String combineKeyForDC(Cell cell) {
        ArrayList<String> key = new ArrayList<String>();
        boolean periodIsRC = cell.getMemberFromUserObject().stream().anyMatch(e -> PresetConstant.PERIOD_DIM.equals(e.getDimension().getNumber()));
        for (IDimMember m : cell.getMemberFromUserObject()) {
            if (m == null) continue;
            key.add(FillDataUtils.getNumberForDCTrain(m, periodIsRC));
        }
        return String.join((CharSequence)"|", key);
    }

    public static String getNumberForDCTrain(IDimMember m, boolean periodIsRC) {
        String oriNum;
        if (DimTypesEnum.CURRENCY.getNumber().equals(m.getDimension().getNumber()) && ((DimMember)m).getOriNumber() != null) {
            return ((DimMember)m).getOriNumber();
        }
        if (m.getPar_SonNum() != null && DimTypesEnum.ENTITY.getNumber().equals(m.getDimension().getNumber())) {
            return m.getPar_SonNum();
        }
        if (!periodIsRC && PresetConstant.FY_DIM.equals(m.getDimension().getNumber()) && "LastYear".equals(oriNum = ((DimMember)m).getOriNumber())) {
            return oriNum;
        }
        return m.getNumber();
    }
}

