/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.IWorksheet;
import com.grapecity.documents.excel.IWorksheets;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Map;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.util.ResourcesLoaderUtil;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.spread.util.GZIPUtils;

public class SpreadUtils {
    public static final String ISO_8859_1 = "ISO-8859-1";
    private static final String dev_license;
    private static final String deploy_license;
    protected static WatchLogger logger;

    public static void SetLicenseKey(boolean isDev) {
        if (isDev) {
            Workbook.SetLicenseKey((String)dev_license);
        } else {
            Workbook.SetLicenseKey((String)deploy_license);
        }
    }

    public static byte[] transZippedJson2Excel(String zippedJson) {
        try {
            byte[] bs = zippedJson.getBytes(ISO_8859_1);
            String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(bs)));
            return SpreadUtils.transJson2Excel(ssjson);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @SDKMark(description="")
    public static byte[] transJson2Excel(String ssjson) {
        JSONObject sps = JSON.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
        if (sps.containsKey("sheets")) {
            JSONObject sheets = (JSONObject)sps.get("sheets");
            for (Map.Entry entry : sheets.entrySet()) {
                JSONObject sheet = (JSONObject)entry.getValue();
                if (null != sheet && sheet.containsKey((Object)"rowFilter")) {
                    sheet.remove((Object)"rowFilter");
                }
                if (null == sheet || !sheet.containsKey((Object)"printInfo")) continue;
                sheet.remove((Object)"printInfo");
            }
        }
        Workbook workbook = SpreadUtils.getWorkbook(sps.toString());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        workbook.save((OutputStream)os);
        return os.toByteArray();
    }

    public static String transZippedBase64StringExcel2Json(String zippedBase64String) {
        byte[] bs = new byte[]{};
        try {
            bs = zippedBase64String.getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] uncompressedData = GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(bs));
        return SpreadUtils.transExcel2Json(uncompressedData);
    }

    public static String transExcel2Json(byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.open((InputStream)is);
        try {
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return workbook.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromJson(InputStream inStream) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.fromJson(inStream);
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            workbook.save((OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Workbook getWorkbook() {
        SpreadUtils.SetLicenseKey(false);
        return new Workbook();
    }

    public static ByteArrayOutputStream getByteArrayOutputStream(String json) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.fromJson(json);
        try {
            workbook.getWorksheets().get(0).getUsedRange().setShrinkToFit(true);
        }
        catch (Exception e) {
            logger.error("setShrinkToFit falied");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.save((OutputStream)out, SaveFileFormat.Pdf);
        return out;
    }

    public static ByteArrayOutputStream getByteArrayOutputStream(String json, SaveFileFormat format) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.fromJson(json);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.save((OutputStream)out, format);
        return out;
    }

    public static ByteArrayOutputStream getByteArrayOutputStream(Workbook workbook, SaveFileFormat format) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.save((OutputStream)out, format);
        return out;
    }

    public static InputStream getInputStream(String json) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.fromJson(json);
        try {
            workbook.getWorksheets().get(0).getUsedRange().setShrinkToFit(true);
        }
        catch (Exception e) {
            logger.error("setShrinkToFit falied");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.save((OutputStream)out, SaveFileFormat.Pdf);
        ByteArrayInputStream stream = new ByteArrayInputStream(out.toByteArray());
        return stream;
    }

    public static ByteArrayOutputStream getByteArrayOutputStream(InputStream stream) {
        Workbook workbook = SpreadUtils.getWorkbook(stream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        workbook.save((OutputStream)out, SaveFileFormat.Pdf);
        return out;
    }

    public static Workbook getWorkbook(InputStream stream) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.fromJson(stream);
        return workbook;
    }

    public static Workbook getWorkbook(String json) {
        Workbook workbook = SpreadUtils.getWorkbook();
        workbook.setEnableCalculation(false);
        workbook.fromJson(json);
        return workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStrFromInsByCode(InputStream is, Charset code) {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is, code));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        return builder.toString();
    }

    public static String getExcelJson(String sheetName, String url) {
        Workbook workbook = SpreadUtils.getWorkbook();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        InputStream ins = fileService.getInputStream(url);
        workbook.open(ins);
        IWorksheets worksheets = workbook.getWorksheets();
        for (IWorksheet worksheet : worksheets) {
            if (!sheetName.equalsIgnoreCase(worksheet.getName())) continue;
            worksheet.activate();
            String jsonExcel = workbook.toJson();
            return jsonExcel;
        }
        return "";
    }

    static {
        String res = ResourcesLoaderUtil.getStringFromResources((String)"spread/license.json");
        JSONObject object = JSON.parseObject((String)res);
        String dev_licensestr = object.get((Object)"dev_license").toString();
        String deploy_licensestr = object.get((Object)"deploy_license").toString();
        dev_license = EncryptUtils.aesDecrypt((String)dev_licensestr);
        deploy_license = EncryptUtils.aesDecrypt((String)deploy_licensestr);
        logger = BcmLogFactory.getWatchLogInstance(SpreadUtils.class);
        SpreadUtils.SetLicenseKey(false);
    }
}

