/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.util;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.IDimMember;

public class TemplateUpgradeUtil {
    public static String upgradeSpread(String data) {
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)data);
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            List mems = cell.getMemberFromUserObject();
            if (mems != null) {
                for (IDimMember mem : mems) {
                    TemplateUpgradeUtil.upgradeMember(mem);
                }
            }
        });
        return JsonSerializerUtil.toJson((SpreadManager)sm);
    }

    private static void upgradeMember(IDimMember mem) {
        if (DimTypesEnum.CURRENCY.getNumber().equals(mem.getDimension().getNumber())) {
            if ("PC".equals(mem.getNumber())) {
                mem.setNumber("DC");
                mem.setName(ResManager.loadKDString((String)"\u9ed8\u8ba4\u5e01", (String)"TemplateUpgradeUtil_2", (String)"fi-bcm-report", (Object[])new Object[0]));
            }
        } else if (DimTypesEnum.PROCESS.getNumber().equals(mem.getDimension().getNumber())) {
            if ("CS".equals(mem.getNumber())) {
                mem.setNumber("EIRpt");
                mem.setName(ResManager.loadKDString((String)"\u62a5\u8868-\u672c\u5e01", (String)"TemplateUpgradeUtil_0", (String)"fi-bcm-report", (Object[])new Object[0]));
            } else if ("SIRPT".equalsIgnoreCase(mem.getNumber())) {
                mem.setNumber("SRPT");
                mem.setName(ResManager.loadKDString((String)"\u62a5\u8868\u6c47\u603b", (String)"TemplateUpgradeUtil_1", (String)"fi-bcm-report", (Object[])new Object[0]));
            }
        }
    }
}

