/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.AppUtil;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.proxy.ITransationHandle;
import kd.fi.bcm.common.proxy.Interceptor;
import kd.fi.bcm.common.util.ThreadCacheUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class AbstractBaseBasicPlugIn
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
BCMBaseFunction,
IOperationLog {
    protected static final String F7KEY2DIM = "f7Key2Dim";
    protected Map<String, Control> cacheControls = new CaseInsensitiveMap();
    private Map<String, SingleF7TypeEnum> map;

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideNoModelPermButton();
    }

    public void initialize() {
        super.initialize();
        this.bcmInit();
        ThreadCacheUtil.putCurrentAppId((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("model".equals(name) && this.getModelId() != 0L) {
            this.hideNoModelPermButton();
        }
        this.bcmProChange(e);
    }

    public void setView(final IFormView formView) {
        IFormView bcmFormView = formView;
        if (formView != null && !formView.getClass().getName().contains("CGLIB") && ApplicationTypeEnum.RPT.getAppnum().equals(formView.getFormShowParameter().getAppId()) && ConfigServiceHelper.getGlobalBoolParam((String)"isHideNoPermButton")) {
            bcmFormView = (IFormView)new Interceptor((Object)formView, new ITransationHandle(){

                public void beforeTransation(Method method, Object[] args) {
                    if ("setVisible".equals(method.getName()) && !AbstractBaseBasicPlugIn.this.isHidingNoModelPermButton()) {
                        String[] buttonArray;
                        Map bizVisibleFromPageCache = AbstractBaseBasicPlugIn.this.getBizVisibleFromPageCache();
                        Boolean isShow = (Boolean)args[0];
                        for (String buttonKey : buttonArray = (String[])args[1]) {
                            bizVisibleFromPageCache.put(buttonKey, isShow);
                        }
                        AbstractBaseBasicPlugIn.this.updateBizVisibleFromPageCache(bizVisibleFromPageCache);
                        if (isShow.booleanValue()) {
                            Set noModelPermButtonKey = AbstractBaseBasicPlugIn.this.getNoModelPermButtonKeyFromPageCache();
                            HashSet<String> showButton = new HashSet<String>(16);
                            for (String key : buttonArray) {
                                if (noModelPermButtonKey.contains(key)) continue;
                                showButton.add(key);
                            }
                            if (!showButton.isEmpty()) {
                                args[1] = showButton.toArray(new String[1]);
                            }
                        }
                    }
                }

                public void afterTransation(Method method, Object[] args) {
                    Set noModelPermButtonKey;
                    Boolean isShow;
                    if ("setVisible".equals(method.getName()) && !AbstractBaseBasicPlugIn.this.isHidingNoModelPermButton() && (isShow = (Boolean)args[0]).booleanValue() && !(noModelPermButtonKey = AbstractBaseBasicPlugIn.this.getNoModelPermButtonKeyFromPageCache()).isEmpty()) {
                        formView.setVisible(Boolean.FALSE, noModelPermButtonKey.toArray(new String[1]));
                    }
                }
            }).createProxy();
        }
        super.setView(bcmFormView);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!AppUtil.isEpmAppId((String)e.getFormShowParameter().getAppId())) {
            this.bcmPreOpen(e);
        } else {
            FormShowParameter fs = (FormShowParameter)e.getSource();
            fs.setHasRight(true);
        }
    }

    public String getModelSign() {
        return "model";
    }

    protected void initSingleMemberF7(List<String> dimkeys, SingleF7TypeEnum f7type) {
        HashMap f7map = Maps.newHashMapWithExpectedSize((int)16);
        if (dimkeys == null) {
            dimkeys = Lists.newArrayListWithExpectedSize((int)16);
        }
        dimkeys.forEach(dimkey -> f7map.put(dimkey, f7type));
        this.initSingleMemberF7(f7map);
    }

    public void onGetControl(OnGetControlArgs e) {
        this.getBcmControl(e);
        String f7Key = e.getKey();
        String pagekey = e.getKey();
        if (this.getDimKeysFromCache().containsKey(f7Key)) {
            Control ctrl;
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
            Map f7Key2Dim = null;
            if (StringUtils.isNotEmpty((String)this.getPageCache().get(F7KEY2DIM))) {
                f7Key2Dim = (Map)this.deSerializedBytes(this.getPageCache().get(F7KEY2DIM));
                String string = f7Key = f7Key2Dim != null && StringUtils.isNotEmpty((String)((String)f7Key2Dim.get(f7Key))) ? (String)f7Key2Dim.get(f7Key) : f7Key;
            }
            if ((ctrl = this.cacheControls.get(f7Key)) != null) {
                e.setControl(ctrl);
            } else {
                BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), f7Key, pagekey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                f7.setDisplayProp("name");
                e.setControl((Control)f7);
                this.cacheControls.put(pagekey, (Control)f7);
            }
        }
    }

    private Map<String, SingleF7TypeEnum> getDimKeysFromCache() {
        if (this.map == null) {
            String searialDimKeys = this.getPageCache().get("dimKeyMap2Type");
            this.map = StringUtils.isNotEmpty((String)searialDimKeys) ? (Map)this.deSerializedBytes(searialDimKeys) : new HashMap(0);
        }
        return this.map;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)16);
            }
            qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            this.getBcmEntityType(e);
        } else {
            super.getEntityType(e);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView mainView;
        Tab tab;
        super.beforeClosed(e);
        if (GuidePageUtils.isFromGuide(this.getView()) && this.getView().getPageId().startsWith("&guidemain") && (tab = (Tab)this.getView().getMainView().getControl("_submaintab_")) != null && "tabpageap".equals(tab.getCurrentTab()) && (mainView = this.getView().getMainView()) != null && mainView.getFormShowParameter().getCustomParam("from_guide_page") != null) {
            HashMap<String, String> arg = new HashMap<String, String>(16);
            arg.put("pageId", mainView.getPageId());
            ((IClientViewProxy)mainView.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        }
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescriotion) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Deprecated
    public void writeOperationLog(String opName, String objNumber, String objName, String result) {
        this.writeLog(opName, objNumber + " " + objName + "," + opName + ResManager.loadKDString((String)result, (String)"AbstractBaseFormPlugin_5", (String)"AbstractBaseBasicPlugIn_0", (Object[])new Object[0]));
    }

    public void writeOperationLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        this.writeMultiLangLog(opNameBridge, opDescBridge);
    }

    @Deprecated
    public void writeLogWithEntityNumber(String entityNumber, String opName, String opDescriotion) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescriotion, (Long)modelId, (String)entityNumber);
        logService.addLog(logInfo);
    }

    public void writeLogWithEntityNumber(String entityNumber, OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)this.getModelId(), (String)entityNumber);
        logService.addLog(logInfo);
    }

    @Deprecated
    public void writeSuccessLogWithEntityNumber(String entityNumber, String opName, String objNumber) {
        this.writeLogWithEntityNumber(entityNumber, opName, String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"AbstractBaseBasicPlugIn_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), objNumber, opName));
    }

    public void writeSuccessLogWithEntityNumber(String entityNumber, OpNameMultiLangEnumBridge opNameBridge, String objNumber) {
        this.writeLogWithEntityNumber(entityNumber, opNameBridge, new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", "AbstractBaseBasicPlugIn_1", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{objNumber, opNameBridge.getDescription()})));
    }
}

