/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.permission.cache.BcmPermSingleModel;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.business.util.OperationLogUtil;
import kd.fi.bcm.common.MessageConstant;
import kd.fi.bcm.common.annotation.SDKMark;
import kd.fi.bcm.common.cache.GlobalCacheServiceHelper;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.enums.status.ResultStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.oplog.IWatchableClickPlugin;
import kd.fi.bcm.common.oplog.IWatchableItemClickPlugin;
import kd.fi.bcm.common.oplog.OPDescMultiLangEnumBridge;
import kd.fi.bcm.common.oplog.OpNameMultiLangEnumBridge;
import kd.fi.bcm.common.proxy.ITransationHandle;
import kd.fi.bcm.common.proxy.Interceptor;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThreadCacheUtil;
import kd.fi.bcm.formplugin.BCMBaseFunction;
import kd.fi.bcm.formplugin.IOperationLog;
import kd.fi.bcm.formplugin.PluginClickProxy;
import kd.fi.bcm.formplugin.PluginItemClickProxy;
import kd.fi.bcm.formplugin.cslscheme.CslSchemeUtils;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.guidemenu.GuidePageUtils;
import kd.fi.bcm.formplugin.model.ModelList;
import kd.fi.bcm.formplugin.pageinteraction.DynamicPage;
import kd.fi.bcm.formplugin.template.model.IPageCacheProxy;
import kd.fi.bcm.formplugin.template.model.ISupportPageCacheProxy;
import kd.fi.bcm.formplugin.util.OrgUtils;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@SDKMark
public abstract class AbstractBaseListPlugin
extends AbstractListPlugin
implements IOperationLog,
BeforeF7SelectListener,
BCMBaseFunction,
IWatchableClickPlugin,
IWatchableItemClickPlugin,
ISupportPageCacheProxy {
    protected static final String F7KEY2DIM = "f7Key2Dim";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    protected Map<String, Control> cacheControls = new CaseInsensitiveMap();
    protected boolean isInitF7BySelected = true;
    protected static final String TREE_CACHE_MAP = "treeCacheMap";
    private IPageCache pageCacheProxy = null;
    private IPageCacheProxy.PageCacheProxy proxy;
    private static Set<String> excludeView = Sets.newHashSet((Object[])new String[]{"bcm_invrelation_set"});
    private Map<String, SingleF7TypeEnum> map;
    protected static final String scenario = "scenario";
    protected static final String year = "year";
    protected static final String period = "period";
    protected static final String model = "model";
    protected static final String cslscheme = "cslscheme";
    protected static final String entity = "entity";
    private boolean isInitFormViewInterceptor = false;
    private boolean isPrint = false;

    public void initialize() {
        super.initialize();
        this.bcmInit();
        ThreadCacheUtil.putCurrentAppId((IFormView)this.getView());
        Optional.ofNullable(this.getView()).map(IFormView::getPageCache).ifPresent(pageCache -> pageCache.put("BOS.setRowDataByNumberDisable", "true"));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LangListDataProvider());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("toolbarap");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.isSingleF7() && this.getControl("currency") instanceof BasedataEdit && (basedataEdit = (BasedataEdit)this.getControl("currency")) != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    protected String gainGroupId() {
        return (String)ThreadCache.get((Object)"groupid", () -> {
            String groupId = this.getPageCache().get("groupId");
            if (StringUtil.isEmptyString((String)groupId)) {
                groupId = UUID.randomUUID().toString().replaceAll("-", "");
                this.getPageCache().put("groupId", groupId);
            }
            return groupId;
        });
    }

    public boolean isSingleF7() {
        return false;
    }

    public String getModelSign() {
        return model;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCSLScheme(e);
        if (this.getModelId() != 0L) {
            this.hideATAndCT(this.getView(), "bcm_audittrialmembertree", this.isExistAuditTrailDimension());
            this.hideATAndCT(this.getView(), "bcm_changetypemembertree", this.isExistChangeTypeDimension());
        }
        this.setF7Disable();
        this.hideNoModelPermButton();
    }

    public void setCSLScheme(EventObject e) {
        String entity = "";
        boolean isTrue = true;
        boolean isFalse = false;
        if (e.getSource() instanceof BillList) {
            entity = ((BillList)e.getSource()).getEntityId();
        } else if (e.getSource() instanceof IListView) {
            entity = ((IListView)e.getSource()).getBillFormId();
        } else if (e.getSource() instanceof IFormView) {
            entity = ((IFormView)e.getSource()).getEntityId();
        }
        if ((this.isCM() || this.isRPT()) && this.getView().getControl(cslscheme) != null) {
            String formId = this.getView().getFormShowParameter().getFormId();
            if (formId.equals("bcm_singlemember") || formId.equals("bcm_singlemember_root") || formId.equals("bcm_singlemember_rate")) {
                if ("bcm_cslscheme".equals(entity) || "bcm_entitymembertree".equals(entity)) {
                    if (GuidePageUtils.isFromGuide(this.getView()) || this.isCMModel()) {
                        this.getView().setVisible(Boolean.valueOf(isTrue), new String[]{cslscheme});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{cslscheme});
                    }
                } else {
                    this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{cslscheme});
                }
            } else if (GuidePageUtils.isFromGuide(this.getView()) || this.isCMModel()) {
                this.getView().setVisible(Boolean.valueOf(isTrue), new String[]{cslscheme});
            } else {
                this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{cslscheme});
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opKey = evt.getItemKey();
        this.checkPerm(opKey);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        this.checkPerm(opkey);
    }

    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey);
        if (perm == null) {
            return;
        }
        this.doCheckPermission(perm[0], perm[1]);
        this.doCheckUnionPerm(perm);
    }

    protected String[] getPerm(String opkey) {
        Map map;
        opkey = this.getPermOpKey(opkey);
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            map = (Map)permitem.get(parameter.getBillFormId());
            if (map == null) {
                map = (Map)permitem.get(this.getPermEntity(this.getView().getEntityId()));
            }
        } else {
            map = (Map)permitem.get(this.getPermEntity(this.getView().getEntityId()));
        }
        if (map == null || map.get(opkey) == null) {
            return null;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return null;
        }
        return perm;
    }

    protected void doCheckPermission(String entityNum, String permItemId) {
        long modelId = this.getModelId();
        if (Objects.equals(modelId, 0L) && !(this instanceof ModelList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        this.doCheckPermission(entityNum, permItemId, modelId, this.getBizAppId());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.doCheckPermission(this.getView().getEntityId(), "4715a0df000000ac");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String entityId = this.getView().getEntityId();
        this.doCheckPermission(entityId, "47150e89000000ac");
    }

    public String getPermOpKey(String opKey) {
        return opKey;
    }

    public String getPermEntity(String entityId) {
        return entityId;
    }

    protected void delPerm4TreeNode(TreeNodeEvent arg0) {
    }

    protected void initSingleMemberF7(List<String> dimkeys, SingleF7TypeEnum f7type) {
        HashMap f7map = Maps.newHashMapWithExpectedSize((int)16);
        if (dimkeys == null) {
            dimkeys = Lists.newArrayListWithExpectedSize((int)16);
        }
        dimkeys.forEach(dimkey -> f7map.put(dimkey, f7type));
        this.initSingleMemberF7(f7map);
    }

    public void onGetControl(final OnGetControlArgs e) {
        this.getBcmControl(e);
        String f7Key = e.getKey();
        String pagekey = e.getKey();
        if (this.getDimKeysFromCache().containsKey(f7Key)) {
            Control ctrl;
            SingleF7TypeEnum type = this.getDimKeysFromCache().get(f7Key);
            Map f7Key2Dim = null;
            if (StringUtils.isNotEmpty((String)this.getPageCache().get(F7KEY2DIM))) {
                f7Key2Dim = (Map)this.deSerializedBytes(this.getPageCache().get(F7KEY2DIM));
                String string = f7Key = f7Key2Dim != null && StringUtils.isNotEmpty((String)((String)f7Key2Dim.get(f7Key))) ? (String)f7Key2Dim.get(f7Key) : f7Key;
            }
            if ((ctrl = this.cacheControls.get(f7Key)) != null) {
                e.setControl(ctrl);
            } else {
                BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.getBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getModelId(), f7Key, pagekey, ev -> this.getSingleMemberF7Handle(Lists.newArrayList(this.getDimKeysFromCache().keySet())).beforeSingleMemberF7Select(ev), false, type);
                f7.setDisplayProp("name");
                f7.setCustomData(this.getF7CustomData(f7Key));
                f7.addBasedataFuzzySearchListener(new BasedataFuzzySearchListener(){

                    public void handleData(BasedataFuzzySearchEvent arg0) {
                        List<Object> queryData = arg0.getQueryData();
                        boolean isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)String.valueOf(AbstractBaseListPlugin.this.getModelId()));
                        if (!e.getKey().equals("account") && !isAdmin) {
                            SysDimensionEnum entityEnum = SysDimensionEnum.getEnumByLowerCaseNumber((String)e.getKey());
                            List ids = queryData.stream().map(data -> ConvertUtil.convertObjToLong(((List)data).get(0))).collect(Collectors.toList());
                            Set noPermIds = AbstractBaseListPlugin.this.getPermService(AbstractBaseListPlugin.this.getModelId()).matchNoPermMembers(Long.valueOf(AbstractBaseListPlugin.this.getDimId(entityEnum.getNumber())), entityEnum.getMemberTreemodel(), ids);
                            queryData = queryData.stream().filter(data -> !noPermIds.contains(ConvertUtil.convertObjToLong(((List)data).get(0)))).collect(Collectors.toList());
                        }
                        if (e.getKey().equals(AbstractBaseListPlugin.entity)) {
                            queryData = OrgUtils.resetBasedataFuzzySearchResult2Org(AbstractBaseListPlugin.this.getModelId(), ((BasedataEditSingleMemberF7)((Object)arg0.getSource())).getCustomData(), queryData);
                        }
                        arg0.setQueryData((List)queryData);
                        if (queryData != null && queryData.size() > 0) {
                            queryData.sort(new Comparator<Object>(){

                                @Override
                                public int compare(Object o1, Object o2) {
                                    if (o1 instanceof AbstractList && o2 instanceof AbstractList) {
                                        AbstractList o1temp = (AbstractList)o1;
                                        AbstractList o2temp = (AbstractList)o2;
                                        return ((String)o1temp.get(1)).compareTo((String)o2temp.get(1));
                                    }
                                    return 0;
                                }
                            });
                        }
                    }
                });
                e.setControl((Control)f7);
                this.cacheControls.put(pagekey, (Control)f7);
            }
        }
    }

    protected Map<String, Object> getF7CustomData(String f7Key) {
        return null;
    }

    protected Map<String, SingleF7TypeEnum> getDimKeysFromCache() {
        if (this.map == null) {
            String serialDimKeys = this.getPageCache().get("dimKeyMap2Type");
            this.map = StringUtils.isNotEmpty((String)serialDimKeys) ? (Map)this.deSerializedBytes(serialDimKeys) : new HashMap(0);
        }
        return this.map;
    }

    protected void refreshBillByUserSelect(List<String> dimKeys, Boolean isOnlyLeaf) {
        if (GuidePageUtils.refreshBillByUserSelect4List(dimKeys, this.getView())) {
            return;
        }
        if (!this.isInitF7BySelected) {
            return;
        }
        String modelId = UserSelectUtil.getModelIdAfterCreateNewData(this.getView(), model);
        if (StringUtils.isEmpty((String)modelId)) {
            this.getPageCache().put("KEY_MODEL_ID", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4f53\u7cfb\u53ef\u4ee5\u4f7f\u7528\u3002", (String)"AbstractBaseListPlugin_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        } else {
            ApplicationTypeEnum application;
            this.getModel().setValue(model, (Object)modelId);
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(modelId), this.getApplicationType());
            ArrayList<String> dimensions = new ArrayList<String>(10);
            for (String key : dimKeys) {
                dimensions.add(UserSelectUtil.getDimensionByKey(key));
                dimensions.add(UserSelectUtil.getDimensionByKey(key) + ".membermodel");
                dimensions.add(key + ".isleaf");
            }
            String selectFields = UserSelectUtil.buildOtherSelectFileds(dimensions);
            DynamicObject userSelect = UserSelectUtil.getUserSelectDynamicObject(selectFields, application = ModelUtil.queryApp(this.getView()));
            if (userSelect == null || !modelId.equals(userSelect.getString(model))) {
                return;
            }
            this.getModel().beginInit();
            PermissionService permSerivce = PermissionServiceImpl.getInstance((Long)LongUtil.toLong((Object)modelId));
            for (String key : dimKeys) {
                try {
                    boolean isNoPerm;
                    SysDimensionEnum dim;
                    Long memberId = userSelect.getLong(key);
                    if (memberId == 0L || !QueryServiceHelper.exists((String)(dim = SysDimensionEnum.getEnumByLowerCaseNumber((String)key)).getMemberTreefrom(), (QFilter[])QFilter.of((String)"model = ? and id = ?", (Object[])new Object[]{Long.valueOf(modelId), memberId}).toArray()) || (isNoPerm = permSerivce.isAllNoPerm(Long.valueOf(userSelect.getLong(UserSelectUtil.getDimensionByKey(key))), userSelect.getString(UserSelectUtil.getDimensionByKey(key) + ".membermodel"), (Collection)Lists.newArrayList((Object[])new Long[]{memberId}))) || isOnlyLeaf.booleanValue() && !userSelect.getBoolean(key + ".isleaf")) continue;
                    this.getModel().setValue(key, (Object)memberId);
                    this.getPageCache().put(key, String.valueOf(memberId));
                }
                catch (Exception e) {
                    log.error(String.format("Model %1$s userSelect get dim %2$s error", modelId, key));
                }
            }
            this.getModel().endInit();
        }
    }

    public void setIsInitF7BySelected(boolean flag) {
        this.isInitF7BySelected = flag;
    }

    protected void propertyChangedModelUse(List<String> dimKeys) {
        String modelId = UserSelectUtil.getF7SelectId(this.getView(), model);
        if (modelId == null) {
            this.getPageCache().put("chooseBackModel", "true");
            this.getModel().setValue(model, (Object)this.getPageCache().get("KEY_MODEL_ID"));
        } else {
            if (modelId.equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                return;
            }
            this.getPageCache().put("KEY_MODEL_ID", modelId);
            SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(modelId), this.getApplicationType());
            SingleMemberF7Util.cacheDimPrem(this.getPageCache(), Long.valueOf(modelId), dimKeys);
            Map<String, String> userselectMap = UserSelectUtil.getUserSelectMapById(modelId, "issummury,id,model,model.id,isadjustlisttype,application,entity,year,period,scenario,currency,modifier,modifydate,onlymodel,formid,version,cslscheme,dmmodel", this.getApplicationType(), dimKeys);
            this.getModel().beginInit();
            for (String key : dimKeys) {
                if (userselectMap.isEmpty()) {
                    this.getModel().setValue(key, null);
                    continue;
                }
                this.getModel().setValue(key, "0".equals(userselectMap.get(key)) ? null : userselectMap.get(key));
            }
            this.getModel().endInit();
            for (String key : dimKeys) {
                this.getView().updateView(key);
            }
        }
        UserSelectUtil.saveUserSelectWhenModelChange(this.getView(), modelId);
    }

    protected Boolean propertyChangedDimUse(String key, DynamicObject newValue, Boolean isOnlyLeaf, Boolean hasCurrency) {
        Boolean isSureReturn = Boolean.TRUE;
        if (scenario.equals(key) || year.equals(key) || period.equals(key) || hasCurrency.booleanValue() && "currency".equals(key) || entity.equals(key) || "version".equals(key)) {
            isSureReturn = SingleMemberF7Util.isSureReturn(this.getPageCache(), key, newValue, isOnlyLeaf);
            if (!isSureReturn.booleanValue()) {
                this.getModel().beginInit();
                this.getModel().setValue(key, null);
                this.getModel().endInit();
                this.getView().updateView();
            }
            UserSelectModel userSelectModel = new UserSelectModel();
            if (scenario.equals(key)) {
                boolean hasSPConfig = DimensionServiceHelper.checkSPConfig((boolean)false, (DynamicObject)newValue, (long)this.getModelId(), (IDataModel)this.getModel(), (String)period);
                userSelectModel.setSPConfig(hasSPConfig);
            }
            this.savetUserSelectWhenOtherChange(key, userSelectModel);
        }
        return isSureReturn;
    }

    protected boolean validator() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId) || !LongUtil.isvalidLong((Object)Long.parseLong(modelId))) {
            if (ThreadCache.get((Object)"modelchange") == null) {
                this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            }
            return false;
        }
        return true;
    }

    @Override
    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    @Override
    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    @Override
    @Deprecated
    public void writeLog(String opName, String opDescription) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)this.getModelId(), (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Override
    public void writeMultiLangLog(OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        long modelId = this.getModelId();
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)modelId, (String)this.getBizEntityNumber());
        logService.addLog(logInfo);
    }

    @Deprecated
    public void writeSuccessLog(String opName, String objNumber) {
        String prefix = ResManager.loadKDString((String)"\u7f16\u53f7", (String)"AbstractBaseListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDescription = String.format("%s%s\uff0c%s%s", prefix, objNumber, opName, ResultStatusEnum.SUCCESS.getName());
        this.writeLog(opName, opDescription);
    }

    public void writeSuccessLog(OpNameMultiLangEnumBridge opName, String objNumber) {
        OPDescMultiLangEnumBridge opDesc = new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c%2$s%3$s", "AbstractBaseListPlugin_20", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{objNumber, opName.getDescription(), ResultStatusEnum.SUCCESS.getName()}));
        this.writeMultiLangLog(opName, opDesc);
    }

    @Deprecated
    public void writeFailLog(String opName, String objNumber) {
        String prefix = ResManager.loadKDString((String)"\u7f16\u53f7", (String)"AbstractBaseListPlugin_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        String opDescription = String.format("%s%s\uff0c%s%s", prefix, objNumber, opName, ResultStatusEnum.FAIL.getName());
        this.writeLog(opName, opDescription);
    }

    public void writeFailLog(OpNameMultiLangEnumBridge opNameBridge, String objNumber) {
        this.writeMultiLangLog(opNameBridge, new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s,%2$s\u5931\u8d25", "AbstractBaseListPlugin_19", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{objNumber, opNameBridge.getDescription()})));
    }

    @Deprecated
    public void writeLogWithEntityNumber(String entityNumber, String opName, String opDescription) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((String)opName, (String)opDescription, (Long)this.getModelId(), (String)entityNumber);
        logService.addLog(logInfo);
    }

    public void writeLogWithEntityNumber(String entityNumber, OpNameMultiLangEnumBridge opNameBridge, OPDescMultiLangEnumBridge opDescBridge) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = OperationLogUtil.buildLogInfo((OpNameMultiLangEnumBridge)opNameBridge, (OPDescMultiLangEnumBridge)opDescBridge, (Long)this.getModelId(), (String)entityNumber);
        logService.addLog(logInfo);
    }

    public void writeOperationLog(String opName, String objNumber, String objName, String result) {
        this.writeLog(opName, String.format(ResManager.loadKDString((String)"%1$s %2$s,%3$s%4$s", (String)"AbstractBaseListPlugin_15", (String)"fi-bcm-formplugin", (Object[])new Object[0]), objNumber, objName, opName, result));
    }

    public void writeOperationLog(String opName, String result) {
        this.writeLog(opName, String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"AbstractBaseListPlugin_16", (String)"fi-bcm-formplugin", (Object[])new Object[0]), opName, result));
    }

    public void writeSuccessLogWithEntityNumber(String entityNumber, String opName, String objNumber) {
        OpNameMultiLangEnumBridge opNameMultiLangEnumBridge = new OpNameMultiLangEnumBridge("\u7f16\u53f7", "AbstractBaseListPlugin_6", "fi-bcm-formplugin", "number");
        OPDescMultiLangEnumBridge opDescMultiLangEnumBridge = new OPDescMultiLangEnumBridge("\u7f16\u53f7%1$s,%2$s\u6210\u529f", "AbstractBaseListPlugin_18", "fi-bcm-formplugin", OPDescMultiLangEnumBridge.genBridgeArgs((String[])new String[]{objNumber, opName}));
        this.writeLogWithEntityNumber(entityNumber, opNameMultiLangEnumBridge, opDescMultiLangEnumBridge);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List qFilterList;
        ListShowParameter showParameter;
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter2 = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilterList2 = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList2 == null) {
                qFilterList2 = Lists.newArrayListWithExpectedSize((int)16);
            }
            qFilterList2.addAll(ModelUtil.getModelFilter(this.getView()));
            showParameter2.setListFilterParameter(new ListFilterParameter(qFilterList2, null));
        }
        if (this.isSingleF7() && ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("currency")) {
            Object modelDyn = this.getModel().getValue(this.getModelSign());
            if (modelDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = Lists.newArrayListWithExpectedSize((int)16);
                }
                qFilterList.add(new QFilter("number", "not in", (Object)new Object[]{"PC", "Currency"}));
                qFilterList.add(new QFilter(model, "=", ((DynamicObject)modelDyn).get("id")));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
        if (this.isCM() && !excludeView.contains(this.getView().getEntityId()) && ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(cslscheme) && this.getDimKeysFromCache().containsKey(scenario) && beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
            Object sceneDy = this.getModel().getValue(scenario);
            if (sceneDy == null) {
                return;
            }
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            qFilterList = ((BasedataEdit)this.getControl(cslscheme)).getQFilters();
            if (qFilterList == null) {
                qFilterList = Lists.newArrayListWithExpectedSize((int)10);
            }
            long modelId = ((DynamicObject)sceneDy).getLong("model.id");
            qFilterList.add(new QFilter(model, "=", (Object)modelId));
            qFilterList.add(new QFilter("id", "in", (Object)DimensionServiceHelper.buildCslschemeFilter((long)modelId, (long)((DynamicObject)sceneDy).getLong("id"))));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.bcmPreOpen(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.bcmProChange(e);
        String name = e.getProperty().getName();
        if (model.equals(name)) {
            this.hideNoModelPermButton();
            this.checkGradeOrgScheme();
        } else if (scenario.equals(name)) {
            this.setCslValueOfByScene(name);
        }
    }

    protected void setCslValueOfByScene(String key) {
        String formId = this.getView().getFormShowParameter().getFormId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = entityType.getProperties();
        List propertyScene = properties.stream().filter(x -> x instanceof BasedataProp && "bcm_scenemembertree".equals(((BasedataProp)x).getBaseEntityId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(propertyScene) || !key.equals(((IDataEntityProperty)propertyScene.get(0)).getName())) {
            return;
        }
        List propertyCsl = properties.stream().filter(x -> x instanceof BasedataProp && "bcm_cslscheme".equals(((BasedataProp)x).getBaseEntityId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(propertyCsl)) {
            String name = ((IDataEntityProperty)propertyCsl.get(0)).getName();
            Object csl = this.getModel().getValue(name);
            Object scene = this.getModel().getValue(key);
            if (csl instanceof DynamicObject && scene instanceof DynamicObject) {
                long sceId = ((DynamicObject)scene).getLong("id");
                long modelId = ((DynamicObject)scene).getLong("model.id");
                List cslIds = DimensionServiceHelper.buildCslschemeFilter((long)modelId, (long)sceId);
                if (!cslIds.contains(((DynamicObject)csl).getLong("id"))) {
                    this.getModel().setValue(name, null);
                }
            }
        }
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            this.getBcmEntityType(e);
        } else {
            super.getEntityType(e);
        }
    }

    protected void invokeOperation(String entityName, String pluginPath, String name, String closeCallBackKey) {
        FormShowParameter showParameter = new FormShowParameter();
        if ("bcm_enum_import".equals(entityName)) {
            showParameter.setFormId("bcm_importstart_enum");
        } else {
            showParameter.setFormId("bos_importstart");
        }
        HashMap parameter = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList plugins = Lists.newArrayListWithExpectedSize((int)1);
        LinkedHashMap plugin = Maps.newLinkedHashMapWithExpectedSize((int)6);
        plugin.put("Type", 0);
        plugin.put("_Type_", "Plugin");
        plugin.put("ClassName", pluginPath);
        plugin.put("Enabled", Boolean.TRUE);
        plugin.put("rowKey", null);
        plugin.put("modelid", this.getModelId());
        plugins.add(plugin);
        parameter.put("plugins", plugins);
        parameter.putAll(this.getCustomParam2Import());
        showParameter.setCustomParams((Map)parameter);
        showParameter.setCustomParam("BillFormId", (Object)entityName);
        showParameter.setCustomParam("ListName", (Object)name);
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("RealPermissionEntityId", (Object)"bcm_permissionclass");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackKey));
        this.getView().showForm(showParameter);
    }

    protected Map<String, Object> getCustomParam2Import() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        return map;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    protected void initCslschemeValue(String modelId, boolean forceCover) {
        CslSchemeUtils.setDefaultCslSchemeValue(modelId, forceCover, this.getView());
        if (this.getPageCache().get("excludeRate") != null && this.getPageCache().get("excludeRate").equals("true")) {
            IDataModel dataModel = this.getView().getModel();
            if (dataModel.getValue(cslscheme) == null) {
                return;
            }
            Long cslSchemeId = ((DynamicObject)dataModel.getValue(cslscheme)).getLong("id");
            DynamicObject dynamicObjectRate = QueryServiceHelper.queryOne((String)"bcm_cslscheme", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cslSchemeId)});
            if ("DefaultRateScheme".equals(dynamicObjectRate.getString("number"))) {
                this.getView().getModel().setValue(cslscheme, null);
            }
        }
        this.getView().updateView(cslscheme);
    }

    protected void saveUserChangedCslscheme(DynamicObject newValue) {
        if (newValue != null) {
            this.savetUserSelectWhenOtherChange(cslscheme, new UserSelectModel());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView mainView;
        Tab tab;
        super.beforeClosed(e);
        if (GuidePageUtils.isFromGuide(this.getView()) && this.getView().getPageId().startsWith("&guidemain") && (tab = (Tab)this.getView().getMainView().getControl("_submaintab_")) != null && "tabpageap".equals(tab.getCurrentTab()) && (mainView = this.getView().getMainView()) != null && mainView.getFormShowParameter().getCustomParam("from_guide_page") != null) {
            HashMap<String, String> arg = new HashMap<String, String>(16);
            arg.put("pageId", mainView.getPageId());
            ((IClientViewProxy)mainView.getService(IClientViewProxy.class)).addAction("closeWindow", arg);
        }
    }

    protected void checkGradeOrgScheme() {
        if (this.isEPM() || this.isFIDM()) {
            return;
        }
        Object modelObj = this.getModel().getValue(model);
        if (modelObj instanceof DynamicObject) {
            DynamicObject modelDyn = (DynamicObject)modelObj;
            long modelId = modelDyn.getLong("id");
            String cacheKey = "checkGradeOrgScheme" + modelId;
            boolean existsScheme = (Boolean)GlobalCacheServiceHelper.getOrLoadFromCommonCache((String)cacheKey, () -> {
                Object exists = AppCacheServiceHelper.get((String)cacheKey);
                if (exists == null || "false".equals(exists)) {
                    DynamicObject[] orgs;
                    DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
                    String type = model.getString("reporttype");
                    if (!ApplicationTypeEnum.RPT.getOIndex().equals(type) && (orgs = UpgradeServiceHelper.getOrgLevel2List((long)modelId)).length > 0) {
                        QFilter filters = QFilter.of((String)"model = ?", (Object[])new Object[]{modelId});
                        if (QueryServiceHelper.exists((String)"bcm_cslscheme", (QFilter[])filters.toArray())) {
                            AppCacheServiceHelper.put((String)cacheKey, (Object)"true");
                            return true;
                        }
                        AppCacheServiceHelper.put((String)cacheKey, (Object)"false");
                        return false;
                    }
                }
                return true;
            });
            if (!existsScheme) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u5165\u3010\u5e94\u7528\u4f53\u7cfb\u5217\u8868\u3011\u5347\u7ea7\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"AbstractBaseListPlugin_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected boolean checkPeriodStatus(long model, String orgNumber, long scenario, long year, long period, String statusField) {
        return PeriodSettingHelper.checkPeriodStatus((long)model, (String)orgNumber, (long)scenario, (long)year, (long)period, (String)statusField);
    }

    protected void cacheTree(DynamicObjectCollection rootNodecollection) {
        HashMap treeCacheMap = Maps.newHashMapWithExpectedSize((int)16);
        if (rootNodecollection != null) {
            for (DynamicObject dyn : rootNodecollection) {
                treeCacheMap.put(dyn.getString("number"), dyn.getString("name"));
            }
        }
        this.getPageCache().put(TREE_CACHE_MAP, ObjectSerialUtil.toByteSerialized((Object)treeCacheMap));
    }

    private long getDimId(String number) {
        QFBuilder range = new QFBuilder("number", "=", (Object)number);
        range.and(model, "=", (Object)this.getModelId());
        DynamicObject cache = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (String)"id", (QFilter[])range.toArray());
        if (cache != null) {
            return cache.getLong("id");
        }
        return 0L;
    }

    public String getCurModelNumber() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return "";
        }
        String modelNumber = MemberReader.findModelNumberById((Object)modelId);
        return StringUtils.isNull((String)modelNumber) ? "" : modelNumber;
    }

    public String getSourceKey() {
        return this.getBizEntityNumber();
    }

    public void addClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addClickListener((ClickListener)new PluginClickProxy(this));
        }
    }

    public void addItemClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addItemClickListener((ItemClickListener)new PluginItemClickProxy(this));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.getControl(this.getModelSign()) == null) {
            return;
        }
        DynamicObject modelDyn = (DynamicObject)this.getModel().getValue(this.getModelSign());
        if (Objects.isNull(modelDyn)) {
            return;
        }
        long modelId = modelDyn.getLong("id");
        List columns = args.getListColumns();
        for (IListColumn column : columns) {
            if (column.getListFieldKey().startsWith("audittrial") || column.getListFieldKey().startsWith("audittrail")) {
                if (this.isExistAuditTrailDimension(modelId)) {
                    column.setVisible(63);
                } else {
                    column.setVisible(0);
                }
            }
            if (!column.getListFieldKey().startsWith("changetype")) continue;
            if (this.isExistChangeTypeDimension(modelId)) {
                column.setVisible(63);
                continue;
            }
            column.setVisible(0);
        }
    }

    @Override
    public void setSingleF7Filter(BasedataEditSingleMemberF7 bdEdit) {
        Long sceneId;
        BCMBaseFunction.super.setSingleF7Filter(bdEdit);
        if (DimTypesEnum.ENTITY.getNumber().equalsIgnoreCase(bdEdit.getDimNumber()) && (sceneId = OrgUtils.getF7Id(this.getModel(), scenario)) != null && sceneId != 0L) {
            if (bdEdit.getCustomData() == null) {
                bdEdit.setCustomData(new HashMap<String, Object>(1));
            }
            bdEdit.getCustomData().put("scenarioId", sceneId);
        }
    }

    @Override
    public Set<Long> unionPermEntityIds() {
        String id = null;
        HashSet<Long> entityIds = new HashSet<Long>(16);
        IDataEntityProperty entityProperty = (IDataEntityProperty)this.getView().getModel().getDataEntityType().getProperties().get((Object)entity);
        if (entityProperty instanceof BasedataProp) {
            id = UserSelectUtil.getF7SelectId(this.getView(), entity);
        }
        if (!StringUtils.isEmpty(id)) {
            entityIds.add(Long.valueOf(id));
        }
        return entityIds;
    }

    protected OrgTreeNode initOrgTree(long modelId, String showType, boolean isShowRate, boolean isOpened) {
        return this.initOrgTree(modelId, showType, isShowRate, isOpened, null);
    }

    protected OrgTreeNode initOrgTree(long modelId, String showType, boolean isShowRate, boolean isOpened, Predicate<IDNumberTreeNode> filterCondition) {
        HashMap need2RemoveNodes = Maps.newHashMapWithExpectedSize((int)16);
        List orgNodes = this.getOrgNodes(modelId, filterCondition, need2RemoveNodes);
        return this.createRootOrgTreeNode(modelId, need2RemoveNodes, orgNodes, showType, isShowRate, isOpened);
    }

    protected OrgTreeNode createRootOrgTreeNode(long modelId, Map<String, List<Long>> need2RemoveNodes, List<IDNumberTreeNode> orgNodes, String showType, boolean isShowRate, boolean isOpened) {
        IDNumberTreeNode root = null;
        for (IDNumberTreeNode node : orgNodes) {
            if (node.getParent() != null) continue;
            root = node;
            break;
        }
        if (root == null) {
            return null;
        }
        Long cslShemeId = OrgUtils.getF7Id(this.getModel(), cslscheme);
        boolean showNoMergeOrg = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM030");
        return TreeBuilder.createOrgTreeNode((long)modelId, (boolean)showNoMergeOrg, need2RemoveNodes, (IDNumberTreeNode)root, (String)showType, (Long)cslShemeId, (boolean)isShowRate, (boolean)isOpened);
    }

    @Override
    public IPageCache getPageCache() {
        if (this.isOpenPageCacheProxy()) {
            if (this.pageCacheProxy == null) {
                IPageCacheProxy.PageCacheProxy proxy2 = (IPageCacheProxy.PageCacheProxy)this.getView().getService(IPageCacheProxy.class);
                if (proxy2 == null) {
                    proxy2 = new IPageCacheProxy.PageCacheProxy(super.getPageCache());
                    this.getView().addService(IPageCacheProxy.class, (Object)proxy2);
                }
                this.pageCacheProxy = proxy2.getProxy();
                this.proxy = proxy2;
                this.getView().addService(IPageCache.class, (Object)this.pageCacheProxy);
            }
            return this.pageCacheProxy;
        }
        return super.getPageCache();
    }

    protected void forcePushCache() {
        if (this.proxy != null) {
            this.beforeDestroy();
            this.proxy.pushCache();
        }
    }

    protected void beforeDestroy() {
    }

    public void setView(final IFormView formView) {
        IFormView bcmFormView = formView;
        if (formView != null && !formView.getClass().getName().contains("CGLIB") && ApplicationTypeEnum.RPT.getAppnum().equals(formView.getFormShowParameter().getAppId()) && ConfigServiceHelper.getGlobalBoolParam((String)"isHideNoPermButton")) {
            bcmFormView = (IFormView)new Interceptor((Object)formView, new ITransationHandle(){

                public void beforeTransation(Method method, Object[] args) {
                    if ("setVisible".equals(method.getName()) && !AbstractBaseListPlugin.this.isHidingNoModelPermButton()) {
                        String[] buttonArray;
                        Map bizVisibleFromPageCache = AbstractBaseListPlugin.this.getBizVisibleFromPageCache();
                        Boolean isShow = (Boolean)args[0];
                        for (String buttonKey : buttonArray = (String[])args[1]) {
                            bizVisibleFromPageCache.put(buttonKey, isShow);
                        }
                        AbstractBaseListPlugin.this.updateBizVisibleFromPageCache(bizVisibleFromPageCache);
                        if (isShow.booleanValue()) {
                            Set noModelPermButtonKey = AbstractBaseListPlugin.this.getNoModelPermButtonKeyFromPageCache();
                            HashSet<String> showButton = new HashSet<String>(16);
                            for (String key : buttonArray) {
                                if (noModelPermButtonKey.contains(key)) continue;
                                showButton.add(key);
                            }
                            if (!showButton.isEmpty()) {
                                args[1] = showButton.toArray(new String[1]);
                            }
                        }
                    }
                }

                public void afterTransation(Method method, Object[] args) {
                    Set noModelPermButtonKey;
                    Boolean isShow;
                    if ("setVisible".equals(method.getName()) && !AbstractBaseListPlugin.this.isHidingNoModelPermButton() && (isShow = (Boolean)args[0]).booleanValue() && !(noModelPermButtonKey = AbstractBaseListPlugin.this.getNoModelPermButtonKeyFromPageCache()).isEmpty()) {
                        formView.setVisible(Boolean.FALSE, noModelPermButtonKey.toArray(new String[1]));
                    }
                }
            }).createProxy();
        }
        super.setView(bcmFormView);
        if (this.isOpenPageCacheProxy()) {
            if (this.isInitFormViewInterceptor) {
                return;
            }
            this.getPageCache();
            if (formView != null) {
                final FormViewPluginProxy viewProxy = (FormViewPluginProxy)formView.getService(FormViewPluginProxy.class);
                if (viewProxy != null && !viewProxy.getClass().getName().contains("CGLIB")) {
                    FormViewPluginProxy proxyService = (FormViewPluginProxy)new Interceptor((Object)viewProxy, new ITransationHandle(){

                        public void beforeTransation(Method method, Object[] args) {
                        }

                        public void afterTransation(Method method, Object[] args) {
                            if ("fireClosedCallBack".equals(method.getName()) || "fireConfirmedCallBack".equals(method.getName())) {
                                for (IFormPlugin pl : viewProxy.getPlugIns()) {
                                    if (!ISupportPageCacheProxy.class.isAssignableFrom(pl.getClass())) continue;
                                    ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).destory();
                                }
                            }
                        }
                    }).createProxy();
                    proxyService.registerPlugins(viewProxy.getPlugIns());
                    formView.addService(FormViewPluginProxy.class, (Object)proxyService);
                }
                this.isInitFormViewInterceptor = true;
            }
        }
    }

    @Override
    public void pushCache() {
        this.forcePushCache();
    }

    public void destory() {
        if (this.proxy != null) {
            this.forcePushCache();
            this.getView().addService(IPageCache.class, (Object)this.proxy.getOriginalPageCache());
            log.info(String.format("class[%s],bcm-pageCache-monitor-->%s", this.getClass().getSimpleName(), this.proxy.toJsonMonitor()));
        }
        if (this.isPrint) {
            return;
        }
        super.destory();
        this.isPrint = true;
    }

    @Override
    public boolean isOpenPageCacheProxy() {
        return ConfigServiceHelper.getGlobalBoolParam((String)"isOpenPageCacheProxy") || "1".equals(ConfigurationUtil.getString((String)"bcm.isOpenPageCacheProxy"));
    }

    public static class LangListDataProvider
    extends ListDataProvider {
    }
}

