/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.ListIterator;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.portal.plugin.BizAppHomePlugin;
import kd.fi.bcm.business.preload.DataPreLoadServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.util.BcmDLockUtil;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.formplugin.AppHome.BcmMenuUpgradeHelper;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.compress.utils.Sets;

public class BcmAppHomePlugin
extends BizAppHomePlugin {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(BcmAppHomePlugin.class);

    public void createNewData(BizDataEventArgs e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("_submaintab_");
        if (tab != null) {
            tab.addTabCloseListener(tabCloseEvent -> tabCloseEvent.getTabKeys().forEach(BcmDLockUtil::unLockOpenReport));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showMenuDescription();
        this.preLoadData();
    }

    private void preLoadData() {
        try {
            DataPreLoadServiceHelper.preLoadMembersByConfig();
        }
        catch (Throwable e) {
            log.error("preLoadMember error:", e);
        }
    }

    private void showMenuDescription() {
        Long userId = this.getUserId();
        String showMenuUpgradeDescription = BcmMenuUpgradeHelper.getMenuUpgradeDescription(userId, "bcm");
        if (!StringUtil.isEmptyString((String)showMenuUpgradeDescription)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bcm_menutext");
            parameter.setCustomParam("textField", (Object)showMenuUpgradeDescription);
            parameter.setCustomParam("apptype", (Object)"bcm");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    public void renderNavigation(JSONArray menuArray, JSONArray qingArray) {
        this.filterMenu(menuArray);
        super.renderNavigation(menuArray, qingArray);
    }

    public long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    private void filterMenu(JSONArray menus) {
        boolean showOldTaskMenu;
        HashSet hideMenuIdSet;
        boolean isHwApp = ConfigServiceHelper.isHwApp();
        HashSet<String> hideMenuSet = new HashSet<String>();
        if (!isHwApp) {
            hideMenuSet.add("bcm_dynamicreportlist");
            hideMenuSet.add("bcm_form_list");
        }
        if (!ConfigServiceHelper.getGlobalBoolParam((String)"CM062")) {
            hideMenuSet.add("bcm_report_workbenchback");
        }
        HashSet hashSet = hideMenuIdSet = !(showOldTaskMenu = ConfigServiceHelper.getGlobalBoolParam((String)ConfigEnum.IS_SHOW_OLDTASK.getNumber())) ? Sets.newHashSet((Object[])new String[]{"WWFNVF0X3GE"}) : Collections.emptySet();
        if (!showOldTaskMenu) {
            hideMenuSet.add("bcm_tasklist");
        }
        ListIterator it = menus.listIterator();
        while (it.hasNext()) {
            JSONObject jsonObject = (JSONObject)it.next();
            String formId = jsonObject.getString("formid");
            if (hideMenuSet.contains(formId)) {
                it.remove();
            }
            if (!hideMenuIdSet.contains(jsonObject.getString("id"))) continue;
            it.remove();
        }
    }
}

