/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.model.UserSelectModel;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.serviceHelper.AppCacheServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.util.TransMemberUtil;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.dimension.util.ModelUtil;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.formplugin.util.UserSelectUtil;
import kd.fi.bcm.spread.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class CardFinancial
extends AbstractBaseFormPlugin
implements RowClickEventListener,
SingleMemberF7Util.ISingleMemberF7Handle,
BeforeF7SelectListener {
    private WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());
    public static final String PROCESS_BALANCESHEET_RATE = "progresszcfzbl";
    public static final String PROCESS_LDBL = "progressldbl";
    public static final String PROCESS_CQBL = "progresscqbl";
    public static final String PROCESS_XSMLL = "progressxsmll";
    public static final String PROCESS_XSJLL = "progressxsjll";
    public static final String DASHBOARD_FORMLUA_VALUES_CACHE_NAME = "DASHBOARD_FORMLUA_VALUES_CACHE_NAME";
    public static final String MODEL = "model";
    public static final String ENTITY = "entity";
    public static final String YEAR = "year";
    public static final String PERIOD = "period";
    public static final String CURRENCY = "currency";
    public static final String ID = "id";
    private Map<String, Object> mdResultMap;
    private Map<String, Object> formulaValues;
    private DynamicObject userSelectObj;
    private static final List<String> f7keys = Lists.newArrayList((Object[])new String[]{"entity", "year", "period", "currency"});
    private static final String PROCESS_EIRPT = "EIRPT";
    private String[] quantificats = new String[]{"", ResManager.loadKDString((String)"\u5343", (String)"CardFinancial_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"CardFinancial_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e\u4e07", (String)"CardFinancial_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])};
    private static final String[] strColl = new String[]{"R1050", "R1099", "R1150", "R1199"};

    @Override
    public void initialize() {
        super.initialize();
        HashMap map = new HashMap();
        this.asMapF7toType(f7keys, SingleF7TypeEnum.LEAF, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners("btn_add", "btn_setvalues", "btn_refresh", "btn_edit", "btn_del");
        CardEntry entryentityfi = (CardEntry)this.getControl("menuentry_fi");
        entryentityfi.addRowClickListener((RowClickEventListener)this);
        for (String s : f7keys) {
            BasedataEdit base = (BasedataEdit)this.getControl(s);
            if (base == null) continue;
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit base = (BasedataEdit)this.getControl(MODEL);
        if (base != null) {
            base.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent arg0) {
                    ListShowParameter l = (ListShowParameter)arg0.getFormShowParameter();
                    List f = l.getListFilterParameter().getQFilters();
                    ApplicationTypeEnum sign = ModelUtil.queryApp(CardFinancial.this.getView());
                    QFilter qf = ApplicationTypeEnum.CM == sign ? new QFilter("ReportType", "=", (Object)"1") : new QFilter("ReportType", "!=", (Object)"3");
                    QFilter superid = new QFilter(CardFinancial.ID, "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                    QFilter perRoleids = new QFilter(CardFinancial.ID, "in", (Object)BcmFunPermissionHelper.getFuncAuthModel((long)Long.parseLong(RequestContext.get().getUserId()), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(CardFinancial.this.getView()), (String)CardFinancial.this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)Boolean.FALSE, (boolean)Boolean.TRUE));
                    qf.and(superid.or(perRoleids));
                    if (f != null) {
                        f.add(qf);
                    } else {
                        ArrayList<QFilter> lq = new ArrayList<QFilter>();
                        lq.add(qf);
                        l.getListFilterParameter().setQFilters(lq);
                    }
                }
            });
        }
        BasedataEdit baseentity = (BasedataEdit)this.getControl(ENTITY);
        baseentity.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent arg0) {
                if (arg0.getFormShowParameter() instanceof ListShowParameter) {
                    ListShowParameter l = (ListShowParameter)arg0.getFormShowParameter();
                    List f = l.getListFilterParameter().getQFilters();
                    ApplicationTypeEnum sign = ModelUtil.queryApp(CardFinancial.this.getView());
                    if (ApplicationTypeEnum.CM == sign) {
                        QFilter qf = new QFilter("storagetype", "=", (Object)StorageTypeEnum.STORAGE.index);
                        if (f != null) {
                            f.add(qf);
                        } else {
                            ArrayList<QFilter> lq = new ArrayList<QFilter>();
                            lq.add(qf);
                            l.getListFilterParameter().setQFilters(lq);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.setDefaultByModelSelect();
            ApplicationTypeEnum sign = ModelUtil.queryApp(this.getView());
            if (this.getModel().getValue(MODEL) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CardFinancial_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
            Long modelid = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
            QFilter filter = new QFilter(ID, "=", (Object)modelid).and("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
            boolean isRpt = QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{filter});
            if (ApplicationTypeEnum.RPT == sign && isRpt) {
                this.initDashboard();
                this.presetNewData();
            }
        }
        catch (KDBizException e1) {
            this.getView().showTipNotification(e1.getMessage());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ArrayList list2;
        super.propertyChanged(e);
        if (MODEL.equals(e.getProperty().getName())) {
            this.getModel().beginInit();
            for (String s : f7keys) {
                this.getModel().setValue(s, null);
            }
            this.getModel().endInit();
            for (String s : f7keys) {
                this.getView().updateView(s);
            }
            DynamicObject d = (DynamicObject)this.getModel().getValue(MODEL);
            String id = d == null ? "0" : d.getString(ID);
            this.getPageCache().put("KEY_MODEL_ID", id);
        }
        if ((list2 = Lists.newArrayList((Object[])new String[]{MODEL, ENTITY, YEAR, PERIOD, CURRENCY})).contains(e.getProperty().getName())) {
            UserSelectModel usermodel = new UserSelectModel();
            usermodel.setApplication(ModelUtil.queryApp(this.getView()));
            String currency = UserSelectUtil.getF7SelectId(this.getView(), CURRENCY);
            usermodel.setCurrency(currency);
            String model = UserSelectUtil.getF7SelectId(this.getView(), MODEL);
            usermodel.setModel(model);
            String entity = UserSelectUtil.getF7SelectId(this.getView(), ENTITY);
            usermodel.setOrg(entity);
            String period = UserSelectUtil.getF7SelectId(this.getView(), PERIOD);
            usermodel.setPeriod(period);
            String year = UserSelectUtil.getF7SelectId(this.getView(), YEAR);
            usermodel.setYear(year);
            usermodel.setModifier(RequestContext.getOrCreate().getUserId());
            UserSelectUtil.savetUserSelect(usermodel);
            ApplicationTypeEnum sign = ModelUtil.queryApp(this.getView());
            QFilter filter = new QFilter(ID, "=", (Object)LongUtil.toLong((Object)usermodel.getModel())).and("reporttype", "=", (Object)ApplicationTypeEnum.RPT.getOIndex());
            boolean isRpt = QueryServiceHelper.exists((String)"bcm_model", (QFilter[])new QFilter[]{filter});
            if (ApplicationTypeEnum.RPT == sign && isRpt) {
                this.presetNewData();
            }
            if (!(StringUtils.isEmpty((String)currency) || StringUtils.isEmpty((String)model) || StringUtils.isEmpty((String)entity) || StringUtils.isEmpty((String)period) || StringUtils.isEmpty((String)year))) {
                this.refreshDimenRow();
            } else {
                this.getModel().deleteEntryData("menuentry_fi");
            }
        }
    }

    private void refreshDimenRow() {
        boolean isFasle = false;
        ArrayList list = Lists.newArrayList((Object[])new String[]{ENTITY, YEAR, PERIOD, CURRENCY});
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        QFilter qf = new QFilter("creator", "=", (Object)userId);
        if (this.getModel().getValue(MODEL) == null) {
            return;
        }
        long modelId = ((DynamicObject)this.getModel().getValue(MODEL)).getLong(ID);
        QFilter modelqfilter = new QFilter(MODEL, "=", (Object)modelId);
        qf.and(modelqfilter);
        String selectfields = "currency.number,currency.name,id,account,account.number,audittrail.number,changetype.number,internalcompany.number,process.number,scenario.number,multigaap.number,userdefined1.number,mycompany.number,datasort.number,userdefined2.number,userdefined3.number,userdefined4.number,userdefined5.number,userdefined6.number,userdefined1.dimension.number,userdefined2.dimension.number,userdefined3.dimension.number,userdefined4.dimension.number,userdefined5.dimension.number,userdefined6.dimension.number,unit";
        DynamicObjectCollection dot = QueryServiceHelper.query((String)"bcm_dimensionselect", (String)selectfields, (QFilter[])new QFilter[]{qf}, (String)"createtime");
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData("menuentry_fi");
        if (dot != null && dot.size() > 0) {
            Long orgId;
            AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("value", new Object[0]);
            vs.addField("account", new Object[0]);
            vs.addField("billselect", new Object[0]);
            vs.addField("unit", new Object[0]);
            DynamicObjectCollection dimencol = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,issysdimension,shortnumber", (QFilter[])new QFilter[]{modelqfilter});
            HashMap<String, DynamicObject> sysdimen = new HashMap<String, DynamicObject>();
            HashMap<String, DynamicObject> notsysdimen = new HashMap<String, DynamicObject>();
            int userd = 0;
            for (DynamicObject d : dimencol) {
                if (d.getBoolean("issysdimension")) {
                    sysdimen.put(d.getString("number").toLowerCase(Locale.ENGLISH), d);
                    continue;
                }
                notsysdimen.put("userdefined" + ++userd, d);
            }
            String orgcurrencynum = null;
            if (this.getModel().getValue(CURRENCY) == null || this.getModel().getValue(ENTITY) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"CardFinancial_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String pageCurrency = ((DynamicObject)this.getModel().getValue(CURRENCY)).getString("number");
            Long l = orgId = this.getModel().getValue(ENTITY) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(ENTITY)).getLong(ID));
            if ("EC".equals(pageCurrency)) {
                Long yearId = this.getModel().getValue(YEAR) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(YEAR)).getLong(ID));
                Long periodId = this.getModel().getValue(PERIOD) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(PERIOD)).getLong(ID));
                DynamicObject currencyObj = null;
                if (orgId != null && yearId != null && periodId != null) {
                    currencyObj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId);
                }
                orgcurrencynum = currencyObj == null ? pageCurrency : currencyObj.getString("number");
            } else if ("DC".equals(pageCurrency)) {
                orgcurrencynum = (String)TransMemberUtil.transOrgAndCurbyOrgId((long)modelId, (long)orgId.longValue(), (String)PROCESS_EIRPT, (String)pageCurrency, (long)0L, (long)0L).p2;
                if (StringUtils.isEmpty((String)orgcurrencynum)) {
                    orgcurrencynum = pageCurrency;
                }
            } else {
                orgcurrencynum = pageCurrency;
            }
            for (DynamicObject d : dot) {
                Map.Entry obj2;
                BigDecimal big = null;
                SQLBuilder sql = new SQLBuilder(((DynamicObject)this.getModel().getValue(MODEL)).getString("number"));
                for (Map.Entry obj2 : notsysdimen.entrySet()) {
                    String dimennumber;
                    String trueNum = ((DynamicObject)obj2.getValue()).getString("number");
                    if (trueNum.equals(dimennumber = d.getString((String)obj2.getKey() + ".dimension.number"))) {
                        sql.addFilter(dimennumber, new String[]{d.getString((String)obj2.getKey() + ".number")});
                        continue;
                    }
                    sql.addFilter(trueNum, new String[]{((DynamicObject)obj2.getValue()).getString("shortnumber") + "None"});
                }
                boolean issearch = true;
                obj2 = sysdimen.entrySet().iterator();
                while (obj2.hasNext()) {
                    Map.Entry obj3 = (Map.Entry)obj2.next();
                    String dimensionnumber = ((DynamicObject)obj3.getValue()).getString("number");
                    if (list.contains(dimensionnumber.toLowerCase(Locale.ENGLISH))) {
                        if ("Currency".equals(dimensionnumber)) {
                            sql.addFilter(dimensionnumber, new String[]{orgcurrencynum});
                            continue;
                        }
                        if (this.getModel().getValue(dimensionnumber.toLowerCase(Locale.ENGLISH)) == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"CardFinancial_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        sql.addFilter(dimensionnumber, new String[]{((DynamicObject)this.getModel().getValue(dimensionnumber.toLowerCase(Locale.ENGLISH))).getString("number")});
                        continue;
                    }
                    if (d.getString((String)obj3.getKey() + ".number") == null) {
                        issearch = false;
                        continue;
                    }
                    sql.addFilter(dimensionnumber, new String[]{d.getString((String)obj3.getKey() + ".number")});
                }
                sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                sql.addSelectField(new String[]{"Account"});
                if (issearch) {
                    try {
                        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
                        while (set.next()) {
                            big = set.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField());
                        }
                    }
                    catch (Throwable throwable) {
                        this.getView().showTipNotification(ThrowableHelper.toString((Throwable)throwable));
                    }
                }
                if (big == null) {
                    big = BigDecimal.valueOf(0.0);
                }
                DecimalFormat df = new DecimalFormat("###,##0.00");
                DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bcm_currencymembertree");
                currency.set("number", (Object)d.getString("currency.number"));
                currency.set("name", (Object)d.getString("currency.name"));
                Object[] obj4 = this.getUnit(d.getString("unit"), big, currency);
                vs.addRow(new Object[]{df.format(obj4[1]), d.getLong("account"), d.getLong(ID), obj4[0]});
            }
            model.batchCreateNewEntryRow("menuentry_fi", vs);
            model.endInit();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"menuentry_fi"});
            this.getView().updateView("menuentry_fi");
        } else {
            this.getView().setVisible(Boolean.valueOf(isFasle), new String[]{"menuentry_fi"});
        }
    }

    private Object[] getUnit(String dunit, BigDecimal big, DynamicObject currency) {
        String realunit = currency.getString("name");
        if (StringUtil.equals((String)"CNY", (String)currency.getString("number"))) {
            realunit = ResManager.loadKDString((String)"\u5143", (String)"CardFinancial_4", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
        }
        int[] dunits = new int[]{1000, 10000, 1000000};
        String unit = String.format("(%s%s)", this.quantificats[Integer.parseInt(dunit) - 1], realunit);
        if (big != null && Integer.parseInt(dunit) >= 2) {
            big = big.divide(new BigDecimal(dunits[Integer.parseInt(dunit) - 2]));
        }
        return new Object[]{unit, big};
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getModel().getValue(MODEL) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CardFinancial_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
        switch (key) {
            case "btn_add": {
                this.OpenDimensionSelect(0L);
                break;
            }
            case "btn_setvalues": {
                this.openSelectValuesForm();
                break;
            }
            case "btn_refresh": {
                this.initDashboard();
                this.refreshDimenRow();
                break;
            }
            case "btn_edit": {
                if (!this.checkDimension()) break;
                this.showEditDimension();
                break;
            }
            case "btn_del": {
                int[] rows;
                if (!this.checkDimension() || (rows = this.getSelectRow()) == null) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664\u9009\u4e2d\u7684\u5361\u7247\u5417\uff1f", (String)"CardFinancial_12", (String)"fi-bcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("del", (IFormPlugin)this));
                break;
            }
        }
    }

    private boolean checkDimension() {
        Long currency;
        IDataModel formmodel = this.getModel();
        Long model = formmodel.getValue(MODEL) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(MODEL)).getLong(ID));
        Long entity = formmodel.getValue(ENTITY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(ENTITY)).getLong(ID));
        Long year = formmodel.getValue(YEAR) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(YEAR)).getLong(ID));
        Long period = formmodel.getValue(PERIOD) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(PERIOD)).getLong(ID));
        Long l = currency = formmodel.getValue(CURRENCY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(CURRENCY)).getLong(ID));
        if (model == null || entity == null || year == null || period == null || currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7ef4\u5ea6\u3002", (String)"CardFinancial_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void showEditDimension() {
        int[] selectRow = this.getSelectRow();
        if (selectRow != null && selectRow.length == 1) {
            IDataModel dataModel = this.getModel();
            Long pkId = ((DynamicObject)dataModel.getValue("billselect", selectRow[0])).getLong(ID);
            this.OpenDimensionSelect(pkId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (!StringUtils.isEmpty((String)callBackId) && "del".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            int[] rows = this.getSelectRow();
            IDataModel dataModel = this.getModel();
            if (rows != null) {
                ArrayList<Object> pkIds = new ArrayList<Object>(rows.length);
                for (int row : rows) {
                    Object pkId = ((DynamicObject)dataModel.getValue("billselect", row)).get(ID);
                    pkIds.add(pkId);
                }
                DeleteServiceHelper.delete((String)"bcm_dimensionselect", (QFilter[])new QFilter(ID, "in", pkIds).toArray());
                this.getModel().beginInit();
                this.initDashboard();
                this.refreshDimenRow();
                this.getModel().endInit();
                this.getView().updateView("menuentry_fi");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CardFinancial_13", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int[] getSelectRow() {
        CardEntry entryentityfi = (CardEntry)this.getControl("menuentry_fi");
        int[] selectRows = entryentityfi.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            return selectRows;
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("dimensionselectcloseaction".equals(actionId)) {
            Object returndata = closedCallBackEvent.getReturnData();
            if (returndata != null) {
                Map returnmap = (Map)returndata;
                if (((Boolean)returnmap.get("addrow")).booleanValue()) {
                    this.addDimenRow(returnmap);
                } else if (((Boolean)returnmap.get("needRefresh")).booleanValue()) {
                    this.refreshDimenRow();
                }
            }
        } else if ("valuesFormClosed".equals(actionId)) {
            this.initDashboard();
        }
    }

    private void addDimenRow(Map<String, Object> returnmap) {
        boolean isTrue = true;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        BigDecimal value = (BigDecimal)returnmap.get("money");
        Long account = (Long)returnmap.get("Account");
        Long billselectid = (Long)returnmap.get("billselect");
        String dunit = (String)returnmap.get("unit");
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)returnmap.get(CURRENCY), (String)"bcm_currencymembertree");
        Object[] obj = this.getUnit(dunit, value, currency);
        IDataModel dataModel = this.getModel();
        int index = dataModel.createNewEntryRow("menuentry_fi");
        dataModel.setValue("value", (Object)df.format(obj[1]), index);
        dataModel.setValue("account", (Object)account, index);
        dataModel.setValue("billselect", (Object)billselectid, index);
        dataModel.setValue("unit", obj[0], index);
        this.getView().setVisible(Boolean.valueOf(isTrue), new String[]{"menuentry_fi"});
    }

    private void OpenDimensionSelect(Long billselect) {
        String periodnumber;
        Long currency;
        Long period;
        Long year;
        Long entity;
        Long model;
        IDataModel formmodel = this.getModel();
        String currencynumber = null;
        Long l = model = formmodel.getValue(MODEL) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(MODEL)).getLong(ID));
        if (model == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardFinancial_5", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long l2 = entity = formmodel.getValue(ENTITY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(ENTITY)).getLong(ID));
        if (entity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardFinancial_6", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long l3 = year = formmodel.getValue(YEAR) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(YEAR)).getLong(ID));
        if (year == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d22\u5e74\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardFinancial_7", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long l4 = period = formmodel.getValue(PERIOD) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(PERIOD)).getLong(ID));
        if (period == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardFinancial_8", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long l5 = currency = formmodel.getValue(CURRENCY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(CURRENCY)).getLong(ID));
        if (currency == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CardFinancial_9", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
            return;
        }
        String entitynumber = formmodel.getValue(ENTITY) == null ? null : ((DynamicObject)formmodel.getValue(ENTITY)).getString("number");
        String yearnumber = formmodel.getValue(YEAR) == null ? null : ((DynamicObject)formmodel.getValue(YEAR)).getString("number");
        String string = periodnumber = formmodel.getValue(PERIOD) == null ? null : ((DynamicObject)formmodel.getValue(PERIOD)).getString("number");
        if ("EC".equals(((DynamicObject)this.getModel().getValue(CURRENCY)).getString("number"))) {
            DynamicObject currencyobj = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)entity, (Long)year, (Long)period);
            if (currencyobj == null) {
                currency = formmodel.getValue(CURRENCY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(CURRENCY)).getLong(ID));
                currencynumber = formmodel.getValue(CURRENCY) == null ? null : ((DynamicObject)formmodel.getValue(CURRENCY)).getString("number");
            } else {
                currency = formmodel.getValue(CURRENCY) == null ? null : Long.valueOf(currencyobj.getLong(ID));
                currencynumber = formmodel.getValue(CURRENCY) == null ? null : currencyobj.getString("number");
            }
        } else {
            currency = formmodel.getValue(CURRENCY) == null ? null : Long.valueOf(((DynamicObject)formmodel.getValue(CURRENCY)).getLong(ID));
            currencynumber = formmodel.getValue(CURRENCY) == null ? null : ((DynamicObject)formmodel.getValue(CURRENCY)).getString("number");
        }
        BaseShowParameter base = new BaseShowParameter();
        base.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimensionselectcloseaction"));
        base.getOpenStyle().setShowType(ShowType.Modal);
        if (billselect != 0L) {
            base.setPkId((Object)billselect);
            base.setCustomParam("pkid", (Object)billselect);
            base.setBillStatus(BillOperationStatus.EDIT);
        } else {
            base.setBillStatus(BillOperationStatus.ADDNEW);
        }
        base.setCustomParam(ENTITY, (Object)entity);
        base.setCustomParam(YEAR, (Object)year);
        base.setCustomParam(PERIOD, (Object)period);
        base.setCustomParam(CURRENCY, (Object)currency);
        base.setCustomParam("entitynumber", (Object)entitynumber);
        base.setCustomParam("yearnumber", (Object)yearnumber);
        base.setCustomParam("periodnumber", (Object)periodnumber);
        base.setCustomParam("currencynumber", (Object)currencynumber);
        base.setCustomParam(MODEL, (Object)model);
        base.setFormId("bcm_dimensionselect");
        this.getView().showForm((FormShowParameter)base);
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        if (this.getModel().getValue(MODEL) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CardFinancial_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (this.getModel().getValue(MODEL) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"CardFinancial_10", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setDefaultByModelSelect() {
        boolean isFalse = false;
        UserSelectModel um = UserSelectUtil.getUserSelectAfterCreateNewData(this.getView(), MODEL, false);
        if (um == null) {
            return;
        }
        Set funcAuthModel = BcmFunPermissionHelper.getFuncAuthModel((long)RequestContext.get().getCurrUserId(), (String)"bcm_model", (ApplicationTypeEnum)ModelUtil.queryApp(this.getView()), (String)this.getView().getEntityId(), (String)"47150e89000000ac", (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
        if (CollectionUtils.isEmpty((Collection)funcAuthModel) || !funcAuthModel.contains(LongUtil.toLong((Object)um.getModel()))) {
            return;
        }
        this.getModel().setValue(MODEL, (Object)um.getModel());
        this.getPageCache().put("KEY_MODEL_ID", um.getModel());
        this.getModel().setValue(ENTITY, (Object)um.getOrg());
        this.getModel().setValue(YEAR, (Object)um.getYear());
        this.getModel().setValue(PERIOD, (Object)um.getPeriod());
        this.getModel().setValue(CURRENCY, (Object)um.getCurrency());
        if (StringUtils.isNotEmpty((String)um.getOrg()) && StringUtils.isNotEmpty((String)um.getYear()) && StringUtils.isNotEmpty((String)um.getPeriod()) && StringUtils.isNotEmpty((String)um.getCurrency())) {
            this.refreshDimenRow();
        } else {
            this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{"menuentry_fi"});
        }
    }

    private void presetNewData() {
        DynamicObject d = (DynamicObject)this.getModel().getValue(MODEL);
        Long modelId = d == null ? 0L : d.getLong(ID);
        if (modelId == 0L) {
            return;
        }
        this.getPageCache().put("modelId", modelId.toString());
        String userID = RequestContext.get().getUserId();
        QFilter qcreate = new QFilter("creator", "=", (Object)Long.valueOf(userID));
        QFilter qmodel = new QFilter("model.id", "=", (Object)modelId);
        if (QueryServiceHelper.exists((String)"bcm_dimensionselect", (QFilter[])new QFilter[]{qmodel, qcreate})) {
            return;
        }
        Long scenarioId = this.getDimMemberId("bcm_scenemembertree", modelId, "MRpt");
        if (scenarioId == 0L) {
            return;
        }
        Long processId = this.getDimMemberId("bcm_processmembertree", modelId, "IRpt");
        if (processId == 0L) {
            return;
        }
        Long audittrailId = 0L;
        if (this.isExistAuditTrailDimension() && (audittrailId = this.getDimMemberId("bcm_audittrialmembertree", modelId, "EntityInput")) == 0L) {
            return;
        }
        Long changetypeId = 0L;
        if (this.isExistChangeTypeDimension() && (changetypeId = this.getDimMemberId("bcm_changetypemembertree", modelId, "EndingBalance")) == 0L) {
            return;
        }
        Long internalcompanyId = this.getDimMemberId("bcm_icmembertree", modelId, "ICNone");
        if (internalcompanyId == 0L) {
            return;
        }
        Long mycompanyId = this.getDimMemberId("bcm_mycompanymembertree", modelId, "MCNone");
        Date date = TimeServiceHelper.now();
        Map<String, Long> dimMember = this.getDimMemberId("bcm_accountmembertree", modelId, strColl);
        ArrayList<DynamicObject> dyLst = new ArrayList<DynamicObject>();
        IDataEntityType dataEntityType = null;
        Long accountId = 0L;
        for (int i = 0; i < strColl.length; ++i) {
            accountId = dimMember.get(strColl[i]);
            if (accountId == null || accountId == 0L) continue;
            DynamicObject dyNewObj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionselect");
            if (dataEntityType == null) {
                dataEntityType = dyNewObj.getDataEntityType();
            }
            dyNewObj.set("account", (Object)accountId);
            dyNewObj.set(MODEL, (Object)modelId);
            dyNewObj.set("scenario", (Object)scenarioId);
            dyNewObj.set("process", (Object)processId);
            DynamicObject curr = (DynamicObject)this.getModel().getValue(CURRENCY);
            Long currencyid = curr == null ? 0L : curr.getLong(ID);
            dyNewObj.set(CURRENCY, (Object)currencyid);
            if (this.isExistAuditTrailDimension()) {
                dyNewObj.set("audittrail", (Object)audittrailId);
            }
            if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)modelId))) {
                dyNewObj.set("changetype", (Object)changetypeId);
            }
            dyNewObj.set("internalcompany", (Object)internalcompanyId);
            dyNewObj.set("mycompany", (Object)mycompanyId);
            dyNewObj.set("unit", (Object)1);
            dyNewObj.set("creator", (Object)userID);
            dyNewObj.set("createtime", (Object)date);
            dyLst.add(dyNewObj);
        }
        if (dataEntityType == null || dyLst.isEmpty()) {
            return;
        }
        SaveServiceHelper.save(dataEntityType, (Object[])dyLst.toArray(new DynamicObject[dyLst.size()]));
    }

    private Long getDimMemberId(String entityNumber, Long modelId, String number) {
        String cacheKey = entityNumber + String.valueOf(modelId) + number;
        String cacheValue = this.getPageCache().get(cacheKey);
        if (cacheValue != null) {
            return Long.valueOf(cacheValue);
        }
        QFilter qModelId = new QFilter("model.id", "=", (Object)modelId);
        QFilter qNumber = new QFilter("number", "=", (Object)number);
        DynamicObject dyObj = QueryServiceHelper.queryOne((String)entityNumber, (String)ID, (QFilter[])new QFilter[]{qModelId, qNumber});
        Long DimId = dyObj == null ? 0L : dyObj.getLong(ID);
        if (DimId > 0L) {
            this.getPageCache().put(cacheKey, String.valueOf(DimId));
        }
        return DimId;
    }

    private Map<String, Long> getDimMemberId(String entityNumber, Long modelId, String[] numbers) {
        HashMap<String, Long> dimMember = new HashMap<String, Long>();
        QFilter qModelId = new QFilter("model.id", "=", (Object)modelId);
        QFilter qNumber = new QFilter("number", "in", (Object)numbers);
        DynamicObjectCollection dyObj = QueryServiceHelper.query((String)entityNumber, (String)"number,id", (QFilter[])new QFilter[]{qModelId, qNumber});
        if (dyObj == null) {
            return dimMember;
        }
        for (DynamicObject obj : dyObj) {
            dimMember.put(obj.getString("number"), obj.getLong(ID));
        }
        return dimMember;
    }

    private void initMdResultMap() {
        String modelNumber;
        QFilter qf1 = new QFilter("modifier", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter qf2 = new QFilter("application", "=", (Object)String.valueOf(ModelUtil.queryApp((IFormView)this.getView()).index));
        QFilter qf3 = new QFilter("formid", "=", (Object)"report_card_financialdata");
        this.userSelectObj = BusinessDataServiceHelper.loadSingle((String)"bcm_userselect", (String)"id,model,application,entity,year,period,scenario,currency", (QFilter[])new QFilter[]{qf1, qf2, qf3});
        if (this.userSelectObj == null) {
            return;
        }
        Object entity = this.userSelectObj.get(ENTITY);
        if (entity == null) {
            return;
        }
        String orgNumber = ((DynamicObject)entity).getString("number");
        try {
            String modelId = ((DynamicObject)this.userSelectObj.get(MODEL)).getString(ID);
            modelNumber = QueryDimensionServiceHelper.getModelNumber((long)Long.parseLong(modelId));
        }
        catch (Exception ex) {
            this.logger.error("\u52a0\u8f7d\u4f53\u7cfb\u5931\u8d25\uff01", (Throwable)ex);
            return;
        }
        String recentFYear = ((DynamicObject)this.userSelectObj.get(YEAR)).getString("number");
        String recentPeriod = ((DynamicObject)this.userSelectObj.get(PERIOD)).getString("number");
        String[] currencies = new String[]{"CNone", ((DynamicObject)this.userSelectObj.get(CURRENCY)).getString("number")};
        SQLBuilder sb = new SQLBuilder(modelNumber);
        sb.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sb.addFilter("Entity", new String[]{orgNumber});
        sb.addFilter("Year", new String[]{recentFYear});
        sb.addFilter("Period", new String[]{recentPeriod});
        sb.addFilter("Scenario", new String[]{"MRpt"});
        sb.addFilter("Process", new String[]{"IRpt"});
        sb.addFilter("Currency", currencies);
        sb.addFilter("AuditTrail", new String[]{"EntityInput"});
        sb.addSelectField(new String[]{"ChangeType", "Account"});
        try {
            this.mdResultMap = OlapServiceHelper.queryData((SQLBuilder)sb).asMap();
        }
        catch (Exception ex) {
            this.logger.error("\u62a5\u8868\u5de5\u4f5c\u53f0\u67e5\u8be2\u591a\u7ef4\u6570\u636e\u5e93\u5931\u8d25\u3002", (Throwable)ex);
        }
    }

    private void drawAllPies() {
        String r1200 = "R1200";
        String r1100 = "R1100";
        double divNum = 0.0;
        divNum = this.getValueByAP("R1100", "EndingBalance");
        if (divNum > 0.0) {
            this.drawPie(PROCESS_BALANCESHEET_RATE, (int)(this.getValueByAP("R1200", "EndingBalance") / divNum * 100.0), Double.parseDouble(this.formulaValues.get(PROCESS_BALANCESHEET_RATE).toString()));
        }
        String r1050 = "R1050";
        String r1150 = "R1150";
        divNum = this.getValueByAP("R1150", "EndingBalance");
        if (divNum > 0.0) {
            this.drawPie(PROCESS_LDBL, (int)(this.getValueByAP("R1050", "EndingBalance") / divNum * 100.0), Double.parseDouble(this.formulaValues.get(PROCESS_LDBL).toString()));
        }
        String r1299 = "R1299";
        divNum = this.getValueByAP("R1299", "EndingBalance");
        if (divNum > 0.0) {
            this.drawPie(PROCESS_CQBL, (int)(this.getValueByAP("R1200", "EndingBalance") / divNum * 100.0), Double.parseDouble(this.formulaValues.get(PROCESS_CQBL).toString()));
        }
        String r2001 = "R2001";
        String r2002 = "R2002";
        divNum = this.getValueByAP("R2001", "CurrentPeriod");
        if (divNum > 0.0) {
            this.drawPie(PROCESS_XSMLL, (int)((divNum - this.getValueByAP("R2002", "CurrentPeriod")) / divNum * 100.0), Double.parseDouble(this.formulaValues.get(PROCESS_XSMLL).toString()));
        }
        String r2110 = "R2110";
        divNum = this.getValueByAP("R2001", "CurrentPeriod");
        if (divNum > 0.0) {
            this.drawPie(PROCESS_XSJLL, (int)(this.getValueByAP("R2110", "CurrentPeriod") / divNum * 100.0), Double.parseDouble(this.formulaValues.get(PROCESS_XSJLL).toString()));
        }
    }

    private void setFormulaValues() {
        Label tag_zcfz;
        this.formulaValues = (Map)AppCacheServiceHelper.get((String)DASHBOARD_FORMLUA_VALUES_CACHE_NAME, Map.class);
        if (this.formulaValues == null) {
            this.setDefaultFormulaValues();
        }
        if ((tag_zcfz = (Label)this.getView().getControl("tag_zcfzbl")) == null) {
            return;
        }
        tag_zcfz.setText(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u503c\uff1a%s", (String)"CardFinancial_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.decimalToString((Number)this.formulaValues.get(PROCESS_BALANCESHEET_RATE))));
        Label tag_ldbl = (Label)this.getView().getControl("tag_ldbl");
        tag_ldbl.setText(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u503c\uff1a%s", (String)"CardFinancial_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.decimalToString((Number)this.formulaValues.get(PROCESS_LDBL))));
        Label tag_cqbl = (Label)this.getView().getControl("tag_cqbl");
        tag_cqbl.setText(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u503c\uff1a%s", (String)"CardFinancial_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.decimalToString((Number)this.formulaValues.get(PROCESS_CQBL))));
        Label tag_xsmll = (Label)this.getView().getControl("tag_xsmll");
        tag_xsmll.setText(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u503c\uff1a%s", (String)"CardFinancial_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.decimalToString((Number)this.formulaValues.get(PROCESS_XSMLL))));
        Label tag_xsjll = (Label)this.getView().getControl("tag_xsjll");
        tag_xsjll.setText(String.format(ResManager.loadKDString((String)"\u6807\u51c6\u503c\uff1a%s", (String)"CardFinancial_11", (String)"fi-bcm-formplugin", (Object[])new Object[0]), this.decimalToString((Number)this.formulaValues.get(PROCESS_XSJLL))));
    }

    private void setDefaultFormulaValues() {
        this.formulaValues = new LinkedHashMap<String, Object>();
        this.formulaValues.put(PROCESS_BALANCESHEET_RATE, BigDecimal.valueOf(0.7));
        this.formulaValues.put(PROCESS_LDBL, BigDecimal.valueOf(2.0));
        this.formulaValues.put(PROCESS_CQBL, BigDecimal.valueOf(1.2));
        this.formulaValues.put(PROCESS_XSMLL, BigDecimal.valueOf(0.15));
        this.formulaValues.put(PROCESS_XSJLL, BigDecimal.valueOf(0.1));
        AppCacheServiceHelper.put((String)DASHBOARD_FORMLUA_VALUES_CACHE_NAME, this.formulaValues);
    }

    public void drawPie(String controlId, int percent, double baseCount) {
        double baseRate = baseCount * 2.0;
        ProgressBar progresszcfzbl = (ProgressBar)this.getControl(controlId);
        progresszcfzbl.setPercent((int)((double)percent / baseRate), (double)percent / 100.0 + "");
    }

    public double getValueByAP(String account, String changeType) {
        if (MemberReader.isExistChangeTypeDimension((String)MemberReader.findModelNumberById((Object)this.getModelId()))) {
            Object valObj = this.mdResultMap.get(changeType + "|" + account);
            return valObj == null ? 0.0 : Math.abs(Double.parseDouble(valObj.toString()));
        }
        return 0.0;
    }

    private void openSelectValuesForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("report_dashboard_setvalue");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "valuesFormClosed");
        formShowParameter.setCloseCallBack(callBack);
        this.getView().showForm(formShowParameter);
    }

    private void initDashboard() {
        this.setFormulaValues();
        this.initMdResultMap();
        if (this.mdResultMap != null) {
            this.drawAllPies();
        }
    }

    private String decimalToString(Number decimal) {
        DecimalFormat nf = new DecimalFormat();
        ((NumberFormat)nf).setMaximumFractionDigits(4);
        return nf.format(new BigDecimal(decimal.toString()));
    }
}

