/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.formplugin.AppHome;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.convert.util.ConvertUtil;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.common.enums.FacTabFieldDefEnum;
import kd.fi.bcm.common.enums.SingleF7TypeEnum;
import kd.fi.bcm.formplugin.AbstractBaseFormPlugin;
import kd.fi.bcm.formplugin.database.BasedataEditSingleMemberF7;
import kd.fi.bcm.formplugin.util.SingleMemberF7Util;
import kd.fi.bcm.spread.common.util.StringUtil;

public class DimensionSelectPlugin
extends AbstractBaseFormPlugin
implements SingleMemberF7Util.ISingleMemberF7Handle {
    private String[] quantificats = new String[]{"", ResManager.loadKDString((String)"\u5343", (String)"DimensionSelectPlugin_0", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"DimensionSelectPlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e\u4e07", (String)"DimensionSelectPlugin_2", (String)"fi-bcm-formplugin", (Object[])new Object[0])};
    private static final Set<String> notvisiable = Sets.newHashSet((Object[])new String[]{"Entity", "Year", "Period", "Currency"});
    private static final List<String> f7Keys = Lists.newArrayList((Object[])new String[]{"account", "scenario", "process", "audittrail", "changetype", "internalcompany", "multigaap", "mycompany", "datasort", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6"});

    @Override
    public void initialize() {
        super.initialize();
        this.addClickListeners("buttonok");
        HashMap map = new HashMap();
        this.asMapF7toType(f7Keys, SingleF7TypeEnum.COMMON, map);
        this.initSingleMemberF7(map);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean isFalse = false;
        Long model = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        Long entity = (Long)this.getView().getFormShowParameter().getCustomParam("entity");
        Long year = (Long)this.getView().getFormShowParameter().getCustomParam("year");
        Long period = (Long)this.getView().getFormShowParameter().getCustomParam("period");
        Long currency = (Long)this.getView().getFormShowParameter().getCustomParam("currency");
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String yearnumber = (String)this.getView().getFormShowParameter().getCustomParam("yearnumber");
        String periodnumber = (String)this.getView().getFormShowParameter().getCustomParam("periodnumber");
        String currencynumber = (String)this.getView().getFormShowParameter().getCustomParam("currencynumber");
        this.getPageCache().put("KEY_MODEL_ID", model.toString());
        this.getPageCache().put("entity", entity.toString());
        this.getPageCache().put("year", year.toString());
        this.getPageCache().put("period", period.toString());
        this.getPageCache().put("currency", currency.toString());
        this.getPageCache().put("entitynumber", entitynumber);
        this.getPageCache().put("yearnumber", yearnumber);
        this.getPageCache().put("periodnumber", periodnumber);
        this.getPageCache().put("currencynumber", currencynumber);
        this.getModel().setValue("model", (Object)model);
        this.getModel().setValue("currency", (Object)currency);
        DynamicObject currencyDy = (DynamicObject)this.getModel().getValue("currency");
        this.loadCurrency(currencyDy);
        this.getModel().setValue("unit", (Object)1);
        this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{"multigaap", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6"});
        this.setDimensionDefaultValue(model, true);
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        boolean isFalse = false;
        Long model = (Long)this.getView().getFormShowParameter().getCustomParam("model");
        Long entity = (Long)this.getView().getFormShowParameter().getCustomParam("entity");
        Long year = (Long)this.getView().getFormShowParameter().getCustomParam("year");
        Long period = (Long)this.getView().getFormShowParameter().getCustomParam("period");
        Long currency = (Long)this.getView().getFormShowParameter().getCustomParam("currency");
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String yearnumber = (String)this.getView().getFormShowParameter().getCustomParam("yearnumber");
        String periodnumber = (String)this.getView().getFormShowParameter().getCustomParam("periodnumber");
        String currencynumber = (String)this.getView().getFormShowParameter().getCustomParam("currencynumber");
        this.getPageCache().put("KEY_MODEL_ID", model.toString());
        this.getPageCache().put("entity", entity.toString());
        this.getPageCache().put("year", year.toString());
        this.getPageCache().put("period", period.toString());
        this.getPageCache().put("currency", currency.toString());
        this.getPageCache().put("entitynumber", entitynumber);
        this.getPageCache().put("yearnumber", yearnumber);
        this.getPageCache().put("periodnumber", periodnumber);
        this.getPageCache().put("currencynumber", currencynumber);
        this.loadCurrency(BusinessDataServiceHelper.loadSingle((Object)e.getPkId(), (String)"bcm_dimensionselect").getDynamicObject("currency"));
        this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{"multigaap", "userdefined1", "userdefined2", "userdefined3", "userdefined4", "userdefined5", "userdefined6"});
        this.setDimensionDefaultValue(model, false);
        this.getPageCache().put("pkid", this.getView().getFormShowParameter().getCustomParam("pkid").toString());
    }

    private void loadCurrency(DynamicObject currency) {
        if (StringUtil.equals((String)"CNY", (String)currency.getString("number"))) {
            return;
        }
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl("unit");
        ArrayList<ComboItem> dbInstenceItem = new ArrayList<ComboItem>();
        int amount = this.quantificats.length;
        for (int i = 0; i < amount; ++i) {
            ComboItem item = new ComboItem(new LocaleString(String.format("%s%s", this.quantificats[i], currency.getString("name"))), String.valueOf(i + 1));
            dbInstenceItem.add(item);
        }
        dbCombo.setComboItems(dbInstenceItem);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        boolean isTrue = true;
        boolean isFalse = false;
        Button bn = (Button)evt.getSource();
        if ("buttonok".equals(bn.getKey())) {
            Map userdfined = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("userdfined"), HashMap.class);
            Set keypro = userdfined.keySet();
            for (String s : keypro) {
                if (this.getModel().getValue(s) != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u5f55\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionSelectPlugin_3", (String)"fi-bcm-formplugin", (Object[])new Object[0]));
                return;
            }
            String userID = RequestContext.get().getUserId();
            Date date = TimeServiceHelper.getCurrentSystemTime();
            DynamicObject dot = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionselect");
            dot.set("model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            dot.set("creator", (Object)userID);
            dot.set("currency", (Object)this.getPageCache().get("currency"));
            dot.set("createtime", (Object)date);
            dot.set("unit", this.getModel().getValue("unit"));
            QFilter qf1 = new QFilter("1", "=", (Object)1);
            for (String s : keypro) {
                qf1.and(s, "=", (Object)((DynamicObject)this.getModel().getValue(s)).getLong("id"));
                dot.set(s, (Object)((DynamicObject)this.getModel().getValue(s)).getLong("id"));
            }
            BigDecimal money = this.getOlapNum();
            if (money == null) {
                money = new BigDecimal(0);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject exist = QueryServiceHelper.queryOne((String)"bcm_dimensionselect", (String)"id", (QFilter[])new QFilter[]{qf1});
            String beforepkid = this.getPageCache().get("pkid");
            try (TXHandle tx = TX.required();){
                try {
                    if (StringUtils.isNotEmpty((String)beforepkid)) {
                        DeleteServiceHelper.delete((IDataEntityType)dot.getDataEntityType(), (Object[])new Object[]{beforepkid});
                    }
                    if (exist == null || StringUtils.isNotEmpty((String)beforepkid)) {
                        map.put("addrow", isTrue);
                        Long pkid = DB.genGlobalLongId();
                        dot.set("id", (Object)pkid);
                        map.put("billselect", pkid);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dot});
                        if (StringUtils.isNotEmpty((String)beforepkid)) {
                            map.put("addrow", isFalse);
                            map.put("needRefresh", isTrue);
                        }
                    } else {
                        map.put("addrow", isFalse);
                        map.put("needRefresh", isTrue);
                        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)exist.getLong("id"), (String)"bcm_dimensionselect");
                        single.set("creator", (Object)userID);
                        single.set("createtime", (Object)date);
                        single.set("unit", this.getModel().getValue("unit"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{single});
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            map.put("currency", currency.get("id"));
            map.put("money", money.setScale(2));
            map.put("Account", ((DynamicObject)this.getModel().getValue("account")).getLong("id"));
            map.put("unit", this.getModel().getValue("unit"));
            this.getModel().setDataChanged(false);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        BasedataEditSingleMemberF7 f7;
        super.onGetControl(e);
        boolean isFalse = false;
        Control c = e.getControl();
        if (c instanceof BasedataEditSingleMemberF7 && (f7 = (BasedataEditSingleMemberF7)c).getDimNumber().startsWith("userdefined")) {
            f7.setEntity("bcm_userdefinedmembertree");
            Long model = (Long)this.getView().getFormShowParameter().getCustomParam("model");
            QFilter modelqfilter = new QFilter("model", "=", (Object)model);
            Map userdfined = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("userdfined"), HashMap.class);
            QFilter nameQfilter = new QFilter("name", "=", userdfined.get(f7.getDimNumber()));
            QFilter issysdimensionQfilter = new QFilter("issysdimension", "=", (Object)isFalse);
            DynamicObject userdefine = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,name,dseq", (QFilter[])new QFilter[]{modelqfilter, nameQfilter, issysdimensionQfilter});
            if (userdefine != null) {
                f7.setDimId(userdefine.getLong("id"));
                f7.setF7title(userdefine.getString("name"));
                f7.setF7Value(userdefine.getInt("dseq"));
            }
        }
    }

    private BigDecimal getOlapNum() {
        QFilter modelqfilter = new QFilter("model", "=", (Object)ConvertUtil.convertStrToLong((String)this.getPageCache().get("KEY_MODEL_ID")));
        DynamicObjectCollection dimencol = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,issysdimension,name", (QFilter[])new QFilter[]{modelqfilter});
        SQLBuilder sql = new SQLBuilder(((DynamicObject)this.getModel().getValue("model")).getString("number"));
        String key = null;
        int i = 1;
        for (DynamicObject s : dimencol) {
            if (!s.getBoolean("issysdimension")) {
                key = "userdefined" + i;
                ++i;
            } else {
                key = s.getString("number").toLowerCase(Locale.ENGLISH);
            }
            String dimensionmembernumber = null;
            if (notvisiable.contains(s.getString("number"))) {
                dimensionmembernumber = this.getPageCache().get(key + "number");
            } else {
                DynamicObject dot = (DynamicObject)this.getModel().getValue(key);
                dimensionmembernumber = dot.getString("number");
            }
            sql.addFilter(s.getString("number"), new String[]{dimensionmembernumber});
        }
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        sql.addSelectField(new String[]{"Account"});
        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
        BigDecimal value = null;
        while (set.next()) {
            value = set.getBigDecimal(FacTabFieldDefEnum.FIELD_MONEY.getField());
        }
        return value;
    }

    private void setDimensionDefaultValue(Long model, boolean issetvalue) {
        boolean isTrue = true;
        boolean isFalse = false;
        QFilter modelqfilter = new QFilter("model", "=", (Object)model);
        DynamicObjectCollection dimencol = QueryServiceHelper.query((String)"bcm_dimension", (String)"id,number,issysdimension,name,membermodel,shortnumber", (QFilter[])new QFilter[]{modelqfilter});
        int i = 1;
        HashMap<String, String> userdfined = new HashMap<String, String>();
        HashSet<String> dims = new HashSet<String>();
        for (DynamicObject dot : dimencol) {
            String number = dot.getString("number");
            if (notvisiable.contains(number)) continue;
            boolean issysdimension = dot.getBoolean("issysdimension");
            String key = null;
            if (!issysdimension) {
                key = "userdefined" + i;
                ++i;
            } else {
                key = number.toLowerCase(Locale.ENGLISH);
            }
            dims.add(key);
            this.getView().setVisible(Boolean.valueOf(isTrue), new String[]{key});
            BasedataEdit base = (BasedataEdit)this.getControl(key);
            userdfined.put(key, dot.getString("name"));
            QFilter dimensionqfilter = new QFilter("dimension", "=", dot.get("id"));
            base.setQFilter(dimensionqfilter);
            base.setCaption(new LocaleString(dot.getString("name")));
            if (!issetvalue) continue;
            QFilter numberfilter = this.getNumberQfilter(key, dot.getString("shortnumber"), model);
            DynamicObject memberobj = QueryServiceHelper.queryOne((String)dot.getString("membermodel"), (String)"id", (QFilter[])new QFilter[]{dimensionqfilter, numberfilter});
            if (memberobj == null) continue;
            this.getModel().setValue(key, (Object)memberobj.getLong("id"));
        }
        for (String f7keys : f7Keys) {
            if (dims.contains(f7keys)) continue;
            this.getView().setVisible(Boolean.valueOf(isFalse), new String[]{f7keys});
        }
        this.getPageCache().put("userdfined", SerializationUtils.toJsonString(userdfined));
    }

    private QFilter getNumberQfilter(String key, String shortnumber, long modelId) {
        QFilter qfilter = new QFilter("1", "!=", (Object)1);
        switch (key) {
            case "scenario": {
                qfilter = new QFilter("number", "=", (Object)DimensionServiceHelper.getDefaultScenarioNumber((long)modelId, (long)0L));
                break;
            }
            case "process": {
                qfilter = new QFilter("number", "=", (Object)"IRpt");
                break;
            }
            case "audittrail": {
                qfilter = new QFilter("number", "=", (Object)"EntityInput");
                break;
            }
            case "multigaap": {
                qfilter = new QFilter("number", "=", (Object)"PRCGAAP");
                break;
            }
            case "internalcompany": {
                qfilter = new QFilter("number", "=", (Object)(shortnumber + "None"));
                break;
            }
        }
        if (key.startsWith("userdefined")) {
            qfilter = new QFilter("number", "=", (Object)(shortnumber + "None"));
        }
        return qfilter;
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
        Map userdfined = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("userdfined"), HashMap.class);
        arg0.getFormShowParameter().setCaption((String)userdfined.get(arg0.getProperty().getName()));
    }
}

